"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class GetCaptureQueryParamEmbed(str, Enum):
    r"""This endpoint allows you to embed additional resources via the `embed` query string parameter."""

    PAYMENT = "payment"


class GetCaptureRequestTypedDict(TypedDict):
    payment_id: str
    r"""Provide the ID of the related payment."""
    capture_id: str
    r"""Provide the ID of the related capture."""
    embed: NotRequired[GetCaptureQueryParamEmbed]
    r"""This endpoint allows you to embed additional resources via the `embed` query string parameter."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class GetCaptureRequest(BaseModel):
    payment_id: Annotated[
        str,
        pydantic.Field(alias="paymentId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related payment."""

    capture_id: Annotated[
        str,
        pydantic.Field(alias="captureId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related capture."""

    embed: Annotated[
        Optional[GetCaptureQueryParamEmbed],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""This endpoint allows you to embed additional resources via the `embed` query string parameter."""

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["embed", "testmode"]
        nullable_fields = ["testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetCaptureCapturesDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class GetCaptureCapturesDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class GetCaptureCapturesLinksTypedDict(TypedDict):
    documentation: GetCaptureCapturesDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class GetCaptureCapturesLinks(BaseModel):
    documentation: GetCaptureCapturesDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class GetCaptureCapturesResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[GetCaptureCapturesLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""


class GetCaptureCapturesResponseBody(ClientError):
    r"""An error response object."""

    data: GetCaptureCapturesResponseBodyData

    def __init__(
        self,
        data: GetCaptureCapturesResponseBodyData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class GetCaptureAmountTypedDict(TypedDict):
    r"""The amount captured. If no amount is provided, the full authorized amount is captured."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetCaptureAmount(BaseModel):
    r"""The amount captured. If no amount is provided, the full authorized amount is captured."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetCaptureSettlementAmountTypedDict(TypedDict):
    r"""This optional field will contain the approximate amount that will be settled to your account, converted to the currency your account is settled in.

    Since the field contains an estimated amount during capture processing, it may change over time. To retrieve accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions) instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetCaptureSettlementAmount(BaseModel):
    r"""This optional field will contain the approximate amount that will be settled to your account, converted to the currency your account is settled in.

    Since the field contains an estimated amount during capture processing, it may change over time. To retrieve accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions) instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetCaptureMetadata2TypedDict(TypedDict):
    pass


class GetCaptureMetadata2(BaseModel):
    pass


GetCaptureMetadataTypedDict = TypeAliasType(
    "GetCaptureMetadataTypedDict", Union[GetCaptureMetadata2TypedDict, str, List[str]]
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""


GetCaptureMetadata = TypeAliasType(
    "GetCaptureMetadata", Union[GetCaptureMetadata2, str, List[str]]
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""


class GetCaptureSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetCaptureSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetCapturePaymentTypedDict(TypedDict):
    r"""The API resource URL of the [payment](get-payment) that this capture belongs to."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetCapturePayment(BaseModel):
    r"""The API resource URL of the [payment](get-payment) that this capture belongs to."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetCaptureSettlementTypedDict(TypedDict):
    r"""The API resource URL of the [settlement](get-settlement) this capture has been settled with. Not present if not yet settled."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetCaptureSettlement(BaseModel):
    r"""The API resource URL of the [settlement](get-settlement) this capture has been settled with. Not present if not yet settled."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetCaptureShipmentTypedDict(TypedDict):
    r"""The API resource URL of the [shipment](get-shipment) this capture is associated with. Not present if it isn't associated with a shipment."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetCaptureShipment(BaseModel):
    r"""The API resource URL of the [shipment](get-shipment) this capture is associated with. Not present if it isn't associated with a shipment."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetCaptureDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetCaptureDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetCaptureLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: GetCaptureSelfTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payment: GetCapturePaymentTypedDict
    r"""The API resource URL of the [payment](get-payment) that this capture belongs to."""
    documentation: GetCaptureDocumentationTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    settlement: NotRequired[Nullable[GetCaptureSettlementTypedDict]]
    r"""The API resource URL of the [settlement](get-settlement) this capture has been settled with. Not present if not yet settled."""
    shipment: NotRequired[Nullable[GetCaptureShipmentTypedDict]]
    r"""The API resource URL of the [shipment](get-shipment) this capture is associated with. Not present if it isn't associated with a shipment."""


class GetCaptureLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[GetCaptureSelf, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payment: GetCapturePayment
    r"""The API resource URL of the [payment](get-payment) that this capture belongs to."""

    documentation: GetCaptureDocumentation
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    settlement: OptionalNullable[GetCaptureSettlement] = UNSET
    r"""The API resource URL of the [settlement](get-settlement) this capture has been settled with. Not present if not yet settled."""

    shipment: OptionalNullable[GetCaptureShipment] = UNSET
    r"""The API resource URL of the [shipment](get-shipment) this capture is associated with. Not present if it isn't associated with a shipment."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["settlement", "shipment"]
        nullable_fields = ["settlement", "shipment"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetCaptureResponseBodyTypedDict(TypedDict):
    r"""The capture object."""

    resource: str
    r"""Indicates the response contains a capture object. Will always contain the string `capture` for this endpoint."""
    id: str
    r"""The identifier uniquely referring to this capture. Example: `cpt_mNepDkEtco6ah3QNPUGYH`."""
    mode: str
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """
    amount: Nullable[GetCaptureAmountTypedDict]
    r"""The amount captured. If no amount is provided, the full authorized amount is captured."""
    status: str
    r"""The capture's status.

    Possible values: `pending` `succeeded` `failed`
    """
    payment_id: str
    r"""The unique identifier of the payment this capture was created for. For example: `tr_5B8cwPMGnU6qLbRvo7qEZo`. The full payment object can be retrieved via the payment URL in the `_links` object."""
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: GetCaptureLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    description: NotRequired[str]
    r"""The description of the capture."""
    settlement_amount: NotRequired[Nullable[GetCaptureSettlementAmountTypedDict]]
    r"""This optional field will contain the approximate amount that will be settled to your account, converted to the currency your account is settled in.

    Since the field contains an estimated amount during capture processing, it may change over time. To retrieve accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions) instead.
    """
    metadata: NotRequired[Nullable[GetCaptureMetadataTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""
    shipment_id: NotRequired[Nullable[str]]
    r"""The unique identifier of the shipment that triggered the creation of this capture, if applicable. For example: `shp_gNapNy9qQTUFZYnCrCF7J`."""
    settlement_id: NotRequired[Nullable[str]]
    r"""The identifier referring to the settlement this capture was settled with. For example, `stl_BkEjN2eBb`. This field is omitted if the capture is not settled (yet)."""


class GetCaptureResponseBody(BaseModel):
    r"""The capture object."""

    resource: str
    r"""Indicates the response contains a capture object. Will always contain the string `capture` for this endpoint."""

    id: str
    r"""The identifier uniquely referring to this capture. Example: `cpt_mNepDkEtco6ah3QNPUGYH`."""

    mode: str
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """

    amount: Nullable[GetCaptureAmount]
    r"""The amount captured. If no amount is provided, the full authorized amount is captured."""

    status: str
    r"""The capture's status.

    Possible values: `pending` `succeeded` `failed`
    """

    payment_id: Annotated[str, pydantic.Field(alias="paymentId")]
    r"""The unique identifier of the payment this capture was created for. For example: `tr_5B8cwPMGnU6qLbRvo7qEZo`. The full payment object can be retrieved via the payment URL in the `_links` object."""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[GetCaptureLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    description: Optional[str] = None
    r"""The description of the capture."""

    settlement_amount: Annotated[
        OptionalNullable[GetCaptureSettlementAmount],
        pydantic.Field(alias="settlementAmount"),
    ] = UNSET
    r"""This optional field will contain the approximate amount that will be settled to your account, converted to the currency your account is settled in.

    Since the field contains an estimated amount during capture processing, it may change over time. To retrieve accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions) instead.
    """

    metadata: OptionalNullable[GetCaptureMetadata] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""

    shipment_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="shipmentId")
    ] = UNSET
    r"""The unique identifier of the shipment that triggered the creation of this capture, if applicable. For example: `shp_gNapNy9qQTUFZYnCrCF7J`."""

    settlement_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="settlementId")
    ] = UNSET
    r"""The identifier referring to the settlement this capture was settled with. For example, `stl_BkEjN2eBb`. This field is omitted if the capture is not settled (yet)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "description",
            "settlementAmount",
            "metadata",
            "shipmentId",
            "settlementId",
        ]
        nullable_fields = [
            "amount",
            "settlementAmount",
            "metadata",
            "shipmentId",
            "settlementId",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
