"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetWebhookRequestTypedDict(TypedDict):
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class GetWebhookRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["testmode"]
        nullable_fields = ["testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetWebhookWebhooksDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class GetWebhookWebhooksDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class GetWebhookWebhooksLinksTypedDict(TypedDict):
    documentation: GetWebhookWebhooksDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class GetWebhookWebhooksLinks(BaseModel):
    documentation: GetWebhookWebhooksDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class GetWebhookWebhooksResponseResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[GetWebhookWebhooksLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""


class GetWebhookWebhooksResponseResponseBody(ClientError):
    r"""An error response object."""

    data: GetWebhookWebhooksResponseResponseBodyData

    def __init__(
        self,
        data: GetWebhookWebhooksResponseResponseBodyData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class GetWebhookDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class GetWebhookDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class GetWebhookLinksTypedDict(TypedDict):
    documentation: GetWebhookDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class GetWebhookLinks(BaseModel):
    documentation: GetWebhookDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class GetWebhookWebhooksResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[GetWebhookLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""


class GetWebhookWebhooksResponseBody(ClientError):
    r"""An error response object."""

    data: GetWebhookWebhooksResponseBodyData

    def __init__(
        self,
        data: GetWebhookWebhooksResponseBodyData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class GetWebhookResponseBodyTypedDict(TypedDict):
    r"""The webhook object."""

    resource: NotRequired[str]
    r"""Indicates the response contains a webhook subscription object. Will always contain the string `webhook` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this subscription."""
    url: NotRequired[str]
    r"""The subscription's events destination."""
    profile_id: NotRequired[str]
    r"""The identifier uniquely referring to the profile that created the subscription."""
    created_at: NotRequired[str]
    r"""The subscription's date time of creation."""
    name: NotRequired[str]
    r"""The subscription's name."""
    event_types: NotRequired[str]
    r"""The events types that are subscribed."""
    status: NotRequired[str]
    r"""The subscription's current status.

    Possible values: `enabled` `blocked` `disabled`
    """


class GetWebhookResponseBody(BaseModel):
    r"""The webhook object."""

    resource: Optional[str] = "webhook"
    r"""Indicates the response contains a webhook subscription object. Will always contain the string `webhook` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this subscription."""

    url: Optional[str] = None
    r"""The subscription's events destination."""

    profile_id: Annotated[Optional[str], pydantic.Field(alias="profileId")] = None
    r"""The identifier uniquely referring to the profile that created the subscription."""

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The subscription's date time of creation."""

    name: Optional[str] = None
    r"""The subscription's name."""

    event_types: Annotated[Optional[str], pydantic.Field(alias="eventTypes")] = None
    r"""The events types that are subscribed."""

    status: Optional[str] = None
    r"""The subscription's current status.

    Possible values: `enabled` `blocked` `disabled`
    """
