"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetOnboardingStatusSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetOnboardingStatusSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetOnboardingStatusDashboardTypedDict(TypedDict):
    r"""Direct link to the onboarding process in the Mollie dashboard. The merchant can be redirected to this page to complete their onboarding."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetOnboardingStatusDashboard(BaseModel):
    r"""Direct link to the onboarding process in the Mollie dashboard. The merchant can be redirected to this page to complete their onboarding."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetOnboardingStatusOrganizationTypedDict(TypedDict):
    r"""The API resource URL of the organization."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetOnboardingStatusOrganization(BaseModel):
    r"""The API resource URL of the organization."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetOnboardingStatusDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetOnboardingStatusDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetOnboardingStatusLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetOnboardingStatusSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    dashboard: NotRequired[GetOnboardingStatusDashboardTypedDict]
    r"""Direct link to the onboarding process in the Mollie dashboard. The merchant can be redirected to this page to complete their onboarding."""
    organization: NotRequired[GetOnboardingStatusOrganizationTypedDict]
    r"""The API resource URL of the organization."""
    documentation: NotRequired[GetOnboardingStatusDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetOnboardingStatusLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[
        Optional[GetOnboardingStatusSelf], pydantic.Field(alias="self")
    ] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    dashboard: Optional[GetOnboardingStatusDashboard] = None
    r"""Direct link to the onboarding process in the Mollie dashboard. The merchant can be redirected to this page to complete their onboarding."""

    organization: Optional[GetOnboardingStatusOrganization] = None
    r"""The API resource URL of the organization."""

    documentation: Optional[GetOnboardingStatusDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetOnboardingStatusResponseBodyTypedDict(TypedDict):
    r"""The onboarding status object of the current organization."""

    resource: NotRequired[str]
    r"""Indicates the response contains an onboarding status object. Will always contain the string `onboarding` for this resource type."""
    name: NotRequired[str]
    r"""The name of the organization."""
    status: NotRequired[str]
    r"""The current status of the organization's onboarding process.

    * `needs-data` — The merchant needs to provide additional information
    * `in-review` — The merchant provided all information, awaiting review from Mollie
    * `completed` — The onboarding is completed

    Possible values: `needs-data` `in-review` `completed`
    """
    can_receive_payments: NotRequired[bool]
    r"""Whether the organization can receive payments."""
    can_receive_settlements: NotRequired[bool]
    r"""Whether the organization can receive settlements to their external bank account."""
    signed_up_at: NotRequired[str]
    r"""The sign up date time of the organization in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: NotRequired[GetOnboardingStatusLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetOnboardingStatusResponseBody(BaseModel):
    r"""The onboarding status object of the current organization."""

    resource: Optional[str] = "onboarding"
    r"""Indicates the response contains an onboarding status object. Will always contain the string `onboarding` for this resource type."""

    name: Optional[str] = None
    r"""The name of the organization."""

    status: Optional[str] = None
    r"""The current status of the organization's onboarding process.

    * `needs-data` — The merchant needs to provide additional information
    * `in-review` — The merchant provided all information, awaiting review from Mollie
    * `completed` — The onboarding is completed

    Possible values: `needs-data` `in-review` `completed`
    """

    can_receive_payments: Annotated[
        Optional[bool], pydantic.Field(alias="canReceivePayments")
    ] = None
    r"""Whether the organization can receive payments."""

    can_receive_settlements: Annotated[
        Optional[bool], pydantic.Field(alias="canReceiveSettlements")
    ] = None
    r"""Whether the organization can receive settlements to their external bank account."""

    signed_up_at: Annotated[Optional[str], pydantic.Field(alias="signedUpAt")] = None
    r"""The sign up date time of the organization in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[
        Optional[GetOnboardingStatusLinks], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
