"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetChargebackQueryParamEmbed(str, Enum):
    r"""This endpoint allows you to embed additional information via the `embed` query string parameter."""

    PAYMENT = "payment"


class GetChargebackRequestTypedDict(TypedDict):
    payment_id: str
    r"""Provide the ID of the related payment."""
    chargeback_id: str
    r"""Provide the ID of the related chargeback."""
    embed: NotRequired[Nullable[GetChargebackQueryParamEmbed]]
    r"""This endpoint allows you to embed additional information via the `embed` query string parameter."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class GetChargebackRequest(BaseModel):
    payment_id: Annotated[
        str,
        pydantic.Field(alias="paymentId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related payment."""

    chargeback_id: Annotated[
        str,
        pydantic.Field(alias="chargebackId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related chargeback."""

    embed: Annotated[
        OptionalNullable[GetChargebackQueryParamEmbed],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""This endpoint allows you to embed additional information via the `embed` query string parameter."""

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["embed", "testmode"]
        nullable_fields = ["embed", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetChargebackChargebacksDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class GetChargebackChargebacksDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class GetChargebackChargebacksLinksTypedDict(TypedDict):
    documentation: GetChargebackChargebacksDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class GetChargebackChargebacksLinks(BaseModel):
    documentation: GetChargebackChargebacksDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class GetChargebackChargebacksResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[GetChargebackChargebacksLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""


class GetChargebackChargebacksResponseBody(ClientError):
    r"""An error response object."""

    data: GetChargebackChargebacksResponseBodyData

    def __init__(
        self,
        data: GetChargebackChargebacksResponseBodyData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class GetChargebackAmountTypedDict(TypedDict):
    r"""The amount charged back by the customer."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetChargebackAmount(BaseModel):
    r"""The amount charged back by the customer."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetChargebackSettlementAmountTypedDict(TypedDict):
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted to the currency your account is settled in.

    The amount is a **negative** amount.

    Since the field contains an estimated amount during chargeback processing, it may change over time. To retrieve accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions) instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetChargebackSettlementAmount(BaseModel):
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted to the currency your account is settled in.

    The amount is a **negative** amount.

    Since the field contains an estimated amount during chargeback processing, it may change over time. To retrieve accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions) instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ReasonTypedDict(TypedDict):
    r"""Reason for the chargeback as given by the bank. Only available for chargebacks of SEPA Direct Debit payments."""

    code: str
    r"""Technical code provided by the bank."""
    description: str
    r"""A more detailed human-friendly description."""


class Reason(BaseModel):
    r"""Reason for the chargeback as given by the bank. Only available for chargebacks of SEPA Direct Debit payments."""

    code: str
    r"""Technical code provided by the bank."""

    description: str
    r"""A more detailed human-friendly description."""


class GetChargebackSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetChargebackSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetChargebackPaymentTypedDict(TypedDict):
    r"""The API resource URL of the [payment](get-payment) that this chargeback belongs to."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetChargebackPayment(BaseModel):
    r"""The API resource URL of the [payment](get-payment) that this chargeback belongs to."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetChargebackSettlementTypedDict(TypedDict):
    r"""The API resource URL of the [settlement](get-settlement) this chargeback has been settled with. Not present if not yet settled."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetChargebackSettlement(BaseModel):
    r"""The API resource URL of the [settlement](get-settlement) this chargeback has been settled with. Not present if not yet settled."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetChargebackDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetChargebackDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetChargebackLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: GetChargebackSelfTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payment: GetChargebackPaymentTypedDict
    r"""The API resource URL of the [payment](get-payment) that this chargeback belongs to."""
    documentation: GetChargebackDocumentationTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    settlement: NotRequired[Nullable[GetChargebackSettlementTypedDict]]
    r"""The API resource URL of the [settlement](get-settlement) this chargeback has been settled with. Not present if not yet settled."""


class GetChargebackLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[GetChargebackSelf, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payment: GetChargebackPayment
    r"""The API resource URL of the [payment](get-payment) that this chargeback belongs to."""

    documentation: GetChargebackDocumentation
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    settlement: OptionalNullable[GetChargebackSettlement] = UNSET
    r"""The API resource URL of the [settlement](get-settlement) this chargeback has been settled with. Not present if not yet settled."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["settlement"]
        nullable_fields = ["settlement"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetChargebackResponseBodyTypedDict(TypedDict):
    r"""The chargeback object."""

    resource: str
    r"""Indicates the response contains a chargeback object. Will always contain the string `chargeback` for this endpoint."""
    id: str
    r"""The identifier uniquely referring to this chargeback. Example: `chb_n9z0tp`."""
    amount: GetChargebackAmountTypedDict
    r"""The amount charged back by the customer."""
    payment_id: str
    r"""The unique identifier of the payment this chargeback was created for. For example: `tr_5B8cwPMGnU6qLbRvo7qEZo`. The full payment object can be retrieved via the payment URL in the `_links` object."""
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: GetChargebackLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    settlement_amount: NotRequired[Nullable[GetChargebackSettlementAmountTypedDict]]
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted to the currency your account is settled in.

    The amount is a **negative** amount.

    Since the field contains an estimated amount during chargeback processing, it may change over time. To retrieve accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions) instead.
    """
    reason: NotRequired[Nullable[ReasonTypedDict]]
    r"""Reason for the chargeback as given by the bank. Only available for chargebacks of SEPA Direct Debit payments."""
    settlement_id: NotRequired[Nullable[str]]
    r"""The identifier referring to the settlement this payment was settled with. For example, `stl_BkEjN2eBb`. This field is omitted if the refund is not settled (yet)."""
    reversed_at: NotRequired[Nullable[str]]
    r"""The date and time the chargeback was reversed if applicable, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""


class GetChargebackResponseBody(BaseModel):
    r"""The chargeback object."""

    resource: str
    r"""Indicates the response contains a chargeback object. Will always contain the string `chargeback` for this endpoint."""

    id: str
    r"""The identifier uniquely referring to this chargeback. Example: `chb_n9z0tp`."""

    amount: GetChargebackAmount
    r"""The amount charged back by the customer."""

    payment_id: Annotated[str, pydantic.Field(alias="paymentId")]
    r"""The unique identifier of the payment this chargeback was created for. For example: `tr_5B8cwPMGnU6qLbRvo7qEZo`. The full payment object can be retrieved via the payment URL in the `_links` object."""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[GetChargebackLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    settlement_amount: Annotated[
        OptionalNullable[GetChargebackSettlementAmount],
        pydantic.Field(alias="settlementAmount"),
    ] = UNSET
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted to the currency your account is settled in.

    The amount is a **negative** amount.

    Since the field contains an estimated amount during chargeback processing, it may change over time. To retrieve accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions) instead.
    """

    reason: OptionalNullable[Reason] = UNSET
    r"""Reason for the chargeback as given by the bank. Only available for chargebacks of SEPA Direct Debit payments."""

    settlement_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="settlementId")
    ] = UNSET
    r"""The identifier referring to the settlement this payment was settled with. For example, `stl_BkEjN2eBb`. This field is omitted if the refund is not settled (yet)."""

    reversed_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="reversedAt")
    ] = UNSET
    r"""The date and time the chargeback was reversed if applicable, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["settlementAmount", "reason", "settlementId", "reversedAt"]
        nullable_fields = ["settlementAmount", "reason", "settlementId", "reversedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
