"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListSalesInvoicesRequestTypedDict(TypedDict):
    from_: NotRequired[str]
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set."""
    limit: NotRequired[Nullable[int]]
    r"""The maximum number of items to return. Defaults to 50 items."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class ListSalesInvoicesRequest(BaseModel):
    from_: Annotated[
        Optional[str],
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set."""

    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 50
    r"""The maximum number of items to return. Defaults to 50 items."""

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["from", "limit", "testmode"]
        nullable_fields = ["limit", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListSalesInvoicesSalesInvoicesDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListSalesInvoicesSalesInvoicesDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListSalesInvoicesSalesInvoicesLinksTypedDict(TypedDict):
    documentation: ListSalesInvoicesSalesInvoicesDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListSalesInvoicesSalesInvoicesLinks(BaseModel):
    documentation: ListSalesInvoicesSalesInvoicesDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListSalesInvoicesSalesInvoicesResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[
        ListSalesInvoicesSalesInvoicesLinks, pydantic.Field(alias="_links")
    ]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""


class ListSalesInvoicesSalesInvoicesResponseBody(Exception):
    r"""An error response object."""

    data: ListSalesInvoicesSalesInvoicesResponseBodyData

    def __init__(self, data: ListSalesInvoicesSalesInvoicesResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(
            self.data, ListSalesInvoicesSalesInvoicesResponseBodyData
        )


class ListSalesInvoicesMetadataTypedDict(TypedDict):
    r"""Provide any data you like as a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""


class ListSalesInvoicesMetadata(BaseModel):
    r"""Provide any data you like as a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""


class ListSalesInvoicesPaymentDetailsTypedDict(TypedDict):
    r"""Used when setting an invoice to status of `paid`, and will store a payment that fully pays the invoice with the provided details. Required for `paid` status."""

    source: str
    r"""The way through which the invoice is to be set to paid.

    Possible values: `manual` `payment-link` `payment`
    """
    source_reference: NotRequired[Nullable[str]]
    r"""A reference to the payment the sales invoice is paid by. Required for `source` values `payment-link` and `payment`."""


class ListSalesInvoicesPaymentDetails(BaseModel):
    r"""Used when setting an invoice to status of `paid`, and will store a payment that fully pays the invoice with the provided details. Required for `paid` status."""

    source: str
    r"""The way through which the invoice is to be set to paid.

    Possible values: `manual` `payment-link` `payment`
    """

    source_reference: Annotated[
        OptionalNullable[str], pydantic.Field(alias="sourceReference")
    ] = UNSET
    r"""A reference to the payment the sales invoice is paid by. Required for `source` values `payment-link` and `payment`."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceReference"]
        nullable_fields = ["sourceReference"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListSalesInvoicesEmailDetailsTypedDict(TypedDict):
    r"""Used when setting an invoice to status of either `issued` or `paid`. Will be used to issue the invoice to the recipient with the provided `subject` and `body`. Required for `issued` status."""

    subject: str
    r"""The subject of the email to be sent."""
    body: str
    r"""The body of the email to be sent. To add newline characters, you can use `\n`."""


class ListSalesInvoicesEmailDetails(BaseModel):
    r"""Used when setting an invoice to status of either `issued` or `paid`. Will be used to issue the invoice to the recipient with the provided `subject` and `body`. Required for `issued` status."""

    subject: str
    r"""The subject of the email to be sent."""

    body: str
    r"""The body of the email to be sent. To add newline characters, you can use `\n`."""


class ListSalesInvoicesRecipientTypedDict(TypedDict):
    type: str
    r"""The type of recipient, either `consumer` or `business`. This will determine what further fields are required on the `recipient` object.

    Possible values: `consumer` `business`
    """
    email: str
    r"""The email address of the recipient."""
    street_and_number: str
    r"""A street and street number."""
    postal_code: str
    r"""A postal code."""
    city: str
    r"""The recipient's city."""
    country: str
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""
    locale: str
    r"""The locale for the recipient, to be used for translations in PDF generation and payment pages.

    Possible values: `en_US` `en_GB` `nl_NL` `nl_BE` `de_DE` `de_AT` `de_CH` `fr_FR` `fr_BE`
    """
    title: NotRequired[Nullable[str]]
    r"""The title of the `consumer` type recipient, for example Mr. or Mrs.."""
    given_name: NotRequired[Nullable[str]]
    r"""The given name (first name) of the `consumer` type recipient should be at least two characters and cannot contain only numbers."""
    family_name: NotRequired[Nullable[str]]
    r"""The given name (last name) of the `consumer` type recipient should be at least two characters and cannot contain only numbers."""
    organization_name: NotRequired[Nullable[str]]
    r"""The trading name of the `business` type recipient."""
    organization_number: NotRequired[Nullable[str]]
    r"""The Chamber of Commerce number of the organization for a `business` type recipient. Either this or `vatNumber` has to be provided."""
    vat_number: NotRequired[Nullable[str]]
    r"""The VAT number of the organization for a `business` type recipient. Either this or `organizationNumber` has to be provided."""
    phone: NotRequired[Nullable[str]]
    r"""The phone number of the recipient."""
    street_additional: NotRequired[Nullable[str]]
    r"""Any additional addressing details, for example an apartment number."""
    region: NotRequired[Nullable[str]]
    r"""The recipient's region."""


class ListSalesInvoicesRecipient(BaseModel):
    type: str
    r"""The type of recipient, either `consumer` or `business`. This will determine what further fields are required on the `recipient` object.

    Possible values: `consumer` `business`
    """

    email: str
    r"""The email address of the recipient."""

    street_and_number: Annotated[str, pydantic.Field(alias="streetAndNumber")]
    r"""A street and street number."""

    postal_code: Annotated[str, pydantic.Field(alias="postalCode")]
    r"""A postal code."""

    city: str
    r"""The recipient's city."""

    country: str
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""

    locale: str
    r"""The locale for the recipient, to be used for translations in PDF generation and payment pages.

    Possible values: `en_US` `en_GB` `nl_NL` `nl_BE` `de_DE` `de_AT` `de_CH` `fr_FR` `fr_BE`
    """

    title: OptionalNullable[str] = UNSET
    r"""The title of the `consumer` type recipient, for example Mr. or Mrs.."""

    given_name: Annotated[OptionalNullable[str], pydantic.Field(alias="givenName")] = (
        UNSET
    )
    r"""The given name (first name) of the `consumer` type recipient should be at least two characters and cannot contain only numbers."""

    family_name: Annotated[
        OptionalNullable[str], pydantic.Field(alias="familyName")
    ] = UNSET
    r"""The given name (last name) of the `consumer` type recipient should be at least two characters and cannot contain only numbers."""

    organization_name: Annotated[
        OptionalNullable[str], pydantic.Field(alias="organizationName")
    ] = UNSET
    r"""The trading name of the `business` type recipient."""

    organization_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="organizationNumber")
    ] = UNSET
    r"""The Chamber of Commerce number of the organization for a `business` type recipient. Either this or `vatNumber` has to be provided."""

    vat_number: Annotated[OptionalNullable[str], pydantic.Field(alias="vatNumber")] = (
        UNSET
    )
    r"""The VAT number of the organization for a `business` type recipient. Either this or `organizationNumber` has to be provided."""

    phone: OptionalNullable[str] = UNSET
    r"""The phone number of the recipient."""

    street_additional: Annotated[
        OptionalNullable[str], pydantic.Field(alias="streetAdditional")
    ] = UNSET
    r"""Any additional addressing details, for example an apartment number."""

    region: OptionalNullable[str] = UNSET
    r"""The recipient's region."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "title",
            "givenName",
            "familyName",
            "organizationName",
            "organizationNumber",
            "vatNumber",
            "phone",
            "streetAdditional",
            "region",
        ]
        nullable_fields = [
            "title",
            "givenName",
            "familyName",
            "organizationName",
            "organizationNumber",
            "vatNumber",
            "phone",
            "streetAdditional",
            "region",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListSalesInvoicesUnitPriceTypedDict(TypedDict):
    r"""The price of a single item excluding VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    The unit price can be zero in case of free items.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListSalesInvoicesUnitPrice(BaseModel):
    r"""The price of a single item excluding VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    The unit price can be zero in case of free items.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListSalesInvoicesSalesInvoicesDiscountTypedDict(TypedDict):
    r"""The discount to be applied to the line item."""

    type: str
    r"""The type of discount.

    Possible values: `amount` `percentage`
    """
    value: str
    r"""A string containing an exact monetary amount in the given currency, or the percentage."""


class ListSalesInvoicesSalesInvoicesDiscount(BaseModel):
    r"""The discount to be applied to the line item."""

    type: str
    r"""The type of discount.

    Possible values: `amount` `percentage`
    """

    value: str
    r"""A string containing an exact monetary amount in the given currency, or the percentage."""


class ListSalesInvoicesLinesTypedDict(TypedDict):
    description: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""
    quantity: int
    r"""The number of items."""
    vat_rate: str
    r"""The vat rate to be applied to this line item."""
    unit_price: ListSalesInvoicesUnitPriceTypedDict
    r"""The price of a single item excluding VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    The unit price can be zero in case of free items.
    """
    discount: NotRequired[Nullable[ListSalesInvoicesSalesInvoicesDiscountTypedDict]]
    r"""The discount to be applied to the line item."""


class ListSalesInvoicesLines(BaseModel):
    description: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""

    quantity: int
    r"""The number of items."""

    vat_rate: Annotated[str, pydantic.Field(alias="vatRate")]
    r"""The vat rate to be applied to this line item."""

    unit_price: Annotated[ListSalesInvoicesUnitPrice, pydantic.Field(alias="unitPrice")]
    r"""The price of a single item excluding VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    The unit price can be zero in case of free items.
    """

    discount: OptionalNullable[ListSalesInvoicesSalesInvoicesDiscount] = UNSET
    r"""The discount to be applied to the line item."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["discount"]
        nullable_fields = ["discount"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListSalesInvoicesDiscountTypedDict(TypedDict):
    r"""The discount to be applied to the entire invoice, applied on top of any line item discounts."""

    type: str
    r"""The type of discount.

    Possible values: `amount` `percentage`
    """
    value: str
    r"""A string containing an exact monetary amount in the given currency, or the percentage."""


class ListSalesInvoicesDiscount(BaseModel):
    r"""The discount to be applied to the entire invoice, applied on top of any line item discounts."""

    type: str
    r"""The type of discount.

    Possible values: `amount` `percentage`
    """

    value: str
    r"""A string containing an exact monetary amount in the given currency, or the percentage."""


class ListSalesInvoicesAmountDueTypedDict(TypedDict):
    r"""The amount that is left to be paid."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListSalesInvoicesAmountDue(BaseModel):
    r"""The amount that is left to be paid."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListSalesInvoicesSubtotalAmountTypedDict(TypedDict):
    r"""The total amount without VAT before discounts."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListSalesInvoicesSubtotalAmount(BaseModel):
    r"""The total amount without VAT before discounts."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListSalesInvoicesTotalAmountTypedDict(TypedDict):
    r"""The total amount with VAT."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListSalesInvoicesTotalAmount(BaseModel):
    r"""The total amount with VAT."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListSalesInvoicesTotalVatAmountTypedDict(TypedDict):
    r"""The total VAT amount."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListSalesInvoicesTotalVatAmount(BaseModel):
    r"""The total VAT amount."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListSalesInvoicesDiscountedSubtotalAmountTypedDict(TypedDict):
    r"""The total amount without VAT after discounts."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListSalesInvoicesDiscountedSubtotalAmount(BaseModel):
    r"""The total amount without VAT after discounts."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListSalesInvoicesSalesInvoicesSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSalesInvoicesSalesInvoicesSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSalesInvoicesInvoicePaymentTypedDict(TypedDict):
    r"""The URL your customer should visit to make payment for the invoice. This is where you should redirect the customer to unless the `status` is set to `paid`."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSalesInvoicesInvoicePayment(BaseModel):
    r"""The URL your customer should visit to make payment for the invoice. This is where you should redirect the customer to unless the `status` is set to `paid`."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSalesInvoicesPdfLinkTypedDict(TypedDict):
    r"""The URL the invoice is available at, if generated."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSalesInvoicesPdfLink(BaseModel):
    r"""The URL the invoice is available at, if generated."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSalesInvoicesSalesInvoicesResponseDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSalesInvoicesSalesInvoicesResponseDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSalesInvoicesSalesInvoicesResponseLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[ListSalesInvoicesSalesInvoicesSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    invoice_payment: NotRequired[ListSalesInvoicesInvoicePaymentTypedDict]
    r"""The URL your customer should visit to make payment for the invoice. This is where you should redirect the customer to unless the `status` is set to `paid`."""
    pdf_link: NotRequired[Nullable[ListSalesInvoicesPdfLinkTypedDict]]
    r"""The URL the invoice is available at, if generated."""
    documentation: NotRequired[
        ListSalesInvoicesSalesInvoicesResponseDocumentationTypedDict
    ]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListSalesInvoicesSalesInvoicesResponseLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[
        Optional[ListSalesInvoicesSalesInvoicesSelf], pydantic.Field(alias="self")
    ] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    invoice_payment: Annotated[
        Optional[ListSalesInvoicesInvoicePayment],
        pydantic.Field(alias="invoicePayment"),
    ] = None
    r"""The URL your customer should visit to make payment for the invoice. This is where you should redirect the customer to unless the `status` is set to `paid`."""

    pdf_link: Annotated[
        OptionalNullable[ListSalesInvoicesPdfLink], pydantic.Field(alias="pdfLink")
    ] = UNSET
    r"""The URL the invoice is available at, if generated."""

    documentation: Optional[ListSalesInvoicesSalesInvoicesResponseDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["self", "invoicePayment", "pdfLink", "documentation"]
        nullable_fields = ["pdfLink"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListSalesInvoicesSalesInvoicesTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains a sales invoice object. Will always contain the string `sales-invoice` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this invoice. Example: `invoice_4Y0eZitmBnQ6IDoMqZQKh`."""
    invoice_number: NotRequired[Nullable[str]]
    r"""When issued, an invoice number will be set for the sales invoice."""
    status: NotRequired[str]
    r"""The status for the invoice to end up in.

    A `draft` invoice is not paid or not sent and can be updated after creation. Setting it to `issued` sends it to the recipient so they may then pay through our payment system. To skip our payment process, set this to `paid` to mark it as paid. It can then subsequently be sent as well, same as with `issued`.

    A status value that cannot be set but can be returned is `canceled`, for invoices which were issued, but then canceled. Currently this can only be done for invoices created in the dashboard.

    Dependent parameters: - `paymentDetails` is required if invoice should be set directly to `paid` - `customerId` and `mandateId` are required if a recurring payment should be used to set the invoice to `paid` - `emailDetails` optional for `issued` and `paid` to send the invoice by email

    Possible values: `draft` `issued` `paid`
    """
    vat_scheme: NotRequired[str]
    r"""The VAT scheme to create the invoice for. You must be enrolled with One Stop Shop enabled to use it.

    Possible values: `standard` `one-stop-shop` (default: `standard`)
    """
    vat_mode: NotRequired[str]
    r"""The VAT mode to use for VAT calculation. `exclusive` mode means we will apply the relevant VAT on top of the price. `inclusive` means the prices you are providing to us already contain the VAT you want to apply.

    Possible values: `exclusive` `inclusive` (default: `exclusive`)
    """
    memo: NotRequired[Nullable[str]]
    r"""A free-form memo you can set on the invoice, and will be shown on the invoice PDF."""
    metadata: NotRequired[Nullable[ListSalesInvoicesMetadataTypedDict]]
    r"""Provide any data you like as a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""
    payment_term: NotRequired[Nullable[str]]
    r"""The payment term to be set on the invoice.

    Possible values: `7 days` `14 days` `30 days` `45 days` `60 days` `90 days` `120 days` (default: `30 days`)
    """
    payment_details: NotRequired[Nullable[ListSalesInvoicesPaymentDetailsTypedDict]]
    r"""Used when setting an invoice to status of `paid`, and will store a payment that fully pays the invoice with the provided details. Required for `paid` status."""
    email_details: NotRequired[Nullable[ListSalesInvoicesEmailDetailsTypedDict]]
    r"""Used when setting an invoice to status of either `issued` or `paid`. Will be used to issue the invoice to the recipient with the provided `subject` and `body`. Required for `issued` status."""
    customer_id: NotRequired[str]
    r"""The identifier referring to the [customer](get-customer) you want to attempt an automated payment for. If provided, `mandateId` becomes required as well. Only allowed for invoices with status `paid`."""
    mandate_id: NotRequired[str]
    r"""The identifier referring to the [mandate](get-mandate) you want to use for the automated payment. If provided, `customerId` becomes required as well. Only allowed for invoices with status `paid`."""
    recipient_identifier: NotRequired[str]
    r"""An identifier tied to the recipient data. This should be a unique value based on data your system contains, so that both you and us know who we're referring to. It is a value you provide to us so that recipient management is not required to send a first invoice to a recipient."""
    recipient: NotRequired[Nullable[ListSalesInvoicesRecipientTypedDict]]
    lines: NotRequired[Nullable[List[ListSalesInvoicesLinesTypedDict]]]
    r"""Provide the line items for the invoice. Each line contains details such as a description of the item ordered and its price.

    All lines must have the same currency as the invoice.
    """
    discount: NotRequired[Nullable[ListSalesInvoicesDiscountTypedDict]]
    r"""The discount to be applied to the entire invoice, applied on top of any line item discounts."""
    amount_due: NotRequired[ListSalesInvoicesAmountDueTypedDict]
    r"""The amount that is left to be paid."""
    subtotal_amount: NotRequired[ListSalesInvoicesSubtotalAmountTypedDict]
    r"""The total amount without VAT before discounts."""
    total_amount: NotRequired[ListSalesInvoicesTotalAmountTypedDict]
    r"""The total amount with VAT."""
    total_vat_amount: NotRequired[ListSalesInvoicesTotalVatAmountTypedDict]
    r"""The total VAT amount."""
    discounted_subtotal_amount: NotRequired[
        ListSalesInvoicesDiscountedSubtotalAmountTypedDict
    ]
    r"""The total amount without VAT after discounts."""
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    issued_at: NotRequired[Nullable[str]]
    r"""If issued, the date when the sales invoice was issued, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    due_at: NotRequired[Nullable[str]]
    r"""If issued, the date when the sales invoice payment is due, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: NotRequired[ListSalesInvoicesSalesInvoicesResponseLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class ListSalesInvoicesSalesInvoices(BaseModel):
    resource: Optional[str] = "sales-invoice"
    r"""Indicates the response contains a sales invoice object. Will always contain the string `sales-invoice` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this invoice. Example: `invoice_4Y0eZitmBnQ6IDoMqZQKh`."""

    invoice_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="invoiceNumber")
    ] = UNSET
    r"""When issued, an invoice number will be set for the sales invoice."""

    status: Optional[str] = None
    r"""The status for the invoice to end up in.

    A `draft` invoice is not paid or not sent and can be updated after creation. Setting it to `issued` sends it to the recipient so they may then pay through our payment system. To skip our payment process, set this to `paid` to mark it as paid. It can then subsequently be sent as well, same as with `issued`.

    A status value that cannot be set but can be returned is `canceled`, for invoices which were issued, but then canceled. Currently this can only be done for invoices created in the dashboard.

    Dependent parameters: - `paymentDetails` is required if invoice should be set directly to `paid` - `customerId` and `mandateId` are required if a recurring payment should be used to set the invoice to `paid` - `emailDetails` optional for `issued` and `paid` to send the invoice by email

    Possible values: `draft` `issued` `paid`
    """

    vat_scheme: Annotated[Optional[str], pydantic.Field(alias="vatScheme")] = None
    r"""The VAT scheme to create the invoice for. You must be enrolled with One Stop Shop enabled to use it.

    Possible values: `standard` `one-stop-shop` (default: `standard`)
    """

    vat_mode: Annotated[Optional[str], pydantic.Field(alias="vatMode")] = None
    r"""The VAT mode to use for VAT calculation. `exclusive` mode means we will apply the relevant VAT on top of the price. `inclusive` means the prices you are providing to us already contain the VAT you want to apply.

    Possible values: `exclusive` `inclusive` (default: `exclusive`)
    """

    memo: OptionalNullable[str] = UNSET
    r"""A free-form memo you can set on the invoice, and will be shown on the invoice PDF."""

    metadata: OptionalNullable[ListSalesInvoicesMetadata] = UNSET
    r"""Provide any data you like as a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""

    payment_term: Annotated[
        OptionalNullable[str], pydantic.Field(alias="paymentTerm")
    ] = UNSET
    r"""The payment term to be set on the invoice.

    Possible values: `7 days` `14 days` `30 days` `45 days` `60 days` `90 days` `120 days` (default: `30 days`)
    """

    payment_details: Annotated[
        OptionalNullable[ListSalesInvoicesPaymentDetails],
        pydantic.Field(alias="paymentDetails"),
    ] = UNSET
    r"""Used when setting an invoice to status of `paid`, and will store a payment that fully pays the invoice with the provided details. Required for `paid` status."""

    email_details: Annotated[
        OptionalNullable[ListSalesInvoicesEmailDetails],
        pydantic.Field(alias="emailDetails"),
    ] = UNSET
    r"""Used when setting an invoice to status of either `issued` or `paid`. Will be used to issue the invoice to the recipient with the provided `subject` and `body`. Required for `issued` status."""

    customer_id: Annotated[Optional[str], pydantic.Field(alias="customerId")] = None
    r"""The identifier referring to the [customer](get-customer) you want to attempt an automated payment for. If provided, `mandateId` becomes required as well. Only allowed for invoices with status `paid`."""

    mandate_id: Annotated[Optional[str], pydantic.Field(alias="mandateId")] = None
    r"""The identifier referring to the [mandate](get-mandate) you want to use for the automated payment. If provided, `customerId` becomes required as well. Only allowed for invoices with status `paid`."""

    recipient_identifier: Annotated[
        Optional[str], pydantic.Field(alias="recipientIdentifier")
    ] = None
    r"""An identifier tied to the recipient data. This should be a unique value based on data your system contains, so that both you and us know who we're referring to. It is a value you provide to us so that recipient management is not required to send a first invoice to a recipient."""

    recipient: OptionalNullable[ListSalesInvoicesRecipient] = UNSET

    lines: OptionalNullable[List[ListSalesInvoicesLines]] = UNSET
    r"""Provide the line items for the invoice. Each line contains details such as a description of the item ordered and its price.

    All lines must have the same currency as the invoice.
    """

    discount: OptionalNullable[ListSalesInvoicesDiscount] = UNSET
    r"""The discount to be applied to the entire invoice, applied on top of any line item discounts."""

    amount_due: Annotated[
        Optional[ListSalesInvoicesAmountDue], pydantic.Field(alias="amountDue")
    ] = None
    r"""The amount that is left to be paid."""

    subtotal_amount: Annotated[
        Optional[ListSalesInvoicesSubtotalAmount],
        pydantic.Field(alias="subtotalAmount"),
    ] = None
    r"""The total amount without VAT before discounts."""

    total_amount: Annotated[
        Optional[ListSalesInvoicesTotalAmount], pydantic.Field(alias="totalAmount")
    ] = None
    r"""The total amount with VAT."""

    total_vat_amount: Annotated[
        Optional[ListSalesInvoicesTotalVatAmount],
        pydantic.Field(alias="totalVatAmount"),
    ] = None
    r"""The total VAT amount."""

    discounted_subtotal_amount: Annotated[
        Optional[ListSalesInvoicesDiscountedSubtotalAmount],
        pydantic.Field(alias="discountedSubtotalAmount"),
    ] = None
    r"""The total amount without VAT after discounts."""

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    issued_at: Annotated[OptionalNullable[str], pydantic.Field(alias="issuedAt")] = (
        UNSET
    )
    r"""If issued, the date when the sales invoice was issued, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    due_at: Annotated[OptionalNullable[str], pydantic.Field(alias="dueAt")] = UNSET
    r"""If issued, the date when the sales invoice payment is due, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[
        Optional[ListSalesInvoicesSalesInvoicesResponseLinks],
        pydantic.Field(alias="_links"),
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "invoiceNumber",
            "status",
            "vatScheme",
            "vatMode",
            "memo",
            "metadata",
            "paymentTerm",
            "paymentDetails",
            "emailDetails",
            "customerId",
            "mandateId",
            "recipientIdentifier",
            "recipient",
            "lines",
            "discount",
            "amountDue",
            "subtotalAmount",
            "totalAmount",
            "totalVatAmount",
            "discountedSubtotalAmount",
            "createdAt",
            "issuedAt",
            "dueAt",
            "_links",
        ]
        nullable_fields = [
            "invoiceNumber",
            "memo",
            "metadata",
            "paymentTerm",
            "paymentDetails",
            "emailDetails",
            "recipient",
            "lines",
            "discount",
            "issuedAt",
            "dueAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListSalesInvoicesEmbeddedTypedDict(TypedDict):
    sales_invoices: NotRequired[List[ListSalesInvoicesSalesInvoicesTypedDict]]
    r"""An array of sales invoice objects. For a complete reference of the sales invoice object, refer to the [Get sales invoice endpoint](get-sales-invoice) documentation."""


class ListSalesInvoicesEmbedded(BaseModel):
    sales_invoices: Optional[List[ListSalesInvoicesSalesInvoices]] = None
    r"""An array of sales invoice objects. For a complete reference of the sales invoice object, refer to the [Get sales invoice endpoint](get-sales-invoice) documentation."""


class ListSalesInvoicesSelfTypedDict(TypedDict):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSalesInvoicesSelf(BaseModel):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSalesInvoicesPreviousTypedDict(TypedDict):
    r"""The previous set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListSalesInvoicesPrevious(BaseModel):
    r"""The previous set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListSalesInvoicesNextTypedDict(TypedDict):
    r"""The next set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListSalesInvoicesNext(BaseModel):
    r"""The next set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListSalesInvoicesDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSalesInvoicesDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSalesInvoicesLinksTypedDict(TypedDict):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[ListSalesInvoicesSelfTypedDict]
    r"""The URL to the current set of items."""
    previous: NotRequired[Nullable[ListSalesInvoicesPreviousTypedDict]]
    r"""The previous set of items, if available."""
    next: NotRequired[Nullable[ListSalesInvoicesNextTypedDict]]
    r"""The next set of items, if available."""
    documentation: NotRequired[ListSalesInvoicesDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListSalesInvoicesLinks(BaseModel):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[ListSalesInvoicesSelf], pydantic.Field(alias="self")] = (
        None
    )
    r"""The URL to the current set of items."""

    previous: OptionalNullable[ListSalesInvoicesPrevious] = UNSET
    r"""The previous set of items, if available."""

    next: OptionalNullable[ListSalesInvoicesNext] = UNSET
    r"""The next set of items, if available."""

    documentation: Optional[ListSalesInvoicesDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["self", "previous", "next", "documentation"]
        nullable_fields = ["previous", "next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListSalesInvoicesResponseBodyTypedDict(TypedDict):
    r"""A list of sales invoice objects. For a complete reference of the sales invoice object, refer to the [Get sales invoice endpoint](get-sales-invoice) documentation."""

    count: NotRequired[int]
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default limit is 50 items.
    """
    embedded: NotRequired[ListSalesInvoicesEmbeddedTypedDict]
    links: NotRequired[ListSalesInvoicesLinksTypedDict]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class ListSalesInvoicesResponseBody(BaseModel):
    r"""A list of sales invoice objects. For a complete reference of the sales invoice object, refer to the [Get sales invoice endpoint](get-sales-invoice) documentation."""

    count: Optional[int] = None
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default limit is 50 items.
    """

    embedded: Annotated[
        Optional[ListSalesInvoicesEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[
        Optional[ListSalesInvoicesLinks], pydantic.Field(alias="_links")
    ] = None
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
