"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .url import URL, URLTypedDict
from .url_nullable import URLNullable, URLNullableTypedDict
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict


class ListEntityChargebackSettlementAmountTypedDict(TypedDict):
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted
    to the currency your account is settled in.

    The amount is a **negative** amount.

    Since the field contains an estimated amount during chargeback processing, it may change over time. To retrieve
    accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions)
    instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListEntityChargebackSettlementAmount(BaseModel):
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted
    to the currency your account is settled in.

    The amount is a **negative** amount.

    Since the field contains an estimated amount during chargeback processing, it may change over time. To retrieve
    accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions)
    instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListEntityChargebackReasonTypedDict(TypedDict):
    r"""Reason for the chargeback as given by the bank. Only available for chargebacks of SEPA Direct Debit payments."""

    code: str
    r"""Technical code provided by the bank."""
    description: str
    r"""A more detailed human-friendly description."""


class ListEntityChargebackReason(BaseModel):
    r"""Reason for the chargeback as given by the bank. Only available for chargebacks of SEPA Direct Debit payments."""

    code: str
    r"""Technical code provided by the bank."""

    description: str
    r"""A more detailed human-friendly description."""


class ListEntityChargebackLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payment: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    settlement: NotRequired[Nullable[URLNullableTypedDict]]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListEntityChargebackLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[URL, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payment: URL
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    settlement: OptionalNullable[URLNullable] = UNSET
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["settlement"]
        nullable_fields = ["settlement"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListEntityChargebackTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a chargeback object. Will always contain the string `chargeback` for this
    endpoint.
    """
    id: str
    r"""The identifier uniquely referring to this chargeback. Example: `chb_n9z0tp`."""
    amount: AmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    payment_id: str
    r"""The unique identifier of the payment this chargeback was created for. For example: `tr_5B8cwPMGnU6qLbRvo7qEZo`.
    The full payment object can be retrieved via the payment URL in the `_links` object.
    """
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: ListEntityChargebackLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    settlement_amount: NotRequired[
        Nullable[ListEntityChargebackSettlementAmountTypedDict]
    ]
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted
    to the currency your account is settled in.

    The amount is a **negative** amount.

    Since the field contains an estimated amount during chargeback processing, it may change over time. To retrieve
    accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions)
    instead.
    """
    reason: NotRequired[Nullable[ListEntityChargebackReasonTypedDict]]
    r"""Reason for the chargeback as given by the bank. Only available for chargebacks of SEPA Direct Debit payments."""
    settlement_id: NotRequired[Nullable[str]]
    r"""The identifier referring to the settlement this payment was settled with. For example, `stl_BkEjN2eBb`. This field
    is omitted if the refund is not settled (yet).
    """
    reversed_at: NotRequired[Nullable[str]]
    r"""The date and time the chargeback was reversed if applicable, in
    [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format.
    """


class ListEntityChargeback(BaseModel):
    resource: str
    r"""Indicates the response contains a chargeback object. Will always contain the string `chargeback` for this
    endpoint.
    """

    id: str
    r"""The identifier uniquely referring to this chargeback. Example: `chb_n9z0tp`."""

    amount: Amount
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    payment_id: Annotated[str, pydantic.Field(alias="paymentId")]
    r"""The unique identifier of the payment this chargeback was created for. For example: `tr_5B8cwPMGnU6qLbRvo7qEZo`.
    The full payment object can be retrieved via the payment URL in the `_links` object.
    """

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[ListEntityChargebackLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    settlement_amount: Annotated[
        OptionalNullable[ListEntityChargebackSettlementAmount],
        pydantic.Field(alias="settlementAmount"),
    ] = UNSET
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted
    to the currency your account is settled in.

    The amount is a **negative** amount.

    Since the field contains an estimated amount during chargeback processing, it may change over time. To retrieve
    accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions)
    instead.
    """

    reason: OptionalNullable[ListEntityChargebackReason] = UNSET
    r"""Reason for the chargeback as given by the bank. Only available for chargebacks of SEPA Direct Debit payments."""

    settlement_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="settlementId")
    ] = UNSET
    r"""The identifier referring to the settlement this payment was settled with. For example, `stl_BkEjN2eBb`. This field
    is omitted if the refund is not settled (yet).
    """

    reversed_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="reversedAt")
    ] = UNSET
    r"""The date and time the chargeback was reversed if applicable, in
    [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["settlementAmount", "reason", "settlementId", "reversedAt"]
        nullable_fields = ["settlementAmount", "reason", "settlementId", "reversedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
