"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .mode import Mode
from .url import URL, URLTypedDict
from .webhook_event_types import WebhookEventTypes
from .webhook_status import WebhookStatus
from mollie.types import BaseModel, Nullable, UNSET_SENTINEL
from mollie.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import List
from typing_extensions import Annotated, TypedDict


class CreateWebhookLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class CreateWebhookLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[URL, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: URL
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class CreateWebhookTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a webhook subscription object. Will always contain the string `webhook` for this endpoint."""
    id: str
    r"""The identifier uniquely referring to this subscription."""
    url: str
    r"""The subscription's events destination."""
    profile_id: Nullable[str]
    r"""The identifier uniquely referring to the profile that created the subscription."""
    created_at: str
    r"""The subscription's date time of creation."""
    name: str
    r"""The subscription's name."""
    event_types: List[WebhookEventTypes]
    r"""The events types that are subscribed."""
    status: WebhookStatus
    r"""The subscription's current status."""
    mode: Mode
    r"""Whether this entity was created in live mode or in test mode."""
    webhook_secret: str
    r"""The subscription's secret."""
    links: CreateWebhookLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class CreateWebhook(BaseModel):
    resource: str
    r"""Indicates the response contains a webhook subscription object. Will always contain the string `webhook` for this endpoint."""

    id: str
    r"""The identifier uniquely referring to this subscription."""

    url: str
    r"""The subscription's events destination."""

    profile_id: Annotated[Nullable[str], pydantic.Field(alias="profileId")]
    r"""The identifier uniquely referring to the profile that created the subscription."""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The subscription's date time of creation."""

    name: str
    r"""The subscription's name."""

    event_types: Annotated[List[WebhookEventTypes], pydantic.Field(alias="eventTypes")]
    r"""The events types that are subscribed."""

    status: Annotated[WebhookStatus, PlainValidator(validate_open_enum(False))]
    r"""The subscription's current status."""

    mode: Annotated[Mode, PlainValidator(validate_open_enum(False))]
    r"""Whether this entity was created in live mode or in test mode."""

    webhook_secret: Annotated[str, pydantic.Field(alias="webhookSecret")]
    r"""The subscription's secret."""

    links: Annotated[CreateWebhookLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["profileId"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
