"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .webhook_event_types import WebhookEventTypes
from mollie.types import BaseModel
from mollie.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    RequestMetadata,
)
import pydantic
from typing import List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


UpdateWebhookEventTypesTypedDict = TypeAliasType(
    "UpdateWebhookEventTypesTypedDict",
    Union[List[WebhookEventTypes], WebhookEventTypes],
)


UpdateWebhookEventTypes = TypeAliasType(
    "UpdateWebhookEventTypes", Union[List[WebhookEventTypes], WebhookEventTypes]
)


class UpdateWebhookRequestBodyTypedDict(TypedDict):
    name: NotRequired[str]
    r"""A name that identifies the webhook."""
    url: NotRequired[str]
    r"""The URL Mollie will send the events to. This URL must be publicly accessible."""
    event_types: NotRequired[UpdateWebhookEventTypesTypedDict]
    testmode: NotRequired[bool]
    r"""You can enable test mode by setting `testmode` to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class UpdateWebhookRequestBody(BaseModel):
    name: Optional[str] = None
    r"""A name that identifies the webhook."""

    url: Optional[str] = None
    r"""The URL Mollie will send the events to. This URL must be publicly accessible."""

    event_types: Annotated[
        Optional[UpdateWebhookEventTypes], pydantic.Field(alias="eventTypes")
    ] = None

    testmode: Optional[bool] = None
    r"""You can enable test mode by setting `testmode` to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class UpdateWebhookRequestTypedDict(TypedDict):
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""
    idempotency_key: NotRequired[str]
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""
    request_body: NotRequired[UpdateWebhookRequestBodyTypedDict]


class UpdateWebhookRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""

    idempotency_key: Annotated[
        Optional[str],
        pydantic.Field(alias="idempotency-key"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""

    request_body: Annotated[
        Optional[UpdateWebhookRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None
