"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .amount_nullable import AmountNullable, AmountNullableTypedDict
from .mode import Mode
from .payment_address import PaymentAddress, PaymentAddressTypedDict
from .payment_line_item_response import (
    PaymentLineItemResponse,
    PaymentLineItemResponseTypedDict,
)
from .payment_link_method_response import PaymentLinkMethodResponse
from .payment_link_sequence_type_response import PaymentLinkSequenceTypeResponse
from .url import URL, URLTypedDict
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PaymentLinkResponseApplicationFeeTypedDict(TypedDict):
    r"""With Mollie Connect you can charge fees on payment links that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payment links on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If a payment on the payment link succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.
    """

    amount: AmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    description: str
    r"""The description of the application fee. This will appear on settlement reports towards both you and the
    connected merchant.
    """


class PaymentLinkResponseApplicationFee(BaseModel):
    r"""With Mollie Connect you can charge fees on payment links that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payment links on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If a payment on the payment link succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.
    """

    amount: Amount
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    description: str
    r"""The description of the application fee. This will appear on settlement reports towards both you and the
    connected merchant.
    """


class PaymentLinkResponseLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payment_link: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class PaymentLinkResponseLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[URL, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payment_link: Annotated[URL, pydantic.Field(alias="paymentLink")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class PaymentLinkResponseTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a payment link object. Will always contain the string `payment-link` for this
    endpoint.
    """
    id: str
    r"""The identifier uniquely referring to this payment link. Example: `pl_4Y0eZitmBnQ6IDoMqZQKh`."""
    mode: Mode
    r"""Whether this entity was created in live mode or in test mode."""
    description: str
    r"""A short description of the payment link. The description is visible in the Dashboard and will be shown on the
    customer's bank or card statement when possible.
    """
    amount: Nullable[AmountNullableTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    archived: bool
    r"""Whether the payment link is archived. Customers will not be able to complete payments on archived payment links."""
    redirect_url: Nullable[str]
    r"""The URL your customer will be redirected to after completing the payment process. If no redirect URL is provided,
    the customer will be shown a generic message after completing the payment.
    """
    webhook_url: Nullable[str]
    r"""The webhook URL where we will send payment status updates to.

    The webhookUrl is optional, but without a webhook you will miss out on important status changes to any payments
    resulting from the payment link.

    The webhookUrl must be reachable from Mollie's point of view, so you cannot use `localhost`. If you want to use
    webhook during development on `localhost`, you must use a tool like ngrok to have the webhooks delivered to your
    local machine.
    """
    profile_id: Nullable[str]
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation
    request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is
    required.
    """
    reusable: Nullable[bool]
    r"""Indicates whether the payment link is reusable. If this field is set to `true`, customers can make multiple
    payments using the same link.

    If no value is specified, the field defaults to `false`, allowing only a single payment per link.
    """
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    paid_at: Nullable[str]
    r"""The date and time the payment link became paid, in ISO 8601 format."""
    expires_at: Nullable[str]
    r"""The date and time the payment link is set to expire, in ISO 8601 format. If no expiry date was provided up front,
    the payment link will not expire automatically.
    """
    allowed_methods: Nullable[List[PaymentLinkMethodResponse]]
    r"""An array of payment methods that are allowed to be used for this payment link. When this parameter is
    not provided or is an empty array, all enabled payment methods will be available.
    """
    links: PaymentLinkResponseLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    minimum_amount: NotRequired[Nullable[AmountNullableTypedDict]]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    lines: NotRequired[Nullable[List[PaymentLineItemResponseTypedDict]]]
    r"""Optionally provide the order lines for the payment. Each line contains details such as a description of the item
    ordered and its price.

    All lines must have the same currency as the payment.

    Required for payment methods `billie`, `in3`, `klarna`, `riverty` and `voucher`.
    """
    billing_address: NotRequired[PaymentAddressTypedDict]
    shipping_address: NotRequired[PaymentAddressTypedDict]
    application_fee: NotRequired[PaymentLinkResponseApplicationFeeTypedDict]
    r"""With Mollie Connect you can charge fees on payment links that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payment links on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If a payment on the payment link succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.
    """
    sequence_type: NotRequired[PaymentLinkSequenceTypeResponse]
    customer_id: NotRequired[Nullable[str]]
    r"""**Only relevant when `sequenceType` is set to `first`**

    The ID of the [customer](get-customer) the payment link is being created for. If a value is not provided,
    the customer will be required to input relevant information which will be used to establish a mandate after
    the payment is made.
    """


class PaymentLinkResponse(BaseModel):
    resource: str
    r"""Indicates the response contains a payment link object. Will always contain the string `payment-link` for this
    endpoint.
    """

    id: str
    r"""The identifier uniquely referring to this payment link. Example: `pl_4Y0eZitmBnQ6IDoMqZQKh`."""

    mode: Annotated[Mode, PlainValidator(validate_open_enum(False))]
    r"""Whether this entity was created in live mode or in test mode."""

    description: str
    r"""A short description of the payment link. The description is visible in the Dashboard and will be shown on the
    customer's bank or card statement when possible.
    """

    amount: Nullable[AmountNullable]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    archived: bool
    r"""Whether the payment link is archived. Customers will not be able to complete payments on archived payment links."""

    redirect_url: Annotated[Nullable[str], pydantic.Field(alias="redirectUrl")]
    r"""The URL your customer will be redirected to after completing the payment process. If no redirect URL is provided,
    the customer will be shown a generic message after completing the payment.
    """

    webhook_url: Annotated[Nullable[str], pydantic.Field(alias="webhookUrl")]
    r"""The webhook URL where we will send payment status updates to.

    The webhookUrl is optional, but without a webhook you will miss out on important status changes to any payments
    resulting from the payment link.

    The webhookUrl must be reachable from Mollie's point of view, so you cannot use `localhost`. If you want to use
    webhook during development on `localhost`, you must use a tool like ngrok to have the webhooks delivered to your
    local machine.
    """

    profile_id: Annotated[Nullable[str], pydantic.Field(alias="profileId")]
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation
    request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is
    required.
    """

    reusable: Nullable[bool]
    r"""Indicates whether the payment link is reusable. If this field is set to `true`, customers can make multiple
    payments using the same link.

    If no value is specified, the field defaults to `false`, allowing only a single payment per link.
    """

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    paid_at: Annotated[Nullable[str], pydantic.Field(alias="paidAt")]
    r"""The date and time the payment link became paid, in ISO 8601 format."""

    expires_at: Annotated[Nullable[str], pydantic.Field(alias="expiresAt")]
    r"""The date and time the payment link is set to expire, in ISO 8601 format. If no expiry date was provided up front,
    the payment link will not expire automatically.
    """

    allowed_methods: Annotated[
        Nullable[
            List[
                Annotated[
                    PaymentLinkMethodResponse, PlainValidator(validate_open_enum(False))
                ]
            ]
        ],
        pydantic.Field(alias="allowedMethods"),
    ]
    r"""An array of payment methods that are allowed to be used for this payment link. When this parameter is
    not provided or is an empty array, all enabled payment methods will be available.
    """

    links: Annotated[PaymentLinkResponseLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    minimum_amount: Annotated[
        OptionalNullable[AmountNullable], pydantic.Field(alias="minimumAmount")
    ] = UNSET
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    lines: OptionalNullable[List[PaymentLineItemResponse]] = UNSET
    r"""Optionally provide the order lines for the payment. Each line contains details such as a description of the item
    ordered and its price.

    All lines must have the same currency as the payment.

    Required for payment methods `billie`, `in3`, `klarna`, `riverty` and `voucher`.
    """

    billing_address: Annotated[
        Optional[PaymentAddress], pydantic.Field(alias="billingAddress")
    ] = None

    shipping_address: Annotated[
        Optional[PaymentAddress], pydantic.Field(alias="shippingAddress")
    ] = None

    application_fee: Annotated[
        Optional[PaymentLinkResponseApplicationFee],
        pydantic.Field(alias="applicationFee"),
    ] = None
    r"""With Mollie Connect you can charge fees on payment links that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payment links on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If a payment on the payment link succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.
    """

    sequence_type: Annotated[
        Annotated[
            Optional[PaymentLinkSequenceTypeResponse],
            PlainValidator(validate_open_enum(False)),
        ],
        pydantic.Field(alias="sequenceType"),
    ] = None

    customer_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="customerId")
    ] = UNSET
    r"""**Only relevant when `sequenceType` is set to `first`**

    The ID of the [customer](get-customer) the payment link is being created for. If a value is not provided,
    the customer will be required to input relevant information which will be used to establish a mandate after
    the payment is made.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "minimumAmount",
            "lines",
            "billingAddress",
            "shippingAddress",
            "applicationFee",
            "sequenceType",
            "customerId",
        ]
        nullable_fields = [
            "amount",
            "minimumAmount",
            "redirectUrl",
            "webhookUrl",
            "lines",
            "profileId",
            "reusable",
            "paidAt",
            "expiresAt",
            "allowedMethods",
            "customerId",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
