"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .metadata import Metadata, MetadataTypedDict
from .subscription_method import SubscriptionMethod
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class SubscriptionRequestApplicationFeeTypedDict(TypedDict):
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    Setting an application fee on the subscription will ensure this fee is charged on each individual payment.

    Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more
    information.
    """

    amount: AmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    description: str


class SubscriptionRequestApplicationFee(BaseModel):
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    Setting an application fee on the subscription will ensure this fee is charged on each individual payment.

    Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more
    information.
    """

    amount: Amount
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    description: str


class SubscriptionRequestTypedDict(TypedDict):
    amount: NotRequired[AmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    times: NotRequired[Nullable[int]]
    r"""Total number of payments for the subscription. Once this number of payments is reached, the subscription is
    considered completed.

    Test mode subscriptions will get canceled automatically after 10 payments.
    """
    interval: NotRequired[str]
    r"""Interval to wait between payments, for example `1 month` or `14 days`.

    The maximum interval is one year (`12 months`, `52 weeks`, or `365 days`).

    Possible values: `... days`, `... weeks`, `... months`.
    """
    start_date: NotRequired[str]
    r"""The start date of the subscription in `YYYY-MM-DD` format."""
    description: NotRequired[str]
    r"""The subscription's description will be used as the description of the resulting individual payments and so showing
    up on the bank statement of the consumer.

    **Please note:** the description needs to be unique for the Customer in case it has multiple active subscriptions.
    """
    method: NotRequired[Nullable[SubscriptionMethod]]
    r"""The payment method used for this subscription. If omitted, any of the customer's valid mandates may be used."""
    application_fee: NotRequired[SubscriptionRequestApplicationFeeTypedDict]
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    Setting an application fee on the subscription will ensure this fee is charged on each individual payment.

    Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more
    information.
    """
    metadata: NotRequired[Nullable[MetadataTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """
    webhook_url: NotRequired[str]
    r"""We will call this URL for any payment status changes of payments resulting from this subscription.

    This webhook will receive **all** events for the subscription's payments. This may include payment failures as
    well. Be sure to verify the payment's subscription ID and its status.
    """
    mandate_id: NotRequired[str]
    profile_id: NotRequired[str]
    testmode: NotRequired[Nullable[bool]]
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """


class SubscriptionRequest(BaseModel):
    amount: Optional[Amount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    times: OptionalNullable[int] = UNSET
    r"""Total number of payments for the subscription. Once this number of payments is reached, the subscription is
    considered completed.

    Test mode subscriptions will get canceled automatically after 10 payments.
    """

    interval: Optional[str] = None
    r"""Interval to wait between payments, for example `1 month` or `14 days`.

    The maximum interval is one year (`12 months`, `52 weeks`, or `365 days`).

    Possible values: `... days`, `... weeks`, `... months`.
    """

    start_date: Annotated[Optional[str], pydantic.Field(alias="startDate")] = None
    r"""The start date of the subscription in `YYYY-MM-DD` format."""

    description: Optional[str] = None
    r"""The subscription's description will be used as the description of the resulting individual payments and so showing
    up on the bank statement of the consumer.

    **Please note:** the description needs to be unique for the Customer in case it has multiple active subscriptions.
    """

    method: OptionalNullable[SubscriptionMethod] = UNSET
    r"""The payment method used for this subscription. If omitted, any of the customer's valid mandates may be used."""

    application_fee: Annotated[
        Optional[SubscriptionRequestApplicationFee],
        pydantic.Field(alias="applicationFee"),
    ] = None
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    Setting an application fee on the subscription will ensure this fee is charged on each individual payment.

    Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more
    information.
    """

    metadata: OptionalNullable[Metadata] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """

    webhook_url: Annotated[Optional[str], pydantic.Field(alias="webhookUrl")] = None
    r"""We will call this URL for any payment status changes of payments resulting from this subscription.

    This webhook will receive **all** events for the subscription's payments. This may include payment failures as
    well. Be sure to verify the payment's subscription ID and its status.
    """

    mandate_id: Annotated[Optional[str], pydantic.Field(alias="mandateId")] = None

    profile_id: Annotated[Optional[str], pydantic.Field(alias="profileId")] = None

    testmode: OptionalNullable[bool] = UNSET
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "amount",
            "times",
            "interval",
            "startDate",
            "description",
            "method",
            "applicationFee",
            "metadata",
            "webhookUrl",
            "mandateId",
            "profileId",
            "testmode",
        ]
        nullable_fields = ["times", "method", "metadata", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
