"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from pydantic import model_serializer
from typing import Any, Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class CreateCustomerPaymentAmountTypedDict(TypedDict):
    r"""The amount that you want to charge, e.g. `{currency:\"EUR\", value:\"1000.00\"}` if you would want to charge €1000.00.

    You can find the minimum and maximum amounts per payment method in our help center. Additionally, they can be retrieved using the Get method endpoint.

    If a tip was added for a Point-of-Sale payment, the amount will be updated to reflect the initial amount plus the tip amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentAmount(BaseModel):
    r"""The amount that you want to charge, e.g. `{currency:\"EUR\", value:\"1000.00\"}` if you would want to charge €1000.00.

    You can find the minimum and maximum amounts per payment method in our help center. Additionally, they can be retrieved using the Get method endpoint.

    If a tip was added for a Point-of-Sale payment, the amount will be updated to reflect the initial amount plus the tip amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentUnitPriceTypedDict(TypedDict):
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentUnitPrice(BaseModel):
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentDiscountAmountTypedDict(TypedDict):
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount type."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentDiscountAmount(BaseModel):
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount type."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentTotalAmountTypedDict(TypedDict):
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentTotalAmount(BaseModel):
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentVatAmountTypedDict(TypedDict):
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentVatAmount(BaseModel):
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentCategories(str, Enum):
    MEAL = "meal"
    ECO = "eco"
    GIFT = "gift"
    SPORT_CULTURE = "sport_culture"


class CreateCustomerPaymentCustomersAmountTypedDict(TypedDict):
    r"""Total amount and currency of the recurring item."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentCustomersAmount(BaseModel):
    r"""Total amount and currency of the recurring item."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentRecurringTypedDict(TypedDict):
    r"""The details of subsequent recurring billing cycles. These parameters are used in the Mollie Checkout to inform the shopper of the details for recurring products in the payments."""

    interval: str
    r"""Cadence unit of the recurring item. For example: `12 months`, `52 weeks` or `365 days`.

    Possible values: `... months` `... weeks` `... days`
    """
    description: NotRequired[str]
    r"""A description of the recurring item. If not present, the main description of the item will be used."""
    amount: NotRequired[CreateCustomerPaymentCustomersAmountTypedDict]
    r"""Total amount and currency of the recurring item."""
    times: NotRequired[int]
    r"""Total number of charges for the subscription to complete. Leave empty for ongoing subscription."""
    start_date: NotRequired[Nullable[str]]
    r"""The start date of the subscription if it does not start right away (format `YYYY-MM-DD`)"""


class CreateCustomerPaymentRecurring(BaseModel):
    r"""The details of subsequent recurring billing cycles. These parameters are used in the Mollie Checkout to inform the shopper of the details for recurring products in the payments."""

    interval: str
    r"""Cadence unit of the recurring item. For example: `12 months`, `52 weeks` or `365 days`.

    Possible values: `... months` `... weeks` `... days`
    """

    description: Optional[str] = None
    r"""A description of the recurring item. If not present, the main description of the item will be used."""

    amount: Optional[CreateCustomerPaymentCustomersAmount] = None
    r"""Total amount and currency of the recurring item."""

    times: Optional[int] = None
    r"""Total number of charges for the subscription to complete. Leave empty for ongoing subscription."""

    start_date: Annotated[OptionalNullable[str], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the subscription if it does not start right away (format `YYYY-MM-DD`)"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "amount", "times", "startDate"]
        nullable_fields = ["startDate"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateCustomerPaymentLinesTypedDict(TypedDict):
    description: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""
    quantity: int
    r"""The number of items."""
    unit_price: CreateCustomerPaymentUnitPriceTypedDict
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """
    total_amount: CreateCustomerPaymentTotalAmountTypedDict
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """
    type: NotRequired[str]
    r"""The type of product purchased. For example, a physical or a digital product.

    The `tip` payment line type is not available when creating a payment.

    Possible values: `physical` `digital` `shipping_fee` `discount` `store_credit` `gift_card` `surcharge` `tip` (default: `physical`)
    """
    quantity_unit: NotRequired[str]
    r"""The unit for the quantity. For example *pcs*, *kg*, or *cm*."""
    discount_amount: NotRequired[CreateCustomerPaymentDiscountAmountTypedDict]
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount type."""
    vat_rate: NotRequired[str]
    r"""The VAT rate applied to the line, for example `21.00` for 21%. The vatRate should be passed as a string and not as a float, to ensure the correct number of decimals are passed."""
    vat_amount: NotRequired[CreateCustomerPaymentVatAmountTypedDict]
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """
    sku: NotRequired[str]
    r"""The SKU, EAN, ISBN or UPC of the product sold."""
    categories: NotRequired[List[CreateCustomerPaymentCategories]]
    r"""An array with the voucher categories, in case of a line eligible for a voucher. See the [Integrating Vouchers](integrating-vouchers) guide for more information."""
    image_url: NotRequired[str]
    r"""A link pointing to an image of the product sold."""
    product_url: NotRequired[str]
    r"""A link pointing to the product page in your web shop of the product sold."""
    recurring: NotRequired[CreateCustomerPaymentRecurringTypedDict]
    r"""The details of subsequent recurring billing cycles. These parameters are used in the Mollie Checkout to inform the shopper of the details for recurring products in the payments."""


class CreateCustomerPaymentLines(BaseModel):
    description: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""

    quantity: int
    r"""The number of items."""

    unit_price: Annotated[
        CreateCustomerPaymentUnitPrice, pydantic.Field(alias="unitPrice")
    ]
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """

    total_amount: Annotated[
        CreateCustomerPaymentTotalAmount, pydantic.Field(alias="totalAmount")
    ]
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """

    type: Optional[str] = None
    r"""The type of product purchased. For example, a physical or a digital product.

    The `tip` payment line type is not available when creating a payment.

    Possible values: `physical` `digital` `shipping_fee` `discount` `store_credit` `gift_card` `surcharge` `tip` (default: `physical`)
    """

    quantity_unit: Annotated[Optional[str], pydantic.Field(alias="quantityUnit")] = None
    r"""The unit for the quantity. For example *pcs*, *kg*, or *cm*."""

    discount_amount: Annotated[
        Optional[CreateCustomerPaymentDiscountAmount],
        pydantic.Field(alias="discountAmount"),
    ] = None
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount type."""

    vat_rate: Annotated[Optional[str], pydantic.Field(alias="vatRate")] = None
    r"""The VAT rate applied to the line, for example `21.00` for 21%. The vatRate should be passed as a string and not as a float, to ensure the correct number of decimals are passed."""

    vat_amount: Annotated[
        Optional[CreateCustomerPaymentVatAmount], pydantic.Field(alias="vatAmount")
    ] = None
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """

    sku: Optional[str] = None
    r"""The SKU, EAN, ISBN or UPC of the product sold."""

    categories: Optional[List[CreateCustomerPaymentCategories]] = None
    r"""An array with the voucher categories, in case of a line eligible for a voucher. See the [Integrating Vouchers](integrating-vouchers) guide for more information."""

    image_url: Annotated[Optional[str], pydantic.Field(alias="imageUrl")] = None
    r"""A link pointing to an image of the product sold."""

    product_url: Annotated[Optional[str], pydantic.Field(alias="productUrl")] = None
    r"""A link pointing to the product page in your web shop of the product sold."""

    recurring: Optional[CreateCustomerPaymentRecurring] = None
    r"""The details of subsequent recurring billing cycles. These parameters are used in the Mollie Checkout to inform the shopper of the details for recurring products in the payments."""


class CreateCustomerPaymentBillingAddressTypedDict(TypedDict):
    r"""The customer's billing address details. We advise to provide these details to improve fraud protection and conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and `country`.

    Required for payment method `in3`, `klarna`, `billie` and `riverty`.
    """

    title: NotRequired[str]
    r"""The title of the person, for example *Mr.* or *Mrs.*."""
    given_name: NotRequired[str]
    r"""The given name (first name) of the person should be at least two characters and cannot contain only numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    family_name: NotRequired[str]
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    organization_name: NotRequired[str]
    r"""The name of the organization, in case the addressee is an organization."""
    street_and_number: NotRequired[str]
    r"""A street and street number.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    street_additional: NotRequired[str]
    r"""Any additional addressing details, for example an apartment number."""
    postal_code: NotRequired[str]
    r"""A postal code. This field may be required if the provided country has a postal code system.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    email: NotRequired[str]
    r"""A valid e-mail address.

    If you provide the email address for a `banktransfer` payment, we will automatically send the instructions email upon payment creation. The language of the email will follow the locale parameter of the payment.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    phone: NotRequired[str]
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""
    city: NotRequired[str]
    r"""A city name.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    region: NotRequired[str]
    r"""The top-level administrative subdivision of the country. For example: Noord-Holland."""
    country: NotRequired[str]
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """


class CreateCustomerPaymentBillingAddress(BaseModel):
    r"""The customer's billing address details. We advise to provide these details to improve fraud protection and conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and `country`.

    Required for payment method `in3`, `klarna`, `billie` and `riverty`.
    """

    title: Optional[str] = None
    r"""The title of the person, for example *Mr.* or *Mrs.*."""

    given_name: Annotated[Optional[str], pydantic.Field(alias="givenName")] = None
    r"""The given name (first name) of the person should be at least two characters and cannot contain only numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    family_name: Annotated[Optional[str], pydantic.Field(alias="familyName")] = None
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    organization_name: Annotated[
        Optional[str], pydantic.Field(alias="organizationName")
    ] = None
    r"""The name of the organization, in case the addressee is an organization."""

    street_and_number: Annotated[
        Optional[str], pydantic.Field(alias="streetAndNumber")
    ] = None
    r"""A street and street number.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    street_additional: Annotated[
        Optional[str], pydantic.Field(alias="streetAdditional")
    ] = None
    r"""Any additional addressing details, for example an apartment number."""

    postal_code: Annotated[Optional[str], pydantic.Field(alias="postalCode")] = None
    r"""A postal code. This field may be required if the provided country has a postal code system.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    email: Optional[str] = None
    r"""A valid e-mail address.

    If you provide the email address for a `banktransfer` payment, we will automatically send the instructions email upon payment creation. The language of the email will follow the locale parameter of the payment.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    phone: Optional[str] = None
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""

    city: Optional[str] = None
    r"""A city name.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    region: Optional[str] = None
    r"""The top-level administrative subdivision of the country. For example: Noord-Holland."""

    country: Optional[str] = None
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """


class CreateCustomerPaymentShippingAddressTypedDict(TypedDict):
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and `country`.
    """

    title: NotRequired[str]
    r"""The title of the person, for example *Mr.* or *Mrs.*."""
    given_name: NotRequired[str]
    r"""The given name (first name) of the person should be at least two characters and cannot contain only numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    family_name: NotRequired[str]
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    organization_name: NotRequired[str]
    r"""The name of the organization, in case the addressee is an organization."""
    street_and_number: NotRequired[str]
    r"""A street and street number.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    street_additional: NotRequired[str]
    r"""Any additional addressing details, for example an apartment number."""
    postal_code: NotRequired[str]
    r"""A postal code. This field may be required if the provided country has a postal code system.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    email: NotRequired[str]
    r"""A valid e-mail address.

    If you provide the email address for a `banktransfer` payment, we will automatically send the instructions email upon payment creation. The language of the email will follow the locale parameter of the payment.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    phone: NotRequired[str]
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""
    city: NotRequired[str]
    r"""A city name.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    region: NotRequired[str]
    r"""The top-level administrative subdivision of the country. For example: Noord-Holland."""
    country: NotRequired[str]
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """


class CreateCustomerPaymentShippingAddress(BaseModel):
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and `country`.
    """

    title: Optional[str] = None
    r"""The title of the person, for example *Mr.* or *Mrs.*."""

    given_name: Annotated[Optional[str], pydantic.Field(alias="givenName")] = None
    r"""The given name (first name) of the person should be at least two characters and cannot contain only numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    family_name: Annotated[Optional[str], pydantic.Field(alias="familyName")] = None
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    organization_name: Annotated[
        Optional[str], pydantic.Field(alias="organizationName")
    ] = None
    r"""The name of the organization, in case the addressee is an organization."""

    street_and_number: Annotated[
        Optional[str], pydantic.Field(alias="streetAndNumber")
    ] = None
    r"""A street and street number.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    street_additional: Annotated[
        Optional[str], pydantic.Field(alias="streetAdditional")
    ] = None
    r"""Any additional addressing details, for example an apartment number."""

    postal_code: Annotated[Optional[str], pydantic.Field(alias="postalCode")] = None
    r"""A postal code. This field may be required if the provided country has a postal code system.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    email: Optional[str] = None
    r"""A valid e-mail address.

    If you provide the email address for a `banktransfer` payment, we will automatically send the instructions email upon payment creation. The language of the email will follow the locale parameter of the payment.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    phone: Optional[str] = None
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""

    city: Optional[str] = None
    r"""A city name.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    region: Optional[str] = None
    r"""The top-level administrative subdivision of the country. For example: Noord-Holland."""

    country: Optional[str] = None
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """


class CreateCustomerPaymentMetadata2TypedDict(TypedDict):
    pass


class CreateCustomerPaymentMetadata2(BaseModel):
    pass


CreateCustomerPaymentMetadataTypedDict = TypeAliasType(
    "CreateCustomerPaymentMetadataTypedDict",
    Union[CreateCustomerPaymentMetadata2TypedDict, str, List[str]],
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""


CreateCustomerPaymentMetadata = TypeAliasType(
    "CreateCustomerPaymentMetadata",
    Union[CreateCustomerPaymentMetadata2, str, List[str]],
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""


class CreateCustomerPaymentCustomersRequestAmountTypedDict(TypedDict):
    r"""The fee that you wish to charge.

    Be careful to leave enough space for Mollie's own fees to be deducted as well. For example, you cannot charge a €0.99 fee on a €1.00 payment.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentCustomersRequestAmount(BaseModel):
    r"""The fee that you wish to charge.

    Be careful to leave enough space for Mollie's own fees to be deducted as well. For example, you cannot charge a €0.99 fee on a €1.00 payment.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentApplicationFeeTypedDict(TypedDict):
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie merchants.

    If you use OAuth to create payments on a connected merchant's account, you can charge a fee using this `applicationFee` parameter. If the payment succeeds, the fee will be deducted from the merchant's balance and sent to your own account balance.

    If instead you want to split a payment on your own account between yourself and a connected merchant, refer to the `routing` parameter.
    """

    amount: NotRequired[CreateCustomerPaymentCustomersRequestAmountTypedDict]
    r"""The fee that you wish to charge.

    Be careful to leave enough space for Mollie's own fees to be deducted as well. For example, you cannot charge a €0.99 fee on a €1.00 payment.
    """
    description: NotRequired[str]
    r"""The description of the application fee. This will appear on settlement reports towards both you and the connected merchant."""


class CreateCustomerPaymentApplicationFee(BaseModel):
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie merchants.

    If you use OAuth to create payments on a connected merchant's account, you can charge a fee using this `applicationFee` parameter. If the payment succeeds, the fee will be deducted from the merchant's balance and sent to your own account balance.

    If instead you want to split a payment on your own account between yourself and a connected merchant, refer to the `routing` parameter.
    """

    amount: Optional[CreateCustomerPaymentCustomersRequestAmount] = None
    r"""The fee that you wish to charge.

    Be careful to leave enough space for Mollie's own fees to be deducted as well. For example, you cannot charge a €0.99 fee on a €1.00 payment.
    """

    description: Optional[str] = None
    r"""The description of the application fee. This will appear on settlement reports towards both you and the connected merchant."""


class CreateCustomerPaymentCustomersRequestRequestBodyAmountTypedDict(TypedDict):
    r"""The portion of the total payment amount being routed. Currently only `EUR` payments can be routed."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentCustomersRequestRequestBodyAmount(BaseModel):
    r"""The portion of the total payment amount being routed. Currently only `EUR` payments can be routed."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentDestinationTypedDict(TypedDict):
    r"""The destination of this portion of the payment."""

    type: str
    r"""The type of destination. Currently only the destination type `organization` is supported.

    Possible values: `organization`
    """
    organization_id: str
    r"""Required for destination type `organization`. The ID of the connected organization the funds should be routed to."""


class CreateCustomerPaymentDestination(BaseModel):
    r"""The destination of this portion of the payment."""

    type: str
    r"""The type of destination. Currently only the destination type `organization` is supported.

    Possible values: `organization`
    """

    organization_id: Annotated[str, pydantic.Field(alias="organizationId")]
    r"""Required for destination type `organization`. The ID of the connected organization the funds should be routed to."""


class CreateCustomerPaymentSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentPaymentTypedDict(TypedDict):
    r"""The API resource URL of the [payment](get-payment) that belong to this route."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentPayment(BaseModel):
    r"""The API resource URL of the [payment](get-payment) that belong to this route."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: CreateCustomerPaymentSelfTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payment: CreateCustomerPaymentPaymentTypedDict
    r"""The API resource URL of the [payment](get-payment) that belong to this route."""


class CreateCustomerPaymentLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[CreateCustomerPaymentSelf, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payment: CreateCustomerPaymentPayment
    r"""The API resource URL of the [payment](get-payment) that belong to this route."""


class CreateCustomerPaymentRoutingTypedDict(TypedDict):
    amount: CreateCustomerPaymentCustomersRequestRequestBodyAmountTypedDict
    r"""The portion of the total payment amount being routed. Currently only `EUR` payments can be routed."""
    destination: CreateCustomerPaymentDestinationTypedDict
    r"""The destination of this portion of the payment."""
    links: CreateCustomerPaymentLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    release_date: NotRequired[Nullable[str]]
    r"""Optionally, schedule this portion of the payment to be transferred to its destination on a later date. The date must be given in `YYYY-MM-DD` format.

    If no date is given, the funds become available to the connected merchant as soon as the payment succeeds.
    """


class CreateCustomerPaymentRouting(BaseModel):
    amount: CreateCustomerPaymentCustomersRequestRequestBodyAmount
    r"""The portion of the total payment amount being routed. Currently only `EUR` payments can be routed."""

    destination: CreateCustomerPaymentDestination
    r"""The destination of this portion of the payment."""

    links: Annotated[CreateCustomerPaymentLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    release_date: Annotated[
        OptionalNullable[str], pydantic.Field(alias="releaseDate")
    ] = UNSET
    r"""Optionally, schedule this portion of the payment to be transferred to its destination on a later date. The date must be given in `YYYY-MM-DD` format.

    If no date is given, the funds become available to the connected merchant as soon as the payment succeeds.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["releaseDate"]
        nullable_fields = ["releaseDate"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateCustomerPaymentRequestBodyTypedDict(TypedDict):
    description: str
    r"""The description of the payment. This will be shown to your customer on their card or bank statement when possible. We truncate the description automatically according to the limits of the used payment method. The description is also visible in any exports you generate.

    We recommend you use a unique identifier so that you can always link the payment to the order in your back office. This is particularly useful for bookkeeping.

    The maximum length of the description field differs per payment method, with the absolute maximum being 255 characters. The API will not reject strings longer than the maximum length but it will truncate them to fit.
    """
    amount: CreateCustomerPaymentAmountTypedDict
    r"""The amount that you want to charge, e.g. `{currency:\"EUR\", value:\"1000.00\"}` if you would want to charge €1000.00.

    You can find the minimum and maximum amounts per payment method in our help center. Additionally, they can be retrieved using the Get method endpoint.

    If a tip was added for a Point-of-Sale payment, the amount will be updated to reflect the initial amount plus the tip amount.
    """
    redirect_url: Nullable[str]
    r"""The URL your customer will be redirected to after the payment process.

    It could make sense for the redirectUrl to contain a unique identifier – like your order ID – so you can show the right page referencing the order when your customer returns.

    The parameter is normally required, but can be omitted for recurring payments (`sequenceType: recurring`) and for Apple Pay payments with an `applePayPaymentToken`.
    """
    cancel_url: NotRequired[Nullable[str]]
    r"""The URL your customer will be redirected to when the customer explicitly cancels the payment. If this URL is not provided, the customer will be redirected to the `redirectUrl` instead — see above.

    Mollie will always give you status updates via webhooks, including for the canceled status. This parameter is therefore entirely optional, but can be useful when implementing a dedicated customer-facing flow to handle payment cancellations.
    """
    webhook_url: NotRequired[Nullable[str]]
    r"""The webhook URL where we will send payment status updates to.

    The webhookUrl is optional, but without a webhook you will miss out on important status changes to your payment.

    The webhookUrl must be reachable from Mollie's point of view, so you cannot use `localhost`. If you want to use webhook during development on `localhost`, you must use a tool like ngrok to have the webhooks delivered to your local machine.
    """
    lines: NotRequired[Nullable[List[CreateCustomerPaymentLinesTypedDict]]]
    r"""Optionally provide the order lines for the payment. Each line contains details such as a description of the item ordered and its price.

    All lines must have the same currency as the payment.

    Required for payment methods `billie`, `in3`, `klarna`, `riverty` and `voucher`.
    """
    billing_address: NotRequired[CreateCustomerPaymentBillingAddressTypedDict]
    r"""The customer's billing address details. We advise to provide these details to improve fraud protection and conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and `country`.

    Required for payment method `in3`, `klarna`, `billie` and `riverty`.
    """
    shipping_address: NotRequired[CreateCustomerPaymentShippingAddressTypedDict]
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and `country`.
    """
    locale: NotRequired[Nullable[str]]
    r"""Allows you to preset the language to be used in the hosted payment pages shown to the customer. Setting a locale is highly recommended and will greatly improve your conversion rate. When this parameter is omitted the browser language will be used instead if supported by the payment method. You can provide any `xx_XX` format ISO 15897 locale, but our hosted payment pages currently only support the specified languages.

    For bank transfer payments specifically, the locale will determine the target bank account the customer has to transfer the money to. We have dedicated bank accounts for Belgium, Germany, and The Netherlands. Having the customer use a local bank account greatly increases the conversion and speed of payment.
    """
    method: NotRequired[Nullable[str]]
    r"""Normally, a payment method screen is shown. However, when using this parameter, you can choose a specific payment method and your customer will skip the selection screen and is sent directly to the chosen payment method. The parameter enables you to fully integrate the payment method selection into your website.

    You can also specify the methods in an array. By doing so we will still show the payment method selection screen but will only show the methods specified in the array. For example, you can use this functionality to only show payment methods from a specific country to your customer `['bancontact', 'belfius']`.

    Possible values: `alma` `applepay` `bacs` `bancomatpay` `bancontact` `banktransfer` `belfius` `billie` `blik` `creditcard` `directdebit` `eps` `giftcard` `ideal` `in3` `kbc` `klarna` `mbway` `multibanco` `mybank` `payconiq` `paypal` `paysafecard` `pointofsale` `przelewy24` `riverty` `satispay` `swish` `trustly` `twint` `voucher`
    """
    issuer: NotRequired[Nullable[str]]
    r"""**Only relevant for iDEAL, KBC/CBC, gift card, and voucher payments.**

    **⚠️ With the introduction of iDEAL 2 in 2025, this field will be ignored for iDEAL payments. For more information on the migration, refer to our [help center](https://help.mollie.com/hc/articles/19100313768338-iDEAL-2-0).**

    Some payment methods are a network of connected banks or card issuers. In these cases, after selecting the payment method, the customer may still need to select the appropriate issuer before the payment can proceed.

    We provide hosted issuer selection screens, but these screens can be skipped by providing the `issuer` via the API up front.

    The full list of issuers for a specific method can be retrieved via the Methods API by using the optional `issuers` include.

    A valid issuer for iDEAL is for example `ideal_INGBNL2A` (for ING Bank).
    """
    restrict_payment_methods_to_country: NotRequired[Nullable[str]]
    r"""For digital goods in most jurisdictions, you must apply the VAT rate from your customer's country. Choose the VAT rates you have used for the order to ensure your customer's country matches the VAT country.

    Use this parameter to restrict the payment methods available to your customer to those from a single country.

    If available, the credit card method will still be offered, but only cards from the allowed country are accepted.

    The field expects a country code in ISO 3166-1 alpha-2 format, for example `NL`.
    """
    metadata: NotRequired[Nullable[CreateCustomerPaymentMetadataTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""
    capture_mode: NotRequired[Nullable[str]]
    r"""Indicate if the funds should be captured immediately or if you want to [place a hold](https://docs.mollie.com/docs/place-a-hold-for-a-payment#/) and capture at a later time.

    This field needs to be set to `manual` for method `riverty`.

    Possible values: `automatic` `manual` (default: `automatic`)
    """
    capture_delay: NotRequired[Nullable[str]]
    r"""**Only relevant if you wish to manage authorization and capturing separately.**

    Some payment methods allow placing a hold on the card or bank account. This hold or 'authorization' can then at a later point either be 'captured' or canceled.

    By default, we charge the customer's card or bank account immediately when they complete the payment. If you set a capture delay however, we will delay the automatic capturing of the payment for the specified amount of time. For example `8 hours` or `2 days`.

    To schedule an automatic capture, the `captureMode` must be set to `automatic`.

    The maximum delay is 7 days (168 hours).

    Possible values: `... hours` `... days`
    """
    application_fee: NotRequired[Nullable[CreateCustomerPaymentApplicationFeeTypedDict]]
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie merchants.

    If you use OAuth to create payments on a connected merchant's account, you can charge a fee using this `applicationFee` parameter. If the payment succeeds, the fee will be deducted from the merchant's balance and sent to your own account balance.

    If instead you want to split a payment on your own account between yourself and a connected merchant, refer to the `routing` parameter.
    """
    routing: NotRequired[Nullable[List[CreateCustomerPaymentRoutingTypedDict]]]
    r"""*This functionality is not enabled by default. Reach out to our partner management team if you wish to use it.*

    With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie merchants.

    If you create payments on your own account that you want to split between yourself and one or more connected merchants, you can use this `routing` parameter to route the payment accordingly.

    The `routing` parameter should contain an array of objects, with each object describing the destination for a specific portion of the payment.

    It is not necessary to indicate in the array which portion goes to yourself. After all portions of the total payment amount have been routed, the amount left will be routed to the current organization automatically.

    If instead you use OAuth to create payments on a connected merchant's account, refer to the `applicationFee` parameter.
    """
    sequence_type: NotRequired[Nullable[str]]
    r"""**Only relevant for recurring payments.**

    Indicate which part of a recurring sequence this payment is for.

    Recurring payments can only take place if a mandate is available. A common way to establish such a mandate is through a `first` payment. With a `first` payment, the customer agrees to automatic recurring charges taking place on their account in the future.

    If set to `recurring`, the customer's card is charged automatically.

    Defaults to `oneoff`, which is a regular non-recurring payment.

    For PayPal payments, recurring is only possible if your connected PayPal account allows it. You can call our [Methods API](list-methods) with parameter `sequenceType: first` to discover which payment methods on your account are set up correctly for recurring payments.

    Possible values: `oneoff` `first` `recurring` (default: `oneoff`)
    """
    mandate_id: NotRequired[Nullable[str]]
    r"""**Only relevant for recurring payments.**

    When creating recurring payments, the ID of a specific [mandate](get-mandate) can be supplied to indicate which of the customer's accounts should be credited.
    """
    customer_id: NotRequired[Nullable[str]]
    r"""The ID of the [customer](get-customer) the payment is being created for. This is used primarily for recurring payments, but can also be used on regular payments to enable single-click payments.

    If `sequenceType` is set to `recurring`, this field is required.
    """
    profile_id: NotRequired[str]
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    When using an API Key, the `profileId` can be omitted since it is linked to the key. However, for OAuth and Organization tokens, the `profileId` is required.

    For more information, see [Authentication](authentication).
    """
    due_date: NotRequired[str]
    r"""The date by which the payment should be completed in `YYYY-MM-DD` format"""
    testmode: NotRequired[Nullable[bool]]
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.
    """


class CreateCustomerPaymentRequestBody(BaseModel):
    description: str
    r"""The description of the payment. This will be shown to your customer on their card or bank statement when possible. We truncate the description automatically according to the limits of the used payment method. The description is also visible in any exports you generate.

    We recommend you use a unique identifier so that you can always link the payment to the order in your back office. This is particularly useful for bookkeeping.

    The maximum length of the description field differs per payment method, with the absolute maximum being 255 characters. The API will not reject strings longer than the maximum length but it will truncate them to fit.
    """

    amount: CreateCustomerPaymentAmount
    r"""The amount that you want to charge, e.g. `{currency:\"EUR\", value:\"1000.00\"}` if you would want to charge €1000.00.

    You can find the minimum and maximum amounts per payment method in our help center. Additionally, they can be retrieved using the Get method endpoint.

    If a tip was added for a Point-of-Sale payment, the amount will be updated to reflect the initial amount plus the tip amount.
    """

    redirect_url: Annotated[Nullable[str], pydantic.Field(alias="redirectUrl")]
    r"""The URL your customer will be redirected to after the payment process.

    It could make sense for the redirectUrl to contain a unique identifier – like your order ID – so you can show the right page referencing the order when your customer returns.

    The parameter is normally required, but can be omitted for recurring payments (`sequenceType: recurring`) and for Apple Pay payments with an `applePayPaymentToken`.
    """

    cancel_url: Annotated[OptionalNullable[str], pydantic.Field(alias="cancelUrl")] = (
        UNSET
    )
    r"""The URL your customer will be redirected to when the customer explicitly cancels the payment. If this URL is not provided, the customer will be redirected to the `redirectUrl` instead — see above.

    Mollie will always give you status updates via webhooks, including for the canceled status. This parameter is therefore entirely optional, but can be useful when implementing a dedicated customer-facing flow to handle payment cancellations.
    """

    webhook_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="webhookUrl")
    ] = UNSET
    r"""The webhook URL where we will send payment status updates to.

    The webhookUrl is optional, but without a webhook you will miss out on important status changes to your payment.

    The webhookUrl must be reachable from Mollie's point of view, so you cannot use `localhost`. If you want to use webhook during development on `localhost`, you must use a tool like ngrok to have the webhooks delivered to your local machine.
    """

    lines: OptionalNullable[List[CreateCustomerPaymentLines]] = UNSET
    r"""Optionally provide the order lines for the payment. Each line contains details such as a description of the item ordered and its price.

    All lines must have the same currency as the payment.

    Required for payment methods `billie`, `in3`, `klarna`, `riverty` and `voucher`.
    """

    billing_address: Annotated[
        Optional[CreateCustomerPaymentBillingAddress],
        pydantic.Field(alias="billingAddress"),
    ] = None
    r"""The customer's billing address details. We advise to provide these details to improve fraud protection and conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and `country`.

    Required for payment method `in3`, `klarna`, `billie` and `riverty`.
    """

    shipping_address: Annotated[
        Optional[CreateCustomerPaymentShippingAddress],
        pydantic.Field(alias="shippingAddress"),
    ] = None
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and `country`.
    """

    locale: OptionalNullable[str] = UNSET
    r"""Allows you to preset the language to be used in the hosted payment pages shown to the customer. Setting a locale is highly recommended and will greatly improve your conversion rate. When this parameter is omitted the browser language will be used instead if supported by the payment method. You can provide any `xx_XX` format ISO 15897 locale, but our hosted payment pages currently only support the specified languages.

    For bank transfer payments specifically, the locale will determine the target bank account the customer has to transfer the money to. We have dedicated bank accounts for Belgium, Germany, and The Netherlands. Having the customer use a local bank account greatly increases the conversion and speed of payment.
    """

    method: OptionalNullable[str] = UNSET
    r"""Normally, a payment method screen is shown. However, when using this parameter, you can choose a specific payment method and your customer will skip the selection screen and is sent directly to the chosen payment method. The parameter enables you to fully integrate the payment method selection into your website.

    You can also specify the methods in an array. By doing so we will still show the payment method selection screen but will only show the methods specified in the array. For example, you can use this functionality to only show payment methods from a specific country to your customer `['bancontact', 'belfius']`.

    Possible values: `alma` `applepay` `bacs` `bancomatpay` `bancontact` `banktransfer` `belfius` `billie` `blik` `creditcard` `directdebit` `eps` `giftcard` `ideal` `in3` `kbc` `klarna` `mbway` `multibanco` `mybank` `payconiq` `paypal` `paysafecard` `pointofsale` `przelewy24` `riverty` `satispay` `swish` `trustly` `twint` `voucher`
    """

    issuer: OptionalNullable[str] = UNSET
    r"""**Only relevant for iDEAL, KBC/CBC, gift card, and voucher payments.**

    **⚠️ With the introduction of iDEAL 2 in 2025, this field will be ignored for iDEAL payments. For more information on the migration, refer to our [help center](https://help.mollie.com/hc/articles/19100313768338-iDEAL-2-0).**

    Some payment methods are a network of connected banks or card issuers. In these cases, after selecting the payment method, the customer may still need to select the appropriate issuer before the payment can proceed.

    We provide hosted issuer selection screens, but these screens can be skipped by providing the `issuer` via the API up front.

    The full list of issuers for a specific method can be retrieved via the Methods API by using the optional `issuers` include.

    A valid issuer for iDEAL is for example `ideal_INGBNL2A` (for ING Bank).
    """

    restrict_payment_methods_to_country: Annotated[
        OptionalNullable[str], pydantic.Field(alias="restrictPaymentMethodsToCountry")
    ] = UNSET
    r"""For digital goods in most jurisdictions, you must apply the VAT rate from your customer's country. Choose the VAT rates you have used for the order to ensure your customer's country matches the VAT country.

    Use this parameter to restrict the payment methods available to your customer to those from a single country.

    If available, the credit card method will still be offered, but only cards from the allowed country are accepted.

    The field expects a country code in ISO 3166-1 alpha-2 format, for example `NL`.
    """

    metadata: OptionalNullable[CreateCustomerPaymentMetadata] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""

    capture_mode: Annotated[
        OptionalNullable[str], pydantic.Field(alias="captureMode")
    ] = UNSET
    r"""Indicate if the funds should be captured immediately or if you want to [place a hold](https://docs.mollie.com/docs/place-a-hold-for-a-payment#/) and capture at a later time.

    This field needs to be set to `manual` for method `riverty`.

    Possible values: `automatic` `manual` (default: `automatic`)
    """

    capture_delay: Annotated[
        OptionalNullable[str], pydantic.Field(alias="captureDelay")
    ] = UNSET
    r"""**Only relevant if you wish to manage authorization and capturing separately.**

    Some payment methods allow placing a hold on the card or bank account. This hold or 'authorization' can then at a later point either be 'captured' or canceled.

    By default, we charge the customer's card or bank account immediately when they complete the payment. If you set a capture delay however, we will delay the automatic capturing of the payment for the specified amount of time. For example `8 hours` or `2 days`.

    To schedule an automatic capture, the `captureMode` must be set to `automatic`.

    The maximum delay is 7 days (168 hours).

    Possible values: `... hours` `... days`
    """

    application_fee: Annotated[
        OptionalNullable[CreateCustomerPaymentApplicationFee],
        pydantic.Field(alias="applicationFee"),
    ] = UNSET
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie merchants.

    If you use OAuth to create payments on a connected merchant's account, you can charge a fee using this `applicationFee` parameter. If the payment succeeds, the fee will be deducted from the merchant's balance and sent to your own account balance.

    If instead you want to split a payment on your own account between yourself and a connected merchant, refer to the `routing` parameter.
    """

    routing: OptionalNullable[List[CreateCustomerPaymentRouting]] = UNSET
    r"""*This functionality is not enabled by default. Reach out to our partner management team if you wish to use it.*

    With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie merchants.

    If you create payments on your own account that you want to split between yourself and one or more connected merchants, you can use this `routing` parameter to route the payment accordingly.

    The `routing` parameter should contain an array of objects, with each object describing the destination for a specific portion of the payment.

    It is not necessary to indicate in the array which portion goes to yourself. After all portions of the total payment amount have been routed, the amount left will be routed to the current organization automatically.

    If instead you use OAuth to create payments on a connected merchant's account, refer to the `applicationFee` parameter.
    """

    sequence_type: Annotated[
        OptionalNullable[str], pydantic.Field(alias="sequenceType")
    ] = UNSET
    r"""**Only relevant for recurring payments.**

    Indicate which part of a recurring sequence this payment is for.

    Recurring payments can only take place if a mandate is available. A common way to establish such a mandate is through a `first` payment. With a `first` payment, the customer agrees to automatic recurring charges taking place on their account in the future.

    If set to `recurring`, the customer's card is charged automatically.

    Defaults to `oneoff`, which is a regular non-recurring payment.

    For PayPal payments, recurring is only possible if your connected PayPal account allows it. You can call our [Methods API](list-methods) with parameter `sequenceType: first` to discover which payment methods on your account are set up correctly for recurring payments.

    Possible values: `oneoff` `first` `recurring` (default: `oneoff`)
    """

    mandate_id: Annotated[OptionalNullable[str], pydantic.Field(alias="mandateId")] = (
        UNSET
    )
    r"""**Only relevant for recurring payments.**

    When creating recurring payments, the ID of a specific [mandate](get-mandate) can be supplied to indicate which of the customer's accounts should be credited.
    """

    customer_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="customerId")
    ] = UNSET
    r"""The ID of the [customer](get-customer) the payment is being created for. This is used primarily for recurring payments, but can also be used on regular payments to enable single-click payments.

    If `sequenceType` is set to `recurring`, this field is required.
    """

    profile_id: Annotated[Optional[str], pydantic.Field(alias="profileId")] = None
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    When using an API Key, the `profileId` can be omitted since it is linked to the key. However, for OAuth and Organization tokens, the `profileId` is required.

    For more information, see [Authentication](authentication).
    """

    due_date: Annotated[Optional[str], pydantic.Field(alias="dueDate")] = None
    r"""The date by which the payment should be completed in `YYYY-MM-DD` format"""

    testmode: OptionalNullable[bool] = UNSET
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "cancelUrl",
            "webhookUrl",
            "lines",
            "billingAddress",
            "shippingAddress",
            "locale",
            "method",
            "issuer",
            "restrictPaymentMethodsToCountry",
            "metadata",
            "captureMode",
            "captureDelay",
            "applicationFee",
            "routing",
            "sequenceType",
            "mandateId",
            "customerId",
            "profileId",
            "dueDate",
            "testmode",
        ]
        nullable_fields = [
            "redirectUrl",
            "cancelUrl",
            "webhookUrl",
            "lines",
            "locale",
            "method",
            "issuer",
            "restrictPaymentMethodsToCountry",
            "metadata",
            "captureMode",
            "captureDelay",
            "applicationFee",
            "routing",
            "sequenceType",
            "mandateId",
            "customerId",
            "testmode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateCustomerPaymentRequestTypedDict(TypedDict):
    customer_id_param: str
    r"""Provide the ID of the related customer."""
    request_body: NotRequired[CreateCustomerPaymentRequestBodyTypedDict]


class CreateCustomerPaymentRequest(BaseModel):
    customer_id_param: Annotated[
        str,
        pydantic.Field(alias="customerId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related customer."""

    request_body: Annotated[
        Optional[CreateCustomerPaymentRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None


class CreateCustomerPaymentCustomersResponseDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class CreateCustomerPaymentCustomersResponseDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class CreateCustomerPaymentCustomersResponse503LinksTypedDict(TypedDict):
    documentation: CreateCustomerPaymentCustomersResponseDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class CreateCustomerPaymentCustomersResponse503Links(BaseModel):
    documentation: CreateCustomerPaymentCustomersResponseDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class CreateCustomerPaymentCustomersResponseResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[
        CreateCustomerPaymentCustomersResponse503Links, pydantic.Field(alias="_links")
    ]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""


class CreateCustomerPaymentCustomersResponseResponseBody(ClientError):
    r"""An error response object."""

    data: CreateCustomerPaymentCustomersResponseResponseBodyData

    def __init__(
        self,
        data: CreateCustomerPaymentCustomersResponseResponseBodyData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class CreateCustomerPaymentCustomersDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class CreateCustomerPaymentCustomersDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class CreateCustomerPaymentCustomersResponse422LinksTypedDict(TypedDict):
    documentation: CreateCustomerPaymentCustomersDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class CreateCustomerPaymentCustomersResponse422Links(BaseModel):
    documentation: CreateCustomerPaymentCustomersDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class CreateCustomerPaymentCustomersResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[
        CreateCustomerPaymentCustomersResponse422Links, pydantic.Field(alias="_links")
    ]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""


class CreateCustomerPaymentCustomersResponseBody(ClientError):
    r"""An error response object."""

    data: CreateCustomerPaymentCustomersResponseBodyData

    def __init__(
        self,
        data: CreateCustomerPaymentCustomersResponseBodyData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class CreateCustomerPaymentCustomersResponseAmountTypedDict(TypedDict):
    r"""The amount that you want to charge, e.g. `{currency:\"EUR\", value:\"1000.00\"}` if you would want to charge €1000.00.

    You can find the minimum and maximum amounts per payment method in our help center. Additionally, they can be retrieved using the Get method endpoint.

    If a tip was added for a Point-of-Sale payment, the amount will be updated to reflect the initial amount plus the tip amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentCustomersResponseAmount(BaseModel):
    r"""The amount that you want to charge, e.g. `{currency:\"EUR\", value:\"1000.00\"}` if you would want to charge €1000.00.

    You can find the minimum and maximum amounts per payment method in our help center. Additionally, they can be retrieved using the Get method endpoint.

    If a tip was added for a Point-of-Sale payment, the amount will be updated to reflect the initial amount plus the tip amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentAmountRefundedTypedDict(TypedDict):
    r"""The total amount that is already refunded. Only available when refunds are available for this payment. For some payment methods, this amount may be higher than the payment amount, for example to allow reimbursement of the costs for a return shipment to the customer."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentAmountRefunded(BaseModel):
    r"""The total amount that is already refunded. Only available when refunds are available for this payment. For some payment methods, this amount may be higher than the payment amount, for example to allow reimbursement of the costs for a return shipment to the customer."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentAmountRemainingTypedDict(TypedDict):
    r"""The remaining amount that can be refunded. Only available when refunds are available for this payment."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentAmountRemaining(BaseModel):
    r"""The remaining amount that can be refunded. Only available when refunds are available for this payment."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentAmountCapturedTypedDict(TypedDict):
    r"""The total amount that is already captured for this payment. Only available when this payment supports captures."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentAmountCaptured(BaseModel):
    r"""The total amount that is already captured for this payment. Only available when this payment supports captures."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentAmountChargedBackTypedDict(TypedDict):
    r"""The total amount that was charged back for this payment. Only available when the total charged back amount is not zero."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentAmountChargedBack(BaseModel):
    r"""The total amount that was charged back for this payment. Only available when the total charged back amount is not zero."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentSettlementAmountTypedDict(TypedDict):
    r"""This optional field will contain the approximate amount that will be settled to your account, converted to the currency your account is settled in.

    Any amounts not settled by Mollie will not be reflected in this amount, e.g. PayPal or gift cards. If no amount is settled by Mollie the `settlementAmount` is omitted from the response.

    Please note that this amount might be recalculated and changed when the status of the payment changes. We suggest using the List balance transactions endpoint instead to get more accurate settlement amounts for your payments.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentSettlementAmount(BaseModel):
    r"""This optional field will contain the approximate amount that will be settled to your account, converted to the currency your account is settled in.

    Any amounts not settled by Mollie will not be reflected in this amount, e.g. PayPal or gift cards. If no amount is settled by Mollie the `settlementAmount` is omitted from the response.

    Please note that this amount might be recalculated and changed when the status of the payment changes. We suggest using the List balance transactions endpoint instead to get more accurate settlement amounts for your payments.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentCustomersUnitPriceTypedDict(TypedDict):
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentCustomersUnitPrice(BaseModel):
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentCustomersDiscountAmountTypedDict(TypedDict):
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount type."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentCustomersDiscountAmount(BaseModel):
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount type."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentCustomersTotalAmountTypedDict(TypedDict):
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentCustomersTotalAmount(BaseModel):
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentCustomersVatAmountTypedDict(TypedDict):
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentCustomersVatAmount(BaseModel):
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentCustomersCategories(str, Enum):
    MEAL = "meal"
    ECO = "eco"
    GIFT = "gift"
    SPORT_CULTURE = "sport_culture"


class CreateCustomerPaymentCustomersResponse201ApplicationHalPlusJSONResponseBodyAmountTypedDict(
    TypedDict
):
    r"""Total amount and currency of the recurring item."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentCustomersResponse201ApplicationHalPlusJSONResponseBodyAmount(
    BaseModel
):
    r"""Total amount and currency of the recurring item."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentCustomersRecurringTypedDict(TypedDict):
    r"""The details of subsequent recurring billing cycles. These parameters are used in the Mollie Checkout to inform the shopper of the details for recurring products in the payments."""

    interval: str
    r"""Cadence unit of the recurring item. For example: `12 months`, `52 weeks` or `365 days`.

    Possible values: `... months` `... weeks` `... days`
    """
    description: NotRequired[str]
    r"""A description of the recurring item. If not present, the main description of the item will be used."""
    amount: NotRequired[
        CreateCustomerPaymentCustomersResponse201ApplicationHalPlusJSONResponseBodyAmountTypedDict
    ]
    r"""Total amount and currency of the recurring item."""
    times: NotRequired[int]
    r"""Total number of charges for the subscription to complete. Leave empty for ongoing subscription."""
    start_date: NotRequired[Nullable[str]]
    r"""The start date of the subscription if it does not start right away (format `YYYY-MM-DD`)"""


class CreateCustomerPaymentCustomersRecurring(BaseModel):
    r"""The details of subsequent recurring billing cycles. These parameters are used in the Mollie Checkout to inform the shopper of the details for recurring products in the payments."""

    interval: str
    r"""Cadence unit of the recurring item. For example: `12 months`, `52 weeks` or `365 days`.

    Possible values: `... months` `... weeks` `... days`
    """

    description: Optional[str] = None
    r"""A description of the recurring item. If not present, the main description of the item will be used."""

    amount: Optional[
        CreateCustomerPaymentCustomersResponse201ApplicationHalPlusJSONResponseBodyAmount
    ] = None
    r"""Total amount and currency of the recurring item."""

    times: Optional[int] = None
    r"""Total number of charges for the subscription to complete. Leave empty for ongoing subscription."""

    start_date: Annotated[OptionalNullable[str], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the subscription if it does not start right away (format `YYYY-MM-DD`)"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "amount", "times", "startDate"]
        nullable_fields = ["startDate"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateCustomerPaymentCustomersLinesTypedDict(TypedDict):
    description: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""
    quantity: int
    r"""The number of items."""
    unit_price: CreateCustomerPaymentCustomersUnitPriceTypedDict
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """
    total_amount: CreateCustomerPaymentCustomersTotalAmountTypedDict
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """
    type: NotRequired[str]
    r"""The type of product purchased. For example, a physical or a digital product.

    The `tip` payment line type is not available when creating a payment.

    Possible values: `physical` `digital` `shipping_fee` `discount` `store_credit` `gift_card` `surcharge` `tip` (default: `physical`)
    """
    quantity_unit: NotRequired[str]
    r"""The unit for the quantity. For example *pcs*, *kg*, or *cm*."""
    discount_amount: NotRequired[CreateCustomerPaymentCustomersDiscountAmountTypedDict]
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount type."""
    vat_rate: NotRequired[str]
    r"""The VAT rate applied to the line, for example `21.00` for 21%. The vatRate should be passed as a string and not as a float, to ensure the correct number of decimals are passed."""
    vat_amount: NotRequired[CreateCustomerPaymentCustomersVatAmountTypedDict]
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """
    sku: NotRequired[str]
    r"""The SKU, EAN, ISBN or UPC of the product sold."""
    categories: NotRequired[List[CreateCustomerPaymentCustomersCategories]]
    r"""An array with the voucher categories, in case of a line eligible for a voucher. See the [Integrating Vouchers](integrating-vouchers) guide for more information."""
    image_url: NotRequired[str]
    r"""A link pointing to an image of the product sold."""
    product_url: NotRequired[str]
    r"""A link pointing to the product page in your web shop of the product sold."""
    recurring: NotRequired[CreateCustomerPaymentCustomersRecurringTypedDict]
    r"""The details of subsequent recurring billing cycles. These parameters are used in the Mollie Checkout to inform the shopper of the details for recurring products in the payments."""


class CreateCustomerPaymentCustomersLines(BaseModel):
    description: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""

    quantity: int
    r"""The number of items."""

    unit_price: Annotated[
        CreateCustomerPaymentCustomersUnitPrice, pydantic.Field(alias="unitPrice")
    ]
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """

    total_amount: Annotated[
        CreateCustomerPaymentCustomersTotalAmount, pydantic.Field(alias="totalAmount")
    ]
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """

    type: Optional[str] = None
    r"""The type of product purchased. For example, a physical or a digital product.

    The `tip` payment line type is not available when creating a payment.

    Possible values: `physical` `digital` `shipping_fee` `discount` `store_credit` `gift_card` `surcharge` `tip` (default: `physical`)
    """

    quantity_unit: Annotated[Optional[str], pydantic.Field(alias="quantityUnit")] = None
    r"""The unit for the quantity. For example *pcs*, *kg*, or *cm*."""

    discount_amount: Annotated[
        Optional[CreateCustomerPaymentCustomersDiscountAmount],
        pydantic.Field(alias="discountAmount"),
    ] = None
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount type."""

    vat_rate: Annotated[Optional[str], pydantic.Field(alias="vatRate")] = None
    r"""The VAT rate applied to the line, for example `21.00` for 21%. The vatRate should be passed as a string and not as a float, to ensure the correct number of decimals are passed."""

    vat_amount: Annotated[
        Optional[CreateCustomerPaymentCustomersVatAmount],
        pydantic.Field(alias="vatAmount"),
    ] = None
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """

    sku: Optional[str] = None
    r"""The SKU, EAN, ISBN or UPC of the product sold."""

    categories: Optional[List[CreateCustomerPaymentCustomersCategories]] = None
    r"""An array with the voucher categories, in case of a line eligible for a voucher. See the [Integrating Vouchers](integrating-vouchers) guide for more information."""

    image_url: Annotated[Optional[str], pydantic.Field(alias="imageUrl")] = None
    r"""A link pointing to an image of the product sold."""

    product_url: Annotated[Optional[str], pydantic.Field(alias="productUrl")] = None
    r"""A link pointing to the product page in your web shop of the product sold."""

    recurring: Optional[CreateCustomerPaymentCustomersRecurring] = None
    r"""The details of subsequent recurring billing cycles. These parameters are used in the Mollie Checkout to inform the shopper of the details for recurring products in the payments."""


class CreateCustomerPaymentCustomersBillingAddressTypedDict(TypedDict):
    r"""The customer's billing address details. We advise to provide these details to improve fraud protection and conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and `country`.

    Required for payment method `in3`, `klarna`, `billie` and `riverty`.
    """

    title: NotRequired[str]
    r"""The title of the person, for example *Mr.* or *Mrs.*."""
    given_name: NotRequired[str]
    r"""The given name (first name) of the person should be at least two characters and cannot contain only numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    family_name: NotRequired[str]
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    organization_name: NotRequired[str]
    r"""The name of the organization, in case the addressee is an organization."""
    street_and_number: NotRequired[str]
    r"""A street and street number.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    street_additional: NotRequired[str]
    r"""Any additional addressing details, for example an apartment number."""
    postal_code: NotRequired[str]
    r"""A postal code. This field may be required if the provided country has a postal code system.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    email: NotRequired[str]
    r"""A valid e-mail address.

    If you provide the email address for a `banktransfer` payment, we will automatically send the instructions email upon payment creation. The language of the email will follow the locale parameter of the payment.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    phone: NotRequired[str]
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""
    city: NotRequired[str]
    r"""A city name.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    region: NotRequired[str]
    r"""The top-level administrative subdivision of the country. For example: Noord-Holland."""
    country: NotRequired[str]
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """


class CreateCustomerPaymentCustomersBillingAddress(BaseModel):
    r"""The customer's billing address details. We advise to provide these details to improve fraud protection and conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and `country`.

    Required for payment method `in3`, `klarna`, `billie` and `riverty`.
    """

    title: Optional[str] = None
    r"""The title of the person, for example *Mr.* or *Mrs.*."""

    given_name: Annotated[Optional[str], pydantic.Field(alias="givenName")] = None
    r"""The given name (first name) of the person should be at least two characters and cannot contain only numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    family_name: Annotated[Optional[str], pydantic.Field(alias="familyName")] = None
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    organization_name: Annotated[
        Optional[str], pydantic.Field(alias="organizationName")
    ] = None
    r"""The name of the organization, in case the addressee is an organization."""

    street_and_number: Annotated[
        Optional[str], pydantic.Field(alias="streetAndNumber")
    ] = None
    r"""A street and street number.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    street_additional: Annotated[
        Optional[str], pydantic.Field(alias="streetAdditional")
    ] = None
    r"""Any additional addressing details, for example an apartment number."""

    postal_code: Annotated[Optional[str], pydantic.Field(alias="postalCode")] = None
    r"""A postal code. This field may be required if the provided country has a postal code system.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    email: Optional[str] = None
    r"""A valid e-mail address.

    If you provide the email address for a `banktransfer` payment, we will automatically send the instructions email upon payment creation. The language of the email will follow the locale parameter of the payment.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    phone: Optional[str] = None
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""

    city: Optional[str] = None
    r"""A city name.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    region: Optional[str] = None
    r"""The top-level administrative subdivision of the country. For example: Noord-Holland."""

    country: Optional[str] = None
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """


class CreateCustomerPaymentCustomersShippingAddressTypedDict(TypedDict):
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and `country`.
    """

    title: NotRequired[str]
    r"""The title of the person, for example *Mr.* or *Mrs.*."""
    given_name: NotRequired[str]
    r"""The given name (first name) of the person should be at least two characters and cannot contain only numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    family_name: NotRequired[str]
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    organization_name: NotRequired[str]
    r"""The name of the organization, in case the addressee is an organization."""
    street_and_number: NotRequired[str]
    r"""A street and street number.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    street_additional: NotRequired[str]
    r"""Any additional addressing details, for example an apartment number."""
    postal_code: NotRequired[str]
    r"""A postal code. This field may be required if the provided country has a postal code system.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    email: NotRequired[str]
    r"""A valid e-mail address.

    If you provide the email address for a `banktransfer` payment, we will automatically send the instructions email upon payment creation. The language of the email will follow the locale parameter of the payment.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    phone: NotRequired[str]
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""
    city: NotRequired[str]
    r"""A city name.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    region: NotRequired[str]
    r"""The top-level administrative subdivision of the country. For example: Noord-Holland."""
    country: NotRequired[str]
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """


class CreateCustomerPaymentCustomersShippingAddress(BaseModel):
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and `country`.
    """

    title: Optional[str] = None
    r"""The title of the person, for example *Mr.* or *Mrs.*."""

    given_name: Annotated[Optional[str], pydantic.Field(alias="givenName")] = None
    r"""The given name (first name) of the person should be at least two characters and cannot contain only numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    family_name: Annotated[Optional[str], pydantic.Field(alias="familyName")] = None
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    organization_name: Annotated[
        Optional[str], pydantic.Field(alias="organizationName")
    ] = None
    r"""The name of the organization, in case the addressee is an organization."""

    street_and_number: Annotated[
        Optional[str], pydantic.Field(alias="streetAndNumber")
    ] = None
    r"""A street and street number.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    street_additional: Annotated[
        Optional[str], pydantic.Field(alias="streetAdditional")
    ] = None
    r"""Any additional addressing details, for example an apartment number."""

    postal_code: Annotated[Optional[str], pydantic.Field(alias="postalCode")] = None
    r"""A postal code. This field may be required if the provided country has a postal code system.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    email: Optional[str] = None
    r"""A valid e-mail address.

    If you provide the email address for a `banktransfer` payment, we will automatically send the instructions email upon payment creation. The language of the email will follow the locale parameter of the payment.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    phone: Optional[str] = None
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""

    city: Optional[str] = None
    r"""A city name.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    region: Optional[str] = None
    r"""The top-level administrative subdivision of the country. For example: Noord-Holland."""

    country: Optional[str] = None
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """


class CreateCustomerPaymentMetadataCustomers2TypedDict(TypedDict):
    pass


class CreateCustomerPaymentMetadataCustomers2(BaseModel):
    pass


CreateCustomerPaymentCustomersMetadataTypedDict = TypeAliasType(
    "CreateCustomerPaymentCustomersMetadataTypedDict",
    Union[CreateCustomerPaymentMetadataCustomers2TypedDict, str, List[str]],
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""


CreateCustomerPaymentCustomersMetadata = TypeAliasType(
    "CreateCustomerPaymentCustomersMetadata",
    Union[CreateCustomerPaymentMetadataCustomers2, str, List[str]],
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""


class CreateCustomerPaymentCustomersResponse201AmountTypedDict(TypedDict):
    r"""The fee that you wish to charge.

    Be careful to leave enough space for Mollie's own fees to be deducted as well. For example, you cannot charge a €0.99 fee on a €1.00 payment.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentCustomersResponse201Amount(BaseModel):
    r"""The fee that you wish to charge.

    Be careful to leave enough space for Mollie's own fees to be deducted as well. For example, you cannot charge a €0.99 fee on a €1.00 payment.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentCustomersApplicationFeeTypedDict(TypedDict):
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie merchants.

    If you use OAuth to create payments on a connected merchant's account, you can charge a fee using this `applicationFee` parameter. If the payment succeeds, the fee will be deducted from the merchant's balance and sent to your own account balance.

    If instead you want to split a payment on your own account between yourself and a connected merchant, refer to the `routing` parameter.
    """

    amount: NotRequired[CreateCustomerPaymentCustomersResponse201AmountTypedDict]
    r"""The fee that you wish to charge.

    Be careful to leave enough space for Mollie's own fees to be deducted as well. For example, you cannot charge a €0.99 fee on a €1.00 payment.
    """
    description: NotRequired[str]
    r"""The description of the application fee. This will appear on settlement reports towards both you and the connected merchant."""


class CreateCustomerPaymentCustomersApplicationFee(BaseModel):
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie merchants.

    If you use OAuth to create payments on a connected merchant's account, you can charge a fee using this `applicationFee` parameter. If the payment succeeds, the fee will be deducted from the merchant's balance and sent to your own account balance.

    If instead you want to split a payment on your own account between yourself and a connected merchant, refer to the `routing` parameter.
    """

    amount: Optional[CreateCustomerPaymentCustomersResponse201Amount] = None
    r"""The fee that you wish to charge.

    Be careful to leave enough space for Mollie's own fees to be deducted as well. For example, you cannot charge a €0.99 fee on a €1.00 payment.
    """

    description: Optional[str] = None
    r"""The description of the application fee. This will appear on settlement reports towards both you and the connected merchant."""


class CreateCustomerPaymentCustomersResponse201ApplicationHalPlusJSONAmountTypedDict(
    TypedDict
):
    r"""The portion of the total payment amount being routed. Currently only `EUR` payments can be routed."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentCustomersResponse201ApplicationHalPlusJSONAmount(BaseModel):
    r"""The portion of the total payment amount being routed. Currently only `EUR` payments can be routed."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateCustomerPaymentCustomersDestinationTypedDict(TypedDict):
    r"""The destination of this portion of the payment."""

    type: str
    r"""The type of destination. Currently only the destination type `organization` is supported.

    Possible values: `organization`
    """
    organization_id: str
    r"""Required for destination type `organization`. The ID of the connected organization the funds should be routed to."""


class CreateCustomerPaymentCustomersDestination(BaseModel):
    r"""The destination of this portion of the payment."""

    type: str
    r"""The type of destination. Currently only the destination type `organization` is supported.

    Possible values: `organization`
    """

    organization_id: Annotated[str, pydantic.Field(alias="organizationId")]
    r"""Required for destination type `organization`. The ID of the connected organization the funds should be routed to."""


class CreateCustomerPaymentCustomersResponseSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentCustomersResponseSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentCustomersPaymentTypedDict(TypedDict):
    r"""The API resource URL of the [payment](get-payment) that belong to this route."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentCustomersPayment(BaseModel):
    r"""The API resource URL of the [payment](get-payment) that belong to this route."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentCustomersResponseLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: CreateCustomerPaymentCustomersResponseSelfTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payment: CreateCustomerPaymentCustomersPaymentTypedDict
    r"""The API resource URL of the [payment](get-payment) that belong to this route."""


class CreateCustomerPaymentCustomersResponseLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[
        CreateCustomerPaymentCustomersResponseSelf, pydantic.Field(alias="self")
    ]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payment: CreateCustomerPaymentCustomersPayment
    r"""The API resource URL of the [payment](get-payment) that belong to this route."""


class CreateCustomerPaymentCustomersRoutingTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a route object. Will always contain the string `route` for this endpoint."""
    id: str
    r"""The identifier uniquely referring to this route. Mollie will always refer to the route by this ID. Example: `rt_5B8cwPMGnU6qLbRvo7qEZo`."""
    mode: str
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """
    amount: (
        CreateCustomerPaymentCustomersResponse201ApplicationHalPlusJSONAmountTypedDict
    )
    r"""The portion of the total payment amount being routed. Currently only `EUR` payments can be routed."""
    destination: CreateCustomerPaymentCustomersDestinationTypedDict
    r"""The destination of this portion of the payment."""
    created_at: str
    r"""The date and time when the route was created. The date is given in ISO 8601 format."""
    links: CreateCustomerPaymentCustomersResponseLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    release_date: NotRequired[Nullable[str]]
    r"""Optionally, schedule this portion of the payment to be transferred to its destination on a later date. The date must be given in `YYYY-MM-DD` format.

    If no date is given, the funds become available to the connected merchant as soon as the payment succeeds.
    """


class CreateCustomerPaymentCustomersRouting(BaseModel):
    resource: str
    r"""Indicates the response contains a route object. Will always contain the string `route` for this endpoint."""

    id: str
    r"""The identifier uniquely referring to this route. Mollie will always refer to the route by this ID. Example: `rt_5B8cwPMGnU6qLbRvo7qEZo`."""

    mode: str
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """

    amount: CreateCustomerPaymentCustomersResponse201ApplicationHalPlusJSONAmount
    r"""The portion of the total payment amount being routed. Currently only `EUR` payments can be routed."""

    destination: CreateCustomerPaymentCustomersDestination
    r"""The destination of this portion of the payment."""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The date and time when the route was created. The date is given in ISO 8601 format."""

    links: Annotated[
        CreateCustomerPaymentCustomersResponseLinks, pydantic.Field(alias="_links")
    ]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    release_date: Annotated[
        OptionalNullable[str], pydantic.Field(alias="releaseDate")
    ] = UNSET
    r"""Optionally, schedule this portion of the payment to be transferred to its destination on a later date. The date must be given in `YYYY-MM-DD` format.

    If no date is given, the funds become available to the connected merchant as soon as the payment succeeds.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["releaseDate"]
        nullable_fields = ["releaseDate"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateCustomerPaymentStatusReasonTypedDict(TypedDict):
    r"""This object offers details about the status of a payment. Currently it is only available for point-of-sale payments.

    You can find more information about the possible values of this object on [this page](status-reasons).**
    """

    code: str
    r"""A machine-readable code that indicates the reason for the payment's status."""
    message: str
    r"""A description of the status reason, localized according to the payment `locale`."""


class CreateCustomerPaymentStatusReason(BaseModel):
    r"""This object offers details about the status of a payment. Currently it is only available for point-of-sale payments.

    You can find more information about the possible values of this object on [this page](status-reasons).**
    """

    code: str
    r"""A machine-readable code that indicates the reason for the payment's status."""

    message: str
    r"""A description of the status reason, localized according to the payment `locale`."""


class CreateCustomerPaymentCustomersSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentCustomersSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentCheckoutTypedDict(TypedDict):
    r"""The URL your customer should visit to make the payment. This is where you should redirect the customer to."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentCheckout(BaseModel):
    r"""The URL your customer should visit to make the payment. This is where you should redirect the customer to."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentMobileAppCheckoutTypedDict(TypedDict):
    r"""The deeplink URL to the app of the payment method. Currently only available for `bancontact`."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentMobileAppCheckout(BaseModel):
    r"""The deeplink URL to the app of the payment method. Currently only available for `bancontact`."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentChangePaymentStateTypedDict(TypedDict):
    r"""For test mode payments in certain scenarios, a hosted interface is available to help you test different payment states.

    Firstly, for recurring test mode payments. Recurring payments do not have a checkout URL, because these payments are executed without any user interaction.

    Secondly, for paid test mode payments. The payment state screen will then allow you to create a refund or chargeback for the test payment.
    """

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentChangePaymentState(BaseModel):
    r"""For test mode payments in certain scenarios, a hosted interface is available to help you test different payment states.

    Firstly, for recurring test mode payments. Recurring payments do not have a checkout URL, because these payments are executed without any user interaction.

    Secondly, for paid test mode payments. The payment state screen will then allow you to create a refund or chargeback for the test payment.
    """

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentDashboardTypedDict(TypedDict):
    r"""Direct link to the payment in the Mollie Dashboard."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentDashboard(BaseModel):
    r"""Direct link to the payment in the Mollie Dashboard."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentRefundsTypedDict(TypedDict):
    r"""The API resource URL of the [refunds](list-payment-refunds) that belong to this payment."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentRefunds(BaseModel):
    r"""The API resource URL of the [refunds](list-payment-refunds) that belong to this payment."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentChargebacksTypedDict(TypedDict):
    r"""The API resource URL of the [chargebacks](list-payment-chargebacks) that belong to this payment."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentChargebacks(BaseModel):
    r"""The API resource URL of the [chargebacks](list-payment-chargebacks) that belong to this payment."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentCapturesTypedDict(TypedDict):
    r"""The API resource URL of the [captures](list-payment-captures) that belong to this payment."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentCaptures(BaseModel):
    r"""The API resource URL of the [captures](list-payment-captures) that belong to this payment."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentSettlementTypedDict(TypedDict):
    r"""The API resource URL of the [settlement](get-settlement) this payment has been settled with. Not present if not yet settled."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentSettlement(BaseModel):
    r"""The API resource URL of the [settlement](get-settlement) this payment has been settled with. Not present if not yet settled."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentCustomerTypedDict(TypedDict):
    r"""The API resource URL of the [customer](get-customer)."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentCustomer(BaseModel):
    r"""The API resource URL of the [customer](get-customer)."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentMandateTypedDict(TypedDict):
    r"""The API resource URL of the [mandate](get-mandate)."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentMandate(BaseModel):
    r"""The API resource URL of the [mandate](get-mandate)."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentSubscriptionTypedDict(TypedDict):
    r"""The API resource URL of the [subscription](get-subscription)."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentSubscription(BaseModel):
    r"""The API resource URL of the [subscription](get-subscription)."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentOrderTypedDict(TypedDict):
    r"""The API resource URL of the [order](get-order) this payment was created for. Not present if not created for an order."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentOrder(BaseModel):
    r"""The API resource URL of the [order](get-order) this payment was created for. Not present if not created for an order."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentTerminalTypedDict(TypedDict):
    r"""The API resource URL of the [terminal](get-terminal) this payment was created for. Only present for point-of-sale payments."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentTerminal(BaseModel):
    r"""The API resource URL of the [terminal](get-terminal) this payment was created for. Only present for point-of-sale payments."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateCustomerPaymentCustomersLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: CreateCustomerPaymentCustomersSelfTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    dashboard: CreateCustomerPaymentDashboardTypedDict
    r"""Direct link to the payment in the Mollie Dashboard."""
    checkout: NotRequired[CreateCustomerPaymentCheckoutTypedDict]
    r"""The URL your customer should visit to make the payment. This is where you should redirect the customer to."""
    mobile_app_checkout: NotRequired[CreateCustomerPaymentMobileAppCheckoutTypedDict]
    r"""The deeplink URL to the app of the payment method. Currently only available for `bancontact`."""
    change_payment_state: NotRequired[CreateCustomerPaymentChangePaymentStateTypedDict]
    r"""For test mode payments in certain scenarios, a hosted interface is available to help you test different payment states.

    Firstly, for recurring test mode payments. Recurring payments do not have a checkout URL, because these payments are executed without any user interaction.

    Secondly, for paid test mode payments. The payment state screen will then allow you to create a refund or chargeback for the test payment.
    """
    refunds: NotRequired[CreateCustomerPaymentRefundsTypedDict]
    r"""The API resource URL of the [refunds](list-payment-refunds) that belong to this payment."""
    chargebacks: NotRequired[CreateCustomerPaymentChargebacksTypedDict]
    r"""The API resource URL of the [chargebacks](list-payment-chargebacks) that belong to this payment."""
    captures: NotRequired[CreateCustomerPaymentCapturesTypedDict]
    r"""The API resource URL of the [captures](list-payment-captures) that belong to this payment."""
    settlement: NotRequired[CreateCustomerPaymentSettlementTypedDict]
    r"""The API resource URL of the [settlement](get-settlement) this payment has been settled with. Not present if not yet settled."""
    customer: NotRequired[CreateCustomerPaymentCustomerTypedDict]
    r"""The API resource URL of the [customer](get-customer)."""
    mandate: NotRequired[CreateCustomerPaymentMandateTypedDict]
    r"""The API resource URL of the [mandate](get-mandate)."""
    subscription: NotRequired[CreateCustomerPaymentSubscriptionTypedDict]
    r"""The API resource URL of the [subscription](get-subscription)."""
    order: NotRequired[CreateCustomerPaymentOrderTypedDict]
    r"""The API resource URL of the [order](get-order) this payment was created for. Not present if not created for an order."""
    terminal: NotRequired[CreateCustomerPaymentTerminalTypedDict]
    r"""The API resource URL of the [terminal](get-terminal) this payment was created for. Only present for point-of-sale payments."""
    documentation: NotRequired[CreateCustomerPaymentDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class CreateCustomerPaymentCustomersLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[CreateCustomerPaymentCustomersSelf, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    dashboard: CreateCustomerPaymentDashboard
    r"""Direct link to the payment in the Mollie Dashboard."""

    checkout: Optional[CreateCustomerPaymentCheckout] = None
    r"""The URL your customer should visit to make the payment. This is where you should redirect the customer to."""

    mobile_app_checkout: Annotated[
        Optional[CreateCustomerPaymentMobileAppCheckout],
        pydantic.Field(alias="mobileAppCheckout"),
    ] = None
    r"""The deeplink URL to the app of the payment method. Currently only available for `bancontact`."""

    change_payment_state: Annotated[
        Optional[CreateCustomerPaymentChangePaymentState],
        pydantic.Field(alias="changePaymentState"),
    ] = None
    r"""For test mode payments in certain scenarios, a hosted interface is available to help you test different payment states.

    Firstly, for recurring test mode payments. Recurring payments do not have a checkout URL, because these payments are executed without any user interaction.

    Secondly, for paid test mode payments. The payment state screen will then allow you to create a refund or chargeback for the test payment.
    """

    refunds: Optional[CreateCustomerPaymentRefunds] = None
    r"""The API resource URL of the [refunds](list-payment-refunds) that belong to this payment."""

    chargebacks: Optional[CreateCustomerPaymentChargebacks] = None
    r"""The API resource URL of the [chargebacks](list-payment-chargebacks) that belong to this payment."""

    captures: Optional[CreateCustomerPaymentCaptures] = None
    r"""The API resource URL of the [captures](list-payment-captures) that belong to this payment."""

    settlement: Optional[CreateCustomerPaymentSettlement] = None
    r"""The API resource URL of the [settlement](get-settlement) this payment has been settled with. Not present if not yet settled."""

    customer: Optional[CreateCustomerPaymentCustomer] = None
    r"""The API resource URL of the [customer](get-customer)."""

    mandate: Optional[CreateCustomerPaymentMandate] = None
    r"""The API resource URL of the [mandate](get-mandate)."""

    subscription: Optional[CreateCustomerPaymentSubscription] = None
    r"""The API resource URL of the [subscription](get-subscription)."""

    order: Optional[CreateCustomerPaymentOrder] = None
    r"""The API resource URL of the [order](get-order) this payment was created for. Not present if not created for an order."""

    terminal: Optional[CreateCustomerPaymentTerminal] = None
    r"""The API resource URL of the [terminal](get-terminal) this payment was created for. Only present for point-of-sale payments."""

    documentation: Optional[CreateCustomerPaymentDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class CreateCustomerPaymentResponseBodyTypedDict(TypedDict):
    r"""The newly created payment object."""

    resource: str
    r"""Indicates the response contains a payment object. Will always contain the string `payment` for this endpoint."""
    id: str
    r"""The identifier uniquely referring to this payment. Mollie assigns this identifier at payment creation time. Mollie will always refer to the payment by this ID. Example: `tr_5B8cwPMGnU6qLbRvo7qEZo`."""
    mode: str
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """
    description: str
    r"""The description of the payment. This will be shown to your customer on their card or bank statement when possible. We truncate the description automatically according to the limits of the used payment method. The description is also visible in any exports you generate.

    We recommend you use a unique identifier so that you can always link the payment to the order in your back office. This is particularly useful for bookkeeping.

    The maximum length of the description field differs per payment method, with the absolute maximum being 255 characters. The API will not reject strings longer than the maximum length but it will truncate them to fit.
    """
    amount: CreateCustomerPaymentCustomersResponseAmountTypedDict
    r"""The amount that you want to charge, e.g. `{currency:\"EUR\", value:\"1000.00\"}` if you would want to charge €1000.00.

    You can find the minimum and maximum amounts per payment method in our help center. Additionally, they can be retrieved using the Get method endpoint.

    If a tip was added for a Point-of-Sale payment, the amount will be updated to reflect the initial amount plus the tip amount.
    """
    sequence_type: Nullable[str]
    r"""**Only relevant for recurring payments.**

    Indicate which part of a recurring sequence this payment is for.

    Recurring payments can only take place if a mandate is available. A common way to establish such a mandate is through a `first` payment. With a `first` payment, the customer agrees to automatic recurring charges taking place on their account in the future.

    If set to `recurring`, the customer's card is charged automatically.

    Defaults to `oneoff`, which is a regular non-recurring payment.

    For PayPal payments, recurring is only possible if your connected PayPal account allows it. You can call our [Methods API](list-methods) with parameter `sequenceType: first` to discover which payment methods on your account are set up correctly for recurring payments.

    Possible values: `oneoff` `first` `recurring` (default: `oneoff`)
    """
    profile_id: str
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    When using an API Key, the `profileId` can be omitted since it is linked to the key. However, for OAuth and Organization tokens, the `profileId` is required.

    For more information, see [Authentication](authentication).
    """
    status: str
    r"""The payment's status. Refer to the [documentation regarding statuses](https://docs.mollie.com/docs/status-change#/) for more info about which statuses occur at what point.

    Possible values: `open` `pending` `authorized` `paid` `canceled` `expired` `failed`
    """
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: CreateCustomerPaymentCustomersLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    amount_refunded: NotRequired[CreateCustomerPaymentAmountRefundedTypedDict]
    r"""The total amount that is already refunded. Only available when refunds are available for this payment. For some payment methods, this amount may be higher than the payment amount, for example to allow reimbursement of the costs for a return shipment to the customer."""
    amount_remaining: NotRequired[CreateCustomerPaymentAmountRemainingTypedDict]
    r"""The remaining amount that can be refunded. Only available when refunds are available for this payment."""
    amount_captured: NotRequired[CreateCustomerPaymentAmountCapturedTypedDict]
    r"""The total amount that is already captured for this payment. Only available when this payment supports captures."""
    amount_charged_back: NotRequired[CreateCustomerPaymentAmountChargedBackTypedDict]
    r"""The total amount that was charged back for this payment. Only available when the total charged back amount is not zero."""
    settlement_amount: NotRequired[CreateCustomerPaymentSettlementAmountTypedDict]
    r"""This optional field will contain the approximate amount that will be settled to your account, converted to the currency your account is settled in.

    Any amounts not settled by Mollie will not be reflected in this amount, e.g. PayPal or gift cards. If no amount is settled by Mollie the `settlementAmount` is omitted from the response.

    Please note that this amount might be recalculated and changed when the status of the payment changes. We suggest using the List balance transactions endpoint instead to get more accurate settlement amounts for your payments.
    """
    redirect_url: NotRequired[Nullable[str]]
    r"""The URL your customer will be redirected to after the payment process.

    It could make sense for the redirectUrl to contain a unique identifier – like your order ID – so you can show the right page referencing the order when your customer returns.

    The parameter is normally required, but can be omitted for recurring payments (`sequenceType: recurring`) and for Apple Pay payments with an `applePayPaymentToken`.
    """
    cancel_url: NotRequired[Nullable[str]]
    r"""The URL your customer will be redirected to when the customer explicitly cancels the payment. If this URL is not provided, the customer will be redirected to the `redirectUrl` instead — see above.

    Mollie will always give you status updates via webhooks, including for the canceled status. This parameter is therefore entirely optional, but can be useful when implementing a dedicated customer-facing flow to handle payment cancellations.
    """
    webhook_url: NotRequired[Nullable[str]]
    r"""The webhook URL where we will send payment status updates to.

    The webhookUrl is optional, but without a webhook you will miss out on important status changes to your payment.

    The webhookUrl must be reachable from Mollie's point of view, so you cannot use `localhost`. If you want to use webhook during development on `localhost`, you must use a tool like ngrok to have the webhooks delivered to your local machine.
    """
    lines: NotRequired[Nullable[List[CreateCustomerPaymentCustomersLinesTypedDict]]]
    r"""Optionally provide the order lines for the payment. Each line contains details such as a description of the item ordered and its price.

    All lines must have the same currency as the payment.

    Required for payment methods `billie`, `in3`, `klarna`, `riverty` and `voucher`.
    """
    billing_address: NotRequired[CreateCustomerPaymentCustomersBillingAddressTypedDict]
    r"""The customer's billing address details. We advise to provide these details to improve fraud protection and conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and `country`.

    Required for payment method `in3`, `klarna`, `billie` and `riverty`.
    """
    shipping_address: NotRequired[
        CreateCustomerPaymentCustomersShippingAddressTypedDict
    ]
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and `country`.
    """
    locale: NotRequired[Nullable[str]]
    r"""Allows you to preset the language to be used in the hosted payment pages shown to the customer. Setting a locale is highly recommended and will greatly improve your conversion rate. When this parameter is omitted the browser language will be used instead if supported by the payment method. You can provide any `xx_XX` format ISO 15897 locale, but our hosted payment pages currently only support the specified languages.

    For bank transfer payments specifically, the locale will determine the target bank account the customer has to transfer the money to. We have dedicated bank accounts for Belgium, Germany, and The Netherlands. Having the customer use a local bank account greatly increases the conversion and speed of payment.
    """
    country_code: NotRequired[Nullable[str]]
    r"""This optional field contains your customer's ISO 3166-1 alpha-2 country code, detected by us during checkout. This field is omitted if the country code was not detected."""
    method: NotRequired[Nullable[str]]
    r"""The payment method used for this transaction. If a specific method was selected during payment initialization, this field reflects that choice."""
    restrict_payment_methods_to_country: NotRequired[Nullable[str]]
    r"""For digital goods in most jurisdictions, you must apply the VAT rate from your customer's country. Choose the VAT rates you have used for the order to ensure your customer's country matches the VAT country.

    Use this parameter to restrict the payment methods available to your customer to those from a single country.

    If available, the credit card method will still be offered, but only cards from the allowed country are accepted.

    The field expects a country code in ISO 3166-1 alpha-2 format, for example `NL`.
    """
    metadata: NotRequired[Nullable[CreateCustomerPaymentCustomersMetadataTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""
    capture_mode: NotRequired[Nullable[str]]
    r"""Indicate if the funds should be captured immediately or if you want to [place a hold](https://docs.mollie.com/docs/place-a-hold-for-a-payment#/) and capture at a later time.

    This field needs to be set to `manual` for method `riverty`.

    Possible values: `automatic` `manual` (default: `automatic`)
    """
    capture_delay: NotRequired[Nullable[str]]
    r"""**Only relevant if you wish to manage authorization and capturing separately.**

    Some payment methods allow placing a hold on the card or bank account. This hold or 'authorization' can then at a later point either be 'captured' or canceled.

    By default, we charge the customer's card or bank account immediately when they complete the payment. If you set a capture delay however, we will delay the automatic capturing of the payment for the specified amount of time. For example `8 hours` or `2 days`.

    To schedule an automatic capture, the `captureMode` must be set to `automatic`.

    The maximum delay is 7 days (168 hours).

    Possible values: `... hours` `... days`
    """
    capture_before: NotRequired[Nullable[str]]
    r"""Indicates the date before which the payment needs to be captured, in ISO 8601 format. From this date onwards we can no longer guarantee a successful capture. The parameter is omitted if the payment is not authorized (yet)."""
    application_fee: NotRequired[
        Nullable[CreateCustomerPaymentCustomersApplicationFeeTypedDict]
    ]
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie merchants.

    If you use OAuth to create payments on a connected merchant's account, you can charge a fee using this `applicationFee` parameter. If the payment succeeds, the fee will be deducted from the merchant's balance and sent to your own account balance.

    If instead you want to split a payment on your own account between yourself and a connected merchant, refer to the `routing` parameter.
    """
    routing: NotRequired[Nullable[List[CreateCustomerPaymentCustomersRoutingTypedDict]]]
    r"""*This functionality is not enabled by default. Reach out to our partner management team if you wish to use it.*

    With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie merchants.

    If you create payments on your own account that you want to split between yourself and one or more connected merchants, you can use this `routing` parameter to route the payment accordingly.

    The `routing` parameter should contain an array of objects, with each object describing the destination for a specific portion of the payment.

    It is not necessary to indicate in the array which portion goes to yourself. After all portions of the total payment amount have been routed, the amount left will be routed to the current organization automatically.

    If instead you use OAuth to create payments on a connected merchant's account, refer to the `applicationFee` parameter.
    """
    subscription_id: NotRequired[Nullable[str]]
    r"""If the payment was automatically created via a subscription, the ID of the [subscription](get-subscription) will be added to the response."""
    mandate_id: NotRequired[Nullable[str]]
    r"""**Only relevant for recurring payments.**

    When creating recurring payments, the ID of a specific [mandate](get-mandate) can be supplied to indicate which of the customer's accounts should be credited.
    """
    customer_id: NotRequired[Nullable[str]]
    r"""The ID of the [customer](get-customer) the payment is being created for. This is used primarily for recurring payments, but can also be used on regular payments to enable single-click payments.

    If `sequenceType` is set to `recurring`, this field is required.
    """
    settlement_id: NotRequired[Nullable[str]]
    r"""The identifier referring to the [settlement](get-settlement) this payment was settled with."""
    order_id: NotRequired[Nullable[str]]
    r"""If the payment was created for an [order](get-order), the ID of that order will be part of the response."""
    status_reason: NotRequired[Nullable[CreateCustomerPaymentStatusReasonTypedDict]]
    r"""This object offers details about the status of a payment. Currently it is only available for point-of-sale payments.

    You can find more information about the possible values of this object on [this page](status-reasons).**
    """
    is_cancelable: NotRequired[Nullable[bool]]
    r"""Whether the payment can be canceled. This parameter is omitted if the payment reaches a final state."""
    details: NotRequired[Nullable[Dict[str, Any]]]
    r"""An object containing payment details collected during the payment process. For example, details may include the customer's card or bank details and a payment reference. For the full list of details, please refer to the [method-specific parameters](extra-payment-parameters) guide."""
    authorized_at: NotRequired[Nullable[str]]
    r"""The date and time the payment became authorized, in ISO 8601 format. This parameter is omitted if the payment is not authorized (yet)."""
    paid_at: NotRequired[Nullable[str]]
    r"""The date and time the payment became paid, in ISO 8601 format. This parameter is omitted if the payment is not completed (yet)."""
    canceled_at: NotRequired[Nullable[str]]
    r"""The date and time the payment was canceled, in ISO 8601 format. This parameter is omitted if the payment is not canceled (yet)."""
    expires_at: NotRequired[Nullable[str]]
    r"""The date and time the payment will expire, in ISO 8601 format. This parameter is omitted if the payment can no longer expire."""
    expired_at: NotRequired[Nullable[str]]
    r"""The date and time the payment was expired, in ISO 8601 format. This parameter is omitted if the payment did not expire (yet)."""
    failed_at: NotRequired[Nullable[str]]
    r"""The date and time the payment failed, in ISO 8601 format. This parameter is omitted if the payment did not fail (yet)."""


class CreateCustomerPaymentResponseBody(BaseModel):
    r"""The newly created payment object."""

    resource: str
    r"""Indicates the response contains a payment object. Will always contain the string `payment` for this endpoint."""

    id: str
    r"""The identifier uniquely referring to this payment. Mollie assigns this identifier at payment creation time. Mollie will always refer to the payment by this ID. Example: `tr_5B8cwPMGnU6qLbRvo7qEZo`."""

    mode: str
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """

    description: str
    r"""The description of the payment. This will be shown to your customer on their card or bank statement when possible. We truncate the description automatically according to the limits of the used payment method. The description is also visible in any exports you generate.

    We recommend you use a unique identifier so that you can always link the payment to the order in your back office. This is particularly useful for bookkeeping.

    The maximum length of the description field differs per payment method, with the absolute maximum being 255 characters. The API will not reject strings longer than the maximum length but it will truncate them to fit.
    """

    amount: CreateCustomerPaymentCustomersResponseAmount
    r"""The amount that you want to charge, e.g. `{currency:\"EUR\", value:\"1000.00\"}` if you would want to charge €1000.00.

    You can find the minimum and maximum amounts per payment method in our help center. Additionally, they can be retrieved using the Get method endpoint.

    If a tip was added for a Point-of-Sale payment, the amount will be updated to reflect the initial amount plus the tip amount.
    """

    sequence_type: Annotated[Nullable[str], pydantic.Field(alias="sequenceType")]
    r"""**Only relevant for recurring payments.**

    Indicate which part of a recurring sequence this payment is for.

    Recurring payments can only take place if a mandate is available. A common way to establish such a mandate is through a `first` payment. With a `first` payment, the customer agrees to automatic recurring charges taking place on their account in the future.

    If set to `recurring`, the customer's card is charged automatically.

    Defaults to `oneoff`, which is a regular non-recurring payment.

    For PayPal payments, recurring is only possible if your connected PayPal account allows it. You can call our [Methods API](list-methods) with parameter `sequenceType: first` to discover which payment methods on your account are set up correctly for recurring payments.

    Possible values: `oneoff` `first` `recurring` (default: `oneoff`)
    """

    profile_id: Annotated[str, pydantic.Field(alias="profileId")]
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    When using an API Key, the `profileId` can be omitted since it is linked to the key. However, for OAuth and Organization tokens, the `profileId` is required.

    For more information, see [Authentication](authentication).
    """

    status: str
    r"""The payment's status. Refer to the [documentation regarding statuses](https://docs.mollie.com/docs/status-change#/) for more info about which statuses occur at what point.

    Possible values: `open` `pending` `authorized` `paid` `canceled` `expired` `failed`
    """

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[
        CreateCustomerPaymentCustomersLinks, pydantic.Field(alias="_links")
    ]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    amount_refunded: Annotated[
        Optional[CreateCustomerPaymentAmountRefunded],
        pydantic.Field(alias="amountRefunded"),
    ] = None
    r"""The total amount that is already refunded. Only available when refunds are available for this payment. For some payment methods, this amount may be higher than the payment amount, for example to allow reimbursement of the costs for a return shipment to the customer."""

    amount_remaining: Annotated[
        Optional[CreateCustomerPaymentAmountRemaining],
        pydantic.Field(alias="amountRemaining"),
    ] = None
    r"""The remaining amount that can be refunded. Only available when refunds are available for this payment."""

    amount_captured: Annotated[
        Optional[CreateCustomerPaymentAmountCaptured],
        pydantic.Field(alias="amountCaptured"),
    ] = None
    r"""The total amount that is already captured for this payment. Only available when this payment supports captures."""

    amount_charged_back: Annotated[
        Optional[CreateCustomerPaymentAmountChargedBack],
        pydantic.Field(alias="amountChargedBack"),
    ] = None
    r"""The total amount that was charged back for this payment. Only available when the total charged back amount is not zero."""

    settlement_amount: Annotated[
        Optional[CreateCustomerPaymentSettlementAmount],
        pydantic.Field(alias="settlementAmount"),
    ] = None
    r"""This optional field will contain the approximate amount that will be settled to your account, converted to the currency your account is settled in.

    Any amounts not settled by Mollie will not be reflected in this amount, e.g. PayPal or gift cards. If no amount is settled by Mollie the `settlementAmount` is omitted from the response.

    Please note that this amount might be recalculated and changed when the status of the payment changes. We suggest using the List balance transactions endpoint instead to get more accurate settlement amounts for your payments.
    """

    redirect_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="redirectUrl")
    ] = UNSET
    r"""The URL your customer will be redirected to after the payment process.

    It could make sense for the redirectUrl to contain a unique identifier – like your order ID – so you can show the right page referencing the order when your customer returns.

    The parameter is normally required, but can be omitted for recurring payments (`sequenceType: recurring`) and for Apple Pay payments with an `applePayPaymentToken`.
    """

    cancel_url: Annotated[OptionalNullable[str], pydantic.Field(alias="cancelUrl")] = (
        UNSET
    )
    r"""The URL your customer will be redirected to when the customer explicitly cancels the payment. If this URL is not provided, the customer will be redirected to the `redirectUrl` instead — see above.

    Mollie will always give you status updates via webhooks, including for the canceled status. This parameter is therefore entirely optional, but can be useful when implementing a dedicated customer-facing flow to handle payment cancellations.
    """

    webhook_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="webhookUrl")
    ] = UNSET
    r"""The webhook URL where we will send payment status updates to.

    The webhookUrl is optional, but without a webhook you will miss out on important status changes to your payment.

    The webhookUrl must be reachable from Mollie's point of view, so you cannot use `localhost`. If you want to use webhook during development on `localhost`, you must use a tool like ngrok to have the webhooks delivered to your local machine.
    """

    lines: OptionalNullable[List[CreateCustomerPaymentCustomersLines]] = UNSET
    r"""Optionally provide the order lines for the payment. Each line contains details such as a description of the item ordered and its price.

    All lines must have the same currency as the payment.

    Required for payment methods `billie`, `in3`, `klarna`, `riverty` and `voucher`.
    """

    billing_address: Annotated[
        Optional[CreateCustomerPaymentCustomersBillingAddress],
        pydantic.Field(alias="billingAddress"),
    ] = None
    r"""The customer's billing address details. We advise to provide these details to improve fraud protection and conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and `country`.

    Required for payment method `in3`, `klarna`, `billie` and `riverty`.
    """

    shipping_address: Annotated[
        Optional[CreateCustomerPaymentCustomersShippingAddress],
        pydantic.Field(alias="shippingAddress"),
    ] = None
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and `country`.
    """

    locale: OptionalNullable[str] = UNSET
    r"""Allows you to preset the language to be used in the hosted payment pages shown to the customer. Setting a locale is highly recommended and will greatly improve your conversion rate. When this parameter is omitted the browser language will be used instead if supported by the payment method. You can provide any `xx_XX` format ISO 15897 locale, but our hosted payment pages currently only support the specified languages.

    For bank transfer payments specifically, the locale will determine the target bank account the customer has to transfer the money to. We have dedicated bank accounts for Belgium, Germany, and The Netherlands. Having the customer use a local bank account greatly increases the conversion and speed of payment.
    """

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""This optional field contains your customer's ISO 3166-1 alpha-2 country code, detected by us during checkout. This field is omitted if the country code was not detected."""

    method: OptionalNullable[str] = UNSET
    r"""The payment method used for this transaction. If a specific method was selected during payment initialization, this field reflects that choice."""

    restrict_payment_methods_to_country: Annotated[
        OptionalNullable[str], pydantic.Field(alias="restrictPaymentMethodsToCountry")
    ] = UNSET
    r"""For digital goods in most jurisdictions, you must apply the VAT rate from your customer's country. Choose the VAT rates you have used for the order to ensure your customer's country matches the VAT country.

    Use this parameter to restrict the payment methods available to your customer to those from a single country.

    If available, the credit card method will still be offered, but only cards from the allowed country are accepted.

    The field expects a country code in ISO 3166-1 alpha-2 format, for example `NL`.
    """

    metadata: OptionalNullable[CreateCustomerPaymentCustomersMetadata] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""

    capture_mode: Annotated[
        OptionalNullable[str], pydantic.Field(alias="captureMode")
    ] = UNSET
    r"""Indicate if the funds should be captured immediately or if you want to [place a hold](https://docs.mollie.com/docs/place-a-hold-for-a-payment#/) and capture at a later time.

    This field needs to be set to `manual` for method `riverty`.

    Possible values: `automatic` `manual` (default: `automatic`)
    """

    capture_delay: Annotated[
        OptionalNullable[str], pydantic.Field(alias="captureDelay")
    ] = UNSET
    r"""**Only relevant if you wish to manage authorization and capturing separately.**

    Some payment methods allow placing a hold on the card or bank account. This hold or 'authorization' can then at a later point either be 'captured' or canceled.

    By default, we charge the customer's card or bank account immediately when they complete the payment. If you set a capture delay however, we will delay the automatic capturing of the payment for the specified amount of time. For example `8 hours` or `2 days`.

    To schedule an automatic capture, the `captureMode` must be set to `automatic`.

    The maximum delay is 7 days (168 hours).

    Possible values: `... hours` `... days`
    """

    capture_before: Annotated[
        OptionalNullable[str], pydantic.Field(alias="captureBefore")
    ] = UNSET
    r"""Indicates the date before which the payment needs to be captured, in ISO 8601 format. From this date onwards we can no longer guarantee a successful capture. The parameter is omitted if the payment is not authorized (yet)."""

    application_fee: Annotated[
        OptionalNullable[CreateCustomerPaymentCustomersApplicationFee],
        pydantic.Field(alias="applicationFee"),
    ] = UNSET
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie merchants.

    If you use OAuth to create payments on a connected merchant's account, you can charge a fee using this `applicationFee` parameter. If the payment succeeds, the fee will be deducted from the merchant's balance and sent to your own account balance.

    If instead you want to split a payment on your own account between yourself and a connected merchant, refer to the `routing` parameter.
    """

    routing: OptionalNullable[List[CreateCustomerPaymentCustomersRouting]] = UNSET
    r"""*This functionality is not enabled by default. Reach out to our partner management team if you wish to use it.*

    With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie merchants.

    If you create payments on your own account that you want to split between yourself and one or more connected merchants, you can use this `routing` parameter to route the payment accordingly.

    The `routing` parameter should contain an array of objects, with each object describing the destination for a specific portion of the payment.

    It is not necessary to indicate in the array which portion goes to yourself. After all portions of the total payment amount have been routed, the amount left will be routed to the current organization automatically.

    If instead you use OAuth to create payments on a connected merchant's account, refer to the `applicationFee` parameter.
    """

    subscription_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="subscriptionId")
    ] = UNSET
    r"""If the payment was automatically created via a subscription, the ID of the [subscription](get-subscription) will be added to the response."""

    mandate_id: Annotated[OptionalNullable[str], pydantic.Field(alias="mandateId")] = (
        UNSET
    )
    r"""**Only relevant for recurring payments.**

    When creating recurring payments, the ID of a specific [mandate](get-mandate) can be supplied to indicate which of the customer's accounts should be credited.
    """

    customer_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="customerId")
    ] = UNSET
    r"""The ID of the [customer](get-customer) the payment is being created for. This is used primarily for recurring payments, but can also be used on regular payments to enable single-click payments.

    If `sequenceType` is set to `recurring`, this field is required.
    """

    settlement_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="settlementId")
    ] = UNSET
    r"""The identifier referring to the [settlement](get-settlement) this payment was settled with."""

    order_id: Annotated[OptionalNullable[str], pydantic.Field(alias="orderId")] = UNSET
    r"""If the payment was created for an [order](get-order), the ID of that order will be part of the response."""

    status_reason: Annotated[
        OptionalNullable[CreateCustomerPaymentStatusReason],
        pydantic.Field(alias="statusReason"),
    ] = UNSET
    r"""This object offers details about the status of a payment. Currently it is only available for point-of-sale payments.

    You can find more information about the possible values of this object on [this page](status-reasons).**
    """

    is_cancelable: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="isCancelable")
    ] = UNSET
    r"""Whether the payment can be canceled. This parameter is omitted if the payment reaches a final state."""

    details: OptionalNullable[Dict[str, Any]] = UNSET
    r"""An object containing payment details collected during the payment process. For example, details may include the customer's card or bank details and a payment reference. For the full list of details, please refer to the [method-specific parameters](extra-payment-parameters) guide."""

    authorized_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="authorizedAt")
    ] = UNSET
    r"""The date and time the payment became authorized, in ISO 8601 format. This parameter is omitted if the payment is not authorized (yet)."""

    paid_at: Annotated[OptionalNullable[str], pydantic.Field(alias="paidAt")] = UNSET
    r"""The date and time the payment became paid, in ISO 8601 format. This parameter is omitted if the payment is not completed (yet)."""

    canceled_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="canceledAt")
    ] = UNSET
    r"""The date and time the payment was canceled, in ISO 8601 format. This parameter is omitted if the payment is not canceled (yet)."""

    expires_at: Annotated[OptionalNullable[str], pydantic.Field(alias="expiresAt")] = (
        UNSET
    )
    r"""The date and time the payment will expire, in ISO 8601 format. This parameter is omitted if the payment can no longer expire."""

    expired_at: Annotated[OptionalNullable[str], pydantic.Field(alias="expiredAt")] = (
        UNSET
    )
    r"""The date and time the payment was expired, in ISO 8601 format. This parameter is omitted if the payment did not expire (yet)."""

    failed_at: Annotated[OptionalNullable[str], pydantic.Field(alias="failedAt")] = (
        UNSET
    )
    r"""The date and time the payment failed, in ISO 8601 format. This parameter is omitted if the payment did not fail (yet)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "amountRefunded",
            "amountRemaining",
            "amountCaptured",
            "amountChargedBack",
            "settlementAmount",
            "redirectUrl",
            "cancelUrl",
            "webhookUrl",
            "lines",
            "billingAddress",
            "shippingAddress",
            "locale",
            "countryCode",
            "method",
            "restrictPaymentMethodsToCountry",
            "metadata",
            "captureMode",
            "captureDelay",
            "captureBefore",
            "applicationFee",
            "routing",
            "subscriptionId",
            "mandateId",
            "customerId",
            "settlementId",
            "orderId",
            "statusReason",
            "isCancelable",
            "details",
            "authorizedAt",
            "paidAt",
            "canceledAt",
            "expiresAt",
            "expiredAt",
            "failedAt",
        ]
        nullable_fields = [
            "redirectUrl",
            "cancelUrl",
            "webhookUrl",
            "lines",
            "locale",
            "countryCode",
            "method",
            "restrictPaymentMethodsToCountry",
            "metadata",
            "captureMode",
            "captureDelay",
            "captureBefore",
            "applicationFee",
            "routing",
            "sequenceType",
            "subscriptionId",
            "mandateId",
            "customerId",
            "settlementId",
            "orderId",
            "statusReason",
            "isCancelable",
            "details",
            "authorizedAt",
            "paidAt",
            "canceledAt",
            "expiresAt",
            "expiredAt",
            "failedAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
