"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class CreateRefundAmountRequestTypedDict(TypedDict):
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment
    amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateRefundAmountRequest(BaseModel):
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment
    amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateRefundMetadataRequestTypedDict(TypedDict):
    pass


class CreateRefundMetadataRequest(BaseModel):
    pass


CreateRefundMetadataRequestUnionTypedDict = TypeAliasType(
    "CreateRefundMetadataRequestUnionTypedDict",
    Union[CreateRefundMetadataRequestTypedDict, str, List[str]],
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
"""


CreateRefundMetadataRequestUnion = TypeAliasType(
    "CreateRefundMetadataRequestUnion",
    Union[CreateRefundMetadataRequest, str, List[str]],
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
"""


class TypeAcquirerReferenceRequest(str, Enum):
    r"""Specifies the reference type"""

    ACQUIRER_REFERENCE = "acquirer-reference"


class ExternalReferenceRequestTypedDict(TypedDict):
    type: NotRequired[TypeAcquirerReferenceRequest]
    r"""Specifies the reference type"""
    id: NotRequired[str]
    r"""Unique reference from the payment provider"""


class ExternalReferenceRequest(BaseModel):
    type: Optional[TypeAcquirerReferenceRequest] = None
    r"""Specifies the reference type"""

    id: Optional[str] = None
    r"""Unique reference from the payment provider"""


class RoutingReversalAmountRequestTypedDict(TypedDict):
    r"""The amount that will be pulled back."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class RoutingReversalAmountRequest(BaseModel):
    r"""The amount that will be pulled back."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class RoutingReversalType(str, Enum):
    r"""The type of source. Currently only the source type `organization` is supported."""

    ORGANIZATION = "organization"


class CreateRefundSourceRequestTypedDict(TypedDict):
    r"""Where the funds will be pulled back from."""

    type: NotRequired[RoutingReversalType]
    r"""The type of source. Currently only the source type `organization` is supported."""
    organization_id: NotRequired[str]
    r"""Required for source type `organization`. The ID of the connected organization the funds should be pulled
    back from.
    """


class CreateRefundSourceRequest(BaseModel):
    r"""Where the funds will be pulled back from."""

    type: Optional[RoutingReversalType] = None
    r"""The type of source. Currently only the source type `organization` is supported."""

    organization_id: Annotated[
        Optional[str], pydantic.Field(alias="organizationId")
    ] = None
    r"""Required for source type `organization`. The ID of the connected organization the funds should be pulled
    back from.
    """


class RoutingReversalRequestTypedDict(TypedDict):
    amount: NotRequired[RoutingReversalAmountRequestTypedDict]
    r"""The amount that will be pulled back."""
    source: NotRequired[CreateRefundSourceRequestTypedDict]
    r"""Where the funds will be pulled back from."""


class RoutingReversalRequest(BaseModel):
    amount: Optional[RoutingReversalAmountRequest] = None
    r"""The amount that will be pulled back."""

    source: Optional[CreateRefundSourceRequest] = None
    r"""Where the funds will be pulled back from."""


class CreateRefundRequestBodyTypedDict(TypedDict):
    amount: CreateRefundAmountRequestTypedDict
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment
    amount.
    """
    description: NotRequired[str]
    r"""The description of the refund that may be shown to your customer, depending on the payment method used."""
    metadata: NotRequired[Nullable[CreateRefundMetadataRequestUnionTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """
    external_reference: NotRequired[ExternalReferenceRequestTypedDict]
    reverse_routing: NotRequired[Nullable[bool]]
    r"""*This feature is only available to marketplace operators.*

    With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants, by providing the `routing` object during [payment creation](create-payment).

    When creating refunds for these *routed* payments, by default the full amount is deducted from your balance.

    If you want to pull back the funds that were routed to the connected merchant(s), you can set this parameter to
    `true` when issuing a full refund.

    For more fine-grained control and for partial refunds, use the `routingReversals` parameter instead.
    """
    routing_reversals: NotRequired[Nullable[List[RoutingReversalRequestTypedDict]]]
    r"""*This feature is only available to marketplace operators.*

    When creating refunds for *routed* payments, by default the full amount is deducted from your balance.

    If you want to pull back funds from the connected merchant(s), you can use this parameter to specify what amount
    needs to be reversed from which merchant(s).

    If you simply want to fully reverse the routed funds, you can also use the `reverseRouting` parameter instead.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """


class CreateRefundRequestBody(BaseModel):
    amount: CreateRefundAmountRequest
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment
    amount.
    """

    description: Optional[str] = None
    r"""The description of the refund that may be shown to your customer, depending on the payment method used."""

    metadata: OptionalNullable[CreateRefundMetadataRequestUnion] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """

    external_reference: Annotated[
        Optional[ExternalReferenceRequest], pydantic.Field(alias="externalReference")
    ] = None

    reverse_routing: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="reverseRouting")
    ] = UNSET
    r"""*This feature is only available to marketplace operators.*

    With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants, by providing the `routing` object during [payment creation](create-payment).

    When creating refunds for these *routed* payments, by default the full amount is deducted from your balance.

    If you want to pull back the funds that were routed to the connected merchant(s), you can set this parameter to
    `true` when issuing a full refund.

    For more fine-grained control and for partial refunds, use the `routingReversals` parameter instead.
    """

    routing_reversals: Annotated[
        OptionalNullable[List[RoutingReversalRequest]],
        pydantic.Field(alias="routingReversals"),
    ] = UNSET
    r"""*This feature is only available to marketplace operators.*

    When creating refunds for *routed* payments, by default the full amount is deducted from your balance.

    If you want to pull back funds from the connected merchant(s), you can use this parameter to specify what amount
    needs to be reversed from which merchant(s).

    If you simply want to fully reverse the routed funds, you can also use the `reverseRouting` parameter instead.
    """

    testmode: OptionalNullable[bool] = UNSET
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "description",
            "metadata",
            "externalReference",
            "reverseRouting",
            "routingReversals",
            "testmode",
        ]
        nullable_fields = ["metadata", "reverseRouting", "routingReversals", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateRefundRequestTypedDict(TypedDict):
    payment_id: str
    r"""Provide the ID of the related payment."""
    request_body: NotRequired[CreateRefundRequestBodyTypedDict]


class CreateRefundRequest(BaseModel):
    payment_id: Annotated[
        str,
        pydantic.Field(alias="paymentId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related payment."""

    request_body: Annotated[
        Optional[CreateRefundRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None


class CreateRefundUnprocessableEntityDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class CreateRefundUnprocessableEntityDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class CreateRefundUnprocessableEntityLinksTypedDict(TypedDict):
    documentation: CreateRefundUnprocessableEntityDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class CreateRefundUnprocessableEntityLinks(BaseModel):
    documentation: CreateRefundUnprocessableEntityDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class CreateRefundUnprocessableEntityHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[
        CreateRefundUnprocessableEntityLinks, pydantic.Field(alias="_links")
    ]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class CreateRefundUnprocessableEntityHalJSONError(ClientError):
    r"""An error response object."""

    data: CreateRefundUnprocessableEntityHalJSONErrorData

    def __init__(
        self,
        data: CreateRefundUnprocessableEntityHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class ConflictDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ConflictDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ConflictLinksTypedDict(TypedDict):
    documentation: ConflictDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ConflictLinks(BaseModel):
    documentation: ConflictDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ConflictHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[ConflictLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class ConflictHalJSONError(ClientError):
    r"""An error response object."""

    data: ConflictHalJSONErrorData

    def __init__(
        self,
        data: ConflictHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class CreateRefundNotFoundDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class CreateRefundNotFoundDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class CreateRefundNotFoundLinksTypedDict(TypedDict):
    documentation: CreateRefundNotFoundDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class CreateRefundNotFoundLinks(BaseModel):
    documentation: CreateRefundNotFoundDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class CreateRefundNotFoundHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[CreateRefundNotFoundLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class CreateRefundNotFoundHalJSONError(ClientError):
    r"""An error response object."""

    data: CreateRefundNotFoundHalJSONErrorData

    def __init__(
        self,
        data: CreateRefundNotFoundHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class CreateRefundMode(str, Enum):
    r"""Whether this entity was created in live mode or in test mode."""

    LIVE = "live"
    TEST = "test"


class CreateRefundAmountResponseTypedDict(TypedDict):
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment
    amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateRefundAmountResponse(BaseModel):
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment
    amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateRefundSettlementAmountTypedDict(TypedDict):
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted
    to the currency your account is settled in.

    The amount is a **negative** amount.

    If the refund is not directly processed by Mollie, for example for PayPal refunds, the settlement amount will be
    zero.

    Since the field contains an estimated amount during refund processing, it may change over time. For example, while
    the refund is queued the settlement amount is likely not yet available.

    To retrieve accurate settlement amounts we recommend using the
    [List balance transactions endpoint](list-balance-transactions) instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateRefundSettlementAmount(BaseModel):
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted
    to the currency your account is settled in.

    The amount is a **negative** amount.

    If the refund is not directly processed by Mollie, for example for PayPal refunds, the settlement amount will be
    zero.

    Since the field contains an estimated amount during refund processing, it may change over time. For example, while
    the refund is queued the settlement amount is likely not yet available.

    To retrieve accurate settlement amounts we recommend using the
    [List balance transactions endpoint](list-balance-transactions) instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateRefundMetadataResponseTypedDict(TypedDict):
    pass


class CreateRefundMetadataResponse(BaseModel):
    pass


CreateRefundMetadataResponseUnionTypedDict = TypeAliasType(
    "CreateRefundMetadataResponseUnionTypedDict",
    Union[CreateRefundMetadataResponseTypedDict, str, List[str]],
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
"""


CreateRefundMetadataResponseUnion = TypeAliasType(
    "CreateRefundMetadataResponseUnion",
    Union[CreateRefundMetadataResponse, str, List[str]],
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
"""


class CreateRefundStatus(str, Enum):
    r"""Refunds may take some time to get confirmed."""

    QUEUED = "queued"
    PENDING = "pending"
    PROCESSING = "processing"
    REFUNDED = "refunded"
    FAILED = "failed"
    CANCELED = "canceled"


class CreateRefundTypeResponse(str, Enum):
    r"""Specifies the reference type"""

    ACQUIRER_REFERENCE = "acquirer-reference"


class CreateRefundExternalReferenceResponseTypedDict(TypedDict):
    type: NotRequired[CreateRefundTypeResponse]
    r"""Specifies the reference type"""
    id: NotRequired[str]
    r"""Unique reference from the payment provider"""


class CreateRefundExternalReferenceResponse(BaseModel):
    type: Optional[CreateRefundTypeResponse] = None
    r"""Specifies the reference type"""

    id: Optional[str] = None
    r"""Unique reference from the payment provider"""


class CreateRefundRoutingReversalAmountResponseTypedDict(TypedDict):
    r"""The amount that will be pulled back."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateRefundRoutingReversalAmountResponse(BaseModel):
    r"""The amount that will be pulled back."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateRefundSourceOutputTypedDict(TypedDict):
    r"""Where the funds will be pulled back from."""

    organization_id: NotRequired[str]
    r"""Required for source type `organization`. The ID of the connected organization the funds should be pulled
    back from.
    """


class CreateRefundSourceOutput(BaseModel):
    r"""Where the funds will be pulled back from."""

    organization_id: Annotated[
        Optional[str], pydantic.Field(alias="organizationId")
    ] = None
    r"""Required for source type `organization`. The ID of the connected organization the funds should be pulled
    back from.
    """


class CreateRefundRoutingReversalResponseTypedDict(TypedDict):
    amount: NotRequired[CreateRefundRoutingReversalAmountResponseTypedDict]
    r"""The amount that will be pulled back."""
    source: NotRequired[CreateRefundSourceOutputTypedDict]
    r"""Where the funds will be pulled back from."""


class CreateRefundRoutingReversalResponse(BaseModel):
    amount: Optional[CreateRefundRoutingReversalAmountResponse] = None
    r"""The amount that will be pulled back."""

    source: Optional[CreateRefundSourceOutput] = None
    r"""Where the funds will be pulled back from."""


class CreateRefundSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateRefundSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateRefundPaymentTypedDict(TypedDict):
    r"""The API resource URL of the [payment](get-payment) that this refund belongs to."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateRefundPayment(BaseModel):
    r"""The API resource URL of the [payment](get-payment) that this refund belongs to."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateRefundSettlementTypedDict(TypedDict):
    r"""The API resource URL of the [settlement](get-settlement) this refund has been settled with. Not present if not
    yet settled.
    """

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class CreateRefundSettlement(BaseModel):
    r"""The API resource URL of the [settlement](get-settlement) this refund has been settled with. Not present if not
    yet settled.
    """

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class CreateRefundDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateRefundDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateRefundLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: CreateRefundSelfTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payment: CreateRefundPaymentTypedDict
    r"""The API resource URL of the [payment](get-payment) that this refund belongs to."""
    documentation: CreateRefundDocumentationTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    settlement: NotRequired[Nullable[CreateRefundSettlementTypedDict]]
    r"""The API resource URL of the [settlement](get-settlement) this refund has been settled with. Not present if not
    yet settled.
    """


class CreateRefundLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[CreateRefundSelf, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payment: CreateRefundPayment
    r"""The API resource URL of the [payment](get-payment) that this refund belongs to."""

    documentation: CreateRefundDocumentation
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    settlement: OptionalNullable[CreateRefundSettlement] = UNSET
    r"""The API resource URL of the [settlement](get-settlement) this refund has been settled with. Not present if not
    yet settled.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["settlement"]
        nullable_fields = ["settlement"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateRefundResponseTypedDict(TypedDict):
    r"""The newly created refund object."""

    resource: NotRequired[str]
    r"""Indicates the response contains a refund object. Will always contain the string `refund` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this refund. Mollie assigns this identifier at refund creation time. Mollie
    will always refer to the refund by this ID. Example: `re_4qqhO89gsT`.
    """
    mode: NotRequired[CreateRefundMode]
    r"""Whether this entity was created in live mode or in test mode."""
    description: NotRequired[str]
    r"""The description of the refund that may be shown to your customer, depending on the payment method used."""
    amount: NotRequired[CreateRefundAmountResponseTypedDict]
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment
    amount.
    """
    settlement_amount: NotRequired[Nullable[CreateRefundSettlementAmountTypedDict]]
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted
    to the currency your account is settled in.

    The amount is a **negative** amount.

    If the refund is not directly processed by Mollie, for example for PayPal refunds, the settlement amount will be
    zero.

    Since the field contains an estimated amount during refund processing, it may change over time. For example, while
    the refund is queued the settlement amount is likely not yet available.

    To retrieve accurate settlement amounts we recommend using the
    [List balance transactions endpoint](list-balance-transactions) instead.
    """
    metadata: NotRequired[Nullable[CreateRefundMetadataResponseUnionTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """
    payment_id: NotRequired[str]
    r"""The unique identifier of the payment this refund was created for.
    The full payment object can be retrieved via the payment URL in the `_links` object.
    """
    settlement_id: NotRequired[Nullable[str]]
    r"""The identifier referring to the settlement this refund was settled with. This field is omitted if the refund is not settled (yet)."""
    status: NotRequired[CreateRefundStatus]
    r"""Refunds may take some time to get confirmed."""
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    external_reference: NotRequired[CreateRefundExternalReferenceResponseTypedDict]
    routing_reversals: NotRequired[
        Nullable[List[CreateRefundRoutingReversalResponseTypedDict]]
    ]
    r"""*This feature is only available to marketplace operators.*

    When creating refunds for *routed* payments, by default the full amount is deducted from your balance.

    If you want to pull back funds from the connected merchant(s), you can use this parameter to specify what amount
    needs to be reversed from which merchant(s).

    If you simply want to fully reverse the routed funds, you can also use the `reverseRouting` parameter instead.
    """
    links: NotRequired[CreateRefundLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class CreateRefundResponse(BaseModel):
    r"""The newly created refund object."""

    resource: Optional[str] = None
    r"""Indicates the response contains a refund object. Will always contain the string `refund` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this refund. Mollie assigns this identifier at refund creation time. Mollie
    will always refer to the refund by this ID. Example: `re_4qqhO89gsT`.
    """

    mode: Optional[CreateRefundMode] = None
    r"""Whether this entity was created in live mode or in test mode."""

    description: Optional[str] = None
    r"""The description of the refund that may be shown to your customer, depending on the payment method used."""

    amount: Optional[CreateRefundAmountResponse] = None
    r"""The amount refunded to your customer with this refund. The amount is allowed to be lower than the original payment
    amount.
    """

    settlement_amount: Annotated[
        OptionalNullable[CreateRefundSettlementAmount],
        pydantic.Field(alias="settlementAmount"),
    ] = UNSET
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted
    to the currency your account is settled in.

    The amount is a **negative** amount.

    If the refund is not directly processed by Mollie, for example for PayPal refunds, the settlement amount will be
    zero.

    Since the field contains an estimated amount during refund processing, it may change over time. For example, while
    the refund is queued the settlement amount is likely not yet available.

    To retrieve accurate settlement amounts we recommend using the
    [List balance transactions endpoint](list-balance-transactions) instead.
    """

    metadata: OptionalNullable[CreateRefundMetadataResponseUnion] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """

    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None
    r"""The unique identifier of the payment this refund was created for.
    The full payment object can be retrieved via the payment URL in the `_links` object.
    """

    settlement_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="settlementId")
    ] = UNSET
    r"""The identifier referring to the settlement this refund was settled with. This field is omitted if the refund is not settled (yet)."""

    status: Optional[CreateRefundStatus] = None
    r"""Refunds may take some time to get confirmed."""

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    external_reference: Annotated[
        Optional[CreateRefundExternalReferenceResponse],
        pydantic.Field(alias="externalReference"),
    ] = None

    routing_reversals: Annotated[
        OptionalNullable[List[CreateRefundRoutingReversalResponse]],
        pydantic.Field(alias="routingReversals"),
    ] = UNSET
    r"""*This feature is only available to marketplace operators.*

    When creating refunds for *routed* payments, by default the full amount is deducted from your balance.

    If you want to pull back funds from the connected merchant(s), you can use this parameter to specify what amount
    needs to be reversed from which merchant(s).

    If you simply want to fully reverse the routed funds, you can also use the `reverseRouting` parameter instead.
    """

    links: Annotated[Optional[CreateRefundLinks], pydantic.Field(alias="_links")] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "mode",
            "description",
            "amount",
            "settlementAmount",
            "metadata",
            "paymentId",
            "settlementId",
            "status",
            "createdAt",
            "externalReference",
            "routingReversals",
            "_links",
        ]
        nullable_fields = [
            "settlementAmount",
            "metadata",
            "settlementId",
            "routingReversals",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
