"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListWebhooksSort(str, Enum):
    r"""Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from
    newest to oldest.
    """

    ASC = "asc"
    DESC = "desc"


class ListWebhooksEventTypes(str, Enum):
    r"""Used to filter out only the webhooks that are subscribed to certain types of events."""

    PAYMENT_LINK_PAID = "payment-link.paid"
    BALANCE_TRANSACTION_CREATED = "balance-transaction.created"
    SALES_INVOICE_CREATED = "sales-invoice.created"
    SALES_INVOICE_ISSUED = "sales-invoice.issued"
    SALES_INVOICE_CANCELED = "sales-invoice.canceled"
    SALES_INVOICE_PAID = "sales-invoice.paid"


class ListWebhooksRequestTypedDict(TypedDict):
    from_: NotRequired[str]
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """
    limit: NotRequired[Nullable[int]]
    r"""The maximum number of items to return. Defaults to 50 items."""
    sort: NotRequired[Nullable[ListWebhooksSort]]
    r"""Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from
    newest to oldest.
    """
    event_types: NotRequired[ListWebhooksEventTypes]
    r"""Used to filter out only the webhooks that are subscribed to certain types of events."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class ListWebhooksRequest(BaseModel):
    from_: Annotated[
        Optional[str],
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """

    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 50
    r"""The maximum number of items to return. Defaults to 50 items."""

    sort: Annotated[
        OptionalNullable[ListWebhooksSort],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = ListWebhooksSort.DESC
    r"""Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from
    newest to oldest.
    """

    event_types: Annotated[
        Optional[ListWebhooksEventTypes],
        pydantic.Field(alias="eventTypes"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Used to filter out only the webhooks that are subscribed to certain types of events."""

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["from", "limit", "sort", "eventTypes", "testmode"]
        nullable_fields = ["limit", "sort", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListWebhooksBadRequestDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListWebhooksBadRequestDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListWebhooksBadRequestLinksTypedDict(TypedDict):
    documentation: ListWebhooksBadRequestDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListWebhooksBadRequestLinks(BaseModel):
    documentation: ListWebhooksBadRequestDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListWebhooksHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[ListWebhooksBadRequestLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class ListWebhooksHalJSONError(ClientError):
    r"""An error response object."""

    data: ListWebhooksHalJSONErrorData

    def __init__(
        self,
        data: ListWebhooksHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class ListWebhooksStatus(str, Enum):
    r"""The subscription's current status."""

    ENABLED = "enabled"
    BLOCKED = "blocked"
    DISABLED = "disabled"
    DELETED = "deleted"


class ListWebhooksMode(str, Enum):
    r"""The subscription's mode."""

    LIVE = "live"
    TEST = "test"


class WebhookTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains a webhook subscription object.
    Will always contain the string `webhook` for this endpoint.
    """
    id: NotRequired[str]
    r"""The identifier uniquely referring to this subscription."""
    url: NotRequired[str]
    r"""The subscription's events destination."""
    profile_id: NotRequired[str]
    r"""The identifier uniquely referring to the profile that created the subscription."""
    created_at: NotRequired[str]
    r"""The subscription's date time of creation."""
    name: NotRequired[str]
    r"""The subscription's name."""
    event_types: NotRequired[List[str]]
    r"""The events types that are subscribed."""
    status: NotRequired[ListWebhooksStatus]
    r"""The subscription's current status."""
    mode: NotRequired[ListWebhooksMode]
    r"""The subscription's mode."""


class Webhook(BaseModel):
    resource: Optional[str] = "webhook"
    r"""Indicates the response contains a webhook subscription object.
    Will always contain the string `webhook` for this endpoint.
    """

    id: Optional[str] = None
    r"""The identifier uniquely referring to this subscription."""

    url: Optional[str] = None
    r"""The subscription's events destination."""

    profile_id: Annotated[Optional[str], pydantic.Field(alias="profileId")] = None
    r"""The identifier uniquely referring to the profile that created the subscription."""

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The subscription's date time of creation."""

    name: Optional[str] = None
    r"""The subscription's name."""

    event_types: Annotated[Optional[List[str]], pydantic.Field(alias="eventTypes")] = (
        None
    )
    r"""The events types that are subscribed."""

    status: Optional[ListWebhooksStatus] = None
    r"""The subscription's current status."""

    mode: Optional[ListWebhooksMode] = None
    r"""The subscription's mode."""


class ListWebhooksEmbeddedTypedDict(TypedDict):
    webhooks: NotRequired[List[WebhookTypedDict]]
    r"""A list of webhooks."""


class ListWebhooksEmbedded(BaseModel):
    webhooks: Optional[List[Webhook]] = None
    r"""A list of webhooks."""


class ListWebhooksSelfTypedDict(TypedDict):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListWebhooksSelf(BaseModel):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListWebhooksPreviousTypedDict(TypedDict):
    r"""The previous set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListWebhooksPrevious(BaseModel):
    r"""The previous set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListWebhooksNextTypedDict(TypedDict):
    r"""The next set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListWebhooksNext(BaseModel):
    r"""The next set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListWebhooksDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListWebhooksDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListWebhooksLinksTypedDict(TypedDict):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[ListWebhooksSelfTypedDict]
    r"""The URL to the current set of items."""
    previous: NotRequired[Nullable[ListWebhooksPreviousTypedDict]]
    r"""The previous set of items, if available."""
    next: NotRequired[Nullable[ListWebhooksNextTypedDict]]
    r"""The next set of items, if available."""
    documentation: NotRequired[ListWebhooksDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListWebhooksLinks(BaseModel):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[ListWebhooksSelf], pydantic.Field(alias="self")] = None
    r"""The URL to the current set of items."""

    previous: OptionalNullable[ListWebhooksPrevious] = UNSET
    r"""The previous set of items, if available."""

    next: OptionalNullable[ListWebhooksNext] = UNSET
    r"""The next set of items, if available."""

    documentation: Optional[ListWebhooksDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["self", "previous", "next", "documentation"]
        nullable_fields = ["previous", "next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListWebhooksResponseTypedDict(TypedDict):
    r"""A list of webhooks. For a complete reference of the webhook
    object, refer to the [Get hook endpoint](get-webhook) documentation.
    """

    count: NotRequired[int]
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """
    embedded: NotRequired[ListWebhooksEmbeddedTypedDict]
    links: NotRequired[ListWebhooksLinksTypedDict]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class ListWebhooksResponse(BaseModel):
    r"""A list of webhooks. For a complete reference of the webhook
    object, refer to the [Get hook endpoint](get-webhook) documentation.
    """

    count: Optional[int] = None
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """

    embedded: Annotated[
        Optional[ListWebhooksEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[Optional[ListWebhooksLinks], pydantic.Field(alias="_links")] = None
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
