"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListInvoicesSort(str, Enum):
    r"""Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from
    newest to oldest.
    """

    ASC = "asc"
    DESC = "desc"


class ListInvoicesRequestTypedDict(TypedDict):
    reference: NotRequired[Nullable[str]]
    r"""Filter for an invoice with a specific invoice reference, for example
    `2024.10000`.
    """
    year: NotRequired[Nullable[str]]
    r"""Filter for invoices of a specific year, for example `2024`."""
    month: NotRequired[Nullable[str]]
    r"""Filter for invoices of a specific month, for example `01`."""
    from_: NotRequired[Nullable[str]]
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """
    limit: NotRequired[Nullable[int]]
    r"""The maximum number of items to return. Defaults to 50 items."""
    sort: NotRequired[Nullable[ListInvoicesSort]]
    r"""Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from
    newest to oldest.
    """


class ListInvoicesRequest(BaseModel):
    reference: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter for an invoice with a specific invoice reference, for example
    `2024.10000`.
    """

    year: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter for invoices of a specific year, for example `2024`."""

    month: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter for invoices of a specific month, for example `01`."""

    from_: Annotated[
        OptionalNullable[str],
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """

    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 50
    r"""The maximum number of items to return. Defaults to 50 items."""

    sort: Annotated[
        OptionalNullable[ListInvoicesSort],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = ListInvoicesSort.DESC
    r"""Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from
    newest to oldest.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["reference", "year", "month", "from", "limit", "sort"]
        nullable_fields = ["reference", "year", "month", "from", "limit", "sort"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListInvoicesNotFoundDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListInvoicesNotFoundDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListInvoicesNotFoundLinksTypedDict(TypedDict):
    documentation: ListInvoicesNotFoundDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListInvoicesNotFoundLinks(BaseModel):
    documentation: ListInvoicesNotFoundDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListInvoicesNotFoundHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[ListInvoicesNotFoundLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class ListInvoicesNotFoundHalJSONError(ClientError):
    r"""An error response object."""

    data: ListInvoicesNotFoundHalJSONErrorData

    def __init__(
        self,
        data: ListInvoicesNotFoundHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class ListInvoicesBadRequestDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListInvoicesBadRequestDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListInvoicesBadRequestLinksTypedDict(TypedDict):
    documentation: ListInvoicesBadRequestDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListInvoicesBadRequestLinks(BaseModel):
    documentation: ListInvoicesBadRequestDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListInvoicesBadRequestHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[ListInvoicesBadRequestLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class ListInvoicesBadRequestHalJSONError(ClientError):
    r"""An error response object."""

    data: ListInvoicesBadRequestHalJSONErrorData

    def __init__(
        self,
        data: ListInvoicesBadRequestHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class ListInvoicesInvoiceTypedDict(TypedDict):
    pass


class ListInvoicesInvoice(BaseModel):
    pass


class ListInvoicesEmbeddedTypedDict(TypedDict):
    invoices: NotRequired[List[ListInvoicesInvoiceTypedDict]]
    r"""An array of invoice objects. For a complete reference of
    the invoice object, refer to the [Get invoice endpoint](get-invoice) documentation.
    """


class ListInvoicesEmbedded(BaseModel):
    invoices: Optional[List[ListInvoicesInvoice]] = None
    r"""An array of invoice objects. For a complete reference of
    the invoice object, refer to the [Get invoice endpoint](get-invoice) documentation.
    """


class ListInvoicesSelfTypedDict(TypedDict):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListInvoicesSelf(BaseModel):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListInvoicesPreviousTypedDict(TypedDict):
    r"""The previous set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListInvoicesPrevious(BaseModel):
    r"""The previous set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListInvoicesNextTypedDict(TypedDict):
    r"""The next set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListInvoicesNext(BaseModel):
    r"""The next set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListInvoicesDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListInvoicesDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListInvoicesLinksTypedDict(TypedDict):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[ListInvoicesSelfTypedDict]
    r"""The URL to the current set of items."""
    previous: NotRequired[Nullable[ListInvoicesPreviousTypedDict]]
    r"""The previous set of items, if available."""
    next: NotRequired[Nullable[ListInvoicesNextTypedDict]]
    r"""The next set of items, if available."""
    documentation: NotRequired[ListInvoicesDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListInvoicesLinks(BaseModel):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[ListInvoicesSelf], pydantic.Field(alias="self")] = None
    r"""The URL to the current set of items."""

    previous: OptionalNullable[ListInvoicesPrevious] = UNSET
    r"""The previous set of items, if available."""

    next: OptionalNullable[ListInvoicesNext] = UNSET
    r"""The next set of items, if available."""

    documentation: Optional[ListInvoicesDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["self", "previous", "next", "documentation"]
        nullable_fields = ["previous", "next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListInvoicesResponseTypedDict(TypedDict):
    r"""A list of invoice objects. For a complete reference of the invoice
    object, refer to the [Get invoice endpoint](get-invoice) documentation.
    """

    count: NotRequired[int]
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """
    embedded: NotRequired[ListInvoicesEmbeddedTypedDict]
    links: NotRequired[ListInvoicesLinksTypedDict]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class ListInvoicesResponse(BaseModel):
    r"""A list of invoice objects. For a complete reference of the invoice
    object, refer to the [Get invoice endpoint](get-invoice) documentation.
    """

    count: Optional[int] = None
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """

    embedded: Annotated[
        Optional[ListInvoicesEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[Optional[ListInvoicesLinks], pydantic.Field(alias="_links")] = None
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
