"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class ListSubscriptionsSort(str, Enum):
    r"""Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from
    newest to oldest.
    """

    ASC = "asc"
    DESC = "desc"


class ListSubscriptionsRequestTypedDict(TypedDict):
    customer_id: str
    r"""Provide the ID of the related customer."""
    from_: NotRequired[str]
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """
    limit: NotRequired[Nullable[int]]
    r"""The maximum number of items to return. Defaults to 50 items."""
    sort: NotRequired[Nullable[ListSubscriptionsSort]]
    r"""Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from
    newest to oldest.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class ListSubscriptionsRequest(BaseModel):
    customer_id: Annotated[
        str,
        pydantic.Field(alias="customerId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related customer."""

    from_: Annotated[
        Optional[str],
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """

    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 50
    r"""The maximum number of items to return. Defaults to 50 items."""

    sort: Annotated[
        OptionalNullable[ListSubscriptionsSort],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = ListSubscriptionsSort.DESC
    r"""Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from
    newest to oldest.
    """

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["from", "limit", "sort", "testmode"]
        nullable_fields = ["limit", "sort", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListSubscriptionsNotFoundDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListSubscriptionsNotFoundDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListSubscriptionsNotFoundLinksTypedDict(TypedDict):
    documentation: ListSubscriptionsNotFoundDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListSubscriptionsNotFoundLinks(BaseModel):
    documentation: ListSubscriptionsNotFoundDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListSubscriptionsNotFoundHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[ListSubscriptionsNotFoundLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class ListSubscriptionsNotFoundHalJSONError(ClientError):
    r"""An error response object."""

    data: ListSubscriptionsNotFoundHalJSONErrorData

    def __init__(
        self,
        data: ListSubscriptionsNotFoundHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class ListSubscriptionsBadRequestDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListSubscriptionsBadRequestDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListSubscriptionsBadRequestLinksTypedDict(TypedDict):
    documentation: ListSubscriptionsBadRequestDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListSubscriptionsBadRequestLinks(BaseModel):
    documentation: ListSubscriptionsBadRequestDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListSubscriptionsBadRequestHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[ListSubscriptionsBadRequestLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class ListSubscriptionsBadRequestHalJSONError(ClientError):
    r"""An error response object."""

    data: ListSubscriptionsBadRequestHalJSONErrorData

    def __init__(
        self,
        data: ListSubscriptionsBadRequestHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class ListSubscriptionsMode(str, Enum):
    r"""Whether this entity was created in live mode or in test mode."""

    LIVE = "live"
    TEST = "test"


class ListSubscriptionsStatus(str, Enum):
    r"""The subscription's current status is directly related to the status of the underlying customer or mandate that is
    enabling the subscription.
    """

    PENDING = "pending"
    ACTIVE = "active"
    CANCELED = "canceled"
    SUSPENDED = "suspended"
    COMPLETED = "completed"


class ListSubscriptionsAmountTypedDict(TypedDict):
    r"""The amount for each individual payment that is charged with this subscription. For example, for a monthly
    subscription of €10, the subscription amount should be set to €10.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListSubscriptionsAmount(BaseModel):
    r"""The amount for each individual payment that is charged with this subscription. For example, for a monthly
    subscription of €10, the subscription amount should be set to €10.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListSubscriptionsInterval(str, Enum):
    r"""Interval to wait between payments, for example `1 month` or `14 days`.

    The maximum interval is one year (`12 months`, `52 weeks`, or `365 days`).
    """

    DOT_DOT_DOT_DAYS = "... days"
    DOT_DOT_DOT_WEEKS = "... weeks"
    DOT_DOT_DOT_MONTHS = "... months"


class ListSubscriptionsMethod(str, Enum):
    r"""The payment method used for this subscription. If omitted, any of the customer's valid mandates may be used."""

    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    PAYPAL = "paypal"


class ListSubscriptionsApplicationFeeAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListSubscriptionsApplicationFeeAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListSubscriptionsApplicationFeeTypedDict(TypedDict):
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    Setting an application fee on the subscription will ensure this fee is charged on each individual payment.

    Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more
    information.
    """

    amount: ListSubscriptionsApplicationFeeAmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    description: str


class ListSubscriptionsApplicationFee(BaseModel):
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    Setting an application fee on the subscription will ensure this fee is charged on each individual payment.

    Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more
    information.
    """

    amount: ListSubscriptionsApplicationFeeAmount
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    description: str


class ListSubscriptionsMetadataTypedDict(TypedDict):
    pass


class ListSubscriptionsMetadata(BaseModel):
    pass


ListSubscriptionsMetadataUnionTypedDict = TypeAliasType(
    "ListSubscriptionsMetadataUnionTypedDict",
    Union[ListSubscriptionsMetadataTypedDict, str, List[str]],
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity.
Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately
1kB.

Any metadata added to the subscription will be automatically forwarded to the payments generated for it.
"""


ListSubscriptionsMetadataUnion = TypeAliasType(
    "ListSubscriptionsMetadataUnion", Union[ListSubscriptionsMetadata, str, List[str]]
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity.
Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately
1kB.

Any metadata added to the subscription will be automatically forwarded to the payments generated for it.
"""


class ListSubscriptionsSubscriptionSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSubscriptionsSubscriptionSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSubscriptionsCustomerTypedDict(TypedDict):
    r"""The API resource URL of the [customer](get-customer) this subscription was created for."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListSubscriptionsCustomer(BaseModel):
    r"""The API resource URL of the [customer](get-customer) this subscription was created for."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListSubscriptionsMandateTypedDict(TypedDict):
    r"""The API resource URL of the [mandate](get-mandate) this subscription was created for."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListSubscriptionsMandate(BaseModel):
    r"""The API resource URL of the [mandate](get-mandate) this subscription was created for."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListSubscriptionsProfileTypedDict(TypedDict):
    r"""The API resource URL of the [profile](get-profile) this subscription was created for."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListSubscriptionsProfile(BaseModel):
    r"""The API resource URL of the [profile](get-profile) this subscription was created for."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListSubscriptionsPaymentsTypedDict(TypedDict):
    r"""The API resource URL of the [payments](list-payments) created for this subscription. Omitted if no such
    payments exist (yet).
    """

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListSubscriptionsPayments(BaseModel):
    r"""The API resource URL of the [payments](list-payments) created for this subscription. Omitted if no such
    payments exist (yet).
    """

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListSubscriptionsSubscriptionDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSubscriptionsSubscriptionDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSubscriptionsSubscriptionLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: ListSubscriptionsSubscriptionSelfTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    customer: Nullable[ListSubscriptionsCustomerTypedDict]
    r"""The API resource URL of the [customer](get-customer) this subscription was created for."""
    profile: Nullable[ListSubscriptionsProfileTypedDict]
    r"""The API resource URL of the [profile](get-profile) this subscription was created for."""
    documentation: ListSubscriptionsSubscriptionDocumentationTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    mandate: NotRequired[Nullable[ListSubscriptionsMandateTypedDict]]
    r"""The API resource URL of the [mandate](get-mandate) this subscription was created for."""
    payments: NotRequired[Nullable[ListSubscriptionsPaymentsTypedDict]]
    r"""The API resource URL of the [payments](list-payments) created for this subscription. Omitted if no such
    payments exist (yet).
    """


class ListSubscriptionsSubscriptionLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[ListSubscriptionsSubscriptionSelf, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    customer: Nullable[ListSubscriptionsCustomer]
    r"""The API resource URL of the [customer](get-customer) this subscription was created for."""

    profile: Nullable[ListSubscriptionsProfile]
    r"""The API resource URL of the [profile](get-profile) this subscription was created for."""

    documentation: ListSubscriptionsSubscriptionDocumentation
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    mandate: OptionalNullable[ListSubscriptionsMandate] = UNSET
    r"""The API resource URL of the [mandate](get-mandate) this subscription was created for."""

    payments: OptionalNullable[ListSubscriptionsPayments] = UNSET
    r"""The API resource URL of the [payments](list-payments) created for this subscription. Omitted if no such
    payments exist (yet).
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["mandate", "payments"]
        nullable_fields = ["customer", "mandate", "profile", "payments"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListSubscriptionsSubscriptionTypedDict(TypedDict):
    id: str
    r"""The identifier uniquely referring to this subscription. Example: `sub_rVKGtNd6s3`."""
    mode: ListSubscriptionsMode
    r"""Whether this entity was created in live mode or in test mode."""
    status: ListSubscriptionsStatus
    r"""The subscription's current status is directly related to the status of the underlying customer or mandate that is
    enabling the subscription.
    """
    amount: ListSubscriptionsAmountTypedDict
    r"""The amount for each individual payment that is charged with this subscription. For example, for a monthly
    subscription of €10, the subscription amount should be set to €10.
    """
    times: Nullable[int]
    r"""Total number of payments for the subscription. Once this number of payments is reached, the subscription is
    considered completed.

    Test mode subscriptions will get canceled automatically after 10 payments.
    """
    times_remaining: int
    r"""Number of payments left for the subscription."""
    interval: ListSubscriptionsInterval
    r"""Interval to wait between payments, for example `1 month` or `14 days`.

    The maximum interval is one year (`12 months`, `52 weeks`, or `365 days`).
    """
    start_date: str
    r"""The start date of the subscription in `YYYY-MM-DD` format."""
    description: str
    r"""The subscription's description will be used as the description of the resulting individual payments and so showing
    up on the bank statement of the consumer.

    **Please note:** the description needs to be unique for the Customer in case it has multiple active subscriptions.
    """
    method: Nullable[ListSubscriptionsMethod]
    r"""The payment method used for this subscription. If omitted, any of the customer's valid mandates may be used."""
    metadata: Nullable[ListSubscriptionsMetadataUnionTypedDict]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity.
    Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately
    1kB.

    Any metadata added to the subscription will be automatically forwarded to the payments generated for it.
    """
    webhook_url: str
    r"""We will call this URL for any payment status changes of payments resulting from this subscription.

    This webhook will receive **all** events for the subscription's payments. This may include payment failures as
    well. Be sure to verify the payment's subscription ID and its status.
    """
    customer_id: str
    r"""The customer this subscription belongs to."""
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    resource: NotRequired[str]
    r"""Indicates the response contains a subscription object. Will always contain the string `subscription` for this
    endpoint.
    """
    next_payment_date: NotRequired[Nullable[str]]
    r"""The date of the next scheduled payment in `YYYY-MM-DD` format. If the subscription has been completed or canceled,
    this parameter will not be returned.
    """
    application_fee: NotRequired[ListSubscriptionsApplicationFeeTypedDict]
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    Setting an application fee on the subscription will ensure this fee is charged on each individual payment.

    Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more
    information.
    """
    mandate_id: NotRequired[Nullable[str]]
    r"""The mandate used for this subscription, if any."""
    canceled_at: NotRequired[Nullable[str]]
    r"""The subscription's date and time of cancellation, in ISO 8601 format. This parameter is omitted if the
    subscription is not canceled (yet).
    """
    links: NotRequired[ListSubscriptionsSubscriptionLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class ListSubscriptionsSubscription(BaseModel):
    id: str
    r"""The identifier uniquely referring to this subscription. Example: `sub_rVKGtNd6s3`."""

    mode: ListSubscriptionsMode
    r"""Whether this entity was created in live mode or in test mode."""

    status: ListSubscriptionsStatus
    r"""The subscription's current status is directly related to the status of the underlying customer or mandate that is
    enabling the subscription.
    """

    amount: ListSubscriptionsAmount
    r"""The amount for each individual payment that is charged with this subscription. For example, for a monthly
    subscription of €10, the subscription amount should be set to €10.
    """

    times: Nullable[int]
    r"""Total number of payments for the subscription. Once this number of payments is reached, the subscription is
    considered completed.

    Test mode subscriptions will get canceled automatically after 10 payments.
    """

    times_remaining: Annotated[int, pydantic.Field(alias="timesRemaining")]
    r"""Number of payments left for the subscription."""

    interval: ListSubscriptionsInterval
    r"""Interval to wait between payments, for example `1 month` or `14 days`.

    The maximum interval is one year (`12 months`, `52 weeks`, or `365 days`).
    """

    start_date: Annotated[str, pydantic.Field(alias="startDate")]
    r"""The start date of the subscription in `YYYY-MM-DD` format."""

    description: str
    r"""The subscription's description will be used as the description of the resulting individual payments and so showing
    up on the bank statement of the consumer.

    **Please note:** the description needs to be unique for the Customer in case it has multiple active subscriptions.
    """

    method: Nullable[ListSubscriptionsMethod]
    r"""The payment method used for this subscription. If omitted, any of the customer's valid mandates may be used."""

    metadata: Nullable[ListSubscriptionsMetadataUnion]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity.
    Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately
    1kB.

    Any metadata added to the subscription will be automatically forwarded to the payments generated for it.
    """

    webhook_url: Annotated[str, pydantic.Field(alias="webhookUrl")]
    r"""We will call this URL for any payment status changes of payments resulting from this subscription.

    This webhook will receive **all** events for the subscription's payments. This may include payment failures as
    well. Be sure to verify the payment's subscription ID and its status.
    """

    customer_id: Annotated[str, pydantic.Field(alias="customerId")]
    r"""The customer this subscription belongs to."""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    resource: Optional[str] = "subscription"
    r"""Indicates the response contains a subscription object. Will always contain the string `subscription` for this
    endpoint.
    """

    next_payment_date: Annotated[
        OptionalNullable[str], pydantic.Field(alias="nextPaymentDate")
    ] = UNSET
    r"""The date of the next scheduled payment in `YYYY-MM-DD` format. If the subscription has been completed or canceled,
    this parameter will not be returned.
    """

    application_fee: Annotated[
        Optional[ListSubscriptionsApplicationFee],
        pydantic.Field(alias="applicationFee"),
    ] = None
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    Setting an application fee on the subscription will ensure this fee is charged on each individual payment.

    Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more
    information.
    """

    mandate_id: Annotated[OptionalNullable[str], pydantic.Field(alias="mandateId")] = (
        UNSET
    )
    r"""The mandate used for this subscription, if any."""

    canceled_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="canceledAt")
    ] = UNSET
    r"""The subscription's date and time of cancellation, in ISO 8601 format. This parameter is omitted if the
    subscription is not canceled (yet).
    """

    links: Annotated[
        Optional[ListSubscriptionsSubscriptionLinks], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "nextPaymentDate",
            "applicationFee",
            "mandateId",
            "canceledAt",
            "_links",
        ]
        nullable_fields = [
            "times",
            "nextPaymentDate",
            "method",
            "metadata",
            "mandateId",
            "canceledAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListSubscriptionsEmbeddedTypedDict(TypedDict):
    subscriptions: NotRequired[List[ListSubscriptionsSubscriptionTypedDict]]
    r"""An array of subscription objects."""


class ListSubscriptionsEmbedded(BaseModel):
    subscriptions: Optional[List[ListSubscriptionsSubscription]] = None
    r"""An array of subscription objects."""


class ListSubscriptionsSelfTypedDict(TypedDict):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSubscriptionsSelf(BaseModel):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSubscriptionsPreviousTypedDict(TypedDict):
    r"""The previous set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListSubscriptionsPrevious(BaseModel):
    r"""The previous set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListSubscriptionsNextTypedDict(TypedDict):
    r"""The next set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListSubscriptionsNext(BaseModel):
    r"""The next set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListSubscriptionsDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSubscriptionsDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSubscriptionsLinksTypedDict(TypedDict):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[ListSubscriptionsSelfTypedDict]
    r"""The URL to the current set of items."""
    previous: NotRequired[Nullable[ListSubscriptionsPreviousTypedDict]]
    r"""The previous set of items, if available."""
    next: NotRequired[Nullable[ListSubscriptionsNextTypedDict]]
    r"""The next set of items, if available."""
    documentation: NotRequired[ListSubscriptionsDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListSubscriptionsLinks(BaseModel):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[ListSubscriptionsSelf], pydantic.Field(alias="self")] = (
        None
    )
    r"""The URL to the current set of items."""

    previous: OptionalNullable[ListSubscriptionsPrevious] = UNSET
    r"""The previous set of items, if available."""

    next: OptionalNullable[ListSubscriptionsNext] = UNSET
    r"""The next set of items, if available."""

    documentation: Optional[ListSubscriptionsDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["self", "previous", "next", "documentation"]
        nullable_fields = ["previous", "next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListSubscriptionsResponseTypedDict(TypedDict):
    r"""A list of subscription objects."""

    count: NotRequired[int]
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """
    embedded: NotRequired[ListSubscriptionsEmbeddedTypedDict]
    links: NotRequired[ListSubscriptionsLinksTypedDict]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class ListSubscriptionsResponse(BaseModel):
    r"""A list of subscription objects."""

    count: Optional[int] = None
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """

    embedded: Annotated[
        Optional[ListSubscriptionsEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[
        Optional[ListSubscriptionsLinks], pydantic.Field(alias="_links")
    ] = None
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
