"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class ListCapturesEmbed(str, Enum):
    r"""This endpoint allows you to embed additional resources via the
    `embed` query string parameter.
    """

    PAYMENT = "payment"


class ListCapturesRequestTypedDict(TypedDict):
    payment_id: str
    r"""Provide the ID of the related payment."""
    from_: NotRequired[str]
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """
    limit: NotRequired[Nullable[int]]
    r"""The maximum number of items to return. Defaults to 50 items."""
    embed: NotRequired[ListCapturesEmbed]
    r"""This endpoint allows you to embed additional resources via the
    `embed` query string parameter.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class ListCapturesRequest(BaseModel):
    payment_id: Annotated[
        str,
        pydantic.Field(alias="paymentId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related payment."""

    from_: Annotated[
        Optional[str],
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """

    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The maximum number of items to return. Defaults to 50 items."""

    embed: Annotated[
        Optional[ListCapturesEmbed],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""This endpoint allows you to embed additional resources via the
    `embed` query string parameter.
    """

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["from", "limit", "embed", "testmode"]
        nullable_fields = ["limit", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListCapturesNotFoundDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListCapturesNotFoundDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListCapturesNotFoundLinksTypedDict(TypedDict):
    documentation: ListCapturesNotFoundDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListCapturesNotFoundLinks(BaseModel):
    documentation: ListCapturesNotFoundDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListCapturesNotFoundHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[ListCapturesNotFoundLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class ListCapturesNotFoundHalJSONError(ClientError):
    r"""An error response object."""

    data: ListCapturesNotFoundHalJSONErrorData

    def __init__(
        self,
        data: ListCapturesNotFoundHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class ListCapturesBadRequestDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListCapturesBadRequestDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListCapturesBadRequestLinksTypedDict(TypedDict):
    documentation: ListCapturesBadRequestDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListCapturesBadRequestLinks(BaseModel):
    documentation: ListCapturesBadRequestDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListCapturesBadRequestHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[ListCapturesBadRequestLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class ListCapturesBadRequestHalJSONError(ClientError):
    r"""An error response object."""

    data: ListCapturesBadRequestHalJSONErrorData

    def __init__(
        self,
        data: ListCapturesBadRequestHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class ListCapturesMode(str, Enum):
    r"""Whether this entity was created in live mode or in test mode."""

    LIVE = "live"
    TEST = "test"


class ListCapturesAmountTypedDict(TypedDict):
    r"""The amount captured. If no amount is provided, the full authorized amount is captured."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListCapturesAmount(BaseModel):
    r"""The amount captured. If no amount is provided, the full authorized amount is captured."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListCapturesSettlementAmountTypedDict(TypedDict):
    r"""This optional field will contain the approximate amount that will be settled to your account, converted to the
    currency your account is settled in.

    Since the field contains an estimated amount during capture processing, it may change over time. To retrieve
    accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions)
    instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListCapturesSettlementAmount(BaseModel):
    r"""This optional field will contain the approximate amount that will be settled to your account, converted to the
    currency your account is settled in.

    Since the field contains an estimated amount during capture processing, it may change over time. To retrieve
    accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions)
    instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListCapturesStatus(str, Enum):
    r"""The capture's status."""

    PENDING = "pending"
    SUCCEEDED = "succeeded"
    FAILED = "failed"


class ListCapturesMetadataTypedDict(TypedDict):
    pass


class ListCapturesMetadata(BaseModel):
    pass


ListCapturesMetadataUnionTypedDict = TypeAliasType(
    "ListCapturesMetadataUnionTypedDict",
    Union[ListCapturesMetadataTypedDict, str, List[str]],
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
"""


ListCapturesMetadataUnion = TypeAliasType(
    "ListCapturesMetadataUnion", Union[ListCapturesMetadata, str, List[str]]
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
"""


class ListCapturesCaptureSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListCapturesCaptureSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListCapturesPaymentTypedDict(TypedDict):
    r"""The API resource URL of the [payment](get-payment) that this capture belongs to."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListCapturesPayment(BaseModel):
    r"""The API resource URL of the [payment](get-payment) that this capture belongs to."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListCapturesSettlementTypedDict(TypedDict):
    r"""The API resource URL of the [settlement](get-settlement) this capture has been settled with. Not present if
    not yet settled.
    """

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListCapturesSettlement(BaseModel):
    r"""The API resource URL of the [settlement](get-settlement) this capture has been settled with. Not present if
    not yet settled.
    """

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListCapturesShipmentTypedDict(TypedDict):
    r"""The API resource URL of the [shipment](get-shipment) this capture is associated with. Not present if
    it isn't associated with a shipment.
    """

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListCapturesShipment(BaseModel):
    r"""The API resource URL of the [shipment](get-shipment) this capture is associated with. Not present if
    it isn't associated with a shipment.
    """

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListCapturesCaptureDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListCapturesCaptureDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListCapturesCaptureLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: ListCapturesCaptureSelfTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payment: ListCapturesPaymentTypedDict
    r"""The API resource URL of the [payment](get-payment) that this capture belongs to."""
    documentation: ListCapturesCaptureDocumentationTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    settlement: NotRequired[Nullable[ListCapturesSettlementTypedDict]]
    r"""The API resource URL of the [settlement](get-settlement) this capture has been settled with. Not present if
    not yet settled.
    """
    shipment: NotRequired[Nullable[ListCapturesShipmentTypedDict]]
    r"""The API resource URL of the [shipment](get-shipment) this capture is associated with. Not present if
    it isn't associated with a shipment.
    """


class ListCapturesCaptureLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[ListCapturesCaptureSelf, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payment: ListCapturesPayment
    r"""The API resource URL of the [payment](get-payment) that this capture belongs to."""

    documentation: ListCapturesCaptureDocumentation
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    settlement: OptionalNullable[ListCapturesSettlement] = UNSET
    r"""The API resource URL of the [settlement](get-settlement) this capture has been settled with. Not present if
    not yet settled.
    """

    shipment: OptionalNullable[ListCapturesShipment] = UNSET
    r"""The API resource URL of the [shipment](get-shipment) this capture is associated with. Not present if
    it isn't associated with a shipment.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["settlement", "shipment"]
        nullable_fields = ["settlement", "shipment"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListCapturesCaptureTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a capture object. Will always contain the string `capture` for this endpoint."""
    id: str
    r"""The identifier uniquely referring to this capture. Example: `cpt_mNepDkEtco6ah3QNPUGYH`."""
    mode: ListCapturesMode
    r"""Whether this entity was created in live mode or in test mode."""
    amount: Nullable[ListCapturesAmountTypedDict]
    r"""The amount captured. If no amount is provided, the full authorized amount is captured."""
    status: ListCapturesStatus
    r"""The capture's status."""
    payment_id: str
    r"""The unique identifier of the payment this capture was created for. For example: `tr_5B8cwPMGnU6qLbRvo7qEZo`.
    The full payment object can be retrieved via the payment URL in the `_links` object.
    """
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: ListCapturesCaptureLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    description: NotRequired[str]
    r"""The description of the capture."""
    settlement_amount: NotRequired[Nullable[ListCapturesSettlementAmountTypedDict]]
    r"""This optional field will contain the approximate amount that will be settled to your account, converted to the
    currency your account is settled in.

    Since the field contains an estimated amount during capture processing, it may change over time. To retrieve
    accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions)
    instead.
    """
    metadata: NotRequired[Nullable[ListCapturesMetadataUnionTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """
    shipment_id: NotRequired[Nullable[str]]
    r"""The unique identifier of the shipment that triggered the creation of this capture, if applicable. For example:
    `shp_gNapNy9qQTUFZYnCrCF7J`.
    """
    settlement_id: NotRequired[Nullable[str]]
    r"""The identifier referring to the settlement this capture was settled with. For example, `stl_BkEjN2eBb`. This field
    is omitted if the capture is not settled (yet).
    """


class ListCapturesCapture(BaseModel):
    resource: str
    r"""Indicates the response contains a capture object. Will always contain the string `capture` for this endpoint."""

    id: str
    r"""The identifier uniquely referring to this capture. Example: `cpt_mNepDkEtco6ah3QNPUGYH`."""

    mode: ListCapturesMode
    r"""Whether this entity was created in live mode or in test mode."""

    amount: Nullable[ListCapturesAmount]
    r"""The amount captured. If no amount is provided, the full authorized amount is captured."""

    status: ListCapturesStatus
    r"""The capture's status."""

    payment_id: Annotated[str, pydantic.Field(alias="paymentId")]
    r"""The unique identifier of the payment this capture was created for. For example: `tr_5B8cwPMGnU6qLbRvo7qEZo`.
    The full payment object can be retrieved via the payment URL in the `_links` object.
    """

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[ListCapturesCaptureLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    description: Optional[str] = None
    r"""The description of the capture."""

    settlement_amount: Annotated[
        OptionalNullable[ListCapturesSettlementAmount],
        pydantic.Field(alias="settlementAmount"),
    ] = UNSET
    r"""This optional field will contain the approximate amount that will be settled to your account, converted to the
    currency your account is settled in.

    Since the field contains an estimated amount during capture processing, it may change over time. To retrieve
    accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions)
    instead.
    """

    metadata: OptionalNullable[ListCapturesMetadataUnion] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """

    shipment_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="shipmentId")
    ] = UNSET
    r"""The unique identifier of the shipment that triggered the creation of this capture, if applicable. For example:
    `shp_gNapNy9qQTUFZYnCrCF7J`.
    """

    settlement_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="settlementId")
    ] = UNSET
    r"""The identifier referring to the settlement this capture was settled with. For example, `stl_BkEjN2eBb`. This field
    is omitted if the capture is not settled (yet).
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "description",
            "settlementAmount",
            "metadata",
            "shipmentId",
            "settlementId",
        ]
        nullable_fields = [
            "amount",
            "settlementAmount",
            "metadata",
            "shipmentId",
            "settlementId",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListCapturesEmbeddedTypedDict(TypedDict):
    captures: NotRequired[List[ListCapturesCaptureTypedDict]]
    r"""An array of capture objects."""


class ListCapturesEmbedded(BaseModel):
    captures: Optional[List[ListCapturesCapture]] = None
    r"""An array of capture objects."""


class ListCapturesSelfTypedDict(TypedDict):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListCapturesSelf(BaseModel):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListCapturesPreviousTypedDict(TypedDict):
    r"""The previous set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListCapturesPrevious(BaseModel):
    r"""The previous set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListCapturesNextTypedDict(TypedDict):
    r"""The next set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListCapturesNext(BaseModel):
    r"""The next set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListCapturesDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListCapturesDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListCapturesLinksTypedDict(TypedDict):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[ListCapturesSelfTypedDict]
    r"""The URL to the current set of items."""
    previous: NotRequired[Nullable[ListCapturesPreviousTypedDict]]
    r"""The previous set of items, if available."""
    next: NotRequired[Nullable[ListCapturesNextTypedDict]]
    r"""The next set of items, if available."""
    documentation: NotRequired[ListCapturesDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListCapturesLinks(BaseModel):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[ListCapturesSelf], pydantic.Field(alias="self")] = None
    r"""The URL to the current set of items."""

    previous: OptionalNullable[ListCapturesPrevious] = UNSET
    r"""The previous set of items, if available."""

    next: OptionalNullable[ListCapturesNext] = UNSET
    r"""The next set of items, if available."""

    documentation: Optional[ListCapturesDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["self", "previous", "next", "documentation"]
        nullable_fields = ["previous", "next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListCapturesResponseTypedDict(TypedDict):
    r"""A list of capture objects."""

    count: NotRequired[int]
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """
    embedded: NotRequired[ListCapturesEmbeddedTypedDict]
    links: NotRequired[ListCapturesLinksTypedDict]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class ListCapturesResponse(BaseModel):
    r"""A list of capture objects."""

    count: Optional[int] = None
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """

    embedded: Annotated[
        Optional[ListCapturesEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[Optional[ListCapturesLinks], pydantic.Field(alias="_links")] = None
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
