"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetMethodLocale(str, Enum):
    r"""Passing a locale will sort the payment methods in the preferred order
    for the country, and translate the payment method names in the corresponding language.
    """

    EN_US = "en_US"
    EN_GB = "en_GB"
    NL_NL = "nl_NL"
    NL_BE = "nl_BE"
    DE_DE = "de_DE"
    DE_AT = "de_AT"
    DE_CH = "de_CH"
    FR_FR = "fr_FR"
    FR_BE = "fr_BE"
    ES_ES = "es_ES"
    CA_ES = "ca_ES"
    PT_PT = "pt_PT"
    IT_IT = "it_IT"
    NB_NO = "nb_NO"
    SV_SE = "sv_SE"
    FI_FI = "fi_FI"
    DA_DK = "da_DK"
    IS_IS = "is_IS"
    HU_HU = "hu_HU"
    PL_PL = "pl_PL"
    LV_LV = "lv_LV"
    LT_LT = "lt_LT"


class GetMethodInclude(str, Enum):
    r"""This endpoint allows you to include additional information via the
    `include` query string parameter.
    """

    ISSUERS = "issuers"


class GetMethodSequenceType(str, Enum):
    r"""Set this parameter to `first` to only return the methods that
    can be used for the first payment of a recurring sequence.

    Set it to `recurring` to only return methods that can be used for recurring payments or subscriptions.
    """

    ONEOFF = "oneoff"
    FIRST = "first"
    RECURRING = "recurring"


class GetMethodRequestTypedDict(TypedDict):
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""
    locale: NotRequired[GetMethodLocale]
    r"""Passing a locale will sort the payment methods in the preferred order
    for the country, and translate the payment method names in the corresponding language.
    """
    currency: NotRequired[str]
    r"""If provided, the `minimumAmount` and `maximumAmount` will be converted
    to the given currency. An error is returned if the currency is not supported by the payment method.
    """
    profile_id: NotRequired[str]
    r"""The identifier referring to the [profile](get-profile) you wish to
    retrieve the resources for.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted. For
    organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """
    include: NotRequired[Nullable[GetMethodInclude]]
    r"""This endpoint allows you to include additional information via the
    `include` query string parameter.
    """
    sequence_type: NotRequired[GetMethodSequenceType]
    r"""Set this parameter to `first` to only return the methods that
    can be used for the first payment of a recurring sequence.

    Set it to `recurring` to only return methods that can be used for recurring payments or subscriptions.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class GetMethodRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""

    locale: Annotated[
        Optional[GetMethodLocale],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Passing a locale will sort the payment methods in the preferred order
    for the country, and translate the payment method names in the corresponding language.
    """

    currency: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""If provided, the `minimumAmount` and `maximumAmount` will be converted
    to the given currency. An error is returned if the currency is not supported by the payment method.
    """

    profile_id: Annotated[
        Optional[str],
        pydantic.Field(alias="profileId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The identifier referring to the [profile](get-profile) you wish to
    retrieve the resources for.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted. For
    organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """

    include: Annotated[
        OptionalNullable[GetMethodInclude],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""This endpoint allows you to include additional information via the
    `include` query string parameter.
    """

    sequence_type: Annotated[
        Optional[GetMethodSequenceType],
        pydantic.Field(alias="sequenceType"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Set this parameter to `first` to only return the methods that
    can be used for the first payment of a recurring sequence.

    Set it to `recurring` to only return methods that can be used for recurring payments or subscriptions.
    """

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "locale",
            "currency",
            "profileId",
            "include",
            "sequenceType",
            "testmode",
        ]
        nullable_fields = ["include", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetMethodNotFoundDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class GetMethodNotFoundDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class GetMethodNotFoundLinksTypedDict(TypedDict):
    documentation: GetMethodNotFoundDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class GetMethodNotFoundLinks(BaseModel):
    documentation: GetMethodNotFoundDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class GetMethodNotFoundHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[GetMethodNotFoundLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class GetMethodNotFoundHalJSONError(ClientError):
    r"""An error response object."""

    data: GetMethodNotFoundHalJSONErrorData

    def __init__(
        self,
        data: GetMethodNotFoundHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class GetMethodBadRequestDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class GetMethodBadRequestDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class GetMethodBadRequestLinksTypedDict(TypedDict):
    documentation: GetMethodBadRequestDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class GetMethodBadRequestLinks(BaseModel):
    documentation: GetMethodBadRequestDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class GetMethodBadRequestHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[GetMethodBadRequestLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class GetMethodBadRequestHalJSONError(ClientError):
    r"""An error response object."""

    data: GetMethodBadRequestHalJSONErrorData

    def __init__(
        self,
        data: GetMethodBadRequestHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class GetMethodID(str, Enum):
    r"""The unique identifier of the payment method. When used during [payment creation](create-payment), the payment
    method selection screen will be skipped.
    """

    ALMA = "alma"
    APPLEPAY = "applepay"
    BACS = "bacs"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    IDEAL = "ideal"
    IN3 = "in3"
    KBC = "kbc"
    KLARNA = "klarna"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    POINTOFSALE = "pointofsale"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class GetMethodMinimumAmountTypedDict(TypedDict):
    r"""The minimum payment amount required to use this payment method."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetMethodMinimumAmount(BaseModel):
    r"""The minimum payment amount required to use this payment method."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetMethodMaximumAmountTypedDict(TypedDict):
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null`
    is returned instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetMethodMaximumAmount(BaseModel):
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null`
    is returned instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetMethodImageTypedDict(TypedDict):
    r"""URLs of images representing the payment method."""

    size1x: str
    r"""The URL pointing to an icon of 32 by 24 pixels."""
    size2x: str
    r"""The URL pointing to an icon of 64 by 48 pixels."""
    svg: str
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can
    scale to any desired size without compromising visual quality.
    """


class GetMethodImage(BaseModel):
    r"""URLs of images representing the payment method."""

    size1x: str
    r"""The URL pointing to an icon of 32 by 24 pixels."""

    size2x: str
    r"""The URL pointing to an icon of 64 by 48 pixels."""

    svg: str
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can
    scale to any desired size without compromising visual quality.
    """


class GetMethodStatus(str, Enum):
    r"""The payment method's activation status for this profile."""

    ACTIVATED = "activated"
    PENDING_BOARDING = "pending-boarding"
    PENDING_REVIEW = "pending-review"
    PENDING_EXTERNAL = "pending-external"
    REJECTED = "rejected"


class GetMethodIssuerImageTypedDict(TypedDict):
    r"""URLs of images representing the issuer.
    required:
    - size1x
    - size2x
    - svg
    """

    size1x: NotRequired[str]
    r"""The URL pointing to an icon of 32 by 24 pixels."""
    size2x: NotRequired[str]
    r"""The URL pointing to an icon of 64 by 48 pixels."""
    svg: NotRequired[str]
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can
    scale to any desired size without compromising visual quality.
    """


class GetMethodIssuerImage(BaseModel):
    r"""URLs of images representing the issuer.
    required:
    - size1x
    - size2x
    - svg
    """

    size1x: Optional[str] = None
    r"""The URL pointing to an icon of 32 by 24 pixels."""

    size2x: Optional[str] = None
    r"""The URL pointing to an icon of 64 by 48 pixels."""

    svg: Optional[str] = None
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can
    scale to any desired size without compromising visual quality.
    """


class GetMethodIssuerTypedDict(TypedDict):
    resource: str
    id: str
    name: str
    r"""The full name of the issuer."""
    image: GetMethodIssuerImageTypedDict
    r"""URLs of images representing the issuer.
    required:
    - size1x
    - size2x
    - svg
    """


class GetMethodIssuer(BaseModel):
    resource: str

    id: str

    name: str
    r"""The full name of the issuer."""

    image: GetMethodIssuerImage
    r"""URLs of images representing the issuer.
    required:
    - size1x
    - size2x
    - svg
    """


class GetMethodSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetMethodSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetMethodDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetMethodDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetMethodLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: GetMethodSelfTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[GetMethodDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetMethodLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[GetMethodSelf, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[GetMethodDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetMethodResponseTypedDict(TypedDict):
    r"""The payment method object."""

    resource: str
    r"""Indicates the response contains a payment method object. Will always contain the string `method` for this
    endpoint.
    """
    id: GetMethodID
    r"""The unique identifier of the payment method. When used during [payment creation](create-payment), the payment
    method selection screen will be skipped.
    """
    description: str
    r"""The full name of the payment method.

    If a `locale` parameter is provided, the name is translated to the given locale if possible.
    """
    minimum_amount: GetMethodMinimumAmountTypedDict
    r"""The minimum payment amount required to use this payment method."""
    maximum_amount: Nullable[GetMethodMaximumAmountTypedDict]
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null`
    is returned instead.
    """
    image: GetMethodImageTypedDict
    r"""URLs of images representing the payment method."""
    status: Nullable[GetMethodStatus]
    r"""The payment method's activation status for this profile."""
    links: GetMethodLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    issuers: NotRequired[List[GetMethodIssuerTypedDict]]
    r"""**Optional include.** Array of objects for each 'issuer' that is available for this payment method. Only relevant
    for iDEAL, KBC/CBC, gift cards, and vouchers.
    """


class GetMethodResponse(BaseModel):
    r"""The payment method object."""

    resource: str
    r"""Indicates the response contains a payment method object. Will always contain the string `method` for this
    endpoint.
    """

    id: GetMethodID
    r"""The unique identifier of the payment method. When used during [payment creation](create-payment), the payment
    method selection screen will be skipped.
    """

    description: str
    r"""The full name of the payment method.

    If a `locale` parameter is provided, the name is translated to the given locale if possible.
    """

    minimum_amount: Annotated[
        GetMethodMinimumAmount, pydantic.Field(alias="minimumAmount")
    ]
    r"""The minimum payment amount required to use this payment method."""

    maximum_amount: Annotated[
        Nullable[GetMethodMaximumAmount], pydantic.Field(alias="maximumAmount")
    ]
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null`
    is returned instead.
    """

    image: GetMethodImage
    r"""URLs of images representing the payment method."""

    status: Nullable[GetMethodStatus]
    r"""The payment method's activation status for this profile."""

    links: Annotated[GetMethodLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    issuers: Optional[List[GetMethodIssuer]] = None
    r"""**Optional include.** Array of objects for each 'issuer' that is available for this payment method. Only relevant
    for iDEAL, KBC/CBC, gift cards, and vouchers.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["issuers"]
        nullable_fields = ["maximumAmount", "status"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
