"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class GetWebhookEventRequestTypedDict(TypedDict):
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class GetWebhookEventRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["testmode"]
        nullable_fields = ["testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetWebhookEventNotFoundDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class GetWebhookEventNotFoundDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class GetWebhookEventNotFoundLinksTypedDict(TypedDict):
    documentation: GetWebhookEventNotFoundDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class GetWebhookEventNotFoundLinks(BaseModel):
    documentation: GetWebhookEventNotFoundDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class GetWebhookEventHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[GetWebhookEventNotFoundLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class GetWebhookEventHalJSONError(ClientError):
    r"""An error response object."""

    data: GetWebhookEventHalJSONErrorData

    def __init__(
        self,
        data: GetWebhookEventHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class GetWebhookEventMode2(str, Enum):
    r"""Whether this entity was created in live mode or in test mode."""

    LIVE = "live"
    TEST = "test"


class GetWebhookEventStatus(str, Enum):
    r"""The profile status determines whether the profile is able to receive live payments.

    * `unverified`: The profile has not been verified yet and can only be used to create test payments.
    * `verified`: The profile has been verified and can be used to create live payments and test payments.
    * `blocked`: The profile is blocked and can no longer be used or changed.
    """

    UNVERIFIED = "unverified"
    VERIFIED = "verified"
    BLOCKED = "blocked"


class GetWebhookEventReviewStatus(str, Enum):
    r"""The status of the requested changes."""

    PENDING = "pending"
    REJECTED = "rejected"


class GetWebhookEventReviewTypedDict(TypedDict):
    r"""Present if changes have been made that have not yet been approved by Mollie. Changes to test profiles are approved
    automatically, unless a switch to a live profile has been requested. The review object will therefore usually be
    `null` in test mode.
    """

    status: NotRequired[GetWebhookEventReviewStatus]
    r"""The status of the requested changes."""


class GetWebhookEventReview(BaseModel):
    r"""Present if changes have been made that have not yet been approved by Mollie. Changes to test profiles are approved
    automatically, unless a switch to a live profile has been requested. The review object will therefore usually be
    `null` in test mode.
    """

    status: Optional[GetWebhookEventReviewStatus] = None
    r"""The status of the requested changes."""


class EntitySelf2TypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class EntitySelf2(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetWebhookEventDashboardTypedDict(TypedDict):
    r"""Link to the profile in the Mollie dashboard."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetWebhookEventDashboard(BaseModel):
    r"""Link to the profile in the Mollie dashboard."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetWebhookEventChargebacksTypedDict(TypedDict):
    r"""The API resource URL of the chargebacks that belong to this profile."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetWebhookEventChargebacks(BaseModel):
    r"""The API resource URL of the chargebacks that belong to this profile."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetWebhookEventMethodsTypedDict(TypedDict):
    r"""The API resource URL of the methods that are enabled for this profile."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetWebhookEventMethods(BaseModel):
    r"""The API resource URL of the methods that are enabled for this profile."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetWebhookEventPaymentsTypedDict(TypedDict):
    r"""The API resource URL of the payments that belong to this profile."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetWebhookEventPayments(BaseModel):
    r"""The API resource URL of the payments that belong to this profile."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetWebhookEventRefundsTypedDict(TypedDict):
    r"""The API resource URL of the refunds that belong to this profile."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetWebhookEventRefunds(BaseModel):
    r"""The API resource URL of the refunds that belong to this profile."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetWebhookEventCheckoutPreviewURLTypedDict(TypedDict):
    r"""The hosted checkout preview URL. You need to be logged in to access this page."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetWebhookEventCheckoutPreviewURL(BaseModel):
    r"""The hosted checkout preview URL. You need to be logged in to access this page."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class EntityDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class EntityDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class EntityLinks2TypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[EntitySelf2TypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    dashboard: NotRequired[GetWebhookEventDashboardTypedDict]
    r"""Link to the profile in the Mollie dashboard."""
    chargebacks: NotRequired[GetWebhookEventChargebacksTypedDict]
    r"""The API resource URL of the chargebacks that belong to this profile."""
    methods: NotRequired[GetWebhookEventMethodsTypedDict]
    r"""The API resource URL of the methods that are enabled for this profile."""
    payments: NotRequired[GetWebhookEventPaymentsTypedDict]
    r"""The API resource URL of the payments that belong to this profile."""
    refunds: NotRequired[GetWebhookEventRefundsTypedDict]
    r"""The API resource URL of the refunds that belong to this profile."""
    checkout_preview_url: NotRequired[GetWebhookEventCheckoutPreviewURLTypedDict]
    r"""The hosted checkout preview URL. You need to be logged in to access this page."""
    documentation: NotRequired[EntityDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityLinks2(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[EntitySelf2], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    dashboard: Optional[GetWebhookEventDashboard] = None
    r"""Link to the profile in the Mollie dashboard."""

    chargebacks: Optional[GetWebhookEventChargebacks] = None
    r"""The API resource URL of the chargebacks that belong to this profile."""

    methods: Optional[GetWebhookEventMethods] = None
    r"""The API resource URL of the methods that are enabled for this profile."""

    payments: Optional[GetWebhookEventPayments] = None
    r"""The API resource URL of the payments that belong to this profile."""

    refunds: Optional[GetWebhookEventRefunds] = None
    r"""The API resource URL of the refunds that belong to this profile."""

    checkout_preview_url: Annotated[
        Optional[GetWebhookEventCheckoutPreviewURL],
        pydantic.Field(alias="checkoutPreviewUrl"),
    ] = None
    r"""The hosted checkout preview URL. You need to be logged in to access this page."""

    documentation: Optional[EntityDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetWebhookEventProfileTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains a profile object. Will always contain the string `profile` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this profile. Example: `pfl_v9hTwCvYqw`."""
    mode: NotRequired[GetWebhookEventMode2]
    r"""Whether this entity was created in live mode or in test mode."""
    name: NotRequired[str]
    r"""The profile's name, this will usually reflect the trade name or brand name of the profile's website or
    application.
    """
    website: NotRequired[str]
    r"""The URL to the profile's website or application. Only `https` or `http` URLs are allowed. No `@` signs are
    allowed.
    """
    email: NotRequired[str]
    r"""The email address associated with the profile's trade name or brand."""
    phone: NotRequired[str]
    r"""The phone number associated with the profile's trade name or brand."""
    description: NotRequired[str]
    r"""The products or services offered by the profile's website or application."""
    countries_of_activity: NotRequired[List[str]]
    r"""A list of countries where you expect that the majority of the profile's customers reside,
    in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.
    """
    business_category: NotRequired[str]
    r"""The industry associated with the profile's trade name or brand. Please refer to the
    [business category list](common-data-types#business-category) for all possible options.
    """
    status: NotRequired[GetWebhookEventStatus]
    r"""The profile status determines whether the profile is able to receive live payments.

    * `unverified`: The profile has not been verified yet and can only be used to create test payments.
    * `verified`: The profile has been verified and can be used to create live payments and test payments.
    * `blocked`: The profile is blocked and can no longer be used or changed.
    """
    review: NotRequired[GetWebhookEventReviewTypedDict]
    r"""Present if changes have been made that have not yet been approved by Mollie. Changes to test profiles are approved
    automatically, unless a switch to a live profile has been requested. The review object will therefore usually be
    `null` in test mode.
    """
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: NotRequired[EntityLinks2TypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetWebhookEventProfile(BaseModel):
    resource: Optional[str] = None
    r"""Indicates the response contains a profile object. Will always contain the string `profile` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this profile. Example: `pfl_v9hTwCvYqw`."""

    mode: Optional[GetWebhookEventMode2] = None
    r"""Whether this entity was created in live mode or in test mode."""

    name: Optional[str] = None
    r"""The profile's name, this will usually reflect the trade name or brand name of the profile's website or
    application.
    """

    website: Optional[str] = None
    r"""The URL to the profile's website or application. Only `https` or `http` URLs are allowed. No `@` signs are
    allowed.
    """

    email: Optional[str] = None
    r"""The email address associated with the profile's trade name or brand."""

    phone: Optional[str] = None
    r"""The phone number associated with the profile's trade name or brand."""

    description: Optional[str] = None
    r"""The products or services offered by the profile's website or application."""

    countries_of_activity: Annotated[
        Optional[List[str]], pydantic.Field(alias="countriesOfActivity")
    ] = None
    r"""A list of countries where you expect that the majority of the profile's customers reside,
    in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.
    """

    business_category: Annotated[
        Optional[str], pydantic.Field(alias="businessCategory")
    ] = None
    r"""The industry associated with the profile's trade name or brand. Please refer to the
    [business category list](common-data-types#business-category) for all possible options.
    """

    status: Optional[GetWebhookEventStatus] = None
    r"""The profile status determines whether the profile is able to receive live payments.

    * `unverified`: The profile has not been verified yet and can only be used to create test payments.
    * `verified`: The profile has been verified and can be used to create live payments and test payments.
    * `blocked`: The profile is blocked and can no longer be used or changed.
    """

    review: Optional[GetWebhookEventReview] = None
    r"""Present if changes have been made that have not yet been approved by Mollie. Changes to test profiles are approved
    automatically, unless a switch to a live profile has been requested. The review object will therefore usually be
    `null` in test mode.
    """

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[Optional[EntityLinks2], pydantic.Field(alias="_links")] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetWebhookEventMode1(str, Enum):
    r"""Whether this entity was created in live mode or in test mode."""

    LIVE = "live"
    TEST = "test"


class GetWebhookEventAmountTypedDict(TypedDict):
    r"""The amount of the payment link. If no amount is provided initially, the customer will be prompted to enter an
    amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetWebhookEventAmount(BaseModel):
    r"""The amount of the payment link. If no amount is provided initially, the customer will be prompted to enter an
    amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetWebhookEventMinimumAmountTypedDict(TypedDict):
    r"""The minimum amount of the payment link. This property is only allowed when there is no amount provided. The
    customer will be prompted to enter a value greater than or equal to the minimum amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetWebhookEventMinimumAmount(BaseModel):
    r"""The minimum amount of the payment link. This property is only allowed when there is no amount provided. The
    customer will be prompted to enter a value greater than or equal to the minimum amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetWebhookEventType(str, Enum):
    r"""The type of product purchased. For example, a physical or a digital product.

    The `tip` payment line type is not available when creating a payment.
    """

    PHYSICAL = "physical"
    DIGITAL = "digital"
    SHIPPING_FEE = "shipping_fee"
    DISCOUNT = "discount"
    STORE_CREDIT = "store_credit"
    GIFT_CARD = "gift_card"
    SURCHARGE = "surcharge"
    TIP = "tip"


class GetWebhookEventUnitPriceTypedDict(TypedDict):
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetWebhookEventUnitPrice(BaseModel):
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetWebhookEventDiscountAmountTypedDict(TypedDict):
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount
    type.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetWebhookEventDiscountAmount(BaseModel):
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount
    type.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetWebhookEventTotalAmountTypedDict(TypedDict):
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetWebhookEventTotalAmount(BaseModel):
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetWebhookEventVatAmountTypedDict(TypedDict):
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be
    calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of
    `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetWebhookEventVatAmount(BaseModel):
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be
    calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of
    `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetWebhookEventCategory(str, Enum):
    MEAL = "meal"
    ECO = "eco"
    GIFT = "gift"
    SPORT_CULTURE = "sport_culture"


class GetWebhookEventLineTypedDict(TypedDict):
    description: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""
    quantity: int
    r"""The number of items."""
    unit_price: GetWebhookEventUnitPriceTypedDict
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """
    total_amount: GetWebhookEventTotalAmountTypedDict
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """
    type: NotRequired[GetWebhookEventType]
    r"""The type of product purchased. For example, a physical or a digital product.

    The `tip` payment line type is not available when creating a payment.
    """
    quantity_unit: NotRequired[str]
    r"""The unit for the quantity. For example *pcs*, *kg*, or *cm*."""
    discount_amount: NotRequired[GetWebhookEventDiscountAmountTypedDict]
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount
    type.
    """
    vat_rate: NotRequired[str]
    r"""The VAT rate applied to the line, for example `21.00` for 21%. The vatRate should be passed as a string and
    not as a float, to ensure the correct number of decimals are passed.
    """
    vat_amount: NotRequired[GetWebhookEventVatAmountTypedDict]
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be
    calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of
    `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """
    sku: NotRequired[str]
    r"""The SKU, EAN, ISBN or UPC of the product sold."""
    categories: NotRequired[List[GetWebhookEventCategory]]
    r"""An array with the voucher categories, in case of a line eligible for a voucher. See the
    [Integrating Vouchers](integrating-vouchers) guide for more information.
    """
    image_url: NotRequired[str]
    r"""A link pointing to an image of the product sold."""
    product_url: NotRequired[str]
    r"""A link pointing to the product page in your web shop of the product sold."""


class GetWebhookEventLine(BaseModel):
    description: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""

    quantity: int
    r"""The number of items."""

    unit_price: Annotated[GetWebhookEventUnitPrice, pydantic.Field(alias="unitPrice")]
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """

    total_amount: Annotated[
        GetWebhookEventTotalAmount, pydantic.Field(alias="totalAmount")
    ]
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """

    type: Optional[GetWebhookEventType] = None
    r"""The type of product purchased. For example, a physical or a digital product.

    The `tip` payment line type is not available when creating a payment.
    """

    quantity_unit: Annotated[Optional[str], pydantic.Field(alias="quantityUnit")] = None
    r"""The unit for the quantity. For example *pcs*, *kg*, or *cm*."""

    discount_amount: Annotated[
        Optional[GetWebhookEventDiscountAmount], pydantic.Field(alias="discountAmount")
    ] = None
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount
    type.
    """

    vat_rate: Annotated[Optional[str], pydantic.Field(alias="vatRate")] = None
    r"""The VAT rate applied to the line, for example `21.00` for 21%. The vatRate should be passed as a string and
    not as a float, to ensure the correct number of decimals are passed.
    """

    vat_amount: Annotated[
        Optional[GetWebhookEventVatAmount], pydantic.Field(alias="vatAmount")
    ] = None
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be
    calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of
    `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """

    sku: Optional[str] = None
    r"""The SKU, EAN, ISBN or UPC of the product sold."""

    categories: Optional[List[GetWebhookEventCategory]] = None
    r"""An array with the voucher categories, in case of a line eligible for a voucher. See the
    [Integrating Vouchers](integrating-vouchers) guide for more information.
    """

    image_url: Annotated[Optional[str], pydantic.Field(alias="imageUrl")] = None
    r"""A link pointing to an image of the product sold."""

    product_url: Annotated[Optional[str], pydantic.Field(alias="productUrl")] = None
    r"""A link pointing to the product page in your web shop of the product sold."""


class GetWebhookEventBillingAddressTypedDict(TypedDict):
    r"""The customer's billing address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.

    Required for payment method `in3`, `klarna`, `billie` and `riverty`.
    """

    title: NotRequired[str]
    r"""The title of the person, for example *Mr.* or *Mrs.*."""
    given_name: NotRequired[str]
    r"""The given name (first name) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    family_name: NotRequired[str]
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    organization_name: NotRequired[str]
    r"""The name of the organization, in case the addressee is an organization."""
    street_and_number: NotRequired[str]
    r"""A street and street number.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    street_additional: NotRequired[str]
    r"""Any additional addressing details, for example an apartment number."""
    postal_code: NotRequired[str]
    r"""A postal code. This field may be required if the provided country has a postal code system.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    email: NotRequired[str]
    r"""A valid e-mail address.

    If you provide the email address for a `banktransfer` payment, we will automatically send the instructions
    email upon payment creation. The language of the email will follow the locale parameter of the payment.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    phone: NotRequired[str]
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""
    city: NotRequired[str]
    r"""A city name.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    region: NotRequired[str]
    r"""The top-level administrative subdivision of the country. For example: Noord-Holland."""
    country: NotRequired[str]
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """


class GetWebhookEventBillingAddress(BaseModel):
    r"""The customer's billing address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.

    Required for payment method `in3`, `klarna`, `billie` and `riverty`.
    """

    title: Optional[str] = None
    r"""The title of the person, for example *Mr.* or *Mrs.*."""

    given_name: Annotated[Optional[str], pydantic.Field(alias="givenName")] = None
    r"""The given name (first name) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    family_name: Annotated[Optional[str], pydantic.Field(alias="familyName")] = None
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    organization_name: Annotated[
        Optional[str], pydantic.Field(alias="organizationName")
    ] = None
    r"""The name of the organization, in case the addressee is an organization."""

    street_and_number: Annotated[
        Optional[str], pydantic.Field(alias="streetAndNumber")
    ] = None
    r"""A street and street number.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    street_additional: Annotated[
        Optional[str], pydantic.Field(alias="streetAdditional")
    ] = None
    r"""Any additional addressing details, for example an apartment number."""

    postal_code: Annotated[Optional[str], pydantic.Field(alias="postalCode")] = None
    r"""A postal code. This field may be required if the provided country has a postal code system.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    email: Optional[str] = None
    r"""A valid e-mail address.

    If you provide the email address for a `banktransfer` payment, we will automatically send the instructions
    email upon payment creation. The language of the email will follow the locale parameter of the payment.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    phone: Optional[str] = None
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""

    city: Optional[str] = None
    r"""A city name.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    region: Optional[str] = None
    r"""The top-level administrative subdivision of the country. For example: Noord-Holland."""

    country: Optional[str] = None
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """


class GetWebhookEventShippingAddressTypedDict(TypedDict):
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.
    """

    title: NotRequired[str]
    r"""The title of the person, for example *Mr.* or *Mrs.*."""
    given_name: NotRequired[str]
    r"""The given name (first name) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    family_name: NotRequired[str]
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    organization_name: NotRequired[str]
    r"""The name of the organization, in case the addressee is an organization."""
    street_and_number: NotRequired[str]
    r"""A street and street number.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    street_additional: NotRequired[str]
    r"""Any additional addressing details, for example an apartment number."""
    postal_code: NotRequired[str]
    r"""A postal code. This field may be required if the provided country has a postal code system.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    email: NotRequired[str]
    r"""A valid e-mail address.

    If you provide the email address for a `banktransfer` payment, we will automatically send the instructions
    email upon payment creation. The language of the email will follow the locale parameter of the payment.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    phone: NotRequired[str]
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""
    city: NotRequired[str]
    r"""A city name.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    region: NotRequired[str]
    r"""The top-level administrative subdivision of the country. For example: Noord-Holland."""
    country: NotRequired[str]
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """


class GetWebhookEventShippingAddress(BaseModel):
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.
    """

    title: Optional[str] = None
    r"""The title of the person, for example *Mr.* or *Mrs.*."""

    given_name: Annotated[Optional[str], pydantic.Field(alias="givenName")] = None
    r"""The given name (first name) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    family_name: Annotated[Optional[str], pydantic.Field(alias="familyName")] = None
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    organization_name: Annotated[
        Optional[str], pydantic.Field(alias="organizationName")
    ] = None
    r"""The name of the organization, in case the addressee is an organization."""

    street_and_number: Annotated[
        Optional[str], pydantic.Field(alias="streetAndNumber")
    ] = None
    r"""A street and street number.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    street_additional: Annotated[
        Optional[str], pydantic.Field(alias="streetAdditional")
    ] = None
    r"""Any additional addressing details, for example an apartment number."""

    postal_code: Annotated[Optional[str], pydantic.Field(alias="postalCode")] = None
    r"""A postal code. This field may be required if the provided country has a postal code system.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    email: Optional[str] = None
    r"""A valid e-mail address.

    If you provide the email address for a `banktransfer` payment, we will automatically send the instructions
    email upon payment creation. The language of the email will follow the locale parameter of the payment.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    phone: Optional[str] = None
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""

    city: Optional[str] = None
    r"""A city name.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    region: Optional[str] = None
    r"""The top-level administrative subdivision of the country. For example: Noord-Holland."""

    country: Optional[str] = None
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """


class GetWebhookEventApplicationFeeAmountTypedDict(TypedDict):
    r"""The fee that you wish to charge.

    Be careful to leave enough space for Mollie's own fees to be deducted as well. For example, you cannot charge
    a €0.99 fee on a €1.00 payment.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetWebhookEventApplicationFeeAmount(BaseModel):
    r"""The fee that you wish to charge.

    Be careful to leave enough space for Mollie's own fees to be deducted as well. For example, you cannot charge
    a €0.99 fee on a €1.00 payment.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetWebhookEventApplicationFeeTypedDict(TypedDict):
    r"""With Mollie Connect you can charge fees on payment links that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payment links on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If a payment on the payment link succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.
    """

    amount: GetWebhookEventApplicationFeeAmountTypedDict
    r"""The fee that you wish to charge.

    Be careful to leave enough space for Mollie's own fees to be deducted as well. For example, you cannot charge
    a €0.99 fee on a €1.00 payment.
    """
    description: str
    r"""The description of the application fee. This will appear on settlement reports towards both you and the
    connected merchant.
    """


class GetWebhookEventApplicationFee(BaseModel):
    r"""With Mollie Connect you can charge fees on payment links that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payment links on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If a payment on the payment link succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.
    """

    amount: GetWebhookEventApplicationFeeAmount
    r"""The fee that you wish to charge.

    Be careful to leave enough space for Mollie's own fees to be deducted as well. For example, you cannot charge
    a €0.99 fee on a €1.00 payment.
    """

    description: str
    r"""The description of the application fee. This will appear on settlement reports towards both you and the
    connected merchant.
    """


class GetWebhookEventSequenceType(str, Enum):
    r"""If set to `first`, a payment mandate is established right after a payment is made by the customer.

    Defaults to `oneoff`, which is a regular payment link and will not establish a mandate after payment.

    The mandate ID can be retrieved by making a call to the
    [Payment Link Payments Endpoint](get-payment-link-payments).
    """

    ONEOFF = "oneoff"
    FIRST = "first"


class EntitySelf1TypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class EntitySelf1(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetWebhookEventLinksPaymentLinkTypedDict(TypedDict):
    r"""The URL your customer should visit to make the payment. This is where you should redirect the customer to."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetWebhookEventLinksPaymentLink(BaseModel):
    r"""The URL your customer should visit to make the payment. This is where you should redirect the customer to."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class EntityLinks1TypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: EntitySelf1TypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payment_link: GetWebhookEventLinksPaymentLinkTypedDict
    r"""The URL your customer should visit to make the payment. This is where you should redirect the customer to."""


class EntityLinks1(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[EntitySelf1, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payment_link: Annotated[
        GetWebhookEventLinksPaymentLink, pydantic.Field(alias="paymentLink")
    ]
    r"""The URL your customer should visit to make the payment. This is where you should redirect the customer to."""


class GetWebhookEventPaymentLinkOutputTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a payment link object. Will always contain the string `payment-link` for this
    endpoint.
    """
    id: str
    r"""The identifier uniquely referring to this payment link. Example: `pl_4Y0eZitmBnQ6IDoMqZQKh`."""
    mode: GetWebhookEventMode1
    r"""Whether this entity was created in live mode or in test mode."""
    description: str
    r"""A short description of the payment link. The description is visible in the Dashboard and will be shown on the
    customer's bank or card statement when possible.
    """
    amount: Nullable[GetWebhookEventAmountTypedDict]
    r"""The amount of the payment link. If no amount is provided initially, the customer will be prompted to enter an
    amount.
    """
    archived: bool
    r"""Whether the payment link is archived. Customers will not be able to complete payments on archived payment links."""
    redirect_url: Nullable[str]
    r"""The URL your customer will be redirected to after completing the payment process. If no redirect URL is provided,
    the customer will be shown a generic message after completing the payment.
    """
    webhook_url: Nullable[str]
    r"""The webhook URL where we will send payment status updates to.

    The webhookUrl is optional, but without a webhook you will miss out on important status changes to any payments
    resulting from the payment link.

    The webhookUrl must be reachable from Mollie's point of view, so you cannot use `localhost`. If you want to use
    webhook during development on `localhost`, you must use a tool like ngrok to have the webhooks delivered to your
    local machine.
    """
    profile_id: Nullable[str]
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation
    request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is
    required.
    """
    reusable: Nullable[bool]
    r"""Indicates whether the payment link is reusable. If this field is set to `true`, customers can make multiple
    payments using the same link.

    If no value is specified, the field defaults to `false`, allowing only a single payment per link.
    """
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    paid_at: Nullable[str]
    r"""The date and time the payment link became paid, in ISO 8601 format."""
    expires_at: Nullable[str]
    r"""The date and time the payment link is set to expire, in ISO 8601 format. If no expiry date was provided up front,
    the payment link will not expire automatically.
    """
    allowed_methods: Nullable[List[str]]
    r"""An array of payment methods that are allowed to be used for this payment link. When this parameter is
    not provided or is an empty array, all enabled payment methods will be available.

    Enum: 'applepay', 'bancomatpay', 'bancontact', 'banktransfer', 'belfius', 'blik', 'creditcard', 'eps', 'giftcard',
    'ideal', 'kbc', 'mybank', 'paybybank', 'paypal', 'paysafecard', 'pointofsale', 'przelewy24', 'satispay', 'trustly', 'twint',
    'in3', 'riverty', 'klarna', 'billie'.
    """
    links: EntityLinks1TypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    minimum_amount: NotRequired[Nullable[GetWebhookEventMinimumAmountTypedDict]]
    r"""The minimum amount of the payment link. This property is only allowed when there is no amount provided. The
    customer will be prompted to enter a value greater than or equal to the minimum amount.
    """
    lines: NotRequired[Nullable[List[GetWebhookEventLineTypedDict]]]
    r"""Optionally provide the order lines for the payment. Each line contains details such as a description of the item
    ordered and its price.

    All lines must have the same currency as the payment.

    Required for payment methods `billie`, `in3`, `klarna`, `riverty` and `voucher`.
    """
    billing_address: NotRequired[GetWebhookEventBillingAddressTypedDict]
    r"""The customer's billing address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.

    Required for payment method `in3`, `klarna`, `billie` and `riverty`.
    """
    shipping_address: NotRequired[GetWebhookEventShippingAddressTypedDict]
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.
    """
    application_fee: NotRequired[GetWebhookEventApplicationFeeTypedDict]
    r"""With Mollie Connect you can charge fees on payment links that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payment links on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If a payment on the payment link succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.
    """
    sequence_type: NotRequired[Nullable[GetWebhookEventSequenceType]]
    r"""If set to `first`, a payment mandate is established right after a payment is made by the customer.

    Defaults to `oneoff`, which is a regular payment link and will not establish a mandate after payment.

    The mandate ID can be retrieved by making a call to the
    [Payment Link Payments Endpoint](get-payment-link-payments).
    """
    customer_id: NotRequired[Nullable[str]]
    r"""**Only relevant when `sequenceType` is set to `first`**

    The ID of the [customer](get-customer) the payment link is being created for. If a value is not provided,
    the customer will be required to input relevant information which will be used to establish a mandate after
    the payment is made.
    """


class GetWebhookEventPaymentLinkOutput(BaseModel):
    resource: str
    r"""Indicates the response contains a payment link object. Will always contain the string `payment-link` for this
    endpoint.
    """

    id: str
    r"""The identifier uniquely referring to this payment link. Example: `pl_4Y0eZitmBnQ6IDoMqZQKh`."""

    mode: GetWebhookEventMode1
    r"""Whether this entity was created in live mode or in test mode."""

    description: str
    r"""A short description of the payment link. The description is visible in the Dashboard and will be shown on the
    customer's bank or card statement when possible.
    """

    amount: Nullable[GetWebhookEventAmount]
    r"""The amount of the payment link. If no amount is provided initially, the customer will be prompted to enter an
    amount.
    """

    archived: bool
    r"""Whether the payment link is archived. Customers will not be able to complete payments on archived payment links."""

    redirect_url: Annotated[Nullable[str], pydantic.Field(alias="redirectUrl")]
    r"""The URL your customer will be redirected to after completing the payment process. If no redirect URL is provided,
    the customer will be shown a generic message after completing the payment.
    """

    webhook_url: Annotated[Nullable[str], pydantic.Field(alias="webhookUrl")]
    r"""The webhook URL where we will send payment status updates to.

    The webhookUrl is optional, but without a webhook you will miss out on important status changes to any payments
    resulting from the payment link.

    The webhookUrl must be reachable from Mollie's point of view, so you cannot use `localhost`. If you want to use
    webhook during development on `localhost`, you must use a tool like ngrok to have the webhooks delivered to your
    local machine.
    """

    profile_id: Annotated[Nullable[str], pydantic.Field(alias="profileId")]
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation
    request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is
    required.
    """

    reusable: Nullable[bool]
    r"""Indicates whether the payment link is reusable. If this field is set to `true`, customers can make multiple
    payments using the same link.

    If no value is specified, the field defaults to `false`, allowing only a single payment per link.
    """

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    paid_at: Annotated[Nullable[str], pydantic.Field(alias="paidAt")]
    r"""The date and time the payment link became paid, in ISO 8601 format."""

    expires_at: Annotated[Nullable[str], pydantic.Field(alias="expiresAt")]
    r"""The date and time the payment link is set to expire, in ISO 8601 format. If no expiry date was provided up front,
    the payment link will not expire automatically.
    """

    allowed_methods: Annotated[
        Nullable[List[str]], pydantic.Field(alias="allowedMethods")
    ]
    r"""An array of payment methods that are allowed to be used for this payment link. When this parameter is
    not provided or is an empty array, all enabled payment methods will be available.

    Enum: 'applepay', 'bancomatpay', 'bancontact', 'banktransfer', 'belfius', 'blik', 'creditcard', 'eps', 'giftcard',
    'ideal', 'kbc', 'mybank', 'paybybank', 'paypal', 'paysafecard', 'pointofsale', 'przelewy24', 'satispay', 'trustly', 'twint',
    'in3', 'riverty', 'klarna', 'billie'.
    """

    links: Annotated[EntityLinks1, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    minimum_amount: Annotated[
        OptionalNullable[GetWebhookEventMinimumAmount],
        pydantic.Field(alias="minimumAmount"),
    ] = UNSET
    r"""The minimum amount of the payment link. This property is only allowed when there is no amount provided. The
    customer will be prompted to enter a value greater than or equal to the minimum amount.
    """

    lines: OptionalNullable[List[GetWebhookEventLine]] = UNSET
    r"""Optionally provide the order lines for the payment. Each line contains details such as a description of the item
    ordered and its price.

    All lines must have the same currency as the payment.

    Required for payment methods `billie`, `in3`, `klarna`, `riverty` and `voucher`.
    """

    billing_address: Annotated[
        Optional[GetWebhookEventBillingAddress], pydantic.Field(alias="billingAddress")
    ] = None
    r"""The customer's billing address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.

    Required for payment method `in3`, `klarna`, `billie` and `riverty`.
    """

    shipping_address: Annotated[
        Optional[GetWebhookEventShippingAddress],
        pydantic.Field(alias="shippingAddress"),
    ] = None
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.
    """

    application_fee: Annotated[
        Optional[GetWebhookEventApplicationFee], pydantic.Field(alias="applicationFee")
    ] = None
    r"""With Mollie Connect you can charge fees on payment links that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payment links on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If a payment on the payment link succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.
    """

    sequence_type: Annotated[
        OptionalNullable[GetWebhookEventSequenceType],
        pydantic.Field(alias="sequenceType"),
    ] = UNSET
    r"""If set to `first`, a payment mandate is established right after a payment is made by the customer.

    Defaults to `oneoff`, which is a regular payment link and will not establish a mandate after payment.

    The mandate ID can be retrieved by making a call to the
    [Payment Link Payments Endpoint](get-payment-link-payments).
    """

    customer_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="customerId")
    ] = UNSET
    r"""**Only relevant when `sequenceType` is set to `first`**

    The ID of the [customer](get-customer) the payment link is being created for. If a value is not provided,
    the customer will be required to input relevant information which will be used to establish a mandate after
    the payment is made.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "minimumAmount",
            "lines",
            "billingAddress",
            "shippingAddress",
            "applicationFee",
            "sequenceType",
            "customerId",
        ]
        nullable_fields = [
            "amount",
            "minimumAmount",
            "redirectUrl",
            "webhookUrl",
            "lines",
            "profileId",
            "reusable",
            "paidAt",
            "expiresAt",
            "allowedMethods",
            "sequenceType",
            "customerId",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


EntityTypedDict = TypeAliasType(
    "EntityTypedDict",
    Union[GetWebhookEventProfileTypedDict, GetWebhookEventPaymentLinkOutputTypedDict],
)


Entity = TypeAliasType(
    "Entity", Union[GetWebhookEventProfile, GetWebhookEventPaymentLinkOutput]
)


class GetWebhookEventEmbeddedTypedDict(TypedDict):
    r"""Full payload of the event."""

    entity: NotRequired[EntityTypedDict]


class GetWebhookEventEmbedded(BaseModel):
    r"""Full payload of the event."""

    entity: Optional[Entity] = None


class GetWebhookEventSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetWebhookEventSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetWebhookEventDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetWebhookEventDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class LinksEntityTypedDict(TypedDict):
    r"""The API resource URL of the entity that this event belongs to."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class LinksEntity(BaseModel):
    r"""The API resource URL of the entity that this event belongs to."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetWebhookEventLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetWebhookEventSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[GetWebhookEventDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    entity: NotRequired[LinksEntityTypedDict]
    r"""The API resource URL of the entity that this event belongs to."""


class GetWebhookEventLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[GetWebhookEventSelf], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[GetWebhookEventDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    entity: Optional[LinksEntity] = None
    r"""The API resource URL of the entity that this event belongs to."""


class GetWebhookEventResponseTypedDict(TypedDict):
    r"""The webhook event object."""

    resource: NotRequired[str]
    r"""Indicates the response contains a webhook event object. Will always contain the string `event` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this event."""
    type: NotRequired[str]
    r"""The event's type."""
    entity_id: NotRequired[str]
    r"""The entity token that triggered the event"""
    created_at: NotRequired[str]
    r"""The event's date time of creation."""
    embedded: NotRequired[Nullable[GetWebhookEventEmbeddedTypedDict]]
    r"""Full payload of the event."""
    links: NotRequired[GetWebhookEventLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetWebhookEventResponse(BaseModel):
    r"""The webhook event object."""

    resource: Optional[str] = None
    r"""Indicates the response contains a webhook event object. Will always contain the string `event` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this event."""

    type: Optional[str] = None
    r"""The event's type."""

    entity_id: Annotated[Optional[str], pydantic.Field(alias="entityId")] = None
    r"""The entity token that triggered the event"""

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The event's date time of creation."""

    embedded: Annotated[
        OptionalNullable[GetWebhookEventEmbedded], pydantic.Field(alias="_embedded")
    ] = UNSET
    r"""Full payload of the event."""

    links: Annotated[Optional[GetWebhookEventLinks], pydantic.Field(alias="_links")] = (
        None
    )
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "type",
            "entityId",
            "createdAt",
            "_embedded",
            "_links",
        ]
        nullable_fields = ["_embedded"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
