"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListSettlementChargebacksEmbed(str, Enum):
    r"""This endpoint allows you to embed additional information via the `embed` query string parameter."""

    PAYMENT = "payment"


class ListSettlementChargebacksRequestTypedDict(TypedDict):
    settlement_id: str
    r"""Provide the ID of the related settlement."""
    from_: NotRequired[str]
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """
    limit: NotRequired[Nullable[int]]
    r"""The maximum number of items to return. Defaults to 50 items."""
    embed: NotRequired[ListSettlementChargebacksEmbed]
    r"""This endpoint allows you to embed additional information via the `embed` query string parameter."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class ListSettlementChargebacksRequest(BaseModel):
    settlement_id: Annotated[
        str,
        pydantic.Field(alias="settlementId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related settlement."""

    from_: Annotated[
        Optional[str],
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """

    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The maximum number of items to return. Defaults to 50 items."""

    embed: Annotated[
        Optional[ListSettlementChargebacksEmbed],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""This endpoint allows you to embed additional information via the `embed` query string parameter."""

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["from", "limit", "embed", "testmode"]
        nullable_fields = ["limit", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListSettlementChargebacksNotFoundDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListSettlementChargebacksNotFoundDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListSettlementChargebacksNotFoundLinksTypedDict(TypedDict):
    documentation: ListSettlementChargebacksNotFoundDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListSettlementChargebacksNotFoundLinks(BaseModel):
    documentation: ListSettlementChargebacksNotFoundDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListSettlementChargebacksNotFoundHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[
        ListSettlementChargebacksNotFoundLinks, pydantic.Field(alias="_links")
    ]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class ListSettlementChargebacksNotFoundHalJSONError(ClientError):
    r"""An error response object."""

    data: ListSettlementChargebacksNotFoundHalJSONErrorData

    def __init__(
        self,
        data: ListSettlementChargebacksNotFoundHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class ListSettlementChargebacksBadRequestDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListSettlementChargebacksBadRequestDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListSettlementChargebacksBadRequestLinksTypedDict(TypedDict):
    documentation: ListSettlementChargebacksBadRequestDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListSettlementChargebacksBadRequestLinks(BaseModel):
    documentation: ListSettlementChargebacksBadRequestDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListSettlementChargebacksBadRequestHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[
        ListSettlementChargebacksBadRequestLinks, pydantic.Field(alias="_links")
    ]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class ListSettlementChargebacksBadRequestHalJSONError(ClientError):
    r"""An error response object."""

    data: ListSettlementChargebacksBadRequestHalJSONErrorData

    def __init__(
        self,
        data: ListSettlementChargebacksBadRequestHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class ListSettlementChargebacksAmountTypedDict(TypedDict):
    r"""The amount charged back by the customer."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListSettlementChargebacksAmount(BaseModel):
    r"""The amount charged back by the customer."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListSettlementChargebacksSettlementAmountTypedDict(TypedDict):
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted
    to the currency your account is settled in.

    The amount is a **negative** amount.

    Since the field contains an estimated amount during chargeback processing, it may change over time. To retrieve
    accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions)
    instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListSettlementChargebacksSettlementAmount(BaseModel):
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted
    to the currency your account is settled in.

    The amount is a **negative** amount.

    Since the field contains an estimated amount during chargeback processing, it may change over time. To retrieve
    accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions)
    instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListSettlementChargebacksReasonTypedDict(TypedDict):
    r"""Reason for the chargeback as given by the bank. Only available for chargebacks of SEPA Direct Debit payments."""

    code: str
    r"""Technical code provided by the bank."""
    description: str
    r"""A more detailed human-friendly description."""


class ListSettlementChargebacksReason(BaseModel):
    r"""Reason for the chargeback as given by the bank. Only available for chargebacks of SEPA Direct Debit payments."""

    code: str
    r"""Technical code provided by the bank."""

    description: str
    r"""A more detailed human-friendly description."""


class ListSettlementChargebacksChargebackSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementChargebacksChargebackSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementChargebacksPaymentTypedDict(TypedDict):
    r"""The API resource URL of the [payment](get-payment) that this chargeback belongs to."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementChargebacksPayment(BaseModel):
    r"""The API resource URL of the [payment](get-payment) that this chargeback belongs to."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementChargebacksSettlementTypedDict(TypedDict):
    r"""The API resource URL of the [settlement](get-settlement) this chargeback has been settled with. Not present if
    not yet settled.
    """

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementChargebacksSettlement(BaseModel):
    r"""The API resource URL of the [settlement](get-settlement) this chargeback has been settled with. Not present if
    not yet settled.
    """

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementChargebacksChargebackDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementChargebacksChargebackDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementChargebacksChargebackLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: ListSettlementChargebacksChargebackSelfTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payment: ListSettlementChargebacksPaymentTypedDict
    r"""The API resource URL of the [payment](get-payment) that this chargeback belongs to."""
    documentation: ListSettlementChargebacksChargebackDocumentationTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    settlement: NotRequired[Nullable[ListSettlementChargebacksSettlementTypedDict]]
    r"""The API resource URL of the [settlement](get-settlement) this chargeback has been settled with. Not present if
    not yet settled.
    """


class ListSettlementChargebacksChargebackLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[
        ListSettlementChargebacksChargebackSelf, pydantic.Field(alias="self")
    ]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payment: ListSettlementChargebacksPayment
    r"""The API resource URL of the [payment](get-payment) that this chargeback belongs to."""

    documentation: ListSettlementChargebacksChargebackDocumentation
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    settlement: OptionalNullable[ListSettlementChargebacksSettlement] = UNSET
    r"""The API resource URL of the [settlement](get-settlement) this chargeback has been settled with. Not present if
    not yet settled.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["settlement"]
        nullable_fields = ["settlement"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListSettlementChargebacksChargebackTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a chargeback object. Will always contain the string `chargeback` for this
    endpoint.
    """
    id: str
    r"""The identifier uniquely referring to this chargeback. Example: `chb_n9z0tp`."""
    amount: ListSettlementChargebacksAmountTypedDict
    r"""The amount charged back by the customer."""
    payment_id: str
    r"""The unique identifier of the payment this chargeback was created for. For example: `tr_5B8cwPMGnU6qLbRvo7qEZo`.
    The full payment object can be retrieved via the payment URL in the `_links` object.
    """
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: ListSettlementChargebacksChargebackLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    settlement_amount: NotRequired[
        Nullable[ListSettlementChargebacksSettlementAmountTypedDict]
    ]
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted
    to the currency your account is settled in.

    The amount is a **negative** amount.

    Since the field contains an estimated amount during chargeback processing, it may change over time. To retrieve
    accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions)
    instead.
    """
    reason: NotRequired[Nullable[ListSettlementChargebacksReasonTypedDict]]
    r"""Reason for the chargeback as given by the bank. Only available for chargebacks of SEPA Direct Debit payments."""
    settlement_id: NotRequired[Nullable[str]]
    r"""The identifier referring to the settlement this payment was settled with. For example, `stl_BkEjN2eBb`. This field
    is omitted if the refund is not settled (yet).
    """
    reversed_at: NotRequired[Nullable[str]]
    r"""The date and time the chargeback was reversed if applicable, in
    [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format.
    """


class ListSettlementChargebacksChargeback(BaseModel):
    resource: str
    r"""Indicates the response contains a chargeback object. Will always contain the string `chargeback` for this
    endpoint.
    """

    id: str
    r"""The identifier uniquely referring to this chargeback. Example: `chb_n9z0tp`."""

    amount: ListSettlementChargebacksAmount
    r"""The amount charged back by the customer."""

    payment_id: Annotated[str, pydantic.Field(alias="paymentId")]
    r"""The unique identifier of the payment this chargeback was created for. For example: `tr_5B8cwPMGnU6qLbRvo7qEZo`.
    The full payment object can be retrieved via the payment URL in the `_links` object.
    """

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[
        ListSettlementChargebacksChargebackLinks, pydantic.Field(alias="_links")
    ]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    settlement_amount: Annotated[
        OptionalNullable[ListSettlementChargebacksSettlementAmount],
        pydantic.Field(alias="settlementAmount"),
    ] = UNSET
    r"""This optional field will contain the approximate amount that will be deducted from your account balance, converted
    to the currency your account is settled in.

    The amount is a **negative** amount.

    Since the field contains an estimated amount during chargeback processing, it may change over time. To retrieve
    accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions)
    instead.
    """

    reason: OptionalNullable[ListSettlementChargebacksReason] = UNSET
    r"""Reason for the chargeback as given by the bank. Only available for chargebacks of SEPA Direct Debit payments."""

    settlement_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="settlementId")
    ] = UNSET
    r"""The identifier referring to the settlement this payment was settled with. For example, `stl_BkEjN2eBb`. This field
    is omitted if the refund is not settled (yet).
    """

    reversed_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="reversedAt")
    ] = UNSET
    r"""The date and time the chargeback was reversed if applicable, in
    [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["settlementAmount", "reason", "settlementId", "reversedAt"]
        nullable_fields = ["settlementAmount", "reason", "settlementId", "reversedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListSettlementChargebacksEmbeddedTypedDict(TypedDict):
    chargebacks: NotRequired[List[ListSettlementChargebacksChargebackTypedDict]]
    r"""A list of chargeback objects."""


class ListSettlementChargebacksEmbedded(BaseModel):
    chargebacks: Optional[List[ListSettlementChargebacksChargeback]] = None
    r"""A list of chargeback objects."""


class ListSettlementChargebacksSelfTypedDict(TypedDict):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementChargebacksSelf(BaseModel):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementChargebacksPreviousTypedDict(TypedDict):
    r"""The previous set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementChargebacksPrevious(BaseModel):
    r"""The previous set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementChargebacksNextTypedDict(TypedDict):
    r"""The next set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementChargebacksNext(BaseModel):
    r"""The next set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementChargebacksDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementChargebacksDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementChargebacksLinksTypedDict(TypedDict):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[ListSettlementChargebacksSelfTypedDict]
    r"""The URL to the current set of items."""
    previous: NotRequired[Nullable[ListSettlementChargebacksPreviousTypedDict]]
    r"""The previous set of items, if available."""
    next: NotRequired[Nullable[ListSettlementChargebacksNextTypedDict]]
    r"""The next set of items, if available."""
    documentation: NotRequired[ListSettlementChargebacksDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListSettlementChargebacksLinks(BaseModel):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[
        Optional[ListSettlementChargebacksSelf], pydantic.Field(alias="self")
    ] = None
    r"""The URL to the current set of items."""

    previous: OptionalNullable[ListSettlementChargebacksPrevious] = UNSET
    r"""The previous set of items, if available."""

    next: OptionalNullable[ListSettlementChargebacksNext] = UNSET
    r"""The next set of items, if available."""

    documentation: Optional[ListSettlementChargebacksDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["self", "previous", "next", "documentation"]
        nullable_fields = ["previous", "next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListSettlementChargebacksResponseTypedDict(TypedDict):
    r"""A list of chargeback objects."""

    count: NotRequired[int]
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """
    embedded: NotRequired[ListSettlementChargebacksEmbeddedTypedDict]
    links: NotRequired[ListSettlementChargebacksLinksTypedDict]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class ListSettlementChargebacksResponse(BaseModel):
    r"""A list of chargeback objects."""

    count: Optional[int] = None
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """

    embedded: Annotated[
        Optional[ListSettlementChargebacksEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[
        Optional[ListSettlementChargebacksLinks], pydantic.Field(alias="_links")
    ] = None
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
