"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class UpdateCustomerLocaleRequest(str, Enum):
    r"""Preconfigure the language to be used in the hosted payment pages shown to the customer. Should only be provided if
    absolutely necessary. If not provided, the browser language will be used which is typically highly accurate.
    """

    EN_US = "en_US"
    EN_GB = "en_GB"
    NL_NL = "nl_NL"
    NL_BE = "nl_BE"
    DE_DE = "de_DE"
    DE_AT = "de_AT"
    DE_CH = "de_CH"
    FR_FR = "fr_FR"
    FR_BE = "fr_BE"
    ES_ES = "es_ES"
    CA_ES = "ca_ES"
    PT_PT = "pt_PT"
    IT_IT = "it_IT"
    NB_NO = "nb_NO"
    SV_SE = "sv_SE"
    FI_FI = "fi_FI"
    DA_DK = "da_DK"
    IS_IS = "is_IS"
    HU_HU = "hu_HU"
    PL_PL = "pl_PL"
    LV_LV = "lv_LV"
    LT_LT = "lt_LT"


class UpdateCustomerMetadataRequestTypedDict(TypedDict):
    pass


class UpdateCustomerMetadataRequest(BaseModel):
    pass


UpdateCustomerMetadataRequestUnionTypedDict = TypeAliasType(
    "UpdateCustomerMetadataRequestUnionTypedDict",
    Union[UpdateCustomerMetadataRequestTypedDict, str, List[str]],
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
"""


UpdateCustomerMetadataRequestUnion = TypeAliasType(
    "UpdateCustomerMetadataRequestUnion",
    Union[UpdateCustomerMetadataRequest, str, List[str]],
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
"""


class UpdateCustomerRequestBodyTypedDict(TypedDict):
    name: NotRequired[Nullable[str]]
    r"""The full name of the customer."""
    email: NotRequired[Nullable[str]]
    r"""The email address of the customer."""
    locale: NotRequired[Nullable[UpdateCustomerLocaleRequest]]
    r"""Preconfigure the language to be used in the hosted payment pages shown to the customer. Should only be provided if
    absolutely necessary. If not provided, the browser language will be used which is typically highly accurate.
    """
    metadata: NotRequired[Nullable[UpdateCustomerMetadataRequestUnionTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """


class UpdateCustomerRequestBody(BaseModel):
    name: OptionalNullable[str] = UNSET
    r"""The full name of the customer."""

    email: OptionalNullable[str] = UNSET
    r"""The email address of the customer."""

    locale: OptionalNullable[UpdateCustomerLocaleRequest] = UNSET
    r"""Preconfigure the language to be used in the hosted payment pages shown to the customer. Should only be provided if
    absolutely necessary. If not provided, the browser language will be used which is typically highly accurate.
    """

    metadata: OptionalNullable[UpdateCustomerMetadataRequestUnion] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """

    testmode: OptionalNullable[bool] = UNSET
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["name", "email", "locale", "metadata", "testmode"]
        nullable_fields = ["name", "email", "locale", "metadata", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UpdateCustomerRequestTypedDict(TypedDict):
    customer_id: str
    r"""Provide the ID of the related customer."""
    request_body: NotRequired[UpdateCustomerRequestBodyTypedDict]


class UpdateCustomerRequest(BaseModel):
    customer_id: Annotated[
        str,
        pydantic.Field(alias="customerId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related customer."""

    request_body: Annotated[
        Optional[UpdateCustomerRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None


class UpdateCustomerNotFoundDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class UpdateCustomerNotFoundDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class UpdateCustomerNotFoundLinksTypedDict(TypedDict):
    documentation: UpdateCustomerNotFoundDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateCustomerNotFoundLinks(BaseModel):
    documentation: UpdateCustomerNotFoundDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateCustomerHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[UpdateCustomerNotFoundLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class UpdateCustomerHalJSONError(ClientError):
    r"""An error response object."""

    data: UpdateCustomerHalJSONErrorData

    def __init__(
        self,
        data: UpdateCustomerHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class UpdateCustomerMode(str, Enum):
    r"""Whether this entity was created in live mode or in test mode."""

    LIVE = "live"
    TEST = "test"


class UpdateCustomerLocaleResponse(str, Enum):
    r"""Preconfigure the language to be used in the hosted payment pages shown to the customer. Should only be provided if
    absolutely necessary. If not provided, the browser language will be used which is typically highly accurate.
    """

    EN_US = "en_US"
    EN_GB = "en_GB"
    NL_NL = "nl_NL"
    NL_BE = "nl_BE"
    DE_DE = "de_DE"
    DE_AT = "de_AT"
    DE_CH = "de_CH"
    FR_FR = "fr_FR"
    FR_BE = "fr_BE"
    ES_ES = "es_ES"
    CA_ES = "ca_ES"
    PT_PT = "pt_PT"
    IT_IT = "it_IT"
    NB_NO = "nb_NO"
    SV_SE = "sv_SE"
    FI_FI = "fi_FI"
    DA_DK = "da_DK"
    IS_IS = "is_IS"
    HU_HU = "hu_HU"
    PL_PL = "pl_PL"
    LV_LV = "lv_LV"
    LT_LT = "lt_LT"


class UpdateCustomerMetadataResponseTypedDict(TypedDict):
    pass


class UpdateCustomerMetadataResponse(BaseModel):
    pass


UpdateCustomerMetadataResponseUnionTypedDict = TypeAliasType(
    "UpdateCustomerMetadataResponseUnionTypedDict",
    Union[UpdateCustomerMetadataResponseTypedDict, str, List[str]],
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
"""


UpdateCustomerMetadataResponseUnion = TypeAliasType(
    "UpdateCustomerMetadataResponseUnion",
    Union[UpdateCustomerMetadataResponse, str, List[str]],
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
"""


class UpdateCustomerSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateCustomerSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateCustomerDashboardTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateCustomerDashboard(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateCustomerPaymentsTypedDict(TypedDict):
    r"""The API resource URL of the [payments](list-payments) linked to this customer. Omitted if no such payments
    exist (yet).
    """

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class UpdateCustomerPayments(BaseModel):
    r"""The API resource URL of the [payments](list-payments) linked to this customer. Omitted if no such payments
    exist (yet).
    """

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class UpdateCustomerMandatesTypedDict(TypedDict):
    r"""The API resource URL of the [mandates](list-mandates) linked to this customer. Omitted if no such mandates
    exist (yet).
    """

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class UpdateCustomerMandates(BaseModel):
    r"""The API resource URL of the [mandates](list-mandates) linked to this customer. Omitted if no such mandates
    exist (yet).
    """

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class UpdateCustomerSubscriptionsTypedDict(TypedDict):
    r"""The API resource URL of the [subscriptions](list-subscriptions) linked to this customer. Omitted if no such
    subscriptions exist (yet).
    """

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class UpdateCustomerSubscriptions(BaseModel):
    r"""The API resource URL of the [subscriptions](list-subscriptions) linked to this customer. Omitted if no such
    subscriptions exist (yet).
    """

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class UpdateCustomerDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateCustomerDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class UpdateCustomerLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: UpdateCustomerSelfTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    dashboard: UpdateCustomerDashboardTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: UpdateCustomerDocumentationTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payments: NotRequired[Nullable[UpdateCustomerPaymentsTypedDict]]
    r"""The API resource URL of the [payments](list-payments) linked to this customer. Omitted if no such payments
    exist (yet).
    """
    mandates: NotRequired[Nullable[UpdateCustomerMandatesTypedDict]]
    r"""The API resource URL of the [mandates](list-mandates) linked to this customer. Omitted if no such mandates
    exist (yet).
    """
    subscriptions: NotRequired[Nullable[UpdateCustomerSubscriptionsTypedDict]]
    r"""The API resource URL of the [subscriptions](list-subscriptions) linked to this customer. Omitted if no such
    subscriptions exist (yet).
    """


class UpdateCustomerLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[UpdateCustomerSelf, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    dashboard: UpdateCustomerDashboard
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: UpdateCustomerDocumentation
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payments: OptionalNullable[UpdateCustomerPayments] = UNSET
    r"""The API resource URL of the [payments](list-payments) linked to this customer. Omitted if no such payments
    exist (yet).
    """

    mandates: OptionalNullable[UpdateCustomerMandates] = UNSET
    r"""The API resource URL of the [mandates](list-mandates) linked to this customer. Omitted if no such mandates
    exist (yet).
    """

    subscriptions: OptionalNullable[UpdateCustomerSubscriptions] = UNSET
    r"""The API resource URL of the [subscriptions](list-subscriptions) linked to this customer. Omitted if no such
    subscriptions exist (yet).
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["payments", "mandates", "subscriptions"]
        nullable_fields = ["payments", "mandates", "subscriptions"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UpdateCustomerResponseTypedDict(TypedDict):
    r"""The updated customer object."""

    resource: str
    r"""Indicates the response contains a customer object. Will always contain the string `customer` for this endpoint."""
    id: str
    r"""The identifier uniquely referring to this customer. Example: `cst_vsKJpSsabw`."""
    mode: UpdateCustomerMode
    r"""Whether this entity was created in live mode or in test mode."""
    name: Nullable[str]
    r"""The full name of the customer."""
    email: Nullable[str]
    r"""The email address of the customer."""
    locale: Nullable[UpdateCustomerLocaleResponse]
    r"""Preconfigure the language to be used in the hosted payment pages shown to the customer. Should only be provided if
    absolutely necessary. If not provided, the browser language will be used which is typically highly accurate.
    """
    metadata: Nullable[UpdateCustomerMetadataResponseUnionTypedDict]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: UpdateCustomerLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class UpdateCustomerResponse(BaseModel):
    r"""The updated customer object."""

    resource: str
    r"""Indicates the response contains a customer object. Will always contain the string `customer` for this endpoint."""

    id: str
    r"""The identifier uniquely referring to this customer. Example: `cst_vsKJpSsabw`."""

    mode: UpdateCustomerMode
    r"""Whether this entity was created in live mode or in test mode."""

    name: Nullable[str]
    r"""The full name of the customer."""

    email: Nullable[str]
    r"""The email address of the customer."""

    locale: Nullable[UpdateCustomerLocaleResponse]
    r"""Preconfigure the language to be used in the hosted payment pages shown to the customer. Should only be provided if
    absolutely necessary. If not provided, the browser language will be used which is typically highly accurate.
    """

    metadata: Nullable[UpdateCustomerMetadataResponseUnion]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[UpdateCustomerLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["name", "email", "locale", "metadata"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
