"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import Any, Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class ListAllSubscriptionsRequestTypedDict(TypedDict):
    from_: NotRequired[str]
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """
    limit: NotRequired[Nullable[int]]
    r"""The maximum number of items to return. Defaults to 50 items."""
    profile_id: NotRequired[Nullable[str]]
    r"""The identifier referring to the [profile](get-profile) you wish to retrieve subscriptions for.

    Most API credentials are linked to a single profile. In these cases the `profileId` is already implied.

    To retrieve all subscriptions across the organization, use an organization-level API credential and omit the
    `profileId` parameter.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class ListAllSubscriptionsRequest(BaseModel):
    from_: Annotated[
        Optional[str],
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """

    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The maximum number of items to return. Defaults to 50 items."""

    profile_id: Annotated[
        OptionalNullable[str],
        pydantic.Field(alias="profileId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The identifier referring to the [profile](get-profile) you wish to retrieve subscriptions for.

    Most API credentials are linked to a single profile. In these cases the `profileId` is already implied.

    To retrieve all subscriptions across the organization, use an organization-level API credential and omit the
    `profileId` parameter.
    """

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["from", "limit", "profileId", "testmode"]
        nullable_fields = ["limit", "profileId", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListAllSubscriptionsNotFoundDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListAllSubscriptionsNotFoundDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListAllSubscriptionsNotFoundLinksTypedDict(TypedDict):
    documentation: ListAllSubscriptionsNotFoundDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListAllSubscriptionsNotFoundLinks(BaseModel):
    documentation: ListAllSubscriptionsNotFoundDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListAllSubscriptionsNotFoundHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[ListAllSubscriptionsNotFoundLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class ListAllSubscriptionsNotFoundHalJSONError(ClientError):
    r"""An error response object."""

    data: ListAllSubscriptionsNotFoundHalJSONErrorData

    def __init__(
        self,
        data: ListAllSubscriptionsNotFoundHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class ListAllSubscriptionsBadRequestDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListAllSubscriptionsBadRequestDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListAllSubscriptionsBadRequestLinksTypedDict(TypedDict):
    documentation: ListAllSubscriptionsBadRequestDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListAllSubscriptionsBadRequestLinks(BaseModel):
    documentation: ListAllSubscriptionsBadRequestDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListAllSubscriptionsBadRequestHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[
        ListAllSubscriptionsBadRequestLinks, pydantic.Field(alias="_links")
    ]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class ListAllSubscriptionsBadRequestHalJSONError(ClientError):
    r"""An error response object."""

    data: ListAllSubscriptionsBadRequestHalJSONErrorData

    def __init__(
        self,
        data: ListAllSubscriptionsBadRequestHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class ListAllSubscriptionsMode(str, Enum):
    r"""Whether this entity was created in live mode or in test mode."""

    LIVE = "live"
    TEST = "test"


class ListAllSubscriptionsStatus(str, Enum):
    r"""The subscription's current status is directly related to the status of the underlying customer or mandate that is
    enabling the subscription.
    """

    PENDING = "pending"
    ACTIVE = "active"
    CANCELED = "canceled"
    SUSPENDED = "suspended"
    COMPLETED = "completed"


class ListAllSubscriptionsAmountTypedDict(TypedDict):
    r"""The amount for each individual payment that is charged with this subscription. For example, for a monthly
    subscription of €10, the subscription amount should be set to €10.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListAllSubscriptionsAmount(BaseModel):
    r"""The amount for each individual payment that is charged with this subscription. For example, for a monthly
    subscription of €10, the subscription amount should be set to €10.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListAllSubscriptionsInterval(str, Enum):
    r"""Interval to wait between payments, for example `1 month` or `14 days`.

    The maximum interval is one year (`12 months`, `52 weeks`, or `365 days`).
    """

    DOT_DOT_DOT_DAYS = "... days"
    DOT_DOT_DOT_WEEKS = "... weeks"
    DOT_DOT_DOT_MONTHS = "... months"


class ListAllSubscriptionsMethod(str, Enum):
    r"""The payment method used for this subscription. If omitted, any of the customer's valid mandates may be used."""

    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    PAYPAL = "paypal"


class ListAllSubscriptionsApplicationFeeAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListAllSubscriptionsApplicationFeeAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListAllSubscriptionsApplicationFeeTypedDict(TypedDict):
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    Setting an application fee on the subscription will ensure this fee is charged on each individual payment.

    Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more
    information.
    """

    amount: ListAllSubscriptionsApplicationFeeAmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    description: str


class ListAllSubscriptionsApplicationFee(BaseModel):
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    Setting an application fee on the subscription will ensure this fee is charged on each individual payment.

    Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more
    information.
    """

    amount: ListAllSubscriptionsApplicationFeeAmount
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    description: str


ListAllSubscriptionsMetadataTypedDict = TypeAliasType(
    "ListAllSubscriptionsMetadataTypedDict", Union[str, Dict[str, Any], List[str]]
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity.
Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately
1kB.

Any metadata added to the subscription will be automatically forwarded to the payments generated for it.
"""


ListAllSubscriptionsMetadata = TypeAliasType(
    "ListAllSubscriptionsMetadata", Union[str, Dict[str, Any], List[str]]
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity.
Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately
1kB.

Any metadata added to the subscription will be automatically forwarded to the payments generated for it.
"""


class ListAllSubscriptionsSubscriptionSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListAllSubscriptionsSubscriptionSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListAllSubscriptionsCustomerTypedDict(TypedDict):
    r"""The API resource URL of the [customer](get-customer) this subscription was created for."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListAllSubscriptionsCustomer(BaseModel):
    r"""The API resource URL of the [customer](get-customer) this subscription was created for."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListAllSubscriptionsMandateTypedDict(TypedDict):
    r"""The API resource URL of the [mandate](get-mandate) this subscription was created for."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListAllSubscriptionsMandate(BaseModel):
    r"""The API resource URL of the [mandate](get-mandate) this subscription was created for."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListAllSubscriptionsProfileTypedDict(TypedDict):
    r"""The API resource URL of the [profile](get-profile) this subscription was created for."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListAllSubscriptionsProfile(BaseModel):
    r"""The API resource URL of the [profile](get-profile) this subscription was created for."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListAllSubscriptionsPaymentsTypedDict(TypedDict):
    r"""The API resource URL of the [payments](list-payments) created for this subscription. Omitted if no such
    payments exist (yet).
    """

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListAllSubscriptionsPayments(BaseModel):
    r"""The API resource URL of the [payments](list-payments) created for this subscription. Omitted if no such
    payments exist (yet).
    """

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListAllSubscriptionsSubscriptionDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListAllSubscriptionsSubscriptionDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListAllSubscriptionsSubscriptionLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: ListAllSubscriptionsSubscriptionSelfTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    customer: Nullable[ListAllSubscriptionsCustomerTypedDict]
    r"""The API resource URL of the [customer](get-customer) this subscription was created for."""
    profile: Nullable[ListAllSubscriptionsProfileTypedDict]
    r"""The API resource URL of the [profile](get-profile) this subscription was created for."""
    documentation: ListAllSubscriptionsSubscriptionDocumentationTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    mandate: NotRequired[Nullable[ListAllSubscriptionsMandateTypedDict]]
    r"""The API resource URL of the [mandate](get-mandate) this subscription was created for."""
    payments: NotRequired[Nullable[ListAllSubscriptionsPaymentsTypedDict]]
    r"""The API resource URL of the [payments](list-payments) created for this subscription. Omitted if no such
    payments exist (yet).
    """


class ListAllSubscriptionsSubscriptionLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[ListAllSubscriptionsSubscriptionSelf, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    customer: Nullable[ListAllSubscriptionsCustomer]
    r"""The API resource URL of the [customer](get-customer) this subscription was created for."""

    profile: Nullable[ListAllSubscriptionsProfile]
    r"""The API resource URL of the [profile](get-profile) this subscription was created for."""

    documentation: ListAllSubscriptionsSubscriptionDocumentation
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    mandate: OptionalNullable[ListAllSubscriptionsMandate] = UNSET
    r"""The API resource URL of the [mandate](get-mandate) this subscription was created for."""

    payments: OptionalNullable[ListAllSubscriptionsPayments] = UNSET
    r"""The API resource URL of the [payments](list-payments) created for this subscription. Omitted if no such
    payments exist (yet).
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["mandate", "payments"]
        nullable_fields = ["customer", "mandate", "profile", "payments"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListAllSubscriptionsSubscriptionTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a subscription object. Will always contain the string `subscription` for this
    endpoint.
    """
    id: str
    r"""The identifier uniquely referring to this subscription. Example: `sub_rVKGtNd6s3`."""
    mode: ListAllSubscriptionsMode
    r"""Whether this entity was created in live mode or in test mode."""
    status: ListAllSubscriptionsStatus
    r"""The subscription's current status is directly related to the status of the underlying customer or mandate that is
    enabling the subscription.
    """
    amount: ListAllSubscriptionsAmountTypedDict
    r"""The amount for each individual payment that is charged with this subscription. For example, for a monthly
    subscription of €10, the subscription amount should be set to €10.
    """
    times: Nullable[int]
    r"""Total number of payments for the subscription. Once this number of payments is reached, the subscription is
    considered completed.

    Test mode subscriptions will get canceled automatically after 10 payments.
    """
    times_remaining: int
    r"""Number of payments left for the subscription."""
    interval: ListAllSubscriptionsInterval
    r"""Interval to wait between payments, for example `1 month` or `14 days`.

    The maximum interval is one year (`12 months`, `52 weeks`, or `365 days`).
    """
    start_date: str
    r"""The start date of the subscription in `YYYY-MM-DD` format."""
    description: str
    r"""The subscription's description will be used as the description of the resulting individual payments and so showing
    up on the bank statement of the consumer.

    **Please note:** the description needs to be unique for the Customer in case it has multiple active subscriptions.
    """
    method: Nullable[ListAllSubscriptionsMethod]
    r"""The payment method used for this subscription. If omitted, any of the customer's valid mandates may be used."""
    metadata: Nullable[ListAllSubscriptionsMetadataTypedDict]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity.
    Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately
    1kB.

    Any metadata added to the subscription will be automatically forwarded to the payments generated for it.
    """
    webhook_url: str
    r"""We will call this URL for any payment status changes of payments resulting from this subscription.

    This webhook will receive **all** events for the subscription's payments. This may include payment failures as
    well. Be sure to verify the payment's subscription ID and its status.
    """
    customer_id: str
    r"""The customer this subscription belongs to."""
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    next_payment_date: NotRequired[Nullable[str]]
    r"""The date of the next scheduled payment in `YYYY-MM-DD` format. If the subscription has been completed or canceled,
    this parameter will not be returned.
    """
    application_fee: NotRequired[ListAllSubscriptionsApplicationFeeTypedDict]
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    Setting an application fee on the subscription will ensure this fee is charged on each individual payment.

    Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more
    information.
    """
    mandate_id: NotRequired[Nullable[str]]
    r"""The mandate used for this subscription, if any."""
    canceled_at: NotRequired[Nullable[str]]
    r"""The subscription's date and time of cancellation, in ISO 8601 format. This parameter is omitted if the
    subscription is not canceled (yet).
    """
    links: NotRequired[ListAllSubscriptionsSubscriptionLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class ListAllSubscriptionsSubscription(BaseModel):
    resource: str
    r"""Indicates the response contains a subscription object. Will always contain the string `subscription` for this
    endpoint.
    """

    id: str
    r"""The identifier uniquely referring to this subscription. Example: `sub_rVKGtNd6s3`."""

    mode: ListAllSubscriptionsMode
    r"""Whether this entity was created in live mode or in test mode."""

    status: ListAllSubscriptionsStatus
    r"""The subscription's current status is directly related to the status of the underlying customer or mandate that is
    enabling the subscription.
    """

    amount: ListAllSubscriptionsAmount
    r"""The amount for each individual payment that is charged with this subscription. For example, for a monthly
    subscription of €10, the subscription amount should be set to €10.
    """

    times: Nullable[int]
    r"""Total number of payments for the subscription. Once this number of payments is reached, the subscription is
    considered completed.

    Test mode subscriptions will get canceled automatically after 10 payments.
    """

    times_remaining: Annotated[int, pydantic.Field(alias="timesRemaining")]
    r"""Number of payments left for the subscription."""

    interval: ListAllSubscriptionsInterval
    r"""Interval to wait between payments, for example `1 month` or `14 days`.

    The maximum interval is one year (`12 months`, `52 weeks`, or `365 days`).
    """

    start_date: Annotated[str, pydantic.Field(alias="startDate")]
    r"""The start date of the subscription in `YYYY-MM-DD` format."""

    description: str
    r"""The subscription's description will be used as the description of the resulting individual payments and so showing
    up on the bank statement of the consumer.

    **Please note:** the description needs to be unique for the Customer in case it has multiple active subscriptions.
    """

    method: Nullable[ListAllSubscriptionsMethod]
    r"""The payment method used for this subscription. If omitted, any of the customer's valid mandates may be used."""

    metadata: Nullable[ListAllSubscriptionsMetadata]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity.
    Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately
    1kB.

    Any metadata added to the subscription will be automatically forwarded to the payments generated for it.
    """

    webhook_url: Annotated[str, pydantic.Field(alias="webhookUrl")]
    r"""We will call this URL for any payment status changes of payments resulting from this subscription.

    This webhook will receive **all** events for the subscription's payments. This may include payment failures as
    well. Be sure to verify the payment's subscription ID and its status.
    """

    customer_id: Annotated[str, pydantic.Field(alias="customerId")]
    r"""The customer this subscription belongs to."""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    next_payment_date: Annotated[
        OptionalNullable[str], pydantic.Field(alias="nextPaymentDate")
    ] = UNSET
    r"""The date of the next scheduled payment in `YYYY-MM-DD` format. If the subscription has been completed or canceled,
    this parameter will not be returned.
    """

    application_fee: Annotated[
        Optional[ListAllSubscriptionsApplicationFee],
        pydantic.Field(alias="applicationFee"),
    ] = None
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    Setting an application fee on the subscription will ensure this fee is charged on each individual payment.

    Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more
    information.
    """

    mandate_id: Annotated[OptionalNullable[str], pydantic.Field(alias="mandateId")] = (
        UNSET
    )
    r"""The mandate used for this subscription, if any."""

    canceled_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="canceledAt")
    ] = UNSET
    r"""The subscription's date and time of cancellation, in ISO 8601 format. This parameter is omitted if the
    subscription is not canceled (yet).
    """

    links: Annotated[
        Optional[ListAllSubscriptionsSubscriptionLinks], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "nextPaymentDate",
            "applicationFee",
            "mandateId",
            "canceledAt",
            "_links",
        ]
        nullable_fields = [
            "times",
            "nextPaymentDate",
            "method",
            "metadata",
            "mandateId",
            "canceledAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListAllSubscriptionsEmbeddedTypedDict(TypedDict):
    subscriptions: NotRequired[List[ListAllSubscriptionsSubscriptionTypedDict]]
    r"""A list of subscription objects."""


class ListAllSubscriptionsEmbedded(BaseModel):
    subscriptions: Optional[List[ListAllSubscriptionsSubscription]] = None
    r"""A list of subscription objects."""


class ListAllSubscriptionsSelfTypedDict(TypedDict):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListAllSubscriptionsSelf(BaseModel):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListAllSubscriptionsPreviousTypedDict(TypedDict):
    r"""The previous set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListAllSubscriptionsPrevious(BaseModel):
    r"""The previous set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListAllSubscriptionsNextTypedDict(TypedDict):
    r"""The next set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListAllSubscriptionsNext(BaseModel):
    r"""The next set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListAllSubscriptionsDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListAllSubscriptionsDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListAllSubscriptionsLinksTypedDict(TypedDict):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[ListAllSubscriptionsSelfTypedDict]
    r"""The URL to the current set of items."""
    previous: NotRequired[Nullable[ListAllSubscriptionsPreviousTypedDict]]
    r"""The previous set of items, if available."""
    next: NotRequired[Nullable[ListAllSubscriptionsNextTypedDict]]
    r"""The next set of items, if available."""
    documentation: NotRequired[ListAllSubscriptionsDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListAllSubscriptionsLinks(BaseModel):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[
        Optional[ListAllSubscriptionsSelf], pydantic.Field(alias="self")
    ] = None
    r"""The URL to the current set of items."""

    previous: OptionalNullable[ListAllSubscriptionsPrevious] = UNSET
    r"""The previous set of items, if available."""

    next: OptionalNullable[ListAllSubscriptionsNext] = UNSET
    r"""The next set of items, if available."""

    documentation: Optional[ListAllSubscriptionsDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["self", "previous", "next", "documentation"]
        nullable_fields = ["previous", "next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListAllSubscriptionsResponseTypedDict(TypedDict):
    r"""A list of subscription objects."""

    count: NotRequired[int]
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """
    embedded: NotRequired[ListAllSubscriptionsEmbeddedTypedDict]
    links: NotRequired[ListAllSubscriptionsLinksTypedDict]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class ListAllSubscriptionsResponse(BaseModel):
    r"""A list of subscription objects."""

    count: Optional[int] = None
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """

    embedded: Annotated[
        Optional[ListAllSubscriptionsEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[
        Optional[ListAllSubscriptionsLinks], pydantic.Field(alias="_links")
    ] = None
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
