"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import Any, Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class ListSettlementCapturesEmbed(str, Enum):
    r"""This endpoint allows you to embed additional resources via the
    `embed` query string parameter.
    """

    PAYMENT = "payment"


class ListSettlementCapturesRequestTypedDict(TypedDict):
    settlement_id: str
    r"""Provide the ID of the related settlement."""
    from_: NotRequired[str]
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """
    limit: NotRequired[Nullable[int]]
    r"""The maximum number of items to return. Defaults to 50 items."""
    embed: NotRequired[ListSettlementCapturesEmbed]
    r"""This endpoint allows you to embed additional resources via the
    `embed` query string parameter.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class ListSettlementCapturesRequest(BaseModel):
    settlement_id: Annotated[
        str,
        pydantic.Field(alias="settlementId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related settlement."""

    from_: Annotated[
        Optional[str],
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """

    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The maximum number of items to return. Defaults to 50 items."""

    embed: Annotated[
        Optional[ListSettlementCapturesEmbed],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""This endpoint allows you to embed additional resources via the
    `embed` query string parameter.
    """

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["from", "limit", "embed", "testmode"]
        nullable_fields = ["limit", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListSettlementCapturesNotFoundDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListSettlementCapturesNotFoundDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListSettlementCapturesNotFoundLinksTypedDict(TypedDict):
    documentation: ListSettlementCapturesNotFoundDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListSettlementCapturesNotFoundLinks(BaseModel):
    documentation: ListSettlementCapturesNotFoundDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListSettlementCapturesNotFoundHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[
        ListSettlementCapturesNotFoundLinks, pydantic.Field(alias="_links")
    ]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class ListSettlementCapturesNotFoundHalJSONError(ClientError):
    r"""An error response object."""

    data: ListSettlementCapturesNotFoundHalJSONErrorData

    def __init__(
        self,
        data: ListSettlementCapturesNotFoundHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class ListSettlementCapturesBadRequestDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListSettlementCapturesBadRequestDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListSettlementCapturesBadRequestLinksTypedDict(TypedDict):
    documentation: ListSettlementCapturesBadRequestDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListSettlementCapturesBadRequestLinks(BaseModel):
    documentation: ListSettlementCapturesBadRequestDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListSettlementCapturesBadRequestHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[
        ListSettlementCapturesBadRequestLinks, pydantic.Field(alias="_links")
    ]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class ListSettlementCapturesBadRequestHalJSONError(ClientError):
    r"""An error response object."""

    data: ListSettlementCapturesBadRequestHalJSONErrorData

    def __init__(
        self,
        data: ListSettlementCapturesBadRequestHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class ListSettlementCapturesMode(str, Enum):
    r"""Whether this entity was created in live mode or in test mode."""

    LIVE = "live"
    TEST = "test"


class ListSettlementCapturesAmountTypedDict(TypedDict):
    r"""The amount captured. If no amount is provided, the full authorized amount is captured."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListSettlementCapturesAmount(BaseModel):
    r"""The amount captured. If no amount is provided, the full authorized amount is captured."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListSettlementCapturesSettlementAmountTypedDict(TypedDict):
    r"""This optional field will contain the approximate amount that will be settled to your account, converted to the
    currency your account is settled in.

    Since the field contains an estimated amount during capture processing, it may change over time. To retrieve
    accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions)
    instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListSettlementCapturesSettlementAmount(BaseModel):
    r"""This optional field will contain the approximate amount that will be settled to your account, converted to the
    currency your account is settled in.

    Since the field contains an estimated amount during capture processing, it may change over time. To retrieve
    accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions)
    instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListSettlementCapturesStatus(str, Enum):
    r"""The capture's status."""

    PENDING = "pending"
    SUCCEEDED = "succeeded"
    FAILED = "failed"


ListSettlementCapturesMetadataTypedDict = TypeAliasType(
    "ListSettlementCapturesMetadataTypedDict", Union[str, Dict[str, Any], List[str]]
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
"""


ListSettlementCapturesMetadata = TypeAliasType(
    "ListSettlementCapturesMetadata", Union[str, Dict[str, Any], List[str]]
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
"""


class ListSettlementCapturesCaptureSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementCapturesCaptureSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementCapturesPaymentTypedDict(TypedDict):
    r"""The API resource URL of the [payment](get-payment) that this capture belongs to."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementCapturesPayment(BaseModel):
    r"""The API resource URL of the [payment](get-payment) that this capture belongs to."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementCapturesSettlementTypedDict(TypedDict):
    r"""The API resource URL of the [settlement](get-settlement) this capture has been settled with. Not present if
    not yet settled.
    """

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementCapturesSettlement(BaseModel):
    r"""The API resource URL of the [settlement](get-settlement) this capture has been settled with. Not present if
    not yet settled.
    """

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementCapturesShipmentTypedDict(TypedDict):
    r"""The API resource URL of the [shipment](get-shipment) this capture is associated with. Not present if
    it isn't associated with a shipment.
    """

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementCapturesShipment(BaseModel):
    r"""The API resource URL of the [shipment](get-shipment) this capture is associated with. Not present if
    it isn't associated with a shipment.
    """

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementCapturesCaptureDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementCapturesCaptureDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementCapturesCaptureLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: ListSettlementCapturesCaptureSelfTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payment: ListSettlementCapturesPaymentTypedDict
    r"""The API resource URL of the [payment](get-payment) that this capture belongs to."""
    documentation: ListSettlementCapturesCaptureDocumentationTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    settlement: NotRequired[Nullable[ListSettlementCapturesSettlementTypedDict]]
    r"""The API resource URL of the [settlement](get-settlement) this capture has been settled with. Not present if
    not yet settled.
    """
    shipment: NotRequired[Nullable[ListSettlementCapturesShipmentTypedDict]]
    r"""The API resource URL of the [shipment](get-shipment) this capture is associated with. Not present if
    it isn't associated with a shipment.
    """


class ListSettlementCapturesCaptureLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[ListSettlementCapturesCaptureSelf, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payment: ListSettlementCapturesPayment
    r"""The API resource URL of the [payment](get-payment) that this capture belongs to."""

    documentation: ListSettlementCapturesCaptureDocumentation
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    settlement: OptionalNullable[ListSettlementCapturesSettlement] = UNSET
    r"""The API resource URL of the [settlement](get-settlement) this capture has been settled with. Not present if
    not yet settled.
    """

    shipment: OptionalNullable[ListSettlementCapturesShipment] = UNSET
    r"""The API resource URL of the [shipment](get-shipment) this capture is associated with. Not present if
    it isn't associated with a shipment.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["settlement", "shipment"]
        nullable_fields = ["settlement", "shipment"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListSettlementCapturesCaptureTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a capture object. Will always contain the string `capture` for this endpoint."""
    id: str
    r"""The identifier uniquely referring to this capture. Example: `cpt_mNepDkEtco6ah3QNPUGYH`."""
    mode: ListSettlementCapturesMode
    r"""Whether this entity was created in live mode or in test mode."""
    amount: Nullable[ListSettlementCapturesAmountTypedDict]
    r"""The amount captured. If no amount is provided, the full authorized amount is captured."""
    status: ListSettlementCapturesStatus
    r"""The capture's status."""
    payment_id: str
    r"""The unique identifier of the payment this capture was created for. For example: `tr_5B8cwPMGnU6qLbRvo7qEZo`.
    The full payment object can be retrieved via the payment URL in the `_links` object.
    """
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: ListSettlementCapturesCaptureLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    description: NotRequired[str]
    r"""The description of the capture."""
    settlement_amount: NotRequired[
        Nullable[ListSettlementCapturesSettlementAmountTypedDict]
    ]
    r"""This optional field will contain the approximate amount that will be settled to your account, converted to the
    currency your account is settled in.

    Since the field contains an estimated amount during capture processing, it may change over time. To retrieve
    accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions)
    instead.
    """
    metadata: NotRequired[Nullable[ListSettlementCapturesMetadataTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """
    shipment_id: NotRequired[Nullable[str]]
    r"""The unique identifier of the shipment that triggered the creation of this capture, if applicable. For example:
    `shp_gNapNy9qQTUFZYnCrCF7J`.
    """
    settlement_id: NotRequired[Nullable[str]]
    r"""The identifier referring to the settlement this capture was settled with. For example, `stl_BkEjN2eBb`. This field
    is omitted if the capture is not settled (yet).
    """


class ListSettlementCapturesCapture(BaseModel):
    resource: str
    r"""Indicates the response contains a capture object. Will always contain the string `capture` for this endpoint."""

    id: str
    r"""The identifier uniquely referring to this capture. Example: `cpt_mNepDkEtco6ah3QNPUGYH`."""

    mode: ListSettlementCapturesMode
    r"""Whether this entity was created in live mode or in test mode."""

    amount: Nullable[ListSettlementCapturesAmount]
    r"""The amount captured. If no amount is provided, the full authorized amount is captured."""

    status: ListSettlementCapturesStatus
    r"""The capture's status."""

    payment_id: Annotated[str, pydantic.Field(alias="paymentId")]
    r"""The unique identifier of the payment this capture was created for. For example: `tr_5B8cwPMGnU6qLbRvo7qEZo`.
    The full payment object can be retrieved via the payment URL in the `_links` object.
    """

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[ListSettlementCapturesCaptureLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    description: Optional[str] = None
    r"""The description of the capture."""

    settlement_amount: Annotated[
        OptionalNullable[ListSettlementCapturesSettlementAmount],
        pydantic.Field(alias="settlementAmount"),
    ] = UNSET
    r"""This optional field will contain the approximate amount that will be settled to your account, converted to the
    currency your account is settled in.

    Since the field contains an estimated amount during capture processing, it may change over time. To retrieve
    accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions)
    instead.
    """

    metadata: OptionalNullable[ListSettlementCapturesMetadata] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """

    shipment_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="shipmentId")
    ] = UNSET
    r"""The unique identifier of the shipment that triggered the creation of this capture, if applicable. For example:
    `shp_gNapNy9qQTUFZYnCrCF7J`.
    """

    settlement_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="settlementId")
    ] = UNSET
    r"""The identifier referring to the settlement this capture was settled with. For example, `stl_BkEjN2eBb`. This field
    is omitted if the capture is not settled (yet).
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "description",
            "settlementAmount",
            "metadata",
            "shipmentId",
            "settlementId",
        ]
        nullable_fields = [
            "amount",
            "settlementAmount",
            "metadata",
            "shipmentId",
            "settlementId",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListSettlementCapturesEmbeddedTypedDict(TypedDict):
    captures: NotRequired[List[ListSettlementCapturesCaptureTypedDict]]
    r"""An array of capture objects."""


class ListSettlementCapturesEmbedded(BaseModel):
    captures: Optional[List[ListSettlementCapturesCapture]] = None
    r"""An array of capture objects."""


class ListSettlementCapturesSelfTypedDict(TypedDict):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementCapturesSelf(BaseModel):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementCapturesPreviousTypedDict(TypedDict):
    r"""The previous set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementCapturesPrevious(BaseModel):
    r"""The previous set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementCapturesNextTypedDict(TypedDict):
    r"""The next set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementCapturesNext(BaseModel):
    r"""The next set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementCapturesDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementCapturesDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListSettlementCapturesLinksTypedDict(TypedDict):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: ListSettlementCapturesSelfTypedDict
    r"""The URL to the current set of items."""
    previous: Nullable[ListSettlementCapturesPreviousTypedDict]
    r"""The previous set of items, if available."""
    next: Nullable[ListSettlementCapturesNextTypedDict]
    r"""The next set of items, if available."""
    documentation: ListSettlementCapturesDocumentationTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListSettlementCapturesLinks(BaseModel):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[ListSettlementCapturesSelf, pydantic.Field(alias="self")]
    r"""The URL to the current set of items."""

    previous: Nullable[ListSettlementCapturesPrevious]
    r"""The previous set of items, if available."""

    next: Nullable[ListSettlementCapturesNext]
    r"""The next set of items, if available."""

    documentation: ListSettlementCapturesDocumentation
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["previous", "next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListSettlementCapturesResponseTypedDict(TypedDict):
    r"""A list of capture objects."""

    count: NotRequired[int]
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """
    embedded: NotRequired[ListSettlementCapturesEmbeddedTypedDict]
    links: NotRequired[ListSettlementCapturesLinksTypedDict]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class ListSettlementCapturesResponse(BaseModel):
    r"""A list of capture objects."""

    count: Optional[int] = None
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """

    embedded: Annotated[
        Optional[ListSettlementCapturesEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[
        Optional[ListSettlementCapturesLinks], pydantic.Field(alias="_links")
    ] = None
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
