# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_alerts200_response_all_of_alerts_inner_contacts_inner import ListAlerts200ResponseAllOfAlertsInnerContactsInner
from typing import Optional, Set
from typing_extensions import Self

class AddAlertsRequestAlert(BaseModel):
    """
    Payload for creating a new monitoring alert
    """ # noqa: E501
    name: StrictStr = Field(description="Unique name scoped to your account for the alert")
    min_duration: Optional[StrictInt] = Field(default=0, description="Duration in minutes of the delay before sending notification(s)", alias="minDuration")
    min_severity: Optional[StrictStr] = Field(default='critical', description="Severity level threshold for sending notifications.", alias="minSeverity")
    active: Optional[StrictBool] = Field(default=True, description="Set to false to disable notifications")
    all_checks: Optional[StrictBool] = Field(default=False, description="Trigger for all checks", alias="allChecks")
    all_groups: Optional[StrictBool] = Field(default=False, description="Trigger for all check groups", alias="allGroups")
    all_apps: Optional[StrictBool] = Field(default=False, description="Trigger for all monitor apps", alias="allApps")
    checks: Optional[List[StrictInt]] = None
    groups: Optional[List[StrictInt]] = None
    apps: Optional[List[StrictInt]] = None
    contacts: Optional[List[ListAlerts200ResponseAllOfAlertsInnerContactsInner]] = None
    __properties: ClassVar[List[str]] = ["name", "minDuration", "minSeverity", "active", "allChecks", "allGroups", "allApps", "checks", "groups", "apps", "contacts"]

    @field_validator('min_severity')
    def min_severity_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['info', 'warning', 'critical']):
            raise ValueError("must be one of enum values ('info', 'warning', 'critical')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddAlertsRequestAlert from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in contacts (list)
        _items = []
        if self.contacts:
            for _item_contacts in self.contacts:
                if _item_contacts:
                    _items.append(_item_contacts.to_dict())
            _dict['contacts'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddAlertsRequestAlert from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "minDuration": obj.get("minDuration") if obj.get("minDuration") is not None else 0,
            "minSeverity": obj.get("minSeverity") if obj.get("minSeverity") is not None else 'critical',
            "active": obj.get("active") if obj.get("active") is not None else True,
            "allChecks": obj.get("allChecks") if obj.get("allChecks") is not None else False,
            "allGroups": obj.get("allGroups") if obj.get("allGroups") is not None else False,
            "allApps": obj.get("allApps") if obj.get("allApps") is not None else False,
            "checks": obj.get("checks"),
            "groups": obj.get("groups"),
            "apps": obj.get("apps"),
            "contacts": [ListAlerts200ResponseAllOfAlertsInnerContactsInner.from_dict(_item) for _item in obj["contacts"]] if obj.get("contacts") is not None else None
        })
        return _obj


