# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_activity200_response_all_of_activity_inner_activity_inner_user import ListActivity200ResponseAllOfActivityInnerActivityInnerUser
from morpheus.models.list_apps200_response_all_of_apps_inner_blueprint import ListApps200ResponseAllOfAppsInnerBlueprint
from typing import Optional, Set
from typing_extensions import Self

class AddApps200ResponseApp(BaseModel):
    """
    AddApps200ResponseApp
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    labels: Optional[List[StrictStr]] = None
    environment: Optional[StrictStr] = None
    account_id: Optional[StrictInt] = Field(default=None, alias="accountId")
    account: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    owner: Optional[ListActivity200ResponseAllOfActivityInnerActivityInnerUser] = None
    site_id: Optional[StrictInt] = Field(default=None, alias="siteId")
    group: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    blueprint: Optional[ListApps200ResponseAllOfAppsInnerBlueprint] = None
    type: Optional[StrictStr] = None
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    removal_date: Optional[datetime] = Field(default=None, alias="removalDate")
    app_context: Optional[StrictStr] = Field(default=None, alias="appContext")
    status: Optional[StrictStr] = None
    app_status: Optional[StrictStr] = Field(default=None, alias="appStatus")
    instance_count: Optional[StrictInt] = Field(default=None, alias="instanceCount")
    container_count: Optional[StrictInt] = Field(default=None, alias="containerCount")
    app_tiers: Optional[List[Dict[str, Any]]] = Field(default=None, alias="appTiers")
    instances: Optional[List[GetAlerts200ResponseAllOfCheckGroupsInnerInstance]] = None
    __properties: ClassVar[List[str]] = ["id", "name", "description", "labels", "environment", "accountId", "account", "owner", "siteId", "group", "blueprint", "type", "dateCreated", "lastUpdated", "removalDate", "appContext", "status", "appStatus", "instanceCount", "containerCount", "appTiers", "instances"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddApps200ResponseApp from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of group
        if self.group:
            _dict['group'] = self.group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of blueprint
        if self.blueprint:
            _dict['blueprint'] = self.blueprint.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in instances (list)
        _items = []
        if self.instances:
            for _item_instances in self.instances:
                if _item_instances:
                    _items.append(_item_instances.to_dict())
            _dict['instances'] = _items
        # set to None if removal_date (nullable) is None
        # and model_fields_set contains the field
        if self.removal_date is None and "removal_date" in self.model_fields_set:
            _dict['removalDate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddApps200ResponseApp from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "labels": obj.get("labels"),
            "environment": obj.get("environment"),
            "accountId": obj.get("accountId"),
            "account": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "owner": ListActivity200ResponseAllOfActivityInnerActivityInnerUser.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "siteId": obj.get("siteId"),
            "group": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["group"]) if obj.get("group") is not None else None,
            "blueprint": ListApps200ResponseAllOfAppsInnerBlueprint.from_dict(obj["blueprint"]) if obj.get("blueprint") is not None else None,
            "type": obj.get("type"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "removalDate": obj.get("removalDate"),
            "appContext": obj.get("appContext"),
            "status": obj.get("status"),
            "appStatus": obj.get("appStatus"),
            "instanceCount": obj.get("instanceCount"),
            "containerCount": obj.get("containerCount"),
            "appTiers": obj.get("appTiers"),
            "instances": [GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(_item) for _item in obj["instances"]] if obj.get("instances") is not None else None
        })
        return _obj


