# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_blueprint200_response_all_of_blueprint_config_one_of1_cloud_formation import AddBlueprint200ResponseAllOfBlueprintConfigOneOf1CloudFormation
from typing import Optional, Set
from typing_extensions import Self

class AddBlueprint200ResponseAllOfBlueprintConfigOneOf1(BaseModel):
    """
    AddBlueprint200ResponseAllOfBlueprintConfigOneOf1
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="A name for the blueprint")
    image: Optional[StrictStr] = Field(default=None, description="Path to display image. Defaults to an internal Morpheus image.")
    type: Optional[StrictStr] = Field(default=None, description="Blueprint Type")
    cloud_formation: Optional[AddBlueprint200ResponseAllOfBlueprintConfigOneOf1CloudFormation] = Field(default=None, alias="cloudFormation")
    visibility: Optional[StrictStr] = Field(default='private', description="Private or Public Access")
    resource_permission: Optional[Dict[str, Any]] = Field(default=None, description="Resource Permission Block", alias="resourcePermission")
    owner: Optional[Dict[str, Any]] = Field(default=None, description="Owner")
    tenant: Optional[Dict[str, Any]] = Field(default=None, description="Tenant")
    __properties: ClassVar[List[str]] = ["name", "image", "type", "cloudFormation", "visibility", "resourcePermission", "owner", "tenant"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['cloudFormation']):
            raise ValueError("must be one of enum values ('cloudFormation')")
        return value

    @field_validator('visibility')
    def visibility_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['private', 'public']):
            raise ValueError("must be one of enum values ('private', 'public')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddBlueprint200ResponseAllOfBlueprintConfigOneOf1 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cloud_formation
        if self.cloud_formation:
            _dict['cloudFormation'] = self.cloud_formation.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddBlueprint200ResponseAllOfBlueprintConfigOneOf1 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "image": obj.get("image"),
            "type": obj.get("type"),
            "cloudFormation": AddBlueprint200ResponseAllOfBlueprintConfigOneOf1CloudFormation.from_dict(obj["cloudFormation"]) if obj.get("cloudFormation") is not None else None,
            "visibility": obj.get("visibility") if obj.get("visibility") is not None else 'private',
            "resourcePermission": obj.get("resourcePermission"),
            "owner": obj.get("owner"),
            "tenant": obj.get("tenant")
        })
        return _obj


