# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_blueprint200_response_all_of_blueprint_config_one_of1_cloud_formation_capabilityautoexpand import AddBlueprint200ResponseAllOfBlueprintConfigOneOf1CloudFormationCAPABILITYAUTOEXPAND
from morpheus.models.add_blueprint200_response_all_of_blueprint_config_one_of1_cloud_formation_capabilitynamediam import AddBlueprint200ResponseAllOfBlueprintConfigOneOf1CloudFormationCAPABILITYNAMEDIAM
from morpheus.models.add_blueprint200_response_all_of_blueprint_config_one_of1_cloud_formation_iam import AddBlueprint200ResponseAllOfBlueprintConfigOneOf1CloudFormationIAM
from morpheus.models.add_blueprint_request_one_of1_cloud_formation_git import AddBlueprintRequestOneOf1CloudFormationGit
from morpheus.models.add_blueprint_request_one_of_arm_cloud_init_enabled import AddBlueprintRequestOneOfArmCloudInitEnabled
from morpheus.models.add_blueprint_request_one_of_arm_install_agent import AddBlueprintRequestOneOfArmInstallAgent
from typing import Optional, Set
from typing_extensions import Self

class AddBlueprint200ResponseAllOfBlueprintConfigOneOf1CloudFormation(BaseModel):
    """
    AddBlueprint200ResponseAllOfBlueprintConfigOneOf1CloudFormation
    """ # noqa: E501
    config_type: StrictStr = Field(description="Configuration Type", alias="configType")
    var_json: Optional[StrictStr] = Field(default=None, description="CloudFormation Template in JSON", alias="json")
    yaml: Optional[StrictStr] = Field(default=None, description="CloudFormation Template in YAML")
    git: Optional[AddBlueprintRequestOneOf1CloudFormationGit] = None
    iam: Optional[AddBlueprint200ResponseAllOfBlueprintConfigOneOf1CloudFormationIAM] = Field(default=None, alias="IAM")
    capability_named_iam: Optional[AddBlueprint200ResponseAllOfBlueprintConfigOneOf1CloudFormationCAPABILITYNAMEDIAM] = Field(default=None, alias="CAPABILITY_NAMED_IAM")
    capability_auto_expand: Optional[AddBlueprint200ResponseAllOfBlueprintConfigOneOf1CloudFormationCAPABILITYAUTOEXPAND] = Field(default=None, alias="CAPABILITY_AUTO_EXPAND")
    install_agent: Optional[AddBlueprintRequestOneOfArmInstallAgent] = Field(default=None, alias="installAgent")
    cloud_init_enabled: Optional[AddBlueprintRequestOneOfArmCloudInitEnabled] = Field(default=None, alias="cloudInitEnabled")
    __properties: ClassVar[List[str]] = ["configType", "json", "yaml", "git", "IAM", "CAPABILITY_NAMED_IAM", "CAPABILITY_AUTO_EXPAND", "installAgent", "cloudInitEnabled"]

    @field_validator('config_type')
    def config_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['json', 'yaml', 'git']):
            raise ValueError("must be one of enum values ('json', 'yaml', 'git')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddBlueprint200ResponseAllOfBlueprintConfigOneOf1CloudFormation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of git
        if self.git:
            _dict['git'] = self.git.to_dict()
        # override the default output from pydantic by calling `to_dict()` of iam
        if self.iam:
            _dict['IAM'] = self.iam.to_dict()
        # override the default output from pydantic by calling `to_dict()` of capability_named_iam
        if self.capability_named_iam:
            _dict['CAPABILITY_NAMED_IAM'] = self.capability_named_iam.to_dict()
        # override the default output from pydantic by calling `to_dict()` of capability_auto_expand
        if self.capability_auto_expand:
            _dict['CAPABILITY_AUTO_EXPAND'] = self.capability_auto_expand.to_dict()
        # override the default output from pydantic by calling `to_dict()` of install_agent
        if self.install_agent:
            _dict['installAgent'] = self.install_agent.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cloud_init_enabled
        if self.cloud_init_enabled:
            _dict['cloudInitEnabled'] = self.cloud_init_enabled.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddBlueprint200ResponseAllOfBlueprintConfigOneOf1CloudFormation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "configType": obj.get("configType"),
            "json": obj.get("json"),
            "yaml": obj.get("yaml"),
            "git": AddBlueprintRequestOneOf1CloudFormationGit.from_dict(obj["git"]) if obj.get("git") is not None else None,
            "IAM": AddBlueprint200ResponseAllOfBlueprintConfigOneOf1CloudFormationIAM.from_dict(obj["IAM"]) if obj.get("IAM") is not None else None,
            "CAPABILITY_NAMED_IAM": AddBlueprint200ResponseAllOfBlueprintConfigOneOf1CloudFormationCAPABILITYNAMEDIAM.from_dict(obj["CAPABILITY_NAMED_IAM"]) if obj.get("CAPABILITY_NAMED_IAM") is not None else None,
            "CAPABILITY_AUTO_EXPAND": AddBlueprint200ResponseAllOfBlueprintConfigOneOf1CloudFormationCAPABILITYAUTOEXPAND.from_dict(obj["CAPABILITY_AUTO_EXPAND"]) if obj.get("CAPABILITY_AUTO_EXPAND") is not None else None,
            "installAgent": AddBlueprintRequestOneOfArmInstallAgent.from_dict(obj["installAgent"]) if obj.get("installAgent") is not None else None,
            "cloudInitEnabled": AddBlueprintRequestOneOfArmCloudInitEnabled.from_dict(obj["cloudInitEnabled"]) if obj.get("cloudInitEnabled") is not None else None
        })
        return _obj


