# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from morpheus.models.add_blueprint_request_one_of import AddBlueprintRequestOneOf
from morpheus.models.add_blueprint_request_one_of1 import AddBlueprintRequestOneOf1
from morpheus.models.add_blueprint_request_one_of2 import AddBlueprintRequestOneOf2
from morpheus.models.add_blueprint_request_one_of3 import AddBlueprintRequestOneOf3
from morpheus.models.add_blueprint_request_one_of4 import AddBlueprintRequestOneOf4
from morpheus.models.add_blueprint_request_one_of5 import AddBlueprintRequestOneOf5
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

ADDBLUEPRINTREQUEST_ONE_OF_SCHEMAS = ["AddBlueprintRequestOneOf", "AddBlueprintRequestOneOf1", "AddBlueprintRequestOneOf2", "AddBlueprintRequestOneOf3", "AddBlueprintRequestOneOf4", "AddBlueprintRequestOneOf5"]

class AddBlueprintRequest(BaseModel):
    """
    AddBlueprintRequest
    """
    # data type: AddBlueprintRequestOneOf
    oneof_schema_1_validator: Optional[AddBlueprintRequestOneOf] = None
    # data type: AddBlueprintRequestOneOf1
    oneof_schema_2_validator: Optional[AddBlueprintRequestOneOf1] = None
    # data type: AddBlueprintRequestOneOf2
    oneof_schema_3_validator: Optional[AddBlueprintRequestOneOf2] = None
    # data type: AddBlueprintRequestOneOf3
    oneof_schema_4_validator: Optional[AddBlueprintRequestOneOf3] = None
    # data type: AddBlueprintRequestOneOf4
    oneof_schema_5_validator: Optional[AddBlueprintRequestOneOf4] = None
    # data type: AddBlueprintRequestOneOf5
    oneof_schema_6_validator: Optional[AddBlueprintRequestOneOf5] = None
    actual_instance: Optional[Union[AddBlueprintRequestOneOf, AddBlueprintRequestOneOf1, AddBlueprintRequestOneOf2, AddBlueprintRequestOneOf3, AddBlueprintRequestOneOf4, AddBlueprintRequestOneOf5]] = None
    one_of_schemas: Set[str] = { "AddBlueprintRequestOneOf", "AddBlueprintRequestOneOf1", "AddBlueprintRequestOneOf2", "AddBlueprintRequestOneOf3", "AddBlueprintRequestOneOf4", "AddBlueprintRequestOneOf5" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = AddBlueprintRequest.model_construct()
        error_messages = []
        match = 0
        # validate data type: AddBlueprintRequestOneOf
        if not isinstance(v, AddBlueprintRequestOneOf):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddBlueprintRequestOneOf`")
        else:
            match += 1
        # validate data type: AddBlueprintRequestOneOf1
        if not isinstance(v, AddBlueprintRequestOneOf1):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddBlueprintRequestOneOf1`")
        else:
            match += 1
        # validate data type: AddBlueprintRequestOneOf2
        if not isinstance(v, AddBlueprintRequestOneOf2):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddBlueprintRequestOneOf2`")
        else:
            match += 1
        # validate data type: AddBlueprintRequestOneOf3
        if not isinstance(v, AddBlueprintRequestOneOf3):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddBlueprintRequestOneOf3`")
        else:
            match += 1
        # validate data type: AddBlueprintRequestOneOf4
        if not isinstance(v, AddBlueprintRequestOneOf4):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddBlueprintRequestOneOf4`")
        else:
            match += 1
        # validate data type: AddBlueprintRequestOneOf5
        if not isinstance(v, AddBlueprintRequestOneOf5):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddBlueprintRequestOneOf5`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in AddBlueprintRequest with oneOf schemas: AddBlueprintRequestOneOf, AddBlueprintRequestOneOf1, AddBlueprintRequestOneOf2, AddBlueprintRequestOneOf3, AddBlueprintRequestOneOf4, AddBlueprintRequestOneOf5. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in AddBlueprintRequest with oneOf schemas: AddBlueprintRequestOneOf, AddBlueprintRequestOneOf1, AddBlueprintRequestOneOf2, AddBlueprintRequestOneOf3, AddBlueprintRequestOneOf4, AddBlueprintRequestOneOf5. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into AddBlueprintRequestOneOf
        try:
            instance.actual_instance = AddBlueprintRequestOneOf.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddBlueprintRequestOneOf1
        try:
            instance.actual_instance = AddBlueprintRequestOneOf1.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddBlueprintRequestOneOf2
        try:
            instance.actual_instance = AddBlueprintRequestOneOf2.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddBlueprintRequestOneOf3
        try:
            instance.actual_instance = AddBlueprintRequestOneOf3.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddBlueprintRequestOneOf4
        try:
            instance.actual_instance = AddBlueprintRequestOneOf4.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddBlueprintRequestOneOf5
        try:
            instance.actual_instance = AddBlueprintRequestOneOf5.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into AddBlueprintRequest with oneOf schemas: AddBlueprintRequestOneOf, AddBlueprintRequestOneOf1, AddBlueprintRequestOneOf2, AddBlueprintRequestOneOf3, AddBlueprintRequestOneOf4, AddBlueprintRequestOneOf5. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into AddBlueprintRequest with oneOf schemas: AddBlueprintRequestOneOf, AddBlueprintRequestOneOf1, AddBlueprintRequestOneOf2, AddBlueprintRequestOneOf3, AddBlueprintRequestOneOf4, AddBlueprintRequestOneOf5. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], AddBlueprintRequestOneOf, AddBlueprintRequestOneOf1, AddBlueprintRequestOneOf2, AddBlueprintRequestOneOf3, AddBlueprintRequestOneOf4, AddBlueprintRequestOneOf5]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


