# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class AddClusterRequestClusterServerVolumesInner(BaseModel):
    """
    AddClusterRequestClusterServerVolumesInner
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=-1, description="The id for the LV configuration being created")
    root_volume: Optional[StrictBool] = Field(default=True, description="If set to false then a non-root LV will be created", alias="rootVolume")
    name: StrictStr = Field(description="Name/type of the LV being created")
    size: Optional[StrictInt] = Field(default=None, description="Size of the LV to be created in GBs  Default is from the service plan ")
    size_id: Optional[StrictStr] = Field(default=None, description="Can be used to select pre-existing LV choices from Morpheus", alias="sizeId")
    storage_type: Optional[StrictInt] = Field(default=None, description="Identifier for LV type", alias="storageType")
    datastore_id: Optional[StrictStr] = Field(description="The ID of the specific datastore. Auto selection can be specified as auto or `autoCluster` (for clusters).", alias="datastoreId")
    __properties: ClassVar[List[str]] = ["id", "rootVolume", "name", "size", "sizeId", "storageType", "datastoreId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddClusterRequestClusterServerVolumesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if size_id (nullable) is None
        # and model_fields_set contains the field
        if self.size_id is None and "size_id" in self.model_fields_set:
            _dict['sizeId'] = None

        # set to None if datastore_id (nullable) is None
        # and model_fields_set contains the field
        if self.datastore_id is None and "datastore_id" in self.model_fields_set:
            _dict['datastoreId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddClusterRequestClusterServerVolumesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id") if obj.get("id") is not None else -1,
            "rootVolume": obj.get("rootVolume") if obj.get("rootVolume") is not None else True,
            "name": obj.get("name") if obj.get("name") is not None else 'root',
            "size": obj.get("size"),
            "sizeId": obj.get("sizeId"),
            "storageType": obj.get("storageType"),
            "datastoreId": obj.get("datastoreId")
        })
        return _obj


