# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_credentials_request_credential_one_of2_auth_key import AddCredentialsRequestCredentialOneOf2AuthKey
from morpheus.models.add_credentials_request_credential_one_of_integration import AddCredentialsRequestCredentialOneOfIntegration
from typing import Optional, Set
from typing_extensions import Self

class AddCredentialsRequestCredentialOneOf3(BaseModel):
    """
    AddCredentialsRequestCredentialOneOf3
    """ # noqa: E501
    type: StrictStr = Field(description="Credential Type Code")
    name: StrictStr = Field(description="A unique name scoped to your account for the credential")
    description: Optional[StrictStr] = Field(default=None, description="Optional Description")
    enabled: Optional[StrictBool] = Field(default=True, description="Credential enabled")
    integration: Optional[AddCredentialsRequestCredentialOneOfIntegration] = None
    auth_path: StrictStr = Field(description="Tenant name", alias="authPath")
    username: StrictStr = Field(description="Username")
    auth_key: AddCredentialsRequestCredentialOneOf2AuthKey = Field(alias="authKey")
    __properties: ClassVar[List[str]] = ["type", "name", "description", "enabled", "integration", "authPath", "username", "authKey"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['tenant-username-keypair']):
            raise ValueError("must be one of enum values ('tenant-username-keypair')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddCredentialsRequestCredentialOneOf3 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of integration
        if self.integration:
            _dict['integration'] = self.integration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of auth_key
        if self.auth_key:
            _dict['authKey'] = self.auth_key.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddCredentialsRequestCredentialOneOf3 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True,
            "integration": AddCredentialsRequestCredentialOneOfIntegration.from_dict(obj["integration"]) if obj.get("integration") is not None else None,
            "authPath": obj.get("authPath"),
            "username": obj.get("username"),
            "authKey": AddCredentialsRequestCredentialOneOf2AuthKey.from_dict(obj["authKey"]) if obj.get("authKey") is not None else None
        })
        return _obj


