# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_integrations_request_one_of6_integration_config import AddIntegrationsRequestOneOf6IntegrationConfig
from typing import Optional, Set
from typing_extensions import Self

class AddIntegrationsRequestOneOf6Integration(BaseModel):
    """
    AddIntegrationsRequestOneOf6Integration
    """ # noqa: E501
    name: StrictStr = Field(description="Name, a unique identifier for the integration")
    type: StrictStr = Field(description="Integration Type Code")
    service_username: StrictStr = Field(description="Username", alias="serviceUsername")
    service_password: Optional[StrictStr] = Field(default=None, description="Password", alias="servicePassword")
    service_token: Optional[StrictStr] = Field(default=None, description="Access Token", alias="serviceToken")
    service_key: Optional[StrictInt] = Field(default=None, description="Key Pair ID", alias="serviceKey")
    config: Optional[AddIntegrationsRequestOneOf6IntegrationConfig] = None
    __properties: ClassVar[List[str]] = ["name", "type", "serviceUsername", "servicePassword", "serviceToken", "serviceKey", "config"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['github']):
            raise ValueError("must be one of enum values ('github')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddIntegrationsRequestOneOf6Integration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddIntegrationsRequestOneOf6Integration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "type": obj.get("type"),
            "serviceUsername": obj.get("serviceUsername"),
            "servicePassword": obj.get("servicePassword"),
            "serviceToken": obj.get("serviceToken"),
            "serviceKey": obj.get("serviceKey"),
            "config": AddIntegrationsRequestOneOf6IntegrationConfig.from_dict(obj["config"]) if obj.get("config") is not None else None
        })
        return _obj


