# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_option_type_request_option_type_option_list import AddOptionTypeRequestOptionTypeOptionList
from typing import Optional, Set
from typing_extensions import Self

class AddOptionTypeRequestOptionType(BaseModel):
    """
    AddOptionTypeRequestOptionType
    """ # noqa: E501
    name: StrictStr = Field(description="The name of the option type for handy reference")
    description: Optional[StrictStr] = Field(default=None, description="Short description of the option type")
    labels: Optional[List[StrictStr]] = Field(default=None, description="Array of label strings, can be used for filtering.")
    field_name: Optional[StrictStr] = Field(default=None, description="Field Name, the name for user input. This along with fieldContext determines the configuration property name.  The property key for when posting this option type to a JSON POST request", alias="fieldName")
    type: Optional[StrictStr] = Field(default='text', description="Type, the type of input. eg. text, checkbox, select, etc.")
    field_label: Optional[StrictStr] = Field(default=None, description="Field Label, the label for user input.", alias="fieldLabel")
    place_holder: Optional[StrictStr] = Field(default=None, description="Any placeholder text when nothing is yet entered", alias="placeHolder")
    verify_pattern: Optional[StrictStr] = Field(default=None, description="Verify Pattern, A regexp string that validates the input, use (?i) to make the matcher case insensitive", alias="verifyPattern")
    default_value: Optional[StrictStr] = Field(default=None, description="The default value if no user entry is specified. This value should be passed to the desired JSON Map if nothing else is entered", alias="defaultValue")
    required: Optional[StrictBool] = Field(default=False, description="Is this field entry required for the request")
    export_meta: Optional[StrictBool] = Field(default=False, description="Export as Tag", alias="exportMeta")
    editable: Optional[StrictBool] = Field(default=False, description="Used primarily on tasks and workflows. Basically wether or not the field can be overridden optionally when the object is run")
    option_list: Optional[AddOptionTypeRequestOptionTypeOptionList] = Field(default=None, alias="optionList")
    __properties: ClassVar[List[str]] = ["name", "description", "labels", "fieldName", "type", "fieldLabel", "placeHolder", "verifyPattern", "defaultValue", "required", "exportMeta", "editable", "optionList"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddOptionTypeRequestOptionType from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of option_list
        if self.option_list:
            _dict['optionList'] = self.option_list.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict['labels'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddOptionTypeRequestOptionType from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "labels": obj.get("labels"),
            "fieldName": obj.get("fieldName"),
            "type": obj.get("type") if obj.get("type") is not None else 'text',
            "fieldLabel": obj.get("fieldLabel"),
            "placeHolder": obj.get("placeHolder"),
            "verifyPattern": obj.get("verifyPattern"),
            "defaultValue": obj.get("defaultValue"),
            "required": obj.get("required") if obj.get("required") is not None else False,
            "exportMeta": obj.get("exportMeta") if obj.get("exportMeta") is not None else False,
            "editable": obj.get("editable") if obj.get("editable") is not None else False,
            "optionList": AddOptionTypeRequestOptionTypeOptionList.from_dict(obj["optionList"]) if obj.get("optionList") is not None else None
        })
        return _obj


