# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from morpheus.models.custom_options_for_amazon import CustomOptionsForAmazon
from morpheus.models.custom_options_for_azure import CustomOptionsForAzure
from morpheus.models.custom_options_for_openstack_open_telekom_huawei import CustomOptionsForOpenstackOpenTelekomHuawei
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

ADDSECURITYGROUPSREQUESTSECURITYGROUPCUSTOMOPTIONS_ANY_OF_SCHEMAS = ["CustomOptionsForAmazon", "CustomOptionsForAzure", "CustomOptionsForOpenstackOpenTelekomHuawei"]

class AddSecurityGroupsRequestSecurityGroupCustomOptions(BaseModel):
    """
    AddSecurityGroupsRequestSecurityGroupCustomOptions
    """

    # data type: CustomOptionsForAzure
    anyof_schema_1_validator: Optional[CustomOptionsForAzure] = None
    # data type: CustomOptionsForAmazon
    anyof_schema_2_validator: Optional[CustomOptionsForAmazon] = None
    # data type: CustomOptionsForOpenstackOpenTelekomHuawei
    anyof_schema_3_validator: Optional[CustomOptionsForOpenstackOpenTelekomHuawei] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[CustomOptionsForAmazon, CustomOptionsForAzure, CustomOptionsForOpenstackOpenTelekomHuawei]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "CustomOptionsForAmazon", "CustomOptionsForAzure", "CustomOptionsForOpenstackOpenTelekomHuawei" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = AddSecurityGroupsRequestSecurityGroupCustomOptions.model_construct()
        error_messages = []
        # validate data type: CustomOptionsForAzure
        if not isinstance(v, CustomOptionsForAzure):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CustomOptionsForAzure`")
        else:
            return v

        # validate data type: CustomOptionsForAmazon
        if not isinstance(v, CustomOptionsForAmazon):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CustomOptionsForAmazon`")
        else:
            return v

        # validate data type: CustomOptionsForOpenstackOpenTelekomHuawei
        if not isinstance(v, CustomOptionsForOpenstackOpenTelekomHuawei):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CustomOptionsForOpenstackOpenTelekomHuawei`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in AddSecurityGroupsRequestSecurityGroupCustomOptions with anyOf schemas: CustomOptionsForAmazon, CustomOptionsForAzure, CustomOptionsForOpenstackOpenTelekomHuawei. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[CustomOptionsForAzure] = None
        try:
            instance.actual_instance = CustomOptionsForAzure.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[CustomOptionsForAmazon] = None
        try:
            instance.actual_instance = CustomOptionsForAmazon.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[CustomOptionsForOpenstackOpenTelekomHuawei] = None
        try:
            instance.actual_instance = CustomOptionsForOpenstackOpenTelekomHuawei.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into AddSecurityGroupsRequestSecurityGroupCustomOptions with anyOf schemas: CustomOptionsForAmazon, CustomOptionsForAzure, CustomOptionsForOpenstackOpenTelekomHuawei. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], CustomOptionsForAmazon, CustomOptionsForAzure, CustomOptionsForOpenstackOpenTelekomHuawei]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


