# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.create_network_proxy_request_network_proxy_account import CreateNetworkProxyRequestNetworkProxyAccount
from typing import Optional, Set
from typing_extensions import Self

class CreateNetworkProxyRequestNetworkProxy(BaseModel):
    """
    CreateNetworkProxyRequestNetworkProxy
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Name")
    proxy_host: Optional[StrictStr] = Field(default=None, description="Proxy Host", alias="proxyHost")
    proxy_port: Optional[StrictStr] = Field(default=None, description="Proxy Port", alias="proxyPort")
    proxy_user: Optional[StrictStr] = Field(default=None, description="Proxy Username", alias="proxyUser")
    proxy_password: Optional[StrictStr] = Field(default=None, description="Proxy Password", alias="proxyPassword")
    proxy_domain: Optional[StrictStr] = Field(default=None, description="Proxy Domain", alias="proxyDomain")
    proxy_workstation: Optional[StrictStr] = Field(default=None, description="Proxy Workstation", alias="proxyWorkstation")
    visibility: Optional[StrictStr] = Field(default='private', description="Visibility")
    account: Optional[CreateNetworkProxyRequestNetworkProxyAccount] = None
    __properties: ClassVar[List[str]] = ["name", "proxyHost", "proxyPort", "proxyUser", "proxyPassword", "proxyDomain", "proxyWorkstation", "visibility", "account"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateNetworkProxyRequestNetworkProxy from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateNetworkProxyRequestNetworkProxy from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "proxyHost": obj.get("proxyHost"),
            "proxyPort": obj.get("proxyPort"),
            "proxyUser": obj.get("proxyUser"),
            "proxyPassword": obj.get("proxyPassword"),
            "proxyDomain": obj.get("proxyDomain"),
            "proxyWorkstation": obj.get("proxyWorkstation"),
            "visibility": obj.get("visibility") if obj.get("visibility") is not None else 'private',
            "account": CreateNetworkProxyRequestNetworkProxyAccount.from_dict(obj["account"]) if obj.get("account") is not None else None
        })
        return _obj


