# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class DeploymentVersionCreate(BaseModel):
    """
    DeploymentVersionCreate
    """ # noqa: E501
    version: Optional[StrictStr] = Field(default=None, description="Version number (userVersion), a unique version identifier for the deployment version.")
    user_version: Optional[StrictStr] = Field(default=None, description="Alias for version", alias="userVersion")
    deploy_type: Optional[StrictStr] = Field(default=None, description="Deploy Type, eg. file, git, fetch", alias="deployType")
    git_url: Optional[StrictStr] = Field(default=None, alias="gitUrl")
    git_ref: Optional[StrictStr] = Field(default=None, alias="gitRef")
    fetch_url: Optional[StrictStr] = Field(default=None, alias="fetchUrl")
    __properties: ClassVar[List[str]] = ["version", "userVersion", "deployType", "gitUrl", "gitRef", "fetchUrl"]

    @field_validator('deploy_type')
    def deploy_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['file', 'git', 'fetch']):
            raise ValueError("must be one of enum values ('file', 'git', 'fetch')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DeploymentVersionCreate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if git_url (nullable) is None
        # and model_fields_set contains the field
        if self.git_url is None and "git_url" in self.model_fields_set:
            _dict['gitUrl'] = None

        # set to None if git_ref (nullable) is None
        # and model_fields_set contains the field
        if self.git_ref is None and "git_ref" in self.model_fields_set:
            _dict['gitRef'] = None

        # set to None if fetch_url (nullable) is None
        # and model_fields_set contains the field
        if self.fetch_url is None and "fetch_url" in self.model_fields_set:
            _dict['fetchUrl'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DeploymentVersionCreate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "version": obj.get("version"),
            "userVersion": obj.get("userVersion"),
            "deployType": obj.get("deployType"),
            "gitUrl": obj.get("gitUrl"),
            "gitRef": obj.get("gitRef"),
            "fetchUrl": obj.get("fetchUrl")
        })
        return _obj


