# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class GetAlerts200ResponseAllOfChecksInnerConfigAnyOf(BaseModel):
    """
    GetAlerts200ResponseAllOfChecksInnerConfigAnyOf
    """ # noqa: E501
    web_method: StrictStr = Field(description="HTTP method to use for testing", alias="webMethod")
    web_url: StrictStr = Field(description="Web URL you wish to use to run a check on", alias="webUrl")
    ignore_ssl: Optional[StrictBool] = Field(default=False, description="Ignore SSL Errors", alias="ignoreSSL")
    check_user: Optional[StrictStr] = Field(default=None, description="If you want to use HTTP Basic Authentication, populate this field with the username", alias="checkUser")
    check_password: Optional[StrictStr] = Field(default=None, description="If you want to use HTTP basic Authentication, populate this field with the password", alias="checkPassword")
    text_check_on: Optional[StrictStr] = Field(default=None, description="Set value to `on` if you want to turn on text matching", alias="textCheckOn")
    web_text_match: Optional[StrictStr] = Field(default=None, description="Set the string you want to look for in the page source", alias="webTextMatch")
    tunnel_on: Optional[StrictStr] = Field(default=None, description="Set to on to turn on tunneling", alias="tunnelOn")
    ssh_host: Optional[StrictStr] = Field(default=None, description="Hostname or IP address of the proxy host", alias="sshHost")
    ssh_port: Optional[StrictInt] = Field(default=None, description="Port for SSH on the proxy host, defaults to 22", alias="sshPort")
    ssh_user: Optional[StrictStr] = Field(default=None, description="SSH user on the proxy host to login as", alias="sshUser")
    ssh_password: Optional[StrictStr] = Field(default=None, description="Password for user, if not using key based authentication", alias="sshPassword")
    __properties: ClassVar[List[str]] = ["webMethod", "webUrl", "ignoreSSL", "checkUser", "checkPassword", "textCheckOn", "webTextMatch", "tunnelOn", "sshHost", "sshPort", "sshUser", "sshPassword"]

    @field_validator('web_method')
    def web_method_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['GET', 'POST']):
            raise ValueError("must be one of enum values ('GET', 'POST')")
        return value

    @field_validator('tunnel_on')
    def tunnel_on_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['on', 'off']):
            raise ValueError("must be one of enum values ('on', 'off')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetAlerts200ResponseAllOfChecksInnerConfigAnyOf from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetAlerts200ResponseAllOfChecksInnerConfigAnyOf from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "webMethod": obj.get("webMethod"),
            "webUrl": obj.get("webUrl"),
            "ignoreSSL": obj.get("ignoreSSL") if obj.get("ignoreSSL") is not None else False,
            "checkUser": obj.get("checkUser"),
            "checkPassword": obj.get("checkPassword"),
            "textCheckOn": obj.get("textCheckOn"),
            "webTextMatch": obj.get("webTextMatch"),
            "tunnelOn": obj.get("tunnelOn"),
            "sshHost": obj.get("sshHost"),
            "sshPort": obj.get("sshPort"),
            "sshUser": obj.get("sshUser"),
            "sshPassword": obj.get("sshPassword")
        })
        return _obj


