# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_app_state200_response_all_of_input_data_inner import GetAppState200ResponseAllOfInputDataInner
from morpheus.models.get_app_state200_response_all_of_input_providers_inner import GetAppState200ResponseAllOfInputProvidersInner
from morpheus.models.get_app_state200_response_all_of_input_variables_inner import GetAppState200ResponseAllOfInputVariablesInner
from typing import Optional, Set
from typing_extensions import Self

class GetAppState200ResponseAllOfInput(BaseModel):
    """
    GetAppState200ResponseAllOfInput
    """ # noqa: E501
    variables: Optional[List[GetAppState200ResponseAllOfInputVariablesInner]] = None
    providers: Optional[List[GetAppState200ResponseAllOfInputProvidersInner]] = None
    data: Optional[List[GetAppState200ResponseAllOfInputDataInner]] = None
    __properties: ClassVar[List[str]] = ["variables", "providers", "data"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetAppState200ResponseAllOfInput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in variables (list)
        _items = []
        if self.variables:
            for _item_variables in self.variables:
                if _item_variables:
                    _items.append(_item_variables.to_dict())
            _dict['variables'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in providers (list)
        _items = []
        if self.providers:
            for _item_providers in self.providers:
                if _item_providers:
                    _items.append(_item_providers.to_dict())
            _dict['providers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in data (list)
        _items = []
        if self.data:
            for _item_data in self.data:
                if _item_data:
                    _items.append(_item_data.to_dict())
            _dict['data'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetAppState200ResponseAllOfInput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "variables": [GetAppState200ResponseAllOfInputVariablesInner.from_dict(_item) for _item in obj["variables"]] if obj.get("variables") is not None else None,
            "providers": [GetAppState200ResponseAllOfInputProvidersInner.from_dict(_item) for _item in obj["providers"]] if obj.get("providers") is not None else None,
            "data": [GetAppState200ResponseAllOfInputDataInner.from_dict(_item) for _item in obj["data"]] if obj.get("data") is not None else None
        })
        return _obj


