# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_archive_bucket200_response_archive_files_inner import GetArchiveBucket200ResponseArchiveFilesInner
from morpheus.models.list_archive_buckets200_response_all_of_archive_buckets_inner import ListArchiveBuckets200ResponseAllOfArchiveBucketsInner
from typing import Optional, Set
from typing_extensions import Self

class GetArchiveBucket200Response(BaseModel):
    """
    GetArchiveBucket200Response
    """ # noqa: E501
    archive_bucket: Optional[ListArchiveBuckets200ResponseAllOfArchiveBucketsInner] = Field(default=None, alias="archiveBucket")
    is_owner: Optional[StrictBool] = Field(default=None, alias="isOwner")
    parent_directory: Optional[StrictStr] = Field(default=None, alias="parentDirectory")
    archive_files: Optional[List[GetArchiveBucket200ResponseArchiveFilesInner]] = Field(default=None, alias="archiveFiles")
    archive_file_count: Optional[StrictInt] = Field(default=None, alias="archiveFileCount")
    __properties: ClassVar[List[str]] = ["archiveBucket", "isOwner", "parentDirectory", "archiveFiles", "archiveFileCount"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetArchiveBucket200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of archive_bucket
        if self.archive_bucket:
            _dict['archiveBucket'] = self.archive_bucket.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in archive_files (list)
        _items = []
        if self.archive_files:
            for _item_archive_files in self.archive_files:
                if _item_archive_files:
                    _items.append(_item_archive_files.to_dict())
            _dict['archiveFiles'] = _items
        # set to None if parent_directory (nullable) is None
        # and model_fields_set contains the field
        if self.parent_directory is None and "parent_directory" in self.model_fields_set:
            _dict['parentDirectory'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetArchiveBucket200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "archiveBucket": ListArchiveBuckets200ResponseAllOfArchiveBucketsInner.from_dict(obj["archiveBucket"]) if obj.get("archiveBucket") is not None else None,
            "isOwner": obj.get("isOwner"),
            "parentDirectory": obj.get("parentDirectory"),
            "archiveFiles": [GetArchiveBucket200ResponseArchiveFilesInner.from_dict(_item) for _item in obj["archiveFiles"]] if obj.get("archiveFiles") is not None else None,
            "archiveFileCount": obj.get("archiveFileCount")
        })
        return _obj


