# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_archive_buckets200_response_all_of_archive_buckets_inner_created_by import ListArchiveBuckets200ResponseAllOfArchiveBucketsInnerCreatedBy
from typing import Optional, Set
from typing_extensions import Self

class GetImageBuild200ResponseImageBuildExecutionsInner(BaseModel):
    """
    GetImageBuild200ResponseImageBuildExecutionsInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    image_build: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = Field(default=None, alias="imageBuild")
    build_number: Optional[StrictInt] = Field(default=None, alias="buildNumber")
    start_date: Optional[datetime] = Field(default=None, alias="startDate")
    end_date: Optional[datetime] = Field(default=None, alias="endDate")
    status_message: Optional[StrictStr] = Field(default=None, alias="statusMessage")
    status_percent: Optional[StrictInt] = Field(default=None, alias="statusPercent")
    status_eta: Optional[StrictStr] = Field(default=None, alias="statusEta")
    status: Optional[StrictStr] = None
    error_message: Optional[StrictStr] = Field(default=None, alias="errorMessage")
    created_by: Optional[ListArchiveBuckets200ResponseAllOfArchiveBucketsInnerCreatedBy] = Field(default=None, alias="createdBy")
    temp_instance: Optional[StrictStr] = Field(default=None, alias="tempInstance")
    virtual_images: Optional[List[Dict[str, Any]]] = Field(default=None, alias="virtualImages")
    __properties: ClassVar[List[str]] = ["id", "imageBuild", "buildNumber", "startDate", "endDate", "statusMessage", "statusPercent", "statusEta", "status", "errorMessage", "createdBy", "tempInstance", "virtualImages"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetImageBuild200ResponseImageBuildExecutionsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of image_build
        if self.image_build:
            _dict['imageBuild'] = self.image_build.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # set to None if end_date (nullable) is None
        # and model_fields_set contains the field
        if self.end_date is None and "end_date" in self.model_fields_set:
            _dict['endDate'] = None

        # set to None if status_message (nullable) is None
        # and model_fields_set contains the field
        if self.status_message is None and "status_message" in self.model_fields_set:
            _dict['statusMessage'] = None

        # set to None if status_eta (nullable) is None
        # and model_fields_set contains the field
        if self.status_eta is None and "status_eta" in self.model_fields_set:
            _dict['statusEta'] = None

        # set to None if error_message (nullable) is None
        # and model_fields_set contains the field
        if self.error_message is None and "error_message" in self.model_fields_set:
            _dict['errorMessage'] = None

        # set to None if temp_instance (nullable) is None
        # and model_fields_set contains the field
        if self.temp_instance is None and "temp_instance" in self.model_fields_set:
            _dict['tempInstance'] = None

        # set to None if virtual_images (nullable) is None
        # and model_fields_set contains the field
        if self.virtual_images is None and "virtual_images" in self.model_fields_set:
            _dict['virtualImages'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetImageBuild200ResponseImageBuildExecutionsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "imageBuild": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["imageBuild"]) if obj.get("imageBuild") is not None else None,
            "buildNumber": obj.get("buildNumber"),
            "startDate": obj.get("startDate"),
            "endDate": obj.get("endDate"),
            "statusMessage": obj.get("statusMessage"),
            "statusPercent": obj.get("statusPercent"),
            "statusEta": obj.get("statusEta"),
            "status": obj.get("status"),
            "errorMessage": obj.get("errorMessage"),
            "createdBy": ListArchiveBuckets200ResponseAllOfArchiveBucketsInnerCreatedBy.from_dict(obj["createdBy"]) if obj.get("createdBy") is not None else None,
            "tempInstance": obj.get("tempInstance"),
            "virtualImages": obj.get("virtualImages")
        })
        return _obj


