# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class GetInstanceThreshold200ResponseInstanceThreshold(BaseModel):
    """
    GetInstanceThreshold200ResponseInstanceThreshold
    """ # noqa: E501
    id: Optional[StrictInt] = None
    auto_up: Optional[StrictBool] = Field(default=None, alias="autoUp")
    auto_down: Optional[StrictBool] = Field(default=None, alias="autoDown")
    min_count: Optional[StrictInt] = Field(default=None, alias="minCount")
    max_count: Optional[StrictInt] = Field(default=None, alias="maxCount")
    scale_increment: Optional[StrictInt] = Field(default=None, alias="scaleIncrement")
    cpu_enabled: Optional[StrictBool] = Field(default=None, alias="cpuEnabled")
    min_cpu: Optional[StrictInt] = Field(default=None, alias="minCpu")
    max_cpu: Optional[StrictInt] = Field(default=None, alias="maxCpu")
    memory_enabled: Optional[StrictBool] = Field(default=None, alias="memoryEnabled")
    min_memory: Optional[StrictInt] = Field(default=None, alias="minMemory")
    max_memory: Optional[StrictInt] = Field(default=None, alias="maxMemory")
    disk_enabled: Optional[StrictBool] = Field(default=None, alias="diskEnabled")
    min_disk: Optional[StrictInt] = Field(default=None, alias="minDisk")
    max_disk: Optional[StrictInt] = Field(default=None, alias="maxDisk")
    min_network: Optional[StrictStr] = Field(default=None, alias="minNetwork")
    network_enabled: Optional[StrictBool] = Field(default=None, alias="networkEnabled")
    iops_enabled: Optional[StrictBool] = Field(default=None, alias="iopsEnabled")
    min_iops: Optional[StrictStr] = Field(default=None, alias="minIops")
    max_iops: Optional[StrictStr] = Field(default=None, alias="maxIops")
    comment: Optional[StrictStr] = None
    zone_id: Optional[StrictInt] = Field(default=None, alias="zoneId")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    __properties: ClassVar[List[str]] = ["id", "autoUp", "autoDown", "minCount", "maxCount", "scaleIncrement", "cpuEnabled", "minCpu", "maxCpu", "memoryEnabled", "minMemory", "maxMemory", "diskEnabled", "minDisk", "maxDisk", "minNetwork", "networkEnabled", "iopsEnabled", "minIops", "maxIops", "comment", "zoneId", "dateCreated", "lastUpdated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetInstanceThreshold200ResponseInstanceThreshold from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if min_network (nullable) is None
        # and model_fields_set contains the field
        if self.min_network is None and "min_network" in self.model_fields_set:
            _dict['minNetwork'] = None

        # set to None if min_iops (nullable) is None
        # and model_fields_set contains the field
        if self.min_iops is None and "min_iops" in self.model_fields_set:
            _dict['minIops'] = None

        # set to None if max_iops (nullable) is None
        # and model_fields_set contains the field
        if self.max_iops is None and "max_iops" in self.model_fields_set:
            _dict['maxIops'] = None

        # set to None if comment (nullable) is None
        # and model_fields_set contains the field
        if self.comment is None and "comment" in self.model_fields_set:
            _dict['comment'] = None

        # set to None if zone_id (nullable) is None
        # and model_fields_set contains the field
        if self.zone_id is None and "zone_id" in self.model_fields_set:
            _dict['zoneId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetInstanceThreshold200ResponseInstanceThreshold from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "autoUp": obj.get("autoUp"),
            "autoDown": obj.get("autoDown"),
            "minCount": obj.get("minCount"),
            "maxCount": obj.get("maxCount"),
            "scaleIncrement": obj.get("scaleIncrement"),
            "cpuEnabled": obj.get("cpuEnabled"),
            "minCpu": obj.get("minCpu"),
            "maxCpu": obj.get("maxCpu"),
            "memoryEnabled": obj.get("memoryEnabled"),
            "minMemory": obj.get("minMemory"),
            "maxMemory": obj.get("maxMemory"),
            "diskEnabled": obj.get("diskEnabled"),
            "minDisk": obj.get("minDisk"),
            "maxDisk": obj.get("maxDisk"),
            "minNetwork": obj.get("minNetwork"),
            "networkEnabled": obj.get("networkEnabled"),
            "iopsEnabled": obj.get("iopsEnabled"),
            "minIops": obj.get("minIops"),
            "maxIops": obj.get("maxIops"),
            "comment": obj.get("comment"),
            "zoneId": obj.get("zoneId"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated")
        })
        return _obj


