# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.get_instance_type_provisioning200_response_all_of_instance_type_instance_type_layouts_inner import GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInner
from morpheus.models.list_catalog_item_types200_response_all_of_catalog_item_types_inner_option_types_inner import ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner
from typing import Optional, Set
from typing_extensions import Self

class GetInstanceTypeProvisioning200ResponseAllOfInstanceType(BaseModel):
    """
    GetInstanceTypeProvisioning200ResponseAllOfInstanceType
    """ # noqa: E501
    id: Optional[StrictInt] = None
    account: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    name: Optional[StrictStr] = None
    labels: Optional[List[StrictStr]] = None
    code: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    provision_type_code: Optional[StrictStr] = Field(default=None, alias="provisionTypeCode")
    category: Optional[StrictStr] = None
    active: Optional[StrictBool] = None
    has_provisioning_step: Optional[StrictBool] = Field(default=None, alias="hasProvisioningStep")
    has_deployment: Optional[StrictBool] = Field(default=None, alias="hasDeployment")
    has_config: Optional[StrictBool] = Field(default=None, alias="hasConfig")
    has_settings: Optional[StrictBool] = Field(default=None, alias="hasSettings")
    has_auto_scale: Optional[StrictBool] = Field(default=None, alias="hasAutoScale")
    proxy_type: Optional[StrictStr] = Field(default=None, alias="proxyType")
    proxy_port: Optional[StrictStr] = Field(default=None, alias="proxyPort")
    proxy_protocol: Optional[StrictStr] = Field(default=None, alias="proxyProtocol")
    environment_prefix: Optional[StrictStr] = Field(default=None, alias="environmentPrefix")
    backup_type: Optional[StrictStr] = Field(default=None, alias="backupType")
    config: Optional[Dict[str, Any]] = None
    visibility: Optional[StrictStr] = None
    featured: Optional[StrictBool] = None
    versions: Optional[List[StrictStr]] = None
    instance_type_layouts: Optional[List[GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInner]] = Field(default=None, alias="instanceTypeLayouts")
    option_types: Optional[List[ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner]] = Field(default=None, alias="optionTypes")
    environment_variables: Optional[List[Dict[str, Any]]] = Field(default=None, alias="environmentVariables")
    price_sets: Optional[List[Dict[str, Any]]] = Field(default=None, alias="priceSets")
    image_path: Optional[StrictStr] = Field(default=None, description="Logo image URL", alias="imagePath")
    dark_image_path: Optional[StrictStr] = Field(default=None, description="Dark logo image URL", alias="darkImagePath")
    __properties: ClassVar[List[str]] = ["id", "account", "name", "labels", "code", "description", "provisionTypeCode", "category", "active", "hasProvisioningStep", "hasDeployment", "hasConfig", "hasSettings", "hasAutoScale", "proxyType", "proxyPort", "proxyProtocol", "environmentPrefix", "backupType", "config", "visibility", "featured", "versions", "instanceTypeLayouts", "optionTypes", "environmentVariables", "priceSets", "imagePath", "darkImagePath"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetInstanceTypeProvisioning200ResponseAllOfInstanceType from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in instance_type_layouts (list)
        _items = []
        if self.instance_type_layouts:
            for _item_instance_type_layouts in self.instance_type_layouts:
                if _item_instance_type_layouts:
                    _items.append(_item_instance_type_layouts.to_dict())
            _dict['instanceTypeLayouts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in option_types (list)
        _items = []
        if self.option_types:
            for _item_option_types in self.option_types:
                if _item_option_types:
                    _items.append(_item_option_types.to_dict())
            _dict['optionTypes'] = _items
        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict['labels'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if provision_type_code (nullable) is None
        # and model_fields_set contains the field
        if self.provision_type_code is None and "provision_type_code" in self.model_fields_set:
            _dict['provisionTypeCode'] = None

        # set to None if proxy_type (nullable) is None
        # and model_fields_set contains the field
        if self.proxy_type is None and "proxy_type" in self.model_fields_set:
            _dict['proxyType'] = None

        # set to None if proxy_port (nullable) is None
        # and model_fields_set contains the field
        if self.proxy_port is None and "proxy_port" in self.model_fields_set:
            _dict['proxyPort'] = None

        # set to None if proxy_protocol (nullable) is None
        # and model_fields_set contains the field
        if self.proxy_protocol is None and "proxy_protocol" in self.model_fields_set:
            _dict['proxyProtocol'] = None

        # set to None if backup_type (nullable) is None
        # and model_fields_set contains the field
        if self.backup_type is None and "backup_type" in self.model_fields_set:
            _dict['backupType'] = None

        # set to None if config (nullable) is None
        # and model_fields_set contains the field
        if self.config is None and "config" in self.model_fields_set:
            _dict['config'] = None

        # set to None if environment_variables (nullable) is None
        # and model_fields_set contains the field
        if self.environment_variables is None and "environment_variables" in self.model_fields_set:
            _dict['environmentVariables'] = None

        # set to None if price_sets (nullable) is None
        # and model_fields_set contains the field
        if self.price_sets is None and "price_sets" in self.model_fields_set:
            _dict['priceSets'] = None

        # set to None if image_path (nullable) is None
        # and model_fields_set contains the field
        if self.image_path is None and "image_path" in self.model_fields_set:
            _dict['imagePath'] = None

        # set to None if dark_image_path (nullable) is None
        # and model_fields_set contains the field
        if self.dark_image_path is None and "dark_image_path" in self.model_fields_set:
            _dict['darkImagePath'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetInstanceTypeProvisioning200ResponseAllOfInstanceType from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "account": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "name": obj.get("name"),
            "labels": obj.get("labels"),
            "code": obj.get("code"),
            "description": obj.get("description"),
            "provisionTypeCode": obj.get("provisionTypeCode"),
            "category": obj.get("category"),
            "active": obj.get("active"),
            "hasProvisioningStep": obj.get("hasProvisioningStep"),
            "hasDeployment": obj.get("hasDeployment"),
            "hasConfig": obj.get("hasConfig"),
            "hasSettings": obj.get("hasSettings"),
            "hasAutoScale": obj.get("hasAutoScale"),
            "proxyType": obj.get("proxyType"),
            "proxyPort": obj.get("proxyPort"),
            "proxyProtocol": obj.get("proxyProtocol"),
            "environmentPrefix": obj.get("environmentPrefix"),
            "backupType": obj.get("backupType"),
            "config": obj.get("config"),
            "visibility": obj.get("visibility"),
            "featured": obj.get("featured"),
            "versions": obj.get("versions"),
            "instanceTypeLayouts": [GetInstanceTypeProvisioning200ResponseAllOfInstanceTypeInstanceTypeLayoutsInner.from_dict(_item) for _item in obj["instanceTypeLayouts"]] if obj.get("instanceTypeLayouts") is not None else None,
            "optionTypes": [ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner.from_dict(_item) for _item in obj["optionTypes"]] if obj.get("optionTypes") is not None else None,
            "environmentVariables": obj.get("environmentVariables"),
            "priceSets": obj.get("priceSets"),
            "imagePath": obj.get("imagePath"),
            "darkImagePath": obj.get("darkImagePath")
        })
        return _obj


