# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_checks_inner_account import GetAlerts200ResponseAllOfChecksInnerAccount
from typing import Optional, Set
from typing_extensions import Self

class GetNetworkDhcpRelay200ResponseNetworkDhcpRelay(BaseModel):
    """
    GetNetworkDhcpRelay200ResponseNetworkDhcpRelay
    """ # noqa: E501
    id: Optional[StrictInt] = None
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    provider_id: Optional[StrictStr] = Field(default=None, alias="providerId")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    name: Optional[StrictStr] = None
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    server_ip_addresses: Optional[List[StrictStr]] = Field(default=None, alias="serverIpAddresses")
    owner: Optional[GetAlerts200ResponseAllOfChecksInnerAccount] = None
    network_server: Optional[GetAlerts200ResponseAllOfChecksInnerAccount] = Field(default=None, alias="networkServer")
    __properties: ClassVar[List[str]] = ["id", "dateCreated", "providerId", "lastUpdated", "name", "externalId", "serverIpAddresses", "owner", "networkServer"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetNetworkDhcpRelay200ResponseNetworkDhcpRelay from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of network_server
        if self.network_server:
            _dict['networkServer'] = self.network_server.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetNetworkDhcpRelay200ResponseNetworkDhcpRelay from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "dateCreated": obj.get("dateCreated"),
            "providerId": obj.get("providerId"),
            "lastUpdated": obj.get("lastUpdated"),
            "name": obj.get("name"),
            "externalId": obj.get("externalId"),
            "serverIpAddresses": obj.get("serverIpAddresses"),
            "owner": GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "networkServer": GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(obj["networkServer"]) if obj.get("networkServer") is not None else None
        })
        return _obj


