# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_network_dhcp_server200_response_network_dhcp_server_config import GetNetworkDhcpServer200ResponseNetworkDhcpServerConfig
from morpheus.models.snapshots_instance200_response_snapshots_inner_snapshot_files_inner_volume import SnapshotsInstance200ResponseSnapshotsInnerSnapshotFilesInnerVolume
from typing import Optional, Set
from typing_extensions import Self

class GetNetworkDhcpServer200ResponseNetworkDhcpServer(BaseModel):
    """
    GetNetworkDhcpServer200ResponseNetworkDhcpServer
    """ # noqa: E501
    id: Optional[StrictInt] = None
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    provider_id: Optional[StrictStr] = Field(default=None, alias="providerId")
    server_ip_address: Optional[StrictStr] = Field(default=None, alias="serverIpAddress")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    lease_time: Optional[StrictInt] = Field(default=None, alias="leaseTime")
    name: Optional[StrictStr] = None
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    config: Optional[GetNetworkDhcpServer200ResponseNetworkDhcpServerConfig] = None
    owner: Optional[SnapshotsInstance200ResponseSnapshotsInnerSnapshotFilesInnerVolume] = None
    network_server: Optional[SnapshotsInstance200ResponseSnapshotsInnerSnapshotFilesInnerVolume] = Field(default=None, alias="networkServer")
    __properties: ClassVar[List[str]] = ["id", "dateCreated", "providerId", "serverIpAddress", "lastUpdated", "leaseTime", "name", "externalId", "config", "owner", "networkServer"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetNetworkDhcpServer200ResponseNetworkDhcpServer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of network_server
        if self.network_server:
            _dict['networkServer'] = self.network_server.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetNetworkDhcpServer200ResponseNetworkDhcpServer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "dateCreated": obj.get("dateCreated"),
            "providerId": obj.get("providerId"),
            "serverIpAddress": obj.get("serverIpAddress"),
            "lastUpdated": obj.get("lastUpdated"),
            "leaseTime": obj.get("leaseTime"),
            "name": obj.get("name"),
            "externalId": obj.get("externalId"),
            "config": GetNetworkDhcpServer200ResponseNetworkDhcpServerConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "owner": SnapshotsInstance200ResponseSnapshotsInnerSnapshotFilesInnerVolume.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "networkServer": SnapshotsInstance200ResponseSnapshotsInnerSnapshotFilesInnerVolume.from_dict(obj["networkServer"]) if obj.get("networkServer") is not None else None
        })
        return _obj


