# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_catalog_item_types200_response_all_of_catalog_item_types_inner_option_types_inner import ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner
from typing import Optional, Set
from typing_extensions import Self

class GetNetworkRouterType200ResponseNetworkRouterType(BaseModel):
    """
    GetNetworkRouterType200ResponseNetworkRouterType
    """ # noqa: E501
    id: Optional[StrictInt] = None
    code: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    enabled: Optional[StrictBool] = None
    creatable: Optional[StrictBool] = None
    selectable: Optional[StrictBool] = None
    has_firewall: Optional[StrictBool] = Field(default=None, alias="hasFirewall")
    has_dhcp: Optional[StrictBool] = Field(default=None, alias="hasDhcp")
    has_routing: Optional[StrictBool] = Field(default=None, alias="hasRouting")
    has_network_server: Optional[StrictBool] = Field(default=None, alias="hasNetworkServer")
    option_types: Optional[List[ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner]] = Field(default=None, alias="optionTypes")
    rule_option_types: Optional[List[ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner]] = Field(default=None, alias="ruleOptionTypes")
    rule_group_option_types: Optional[List[ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner]] = Field(default=None, alias="ruleGroupOptionTypes")
    nat_option_types: Optional[List[ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner]] = Field(default=None, alias="natOptionTypes")
    bgp_option_types: Optional[List[ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner]] = Field(default=None, alias="bgpOptionTypes")
    __properties: ClassVar[List[str]] = ["id", "code", "name", "description", "enabled", "creatable", "selectable", "hasFirewall", "hasDhcp", "hasRouting", "hasNetworkServer", "optionTypes", "ruleOptionTypes", "ruleGroupOptionTypes", "natOptionTypes", "bgpOptionTypes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetNetworkRouterType200ResponseNetworkRouterType from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in option_types (list)
        _items = []
        if self.option_types:
            for _item_option_types in self.option_types:
                if _item_option_types:
                    _items.append(_item_option_types.to_dict())
            _dict['optionTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in rule_option_types (list)
        _items = []
        if self.rule_option_types:
            for _item_rule_option_types in self.rule_option_types:
                if _item_rule_option_types:
                    _items.append(_item_rule_option_types.to_dict())
            _dict['ruleOptionTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in rule_group_option_types (list)
        _items = []
        if self.rule_group_option_types:
            for _item_rule_group_option_types in self.rule_group_option_types:
                if _item_rule_group_option_types:
                    _items.append(_item_rule_group_option_types.to_dict())
            _dict['ruleGroupOptionTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in nat_option_types (list)
        _items = []
        if self.nat_option_types:
            for _item_nat_option_types in self.nat_option_types:
                if _item_nat_option_types:
                    _items.append(_item_nat_option_types.to_dict())
            _dict['natOptionTypes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in bgp_option_types (list)
        _items = []
        if self.bgp_option_types:
            for _item_bgp_option_types in self.bgp_option_types:
                if _item_bgp_option_types:
                    _items.append(_item_bgp_option_types.to_dict())
            _dict['bgpOptionTypes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetNetworkRouterType200ResponseNetworkRouterType from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "code": obj.get("code"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "enabled": obj.get("enabled"),
            "creatable": obj.get("creatable"),
            "selectable": obj.get("selectable"),
            "hasFirewall": obj.get("hasFirewall"),
            "hasDhcp": obj.get("hasDhcp"),
            "hasRouting": obj.get("hasRouting"),
            "hasNetworkServer": obj.get("hasNetworkServer"),
            "optionTypes": [ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner.from_dict(_item) for _item in obj["optionTypes"]] if obj.get("optionTypes") is not None else None,
            "ruleOptionTypes": [ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner.from_dict(_item) for _item in obj["ruleOptionTypes"]] if obj.get("ruleOptionTypes") is not None else None,
            "ruleGroupOptionTypes": [ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner.from_dict(_item) for _item in obj["ruleGroupOptionTypes"]] if obj.get("ruleGroupOptionTypes") is not None else None,
            "natOptionTypes": [ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner.from_dict(_item) for _item in obj["natOptionTypes"]] if obj.get("natOptionTypes") is not None else None,
            "bgpOptionTypes": [ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner.from_dict(_item) for _item in obj["bgpOptionTypes"]] if obj.get("bgpOptionTypes") is not None else None
        })
        return _obj


