# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class InstancesConfigVMWare(BaseModel):
    """
    InstancesConfigVMWare
    """ # noqa: E501
    no_agent: Optional[StrictBool] = Field(default=False, description="Skipping Agent installation will result in a lack of logging and guest operating system statistics. Automation scripts may also be adversely affected.", alias="noAgent")
    resource_pool_id: Optional[StrictStr] = Field(default=None, description="id of the resource group to be used, can be prefixed with `pool-`. A resource pool group can be specified instead by prefixing its ID with `poolGroup-`.", alias="resourcePoolId")
    host_id: Optional[StrictStr] = Field(default=None, description="Specific host to deploy to if so desired.", alias="hostId")
    smbios_asset_tag: Optional[StrictStr] = Field(default=None, description="Sets the asset tag on the SMBIOS for use by the guest operating system. If left blank, the virtual machine name will be used.", alias="smbiosAssetTag")
    nested_virtualization: Optional[StrictStr] = Field(default='off', description="Enable Nested Virtualization", alias="nestedVirtualization")
    vmware_folder_id: Optional[StrictStr] = Field(default=None, description="VMWare Folder External ID (as a String) or ID (as an Integer or String)", alias="vmwareFolderId")
    template: Optional[StrictInt] = Field(default=None, description="Image ID. This is the ID of a Virtual Image.")
    __properties: ClassVar[List[str]] = ["noAgent", "resourcePoolId", "hostId", "smbiosAssetTag", "nestedVirtualization", "vmwareFolderId", "template"]

    @field_validator('nested_virtualization')
    def nested_virtualization_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['on', 'off']):
            raise ValueError("must be one of enum values ('on', 'off')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InstancesConfigVMWare from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if no_agent (nullable) is None
        # and model_fields_set contains the field
        if self.no_agent is None and "no_agent" in self.model_fields_set:
            _dict['noAgent'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InstancesConfigVMWare from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "noAgent": obj.get("noAgent") if obj.get("noAgent") is not None else False,
            "resourcePoolId": obj.get("resourcePoolId"),
            "hostId": obj.get("hostId"),
            "smbiosAssetTag": obj.get("smbiosAssetTag"),
            "nestedVirtualization": obj.get("nestedVirtualization") if obj.get("nestedVirtualization") is not None else 'off',
            "vmwareFolderId": obj.get("vmwareFolderId"),
            "template": obj.get("template")
        })
        return _obj


