# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from morpheus.models.list_integrations200_response_any_of_integrations_inner_any_of7_config import ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOf7Config
from morpheus.models.list_integrations200_response_any_of_integrations_inner_any_of_credential import ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOfCredential
from typing import Optional, Set
from typing_extensions import Self

class IntegrationGitHub(BaseModel):
    """
    IntegrationGitHub
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    enabled: Optional[StrictBool] = None
    type: Optional[StrictStr] = None
    integration_type: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = Field(default=None, alias="integrationType")
    username: Optional[StrictStr] = None
    token: Optional[StrictStr] = None
    token_hash: Optional[StrictStr] = Field(default=None, alias="tokenHash")
    service_key: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = Field(default=None, alias="serviceKey")
    is_plugin: Optional[StrictBool] = Field(default=None, alias="isPlugin")
    config: Optional[ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOf7Config] = None
    status: Optional[StrictStr] = None
    status_date: Optional[datetime] = Field(default=None, alias="statusDate")
    status_message: Optional[StrictStr] = Field(default=None, alias="statusMessage")
    last_sync: Optional[StrictStr] = Field(default=None, alias="lastSync")
    last_sync_duration: Optional[StrictStr] = Field(default=None, alias="lastSyncDuration")
    credential: Optional[ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOfCredential] = None
    __properties: ClassVar[List[str]] = ["id", "name", "enabled", "type", "integrationType", "username", "token", "tokenHash", "serviceKey", "isPlugin", "config", "status", "statusDate", "statusMessage", "lastSync", "lastSyncDuration", "credential"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['github']):
            raise ValueError("must be one of enum values ('github')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IntegrationGitHub from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of integration_type
        if self.integration_type:
            _dict['integrationType'] = self.integration_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of service_key
        if self.service_key:
            _dict['serviceKey'] = self.service_key.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of credential
        if self.credential:
            _dict['credential'] = self.credential.to_dict()
        # set to None if status_message (nullable) is None
        # and model_fields_set contains the field
        if self.status_message is None and "status_message" in self.model_fields_set:
            _dict['statusMessage'] = None

        # set to None if last_sync (nullable) is None
        # and model_fields_set contains the field
        if self.last_sync is None and "last_sync" in self.model_fields_set:
            _dict['lastSync'] = None

        # set to None if last_sync_duration (nullable) is None
        # and model_fields_set contains the field
        if self.last_sync_duration is None and "last_sync_duration" in self.model_fields_set:
            _dict['lastSyncDuration'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IntegrationGitHub from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "enabled": obj.get("enabled"),
            "type": obj.get("type"),
            "integrationType": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["integrationType"]) if obj.get("integrationType") is not None else None,
            "username": obj.get("username"),
            "token": obj.get("token"),
            "tokenHash": obj.get("tokenHash"),
            "serviceKey": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["serviceKey"]) if obj.get("serviceKey") is not None else None,
            "isPlugin": obj.get("isPlugin"),
            "config": ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOf7Config.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "status": obj.get("status"),
            "statusDate": obj.get("statusDate"),
            "statusMessage": obj.get("statusMessage"),
            "lastSync": obj.get("lastSync"),
            "lastSyncDuration": obj.get("lastSyncDuration"),
            "credential": ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOfCredential.from_dict(obj["credential"]) if obj.get("credential") is not None else None
        })
        return _obj


