# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_checks_inner_account import GetAlerts200ResponseAllOfChecksInnerAccount
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from morpheus.models.list_credentials200_response_all_of_credentials_inner_user import ListCredentials200ResponseAllOfCredentialsInnerUser
from morpheus.models.list_jobs200_response_all_of_jobs_inner_any_of_custom_options import ListJobs200ResponseAllOfJobsInnerAnyOfCustomOptions
from morpheus.models.list_jobs200_response_all_of_jobs_inner_any_of_schedule_mode import ListJobs200ResponseAllOfJobsInnerAnyOfScheduleMode
from morpheus.models.list_jobs200_response_all_of_jobs_inner_any_of_targets_inner import ListJobs200ResponseAllOfJobsInnerAnyOfTargetsInner
from typing import Optional, Set
from typing_extensions import Self

class JobTask(BaseModel):
    """
    JobTask
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    labels: Optional[List[StrictStr]] = None
    type: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = None
    task: Optional[GetAlerts200ResponseAllOfChecksInnerAccount] = None
    job_summary: Optional[StrictStr] = Field(default=None, alias="jobSummary")
    schedule_mode: Optional[ListJobs200ResponseAllOfJobsInnerAnyOfScheduleMode] = Field(default=None, alias="scheduleMode")
    date_time: Optional[StrictStr] = Field(default=None, alias="dateTime")
    status: Optional[StrictStr] = None
    namespace: Optional[StrictStr] = None
    category: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    enabled: Optional[StrictBool] = None
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    last_run: Optional[datetime] = Field(default=None, alias="lastRun")
    last_result: Optional[StrictStr] = Field(default=None, alias="lastResult")
    created_by: Optional[ListCredentials200ResponseAllOfCredentialsInnerUser] = Field(default=None, alias="createdBy")
    target_type: Optional[StrictStr] = Field(default=None, alias="targetType")
    targets: Optional[List[ListJobs200ResponseAllOfJobsInnerAnyOfTargetsInner]] = None
    custom_config: Optional[StrictStr] = Field(default=None, alias="customConfig")
    custom_options: Optional[ListJobs200ResponseAllOfJobsInnerAnyOfCustomOptions] = Field(default=None, alias="customOptions")
    __properties: ClassVar[List[str]] = ["id", "name", "labels", "type", "task", "jobSummary", "scheduleMode", "dateTime", "status", "namespace", "category", "description", "enabled", "dateCreated", "lastUpdated", "lastRun", "lastResult", "createdBy", "targetType", "targets", "customConfig", "customOptions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JobTask from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of task
        if self.task:
            _dict['task'] = self.task.to_dict()
        # override the default output from pydantic by calling `to_dict()` of schedule_mode
        if self.schedule_mode:
            _dict['scheduleMode'] = self.schedule_mode.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in targets (list)
        _items = []
        if self.targets:
            for _item_targets in self.targets:
                if _item_targets:
                    _items.append(_item_targets.to_dict())
            _dict['targets'] = _items
        # override the default output from pydantic by calling `to_dict()` of custom_options
        if self.custom_options:
            _dict['customOptions'] = self.custom_options.to_dict()
        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict['labels'] = None

        # set to None if job_summary (nullable) is None
        # and model_fields_set contains the field
        if self.job_summary is None and "job_summary" in self.model_fields_set:
            _dict['jobSummary'] = None

        # set to None if date_time (nullable) is None
        # and model_fields_set contains the field
        if self.date_time is None and "date_time" in self.model_fields_set:
            _dict['dateTime'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if namespace (nullable) is None
        # and model_fields_set contains the field
        if self.namespace is None and "namespace" in self.model_fields_set:
            _dict['namespace'] = None

        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict['category'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if targets (nullable) is None
        # and model_fields_set contains the field
        if self.targets is None and "targets" in self.model_fields_set:
            _dict['targets'] = None

        # set to None if custom_config (nullable) is None
        # and model_fields_set contains the field
        if self.custom_config is None and "custom_config" in self.model_fields_set:
            _dict['customConfig'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JobTask from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "labels": obj.get("labels"),
            "type": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["type"]) if obj.get("type") is not None else None,
            "task": GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(obj["task"]) if obj.get("task") is not None else None,
            "jobSummary": obj.get("jobSummary"),
            "scheduleMode": ListJobs200ResponseAllOfJobsInnerAnyOfScheduleMode.from_dict(obj["scheduleMode"]) if obj.get("scheduleMode") is not None else None,
            "dateTime": obj.get("dateTime"),
            "status": obj.get("status"),
            "namespace": obj.get("namespace"),
            "category": obj.get("category"),
            "description": obj.get("description"),
            "enabled": obj.get("enabled"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "lastRun": obj.get("lastRun"),
            "lastResult": obj.get("lastResult"),
            "createdBy": ListCredentials200ResponseAllOfCredentialsInnerUser.from_dict(obj["createdBy"]) if obj.get("createdBy") is not None else None,
            "targetType": obj.get("targetType"),
            "targets": [ListJobs200ResponseAllOfJobsInnerAnyOfTargetsInner.from_dict(_item) for _item in obj["targets"]] if obj.get("targets") is not None else None,
            "customConfig": obj.get("customConfig"),
            "customOptions": ListJobs200ResponseAllOfJobsInnerAnyOfCustomOptions.from_dict(obj["customOptions"]) if obj.get("customOptions") is not None else None
        })
        return _obj


