# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class LicenseFeatures(BaseModel):
    """
    Features that can be enabled or disabled in the license
    """ # noqa: E501
    dashboard: Optional[StrictBool] = None
    guidance: Optional[StrictBool] = None
    discovery: Optional[StrictBool] = None
    analytics: Optional[StrictBool] = None
    scheduling: Optional[StrictBool] = None
    approvals: Optional[StrictBool] = None
    usage: Optional[StrictBool] = None
    activity: Optional[StrictBool] = None
    instances: Optional[StrictBool] = None
    apps: Optional[StrictBool] = None
    templates: Optional[StrictBool] = None
    automation: Optional[StrictBool] = None
    virtual_images: Optional[StrictBool] = Field(default=None, alias="virtualImages")
    library: Optional[StrictBool] = None
    migrations: Optional[StrictBool] = None
    deployments: Optional[StrictBool] = None
    groups: Optional[StrictBool] = None
    clouds: Optional[StrictBool] = None
    hosts: Optional[StrictBool] = None
    network: Optional[StrictBool] = None
    load_balancers: Optional[StrictBool] = Field(default=None, alias="loadBalancers")
    storage: Optional[StrictBool] = None
    key_pairs: Optional[StrictBool] = Field(default=None, alias="keyPairs")
    ssl_certificates: Optional[StrictBool] = Field(default=None, alias="sslCertificates")
    boot: Optional[StrictBool] = None
    backups: Optional[StrictBool] = None
    cypher: Optional[StrictBool] = None
    archives: Optional[StrictBool] = None
    image_builder: Optional[StrictBool] = Field(default=None, alias="imageBuilder")
    tenants: Optional[StrictBool] = None
    plans: Optional[StrictBool] = None
    pricing: Optional[StrictBool] = None
    users: Optional[StrictBool] = None
    user_groups: Optional[StrictBool] = Field(default=None, alias="userGroups")
    monitoring: Optional[StrictBool] = None
    logging: Optional[StrictBool] = None
    monitoring_services: Optional[StrictBool] = Field(default=None, alias="monitoringServices")
    logging_services: Optional[StrictBool] = Field(default=None, alias="loggingServices")
    backup_services: Optional[StrictBool] = Field(default=None, alias="backupServices")
    dns_services: Optional[StrictBool] = Field(default=None, alias="dnsServices")
    code_service: Optional[StrictBool] = Field(default=None, alias="codeService")
    build_services: Optional[StrictBool] = Field(default=None, alias="buildServices")
    load_balancer_services: Optional[StrictBool] = Field(default=None, alias="loadBalancerServices")
    ipam_services: Optional[StrictBool] = Field(default=None, alias="ipamServices")
    approval_services: Optional[StrictBool] = Field(default=None, alias="approvalServices")
    cmdb_services: Optional[StrictBool] = Field(default=None, alias="cmdbServices")
    deployment_services: Optional[StrictBool] = Field(default=None, alias="deploymentServices")
    automation_services: Optional[StrictBool] = Field(default=None, alias="automationServices")
    service_discovery_services: Optional[StrictBool] = Field(default=None, alias="serviceDiscoveryServices")
    identity_services: Optional[StrictBool] = Field(default=None, alias="identityServices")
    trust_services: Optional[StrictBool] = Field(default=None, alias="trustServices")
    security_services: Optional[StrictBool] = Field(default=None, alias="securityServices")
    __properties: ClassVar[List[str]] = ["dashboard", "guidance", "discovery", "analytics", "scheduling", "approvals", "usage", "activity", "instances", "apps", "templates", "automation", "virtualImages", "library", "migrations", "deployments", "groups", "clouds", "hosts", "network", "loadBalancers", "storage", "keyPairs", "sslCertificates", "boot", "backups", "cypher", "archives", "imageBuilder", "tenants", "plans", "pricing", "users", "userGroups", "monitoring", "logging", "monitoringServices", "loggingServices", "backupServices", "dnsServices", "codeService", "buildServices", "loadBalancerServices", "ipamServices", "approvalServices", "cmdbServices", "deploymentServices", "automationServices", "serviceDiscoveryServices", "identityServices", "trustServices", "securityServices"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LicenseFeatures from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LicenseFeatures from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "dashboard": obj.get("dashboard"),
            "guidance": obj.get("guidance"),
            "discovery": obj.get("discovery"),
            "analytics": obj.get("analytics"),
            "scheduling": obj.get("scheduling"),
            "approvals": obj.get("approvals"),
            "usage": obj.get("usage"),
            "activity": obj.get("activity"),
            "instances": obj.get("instances"),
            "apps": obj.get("apps"),
            "templates": obj.get("templates"),
            "automation": obj.get("automation"),
            "virtualImages": obj.get("virtualImages"),
            "library": obj.get("library"),
            "migrations": obj.get("migrations"),
            "deployments": obj.get("deployments"),
            "groups": obj.get("groups"),
            "clouds": obj.get("clouds"),
            "hosts": obj.get("hosts"),
            "network": obj.get("network"),
            "loadBalancers": obj.get("loadBalancers"),
            "storage": obj.get("storage"),
            "keyPairs": obj.get("keyPairs"),
            "sslCertificates": obj.get("sslCertificates"),
            "boot": obj.get("boot"),
            "backups": obj.get("backups"),
            "cypher": obj.get("cypher"),
            "archives": obj.get("archives"),
            "imageBuilder": obj.get("imageBuilder"),
            "tenants": obj.get("tenants"),
            "plans": obj.get("plans"),
            "pricing": obj.get("pricing"),
            "users": obj.get("users"),
            "userGroups": obj.get("userGroups"),
            "monitoring": obj.get("monitoring"),
            "logging": obj.get("logging"),
            "monitoringServices": obj.get("monitoringServices"),
            "loggingServices": obj.get("loggingServices"),
            "backupServices": obj.get("backupServices"),
            "dnsServices": obj.get("dnsServices"),
            "codeService": obj.get("codeService"),
            "buildServices": obj.get("buildServices"),
            "loadBalancerServices": obj.get("loadBalancerServices"),
            "ipamServices": obj.get("ipamServices"),
            "approvalServices": obj.get("approvalServices"),
            "cmdbServices": obj.get("cmdbServices"),
            "deploymentServices": obj.get("deploymentServices"),
            "automationServices": obj.get("automationServices"),
            "serviceDiscoveryServices": obj.get("serviceDiscoveryServices"),
            "identityServices": obj.get("identityServices"),
            "trustServices": obj.get("trustServices"),
            "securityServices": obj.get("securityServices")
        })
        return _obj


