# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_backup_jobs200_response_all_of_jobs_inner_account import ListBackupJobs200ResponseAllOfJobsInnerAccount
from morpheus.models.list_backup_jobs200_response_all_of_jobs_inner_backups_inner import ListBackupJobs200ResponseAllOfJobsInnerBackupsInner
from morpheus.models.list_backups200_response_all_of_backups_inner_backup_provider import ListBackups200ResponseAllOfBackupsInnerBackupProvider
from morpheus.models.list_backups200_response_all_of_backups_inner_backup_respository import ListBackups200ResponseAllOfBackupsInnerBackupRespository
from morpheus.models.list_backups200_response_all_of_backups_inner_schedule import ListBackups200ResponseAllOfBackupsInnerSchedule
from typing import Optional, Set
from typing_extensions import Self

class ListBackupJobs200ResponseAllOfJobsInner(BaseModel):
    """
    ListBackupJobs200ResponseAllOfJobsInner
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=None, description="Backup ID")
    name: Optional[StrictStr] = Field(default=None, description="Name")
    schedule: Optional[ListBackups200ResponseAllOfBackupsInnerSchedule] = None
    retention_count: Optional[StrictInt] = Field(default=None, alias="retentionCount")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    backup_provider: Optional[ListBackups200ResponseAllOfBackupsInnerBackupProvider] = Field(default=None, alias="backupProvider")
    backup_respository: Optional[ListBackups200ResponseAllOfBackupsInnerBackupRespository] = Field(default=None, alias="backupRespository")
    cron_expression: Optional[StrictStr] = Field(default=None, description="Cron Expression", alias="cronExpression")
    next_fire: Optional[datetime] = Field(default=None, description="Next Fire is the datetime the job will next occur on according to its schedule", alias="nextFire")
    source: Optional[StrictStr] = None
    visibility: Optional[StrictStr] = None
    account: Optional[ListBackupJobs200ResponseAllOfJobsInnerAccount] = None
    enabled: Optional[StrictBool] = Field(default=None, description="Enabled")
    date_created: Optional[datetime] = Field(default=None, description="Date Created", alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, description="Last Updated", alias="lastUpdated")
    backups: Optional[List[ListBackupJobs200ResponseAllOfJobsInnerBackupsInner]] = Field(default=None, description="Backups associated with this job")
    __properties: ClassVar[List[str]] = ["id", "name", "schedule", "retentionCount", "externalId", "backupProvider", "backupRespository", "cronExpression", "nextFire", "source", "visibility", "account", "enabled", "dateCreated", "lastUpdated", "backups"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListBackupJobs200ResponseAllOfJobsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of schedule
        if self.schedule:
            _dict['schedule'] = self.schedule.to_dict()
        # override the default output from pydantic by calling `to_dict()` of backup_provider
        if self.backup_provider:
            _dict['backupProvider'] = self.backup_provider.to_dict()
        # override the default output from pydantic by calling `to_dict()` of backup_respository
        if self.backup_respository:
            _dict['backupRespository'] = self.backup_respository.to_dict()
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in backups (list)
        _items = []
        if self.backups:
            for _item_backups in self.backups:
                if _item_backups:
                    _items.append(_item_backups.to_dict())
            _dict['backups'] = _items
        # set to None if retention_count (nullable) is None
        # and model_fields_set contains the field
        if self.retention_count is None and "retention_count" in self.model_fields_set:
            _dict['retentionCount'] = None

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['externalId'] = None

        # set to None if cron_expression (nullable) is None
        # and model_fields_set contains the field
        if self.cron_expression is None and "cron_expression" in self.model_fields_set:
            _dict['cronExpression'] = None

        # set to None if next_fire (nullable) is None
        # and model_fields_set contains the field
        if self.next_fire is None and "next_fire" in self.model_fields_set:
            _dict['nextFire'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListBackupJobs200ResponseAllOfJobsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "schedule": ListBackups200ResponseAllOfBackupsInnerSchedule.from_dict(obj["schedule"]) if obj.get("schedule") is not None else None,
            "retentionCount": obj.get("retentionCount"),
            "externalId": obj.get("externalId"),
            "backupProvider": ListBackups200ResponseAllOfBackupsInnerBackupProvider.from_dict(obj["backupProvider"]) if obj.get("backupProvider") is not None else None,
            "backupRespository": ListBackups200ResponseAllOfBackupsInnerBackupRespository.from_dict(obj["backupRespository"]) if obj.get("backupRespository") is not None else None,
            "cronExpression": obj.get("cronExpression"),
            "nextFire": obj.get("nextFire"),
            "source": obj.get("source"),
            "visibility": obj.get("visibility"),
            "account": ListBackupJobs200ResponseAllOfJobsInnerAccount.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "enabled": obj.get("enabled"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "backups": [ListBackupJobs200ResponseAllOfJobsInnerBackupsInner.from_dict(_item) for _item in obj["backups"]] if obj.get("backups") is not None else None
        })
        return _obj


