# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ListBackups200ResponseAllOfBackupsInnerStats(BaseModel):
    """
    Backup Result Statistics
    """ # noqa: E501
    total_size: Optional[StrictInt] = Field(default=None, description="Total size of all backups in bytes", alias="totalSize")
    avg_size: Optional[StrictInt] = Field(default=None, description="Average size of each backup in bytes", alias="avgSize")
    total_completed: Optional[StrictInt] = Field(default=None, description="Total completed count", alias="totalCompleted")
    success: Optional[StrictInt] = Field(default=None, description="Successful backup count")
    failed: Optional[StrictInt] = Field(default=None, description="Failed backup count")
    success_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Success rate 0-1", alias="successRate")
    fail_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Failure rate 0-1", alias="failRate")
    last_five_results: Optional[List[StrictStr]] = Field(default=None, description="List of the last 5 backup result statuses", alias="lastFiveResults")
    __properties: ClassVar[List[str]] = ["totalSize", "avgSize", "totalCompleted", "success", "failed", "successRate", "failRate", "lastFiveResults"]

    @field_validator('last_five_results')
    def last_five_results_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['SUCCEEDED', 'FAILED', 'IN_PROGRESS', 'START_REQUESTED']):
                raise ValueError("each list item must be one of ('SUCCEEDED', 'FAILED', 'IN_PROGRESS', 'START_REQUESTED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListBackups200ResponseAllOfBackupsInnerStats from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListBackups200ResponseAllOfBackupsInnerStats from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "totalSize": obj.get("totalSize"),
            "avgSize": obj.get("avgSize"),
            "totalCompleted": obj.get("totalCompleted"),
            "success": obj.get("success"),
            "failed": obj.get("failed"),
            "successRate": obj.get("successRate"),
            "failRate": obj.get("failRate"),
            "lastFiveResults": obj.get("lastFiveResults")
        })
        return _obj


