# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from morpheus.models.list_billing_instances200_response_all_of_billing_info_instances_inner_containers_inner_usages_inner_applicable_prices_inner import ListBillingInstances200ResponseAllOfBillingInfoInstancesInnerContainersInnerUsagesInnerApplicablePricesInner
from morpheus.models.list_billing_instances200_response_all_of_billing_info_instances_inner_containers_inner_usages_inner_prices_used_inner import ListBillingInstances200ResponseAllOfBillingInfoInstancesInnerContainersInnerUsagesInnerPricesUsedInner
from morpheus.models.list_billing_instances200_response_all_of_billing_info_instances_inner_containers_inner_usages_inner_volumes_inner import ListBillingInstances200ResponseAllOfBillingInfoInstancesInnerContainersInnerUsagesInnerVolumesInner
from typing import Optional, Set
from typing_extensions import Self

class ListBillingInstances200ResponseAllOfBillingInfoInstancesInnerContainersInnerUsagesInner(BaseModel):
    """
    ListBillingInstances200ResponseAllOfBillingInfoInstancesInnerContainersInnerUsagesInner
    """ # noqa: E501
    name: Optional[StrictStr] = None
    instance_name: Optional[StrictStr] = Field(default=None, alias="instanceName")
    zone_name: Optional[StrictStr] = Field(default=None, alias="zoneName")
    account_name: Optional[StrictStr] = Field(default=None, alias="accountName")
    volumes: Optional[List[ListBillingInstances200ResponseAllOfBillingInfoInstancesInnerContainersInnerUsagesInnerVolumesInner]] = None
    max_memory: Optional[StrictInt] = Field(default=None, alias="maxMemory")
    max_cpu: Optional[StrictStr] = Field(default=None, alias="maxCpu")
    max_cores: Optional[StrictInt] = Field(default=None, alias="maxCores")
    server_external_id: Optional[StrictStr] = Field(default=None, alias="serverExternalId")
    server_internal_id: Optional[StrictStr] = Field(default=None, alias="serverInternalId")
    plan_name: Optional[StrictStr] = Field(default=None, alias="planName")
    hourly_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="hourlyPrice")
    hourly_cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="hourlyCost")
    currency: Optional[StrictStr] = None
    prices_used: Optional[List[ListBillingInstances200ResponseAllOfBillingInfoInstancesInnerContainersInnerUsagesInnerPricesUsedInner]] = Field(default=None, alias="pricesUsed")
    cost: Optional[Union[StrictFloat, StrictInt]] = None
    price: Optional[Union[StrictFloat, StrictInt]] = None
    created_by_user: Optional[StrictStr] = Field(default=None, alias="createdByUser")
    created_by_user_id: Optional[StrictInt] = Field(default=None, alias="createdByUserId")
    site_id: Optional[StrictInt] = Field(default=None, alias="siteId")
    site_name: Optional[StrictStr] = Field(default=None, alias="siteName")
    site_uuid: Optional[StrictStr] = Field(default=None, alias="siteUUID")
    site_code: Optional[StrictStr] = Field(default=None, alias="siteCode")
    start_date: Optional[datetime] = Field(default=None, alias="startDate")
    end_date: Optional[datetime] = Field(default=None, alias="endDate")
    status: Optional[StrictStr] = None
    tags: Optional[List[Dict[str, Any]]] = None
    applicable_prices: Optional[List[ListBillingInstances200ResponseAllOfBillingInfoInstancesInnerContainersInnerUsagesInnerApplicablePricesInner]] = Field(default=None, alias="applicablePrices")
    service_plan_id: Optional[StrictInt] = Field(default=None, alias="servicePlanId")
    service_plan_name: Optional[StrictStr] = Field(default=None, alias="servicePlanName")
    resource_pool_id: Optional[StrictInt] = Field(default=None, alias="resourcePoolId")
    resource_pool_name: Optional[StrictStr] = Field(default=None, alias="resourcePoolName")
    __properties: ClassVar[List[str]] = ["name", "instanceName", "zoneName", "accountName", "volumes", "maxMemory", "maxCpu", "maxCores", "serverExternalId", "serverInternalId", "planName", "hourlyPrice", "hourlyCost", "currency", "pricesUsed", "cost", "price", "createdByUser", "createdByUserId", "siteId", "siteName", "siteUUID", "siteCode", "startDate", "endDate", "status", "tags", "applicablePrices", "servicePlanId", "servicePlanName", "resourcePoolId", "resourcePoolName"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListBillingInstances200ResponseAllOfBillingInfoInstancesInnerContainersInnerUsagesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in volumes (list)
        _items = []
        if self.volumes:
            for _item_volumes in self.volumes:
                if _item_volumes:
                    _items.append(_item_volumes.to_dict())
            _dict['volumes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in prices_used (list)
        _items = []
        if self.prices_used:
            for _item_prices_used in self.prices_used:
                if _item_prices_used:
                    _items.append(_item_prices_used.to_dict())
            _dict['pricesUsed'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in applicable_prices (list)
        _items = []
        if self.applicable_prices:
            for _item_applicable_prices in self.applicable_prices:
                if _item_applicable_prices:
                    _items.append(_item_applicable_prices.to_dict())
            _dict['applicablePrices'] = _items
        # set to None if max_cpu (nullable) is None
        # and model_fields_set contains the field
        if self.max_cpu is None and "max_cpu" in self.model_fields_set:
            _dict['maxCpu'] = None

        # set to None if site_code (nullable) is None
        # and model_fields_set contains the field
        if self.site_code is None and "site_code" in self.model_fields_set:
            _dict['siteCode'] = None

        # set to None if tags (nullable) is None
        # and model_fields_set contains the field
        if self.tags is None and "tags" in self.model_fields_set:
            _dict['tags'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListBillingInstances200ResponseAllOfBillingInfoInstancesInnerContainersInnerUsagesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "instanceName": obj.get("instanceName"),
            "zoneName": obj.get("zoneName"),
            "accountName": obj.get("accountName"),
            "volumes": [ListBillingInstances200ResponseAllOfBillingInfoInstancesInnerContainersInnerUsagesInnerVolumesInner.from_dict(_item) for _item in obj["volumes"]] if obj.get("volumes") is not None else None,
            "maxMemory": obj.get("maxMemory"),
            "maxCpu": obj.get("maxCpu"),
            "maxCores": obj.get("maxCores"),
            "serverExternalId": obj.get("serverExternalId"),
            "serverInternalId": obj.get("serverInternalId"),
            "planName": obj.get("planName"),
            "hourlyPrice": obj.get("hourlyPrice"),
            "hourlyCost": obj.get("hourlyCost"),
            "currency": obj.get("currency"),
            "pricesUsed": [ListBillingInstances200ResponseAllOfBillingInfoInstancesInnerContainersInnerUsagesInnerPricesUsedInner.from_dict(_item) for _item in obj["pricesUsed"]] if obj.get("pricesUsed") is not None else None,
            "cost": obj.get("cost"),
            "price": obj.get("price"),
            "createdByUser": obj.get("createdByUser"),
            "createdByUserId": obj.get("createdByUserId"),
            "siteId": obj.get("siteId"),
            "siteName": obj.get("siteName"),
            "siteUUID": obj.get("siteUUID"),
            "siteCode": obj.get("siteCode"),
            "startDate": obj.get("startDate"),
            "endDate": obj.get("endDate"),
            "status": obj.get("status"),
            "tags": obj.get("tags"),
            "applicablePrices": [ListBillingInstances200ResponseAllOfBillingInfoInstancesInnerContainersInnerUsagesInnerApplicablePricesInner.from_dict(_item) for _item in obj["applicablePrices"]] if obj.get("applicablePrices") is not None else None,
            "servicePlanId": obj.get("servicePlanId"),
            "servicePlanName": obj.get("servicePlanName"),
            "resourcePoolId": obj.get("resourcePoolId"),
            "resourcePoolName": obj.get("resourcePoolName")
        })
        return _obj


